/*
 * flist-completion.h: e-completion implementation for the flist
 *
 * Authors:
 *    Jacob Berkman  <jacob@ximian.com>
 *
 * Copyright 2001 Ximian, Inc.
 */

#include <config.h>

#include "flist-completion.h"

#include <gtk/gtksignal.h>
#include <gtk/gtkmain.h>
#include <gal/e-text/e-completion.h>
#include <gal/e-text/e-entry.h>

#define TIMEOUT 100

#define d(x)

struct _FListCompletionPrivate {
	ECompletion    *completion;
	const FListDir *dir;
	guint           timeout_id;

	const char *txt;

	int len;
	int start;
	int limit;
	int count;
	int current;
};

/* this bad boy needs some soptimization */
static gint
flc_search_timeout (FListCompletion *flc)
{
	int limit;
	int i;
	int count = 0;
	const GnomeVFSFileInfo *finfo;

	g_return_val_if_fail (flc->priv->dir != NULL, FALSE);

	i = flc->priv->current;

	limit = flist_dir_get_size (flc->priv->dir);

	for (i = 0; i < limit && count < 100; i++) {
		finfo = flist_dir_get_vfs_info (flc->priv->dir, i);
		if (!g_strncasecmp (flc->priv->txt, finfo->name, flc->priv->len)) {
			ECompletionMatch *match;
			/* FIXME: utf8, anyone? */
			match = e_completion_match_new (finfo->name, finfo->name,
							flc->priv->len / (double)strlen (finfo->name));
			
			e_completion_found_match (flc->priv->completion, match);
			count++;
		}
	}
	
	if (1 || !count) {
		flc->priv->timeout_id = 0;
		e_completion_end_search (flc->priv->completion);
		return FALSE;
	}
		
	return TRUE;
}

static void
flc_begin_completion (ECompletion *comp, const gchar *search_text, 
		      gint pos, gint limit, FListCompletion *flc)
{
	gint len;
	d(g_print ("flc_begin_completion()\n"));

	len = strlen (search_text);

	if (flc->priv->timeout_id != 0) {
		gtk_timeout_remove (flc->priv->timeout_id);
		flc->priv->timeout_id = 0;
	}

	if (!len || !flc->priv->dir)
		e_completion_end_search (comp);

	flc->priv->txt     =  search_text;
	flc->priv->len     =  len;
	flc->priv->start   =  0;
	flc->priv->limit   =  100;
	flc->priv->count   =  0;
	flc->priv->current =  0;

	flc->priv->timeout_id = gtk_timeout_add (TIMEOUT, (GtkFunction)flc_search_timeout, flc);
}

static void
flc_end_completion (ECompletion *comp, FListCompletion *flc)
{
	d(g_print ("flc_end_completion()\n"));
}

static void
flc_cancel_completion (ECompletion *comp, FListCompletion *flc)
{
	d(g_print ("flc_cancel_completion()\n"));
}

static void
flist_completion_completion_cb (EEntry *entry, ECompletionMatch *match)
{
	e_entry_set_text (entry, match->match_text);
	gtk_signal_emit_by_name (GTK_OBJECT (entry), "activate");
}

FListCompletion *
flist_completion_new (void)
{
	FListCompletion *flc;

	flc       = g_new0 (FListCompletion, 1);
	flc->priv = g_new0 (FListCompletionPrivate, 1);

	flc->priv->completion = e_completion_new ();
	
	gtk_signal_connect (GTK_OBJECT (flc->priv->completion),
			    "begin_completion",
			    GTK_SIGNAL_FUNC (flc_begin_completion),
			    flc);

	gtk_signal_connect (GTK_OBJECT (flc->priv->completion),
			    "end_completion",
			    GTK_SIGNAL_FUNC (flc_end_completion),
			    flc);

	gtk_signal_connect (GTK_OBJECT (flc->priv->completion),
			    "cancel_completion",
			    GTK_SIGNAL_FUNC (flc_cancel_completion),
			    flc);

	flc->entry = e_entry_new ();
	e_entry_enable_completion_full (E_ENTRY (flc->entry), 
					flc->priv->completion, 0,
					flist_completion_completion_cb);

	return flc;
}

void
flist_completion_free (FListCompletion *flc)
{
	memset (flc->priv, 0, sizeof (FListCompletionPrivate));
	g_free (flc->priv);
	
	memset (flc, 0, sizeof (FListCompletion));
	g_free (flc);
}

void
flist_completion_clear (FListCompletion *flc)
{
	d(g_print ("flist_completion_clear()\n"));
	e_completion_cancel_search (flc->priv->completion);
	flc->priv->dir = NULL;
}

void
flist_completion_files_read (FListCompletion *flc, 
			     const FListDir *dir,
			     int oldsize, int newfiles)
{
	d(g_print ("flist_completion_files_read()\n"));
	flc->priv->dir = dir;
}
