/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- */

/* 
 * Execution of a target
 * 
 * Author : Dave Camp <campd@oit.edu>
 */

#ifndef __GDB_EXECUTION_H__
#define __GDB_EXECUTION_H__

typedef enum {
    GDB_ATTACH_OK,
    GDB_ATTACH_ALREADY_RUNNING,
    GDB_ATTACH_DOESNT_EXIST,
    GDB_ATTACH_ACCESS_DENIED,
    GDB_ATTACH_MISC
} GdbAttachResult;


void gdb_run (GdbInstance *inst);
GdbAttachResult gdb_attach (GdbInstance *inst, int pid);
void gdb_detach (GdbInstance *inst);
void gdb_continue (GdbInstance *inst);
void gdb_step_into (GdbInstance *inst);
void gdb_step_over (GdbInstance *inst);
void gdb_step_out (GdbInstance *inst);
void gdb_stop (GdbInstance *inst);

void gdb_tty_set (GdbInstance *inst, const char *tty_name);

#endif
