/*  -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * 
 * This file is part of the GNOME Debugging Framework.
 * 
 * Copyright (C) 2000 Dave Camp <campd@oit.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 */

#include <config.h>
#include "gdf-dialogs.h"

#include <gnome.h>
#include "gdf-tools.h"

GdfDebuggerClientResult 
gdf_attach_dialog (GdfDebuggerClient *dbg)
{
    GtkWidget *dlg;
    GtkWidget *entry;
    GtkWidget *label;
    GtkWidget *hbox;
    GdfDebuggerClientResult res;
    char *errmsg;
    int btn;
    int pid;
    char *pidstr;
    
    label = gtk_label_new (_("pid :")); 
    entry = gnome_entry_new ("gdf_pid");

    hbox = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
    
    dlg = gnome_dialog_new (_("Attach"), GNOME_STOCK_BUTTON_OK, 
                            GNOME_STOCK_BUTTON_CANCEL, NULL);

    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dlg)->vbox), hbox, 
                        TRUE, TRUE, 0);

    gtk_widget_show (label);
    gtk_widget_show (entry);
    gtk_widget_show (hbox);

    btn = gnome_dialog_run (GNOME_DIALOG (dlg));
    
    if (btn != 0) {
        return GDF_DEBUGGER_CLIENT_OK;
    }
    
    pidstr = gtk_editable_get_chars (GTK_EDITABLE (gnome_entry_gtk_entry (GNOME_ENTRY (entry))), 0, -1);
    pid = atoi (pidstr);
    res = gdf_debugger_client_attach (dbg, pid);
    
    gnome_dialog_close (GNOME_DIALOG (dlg));

    errmsg = NULL;
    switch (res) {
    case GDF_DEBUGGER_CLIENT_OK :
        break;
    case GDF_DEBUGGER_CLIENT_NO_BINARY :
        errmsg = _("No binary loaded.");
    case GDF_DEBUGGER_CLIENT_DOESNT_EXIST :
        errmsg = _("Process doesn't exist.");
        break;
    case GDF_DEBUGGER_CLIENT_SECURITY_EXCEPTION :
        errmsg = _("Access denied.");
        break;
    case GDF_DEBUGGER_CLIENT_INVALID_STATE :
        errmsg = _("Binary must be loaded and not running.");
    case GDF_DEBUGGER_CLIENT_UNKNOWN_ERROR :
        errmsg = _("An unexpected error occured.");
    default :
        g_assert_not_reached ();
    }

    if (errmsg) {
        errmsg = 
            g_strdup_printf (_("Could not attach to process: %s"), errmsg);
        dlg = gnome_error_dialog (errmsg);
        gnome_dialog_run_and_close (GNOME_DIALOG (dlg));
    }    

    return res;
}

