/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- */

#ifndef __GDF_LIBDRYAD_DEBUGGER_H__
#define __GDF_LIBDRYAD_DEBUGGER_H__

typedef struct _GdfLibdryadDebugger GdfLibdryadDebugger;

#include <bonobo/bonobo-object.h>
#include "../../lib/gdf.h"
#include "libdryad.h"
#include "gdf-libdryad-symbol-set.h"

BEGIN_GNOME_DECLS

#define GDF_LIBDRYAD_DEBUGGER_TYPE (gdf_libdryad_debugger_get_type ())
#define GDF_LIBDRYAD_DEBUGGER(o) (GTK_CHECK_CAST ((o), GDF_LIBDRYAD_DEBUGGER_TYPE, GdfLibdryadDebugger))
#define GDF_LIBDRYAD_DEBUGGER_CLASS(k) (GTK_CHECK_CLASS_CAST ((k), GDF_LIBDRYAD_DEBUGGER_CLASS_TYPE, GdfLibdryadDebuggerClass))
#define GDF_IS_LIBDRYAD_DEBUGGER(o) (GTK_CHECK_TYPE ((o), GDF_LIBDRYAD_DEBUGGER_TYPE))
#define GDF_IS_LIBDRYAD_DEBUGGER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), GDF_LIBDRYAD_DEBUGGER_TYPE))

struct _GdfLibdryadDebugger {
    BonoboObject base;

    GdbInstance *gdb_inst;
    GdfEventChannelClient *event_channel;
    GDF_Debugger_State state;

    gchar *tty_name;
    gint pending_exit;
    gint error_condition;
    GList *event_queue;
    GList *stopped_handlers;

    GdfLibdryadSymbolSet *locals;
    GList *symsets;

    gboolean frame_changed;
};

typedef struct 
{
    BonoboObjectClass parent_class;
} GdfLibdryadDebuggerClass;

GdfLibdryadDebugger *gdf_libdryad_debugger_new (void);
GtkType gdf_libdryad_debugger_get_type (void);

END_GNOME_DECLS

#endif

