/* GNOME-DB Components
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if !defined(__components_manager_view_h__)
#  define __components_manager_view_h__

#include <gtk/gtkvbox.h>

G_BEGIN_DECLS

#define COMPONENTS_TYPE_MANAGER_VIEW    (components_manager_view_get_type ())
#define COMPONENTS_MANAGER_VIEW(obj)    (GTK_CHECK_CAST (obj, COMPONENTS_TYPE_MANAGER_VIEW, ComponentsManagerView))
#define COMPONENTS_IS_MANAGER_VIEW(obj) (GTK_CHECK_TYPE (obj, COMPONENTS_TYPE_MANAGER_VIEW))

typedef struct _ComponentsManagerView        ComponentsManagerView;
typedef struct _ComponentsManagerViewClass   ComponentsManagerViewClass;
typedef struct _ComponentsManagerViewPrivate ComponentsManagerViewPrivate;

struct _ComponentsManagerView {
        GtkVBox box;
        ComponentsManagerViewPrivate *priv;
};

struct _ComponentsManagerViewClass {
        GtkVBoxClass parent_class;
};

GType      components_manager_view_get_type (void);

GtkWidget *components_manager_view_new (void);
void       components_manager_view_delete_selected (ComponentsManagerView *view);
void       components_manager_view_show_properties (ComponentsManagerView *view);
void       components_manager_view_select_all (ComponentsManagerView *view);
void       components_manager_view_unselect_all (ComponentsManagerView *view);

#endif
