/* GNOME DB library
 * * Copyright (C) 1998-2001 The Free Software Foundation
 *
 * Authors:
 *	Michael Lausch <michael@lausch.at>
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "gnome-db-login-dlg.h"
#include <gtk/gtkcombo.h>
#include <gtk/gtkeditable.h>
#include <gtk/gtksignal.h>
#include <libgnomeui/gnome-stock.h>
#include <libgnomeui/gnome-uidefs.h>

enum
{
	GNOME_DB_LOGIN,
	GNOME_DB_CANCEL,
	LAST_SIGNAL
};

static gint
gnome_db_logindlg_signals[LAST_SIGNAL] = {0,};

static void gnome_db_logindlg_class_init (GnomeDbLoginDlgClass* klass);
static void gnome_db_logindlg_init       (GnomeDbLoginDlg* login);


void
logindlg_loginhandler (GnomeDbLoginDlg* login)
{
}  

void
logindlg_cancelhandler (GnomeDbLoginDlg* login)
{
}

GtkType
gnome_db_logindlg_get_type (void)
{
	static GtkType db_logindlg_type = 0;

	if (!db_logindlg_type) {
		GtkTypeInfo db_logindlg_info = {
			"GnomeDbLoginDlg",
			sizeof (GnomeDbLoginDlg),
			sizeof(GnomeDbLoginDlgClass),
			(GtkClassInitFunc) gnome_db_logindlg_class_init,
			(GtkObjectInitFunc) gnome_db_logindlg_init,
			(GtkArgSetFunc) NULL,
			(GtkArgGetFunc) NULL,
		};
		db_logindlg_type = gtk_type_unique(gnome_dialog_get_type(), &db_logindlg_info);
    }
	return db_logindlg_type;
}


static void
gnome_db_logindlg_class_init (GnomeDbLoginDlgClass* klass)
{
	GtkObjectClass* object_class;

	object_class = (GtkObjectClass*) klass;

	gnome_db_logindlg_signals[GNOME_DB_LOGIN] =
		gtk_signal_new("login",
					   GTK_RUN_LAST,
					   object_class->type,
					   GTK_SIGNAL_OFFSET(GnomeDbLoginDlgClass, login),
					   gtk_signal_default_marshaller,
					   GTK_TYPE_NONE, 0);
	gnome_db_logindlg_signals[GNOME_DB_CANCEL] =
		gtk_signal_new("cancel",
					   GTK_RUN_LAST,
					   object_class->type,
					   GTK_SIGNAL_OFFSET(GnomeDbLoginDlgClass, cancel),
					   gtk_signal_default_marshaller,
					   GTK_TYPE_NONE, 0);

	gtk_object_class_add_signals(object_class, gnome_db_logindlg_signals, LAST_SIGNAL);
  
	klass->login = logindlg_loginhandler;
	klass->cancel = logindlg_cancelhandler;
}
      

static void
gnome_db_logindlg_init (GnomeDbLoginDlg* login)
{
}


static void
cb_login (GtkWidget* button, gpointer data)
{
  GnomeDbLoginDlg* dialog = GNOME_DB_LOGINDLG(data);
}

static void
cb_cancel (GtkWidget* button, gpointer data)
{
  gnome_dialog_close(GNOME_DIALOG(data));
  gtk_signal_emit(GTK_OBJECT(data), gnome_db_logindlg_signals[GNOME_DB_CANCEL]);
}

/**
 * gnome_db_logindlg_new
 * @login: the GnomeDbLogin widget to be displayed
 * @title: title for the dialog box
 *
 * Create a new GnomeDbLoginDlg and display on it the given GnomeDbLogin
 * widget. The GnomeDbLoginDlg is a convenience widget created to allow
 * easy creation of a dialog box for connecting to any GDA datasource
 *
 * Returns: a pointer to the new widget, or NULL on error
 */
GtkWidget*
gnome_db_logindlg_new (GnomeDbLogin* login, gchar* title)
{
  GtkWidget*   widget;
  const gchar* buttons[3];
  GnomeDialog* dialog;
  
  buttons[0] = GNOME_STOCK_BUTTON_OK;
  buttons[1] = GNOME_STOCK_BUTTON_CANCEL;
  buttons[2] = 0;
  
  widget = gtk_type_new(gnome_db_logindlg_get_type());
  gnome_dialog_constructv(GNOME_DIALOG(widget), title, buttons);
  gnome_dialog_set_default(GNOME_DIALOG(widget), 0);
  
  GNOME_DB_LOGINDLG(widget)->login = login;
  dialog = GNOME_DIALOG(widget);
  gnome_dialog_editable_enters(dialog, GTK_EDITABLE(GTK_COMBO(login->gda_dbname)->entry));
  gnome_dialog_editable_enters(dialog, GTK_EDITABLE(login->username_entry));
  gnome_dialog_editable_enters(dialog, GTK_EDITABLE(login->password_entry));
  gnome_dialog_button_connect(dialog, 0, GTK_SIGNAL_FUNC(cb_login), dialog);
  gnome_dialog_button_connect(dialog, 1, GTK_SIGNAL_FUNC(cb_cancel), dialog);
  gtk_box_pack_start(GTK_BOX(dialog->vbox), GTK_WIDGET(login), TRUE, TRUE, GNOME_PAD);
  gtk_widget_show(GTK_WIDGET(login));
  return widget;
}

/**
 * gnome_db_logindlg_popup
 * @dialog: th GnomeDbLoginDlg widget
 *
 * Popup (open) the given GnomeDbLoginDlg widget, allowing the user to easily
 * selecting the data source to which she wants to connect
 */
void
gnome_db_logindlg_popup (GnomeDbLoginDlg* dialog)
{
  g_return_if_fail(GNOME_DB_IS_LOGINDLG(dialog));
  gtk_widget_show(GTK_WIDGET(dialog));
}
