/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"

static void refresh_list_cb (GtkWidget *w, GtkCList *clist);

static GnomeUIInfo providers_toolbar[] = {
	{ GNOME_APP_UI_ITEM, N_("New"), N_("Add new provider"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_NEW, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Edit"), N_("Edit selected provider"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_PROP, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Refresh"), N_("Refresh providers list"),
	  refresh_list_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_REFRESH, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Start"), N_("Start selected provider"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_EXEC, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Stop"), N_("Stop selected provider"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_STOP, 0, 0, NULL },
	GNOMEUIINFO_END
};

/*
 * Private functions
 */
static void
fill_providers_list (GtkCList *clist)
{
	GList* prov_list;
	GList* node;
	
	g_return_if_fail(GTK_IS_CLIST(clist));
	
	gnome_db_clear_clist(clist);
	gtk_clist_freeze(clist);
	prov_list = gda_provider_list();
	for (node = g_list_first(prov_list); node != NULL; node = g_list_next(node)) {
		GdaProvider* prov = (GdaProvider *) node->data;
		if (prov) {
			gchar*       row[3] = { "", "", ""};
			GnomePixmap* pixmap;
			gint         row_number;
			
			row[1] = GDA_PROVIDER_NAME(prov);
			row[2] = GDA_PROVIDER_COMMENT(prov);
			row_number = gtk_clist_append(clist, row);
			
			if (gda_corba_oafiid_is_active(GDA_PROVIDER_NAME(prov)))
				pixmap = gnome_db_get_pixmap(GNOME_STOCK_MENU_EXEC);
			else
				pixmap = gnome_db_get_pixmap(GNOME_STOCK_MENU_STOP);
			gtk_clist_set_pixmap(clist, row_number, 0, pixmap->pixmap, pixmap->mask);
		}
	}
	gda_provider_free_list(prov_list);
	gtk_clist_thaw(clist);
}

/*
 * Callbacks
 */
static void
refresh_list_cb (GtkWidget *w, GtkCList *clist) {
	g_return_if_fail(GTK_IS_CLIST(clist));
	fill_providers_list(clist);
}

/*
 * Public functions
 */
void
manager_providers_init (GtkNotebook *notebook) {
	GtkWidget* table;
	GtkWidget* toolbar;
	GtkWidget* scroll;
	GtkWidget* clist;
	gchar*     clist_titles[] = { "", N_("Name"), N_("Description") };
	
	g_return_if_fail(GTK_IS_NOTEBOOK(notebook));
	
	table = gnome_db_new_table_widget(1, 2, FALSE);
	scroll = gnome_db_new_scrolled_window_widget();
	gtk_table_attach(GTK_TABLE(table), scroll, 0, 1, 1, 2,
	                 GTK_FILL | GTK_EXPAND | GTK_SHRINK,
	                 GTK_FILL | GTK_EXPAND | GTK_SHRINK,
	                 3, 3);
	clist = gnome_db_new_clist_widget(clist_titles, sizeof(clist_titles) / sizeof(clist_titles[0]));
	fill_providers_list(GTK_CLIST(clist));
	gtk_container_add(GTK_CONTAINER(scroll), clist);
	toolbar = gnome_db_new_toolbar_widget(GTK_ORIENTATION_HORIZONTAL,
	                                      GTK_TOOLBAR_ICONS,
	                                      providers_toolbar,
	                                      (gpointer) clist);
	gtk_table_attach(GTK_TABLE(table), toolbar, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
	
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, gtk_label_new(_("Providers")));
}

