/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_grid_h__
#define __gnome_db_grid_h__ 1

#include <gtk/gtkvbox.h>
#include <libgnome/gnome-defs.h>
#include <gda-recordset.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_GRID            (gnome_db_grid_get_type())
#define GNOME_DB_GRID(obj)            GTK_CHECK_CAST (obj, GNOME_DB_TYPE_GRID, GnomeDbGrid)
#define GNOME_DB_GRID_CLASS(klass)    GTK_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_GRID, GnomeDbGridClass)
#define GNOME_DB_IS_GRID(obj)         GTK_CHECK_TYPE (obj, GNOME_DB_TYPE_GRID)
#define GNOME_DB_IS_GRID_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_GRID))

typedef struct _GnomeDbGrid      GnomeDbGrid;
typedef struct _GnomeDbGridClass GnomeDbGridClass;

struct _GnomeDbGrid {
	GtkVBox        parent;
	GtkWidget*     scrolled_window;
	GtkWidget*     grid; 
	GdaRecordset* recset; 
	gint           total_rows;
	gboolean       show_row_numbers;
	gboolean       show_col_names;
	gint           timeout_handle;
	GtkWidget*     invisible;
	gchar*         clipboard_selection;
};

struct _GnomeDbGridClass {
	GtkVBoxClass parent_class;
	
	void         (*error)       (GnomeDbGrid *grid);
	void         (*loaded)      (GnomeDbGrid *grid);
	void         (*select_row)  (GnomeDbGrid *grid, gint row);
	void         (*unselect_row)(GnomeDbGrid *grid, gint row);
	void         (*add_row)     (GnomeDbGrid *grid, gint row);
};

guint          gnome_db_grid_get_type              (void);
GtkWidget*     gnome_db_grid_new                   (GdaRecordset *recset);

void           gnome_db_grid_set_background        (GnomeDbGrid *grid,
                                                    gint row,
                                                    GdkColor *color);
void           gnome_db_grid_set_foreground        (GnomeDbGrid *grid,
                                                    gint row,
                                                    GdkColor *color);

void           gnome_db_grid_select_all            (GnomeDbGrid *grid);
void           gnome_db_grid_clear_selection       (GnomeDbGrid *grid);
gint           gnome_db_grid_get_selected_rows     (GnomeDbGrid *grid);
void           gnome_db_grid_copy_clipboard        (GnomeDbGrid *grid);
const gchar*   gnome_db_grid_get_cell              (GnomeDbGrid *grid,
                                                    gint col,
                                                    gint row);

void           gnome_db_grid_set_column_visibility (GnomeDbGrid *grid,
                                                    gint col,
                                                    gint vis);
void           gnome_db_grid_set_row_visibility    (GnomeDbGrid *grid,
                                                    gint row,
                                                    gint vis);
void           gnome_db_grid_hide_column_titles    (GnomeDbGrid *grid);
void           gnome_db_grid_show_column_titles    (GnomeDbGrid *grid);
void           gnome_db_grid_hide_row_numbers      (GnomeDbGrid *grid);
void           gnome_db_grid_show_row_numbers      (GnomeDbGrid *grid);

#define        gnome_db_grid_get_row_count(grid)   (GNOME_DB_GRID(grid)->total_rows)
void           gnome_db_grid_clear                 (GnomeDbGrid *grid);
//void           gnome_db_grid_refresh               (GnomeDbGrid *grid);
GdaRecordset*  gnome_db_grid_get_recordset         (GnomeDbGrid *grid);
void           gnome_db_grid_set_recordset         (GnomeDbGrid *grid,
                                                    GdaRecordset *recset);

END_GNOME_DECLS

#endif
