/* GNOME DB library
 * Copyright (C) 1999-2001 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gnome_db_dsn_config_druid_h__
#define __gnome_db_dsn_config_druid_h__ 1

#include <libgnome/gnome-defs.h>
#include <libgnomeui/gnome-druid.h>
#include <gda-config.h>

#define GNOME_DB_TYPE_DSN_CONFIG_DRUID            (gnome_db_dsn_config_druid_get_type())
#define GNOME_DB_DSN_CONFIG_DRUID(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_DSN_CONFIG_DRUID, GnomeDbDsnConfigDruid)
#define GNOME_DB_DSN_CONFIG_DRUID_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_DSN_CONFIG_DRUID, GnomeDbDsnConfigDruidClass)
#define GNOME_DB_IS_DSN_CONFIG_DRUID(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_DSN_CONFIG_DRUID)
#define GNOME_DB_IS_DSN_CONFIG_DRUID_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_DSN_CONFIG_DRUID))

typedef struct _GnomeDbDsnConfigDruidPrivate GnomeDbDsnConfigDruidPrivate;
typedef struct _GnomeDbDsnConfigDruid        GnomeDbDsnConfigDruid;
typedef struct _GnomeDbDsnConfigDruidClass   GnomeDbDsnConfigDruidClass;

struct _GnomeDbDsnConfigDruid {
	GnomeDruid                    druid;
	GnomeDbDsnConfigDruidPrivate *priv;
};

struct _GnomeDbDsnConfigDruidClass {
	GnomeDruidClass parent_class;

	void (*finish)(GnomeDbDsnConfigDruid *druid, gboolean error);
};

GtkType    gnome_db_dsn_config_druid_get_type (void);

GtkWidget *gnome_db_dsn_config_druid_new      (void);
GdaDsn    *gnome_db_dsn_config_druid_get_dsn  (GnomeDbDsnConfigDruid *druid);

#endif
