/*  GNOME-DB Builder
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnomedb-builder.h"

static guint prepare_app (void);

BonoboGenericFactory* builder_factory = NULL;

int
main (int argc, char *argv[])
{
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);
	
	gnome_db_init("gnomedb-builder", VERSION, argc, argv);
	
	/* run application */
	gnome_db_main((GtkFunction) prepare_app);
	return 0;
}

static BonoboObject *
builder_factory_func (BonoboGenericFactory *factory, const char *id, gpointer closure)
{
	g_return_val_if_fail(BONOBO_IS_GENERIC_FACTORY(factory), NULL);
	g_return_val_if_fail(id != NULL, NULL);
	
	if (!strcmp(id, GNOME_DB_OAFIID_BUILDER))
		return builder_control_new();

	return NULL;
}

static guint
prepare_app (void)
{
	/* create builder factory */
	builder_factory = bonobo_generic_factory_new_multi(GNOME_DB_OAFIID_BUILDER_FACTORY,
	                                                   builder_factory_func,
	                                                   NULL);
	bonobo_running_context_auto_exit_unref(BONOBO_OBJECT(builder_factory));

	return FALSE;
}
