/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gda_dblogin_h__
#define __gda_dblogin_h__ 1

#include <gnome.h>
#include <gda-connection.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_LOGIN            (gnome_db_login_get_type())
#define GNOME_DB_LOGIN(obj)            (GTK_CHECK_CAST((obj), GNOME_DB_TYPE_LOGIN, GnomeDbLogin))
#define GNOME_DB_LOGIN_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_DB_TYPE_LOGIN, GnomeDbLoginClass))
#define GNOME_DB_IS_LOGIN(obj)         GTK_CHECK_TYPE(obj, gnome_db_login_get_type())
#define GNOME_DB_IS_LOGIN_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_LOGIN))

typedef struct _GnomeDbLogin           GnomeDbLogin;
typedef struct _GnomeDbLoginClass      GnomeDbLoginClass;

struct _GnomeDbLogin
{
  GtkVBox         box;
  GtkWidget*      gda_dbname;
  GtkWidget*      username_entry;
  GtkWidget*      password_entry;
  GtkWidget*      connection_list;
  Gda_Connection* cnc;
};

struct _GnomeDbLoginClass
{
  GtkVBoxClass      parent_class;
  void              (*login)(GnomeDbLogin* login);
};

GtkType      gnome_db_login_get_type (void);

GtkWidget*   gnome_db_login_new          (Gda_Connection* cnc, gchar* gda_provider, gchar* gda_dbname);
void         gnome_db_login_login        (GnomeDbLogin* login);
void         gnome_db_login_free         (GnomeDbLogin* widget);

const gchar* gnome_db_login_get_gda_name (GnomeDbLogin *login);
const gchar* gnome_db_login_get_username (GnomeDbLogin *login);
const gchar* gnome_db_login_get_password (GnomeDbLogin *login);

END_GNOME_DECLS

#endif
