/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome-db-control-corba.h>

/*** Stub implementations ***/

CORBA_char *
impl_GNOME_DB_Control_getVersion (PortableServer_Servant servant,
                                  CORBA_Environment * ev)
{
	return CORBA_string_dup(VERSION); 
}

CORBA_char *
impl_GNOME_DB_Control_getAuthors (PortableServer_Servant servant,
                                  CORBA_Environment *ev)
{
}

void
impl_GNOME_DB_Control_run (PortableServer_Servant servant,
                           CORBA_Environment *ev)
{
}

void
impl_GNOME_DB_Control_setOwner (PortableServer_Servant servant,
				CORBA_Environment *ev)
{
	g_return_if_fail (servant != NULL);
	gtk_signal_emit_by_name (GTK_OBJECT (bonobo_x_object (servant)), "set_owner");
}

void
impl_GNOME_DB_Control_unsetOwner (PortableServer_Servant servant,
				  CORBA_Environment *ev)
{
	g_return_if_fail (servant != NULL);
	gtk_signal_emit_by_name (GTK_OBJECT (bonobo_x_object (servant)), "unset_owner");
}

void
impl_GNOME_DB_Control_doPrint (PortableServer_Servant servant,
                               CORBA_Environment *ev)
{
	g_return_if_fail (servant != NULL);
	gtk_signal_emit_by_name (GTK_OBJECT (bonobo_x_object (servant)), "do_print");
}

void
impl_GNOME_DB_Control_doCutClipboard (PortableServer_Servant servant,
                                      CORBA_Environment *ev)
{
	g_return_if_fail(servant != NULL);
	gtk_signal_emit_by_name(GTK_OBJECT(bonobo_x_object (servant)), "do_cut_clipboard");
}

void
impl_GNOME_DB_Control_doCopyClipboard (PortableServer_Servant servant,
                                       CORBA_Environment *ev)
{
	g_return_if_fail(servant != NULL);
	gtk_signal_emit_by_name(GTK_OBJECT(bonobo_x_object (servant)), "do_copy_clipboard");
}

void
impl_GNOME_DB_Control_doPasteClipboard (PortableServer_Servant servant,
                                        CORBA_Environment *ev)
{
	g_return_if_fail(servant != NULL);
	gtk_signal_emit_by_name(GTK_OBJECT(bonobo_x_object (servant)), "do_paste_clipboard");
}
