/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static guint prepare_app (void);

/*
 * Variables
 */
GtkWidget* glb_mainwin = NULL;

/* menus */
static GnomeUIInfo filenewmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("_Database..."), N_("Create a new database"),
	  fe_new_database_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_MAIL, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo fileopenmenu[] = {
#if defined(HAVE_PERL)
	{ GNOME_APP_UI_ITEM, N_("Perl script"), N_("Open a Perl script to be executed"),
	  fe_run_perl_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
#endif
	GNOMEUIINFO_END
};
static GnomeUIInfo filemenu[] = {
	GNOMEUIINFO_SUBTREE_STOCK(N_("_New"), filenewmenu, GNOME_STOCK_MENU_NEW),
	GNOMEUIINFO_SUBTREE_STOCK(N_("_Open"), fileopenmenu, GNOME_STOCK_MENU_OPEN),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PRINT_ITEM(fe_do_print_cb, NULL),
	{ GNOME_APP_UI_ITEM, N_("Print preview"), N_("Print preview"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_SEARCH, GNOME_APP_CONFIGURABLE_ITEM_FIND, 0, NULL },
	GNOMEUIINFO_MENU_PRINT_SETUP_ITEM(gnome_db_print_setup_dlg_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Quit"), N_("Exit application"),
	  fe_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_QUIT, GNOME_APP_CONFIGURABLE_ITEM_EXIT, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo editmenu[] = {
	GNOMEUIINFO_MENU_CUT_ITEM (fe_do_cut_clipboard_cb, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM (fe_do_copy_clipboard_cb, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM (fe_do_paste_clipboard_cb, NULL),
	GNOMEUIINFO_END
};
static GnomeUIInfo viewmenu[] = {
	GNOMEUIINFO_TOGGLEITEM (N_("Shortcut _bar"), N_("Show/Hide shortcut bar"),
				fe_show_shortcut_bar_cb, NULL),
	GNOMEUIINFO_END
};
static GnomeUIInfo databasemenu[] = {
	GNOMEUIINFO_END
};
static GnomeUIInfo toolsmenu[] = {
	GNOMEUIINFO_END
};
static GnomeUIInfo optionsmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
	  fe_preferences_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_PREF, GNOME_APP_CONFIGURABLE_ITEM_PREFERENCES, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo helpmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("GNOME-DB Manual"), N_("Open the GNOME-DB online manual"),
	  fe_open_gnome_db_manual_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("libgda Manual"), N_("Open the libgda online manual"),
	  fe_open_libgda_manual_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("libgda API Reference"), N_("Open the libgda API reference"),
	  fe_open_libgda_reference_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("About GNOME-DB..."), N_("View information about this application"),
	  fe_about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_ABOUT, GNOME_APP_CONFIGURABLE_ITEM_ABOUT, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Submit bug report"), N_("Send a bug report to GNOME-DB developers"),
	  gnome_db_submit_bug_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo mainmenu[] = {
	GNOMEUIINFO_SUBTREE (N_("_File"), filemenu),
	GNOMEUIINFO_SUBTREE (N_("_Edit"), editmenu),
	GNOMEUIINFO_SUBTREE (N_("_View"), viewmenu),
	GNOMEUIINFO_SUBTREE (N_("_Database"), databasemenu),
	GNOMEUIINFO_SUBTREE (N_("_Tools"), toolsmenu),
	GNOMEUIINFO_SUBTREE (N_("_Options"), optionsmenu),
	GNOMEUIINFO_SUBTREE (N_("_Help"), helpmenu),
	GNOMEUIINFO_END
};

/* toolbar */
static GnomeUIInfo toolbar[] = {
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

int
main (int argc, char *argv[])
{
	gchar *icon_file;

	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);
	
	gnome_db_init("gnomedb-fe", VERSION, argc, argv);
	fe_config_load();
	
	icon_file = gnome_pixmap_file("gnome-db.png");
	gnome_window_icon_set_default_from_file(icon_file);

	/* run application */
	gnome_db_main((GtkFunction) prepare_app);
	g_free((gpointer) icon_file);

	return 0;
}

static guint
prepare_app (void)
{
	glb_mainwin = gnome_db_window_new("gnomedb-fe", mainmenu, toolbar, NULL);
	gtk_signal_connect(GTK_OBJECT(glb_mainwin),
	                   "close",
	                   GTK_SIGNAL_FUNC(fe_quit_cb),
	                   NULL);

	gnome_db_window_set_contents(GNOME_DB_WINDOW(glb_mainwin), fe_workarea_create());
	gnome_db_window_show(GNOME_DB_WINDOW(glb_mainwin));
	
	if (gda_config_get_boolean(GNOMEDB_FE_CONFIG_KEY_SAVE_WINDOW_POS))
		gnome_db_load_window_config("MainWindow", glb_mainwin);
	
	return FALSE;
}
