/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-com.h>

static void new_table_cb        (GtkWidget *w, GnomeDbControl *control);
static void open_database_cb    (GtkWidget *w, GnomeDbControl *control);
static void refresh_database_cb (GtkWidget *w, GnomeDbControl *control);
static void save_database_cb    (GtkWidget *w, GnomeDbControl *control);

static GnomeUIInfo filenewmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Database design"), N_("Start with a new database design"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_NEW, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Table..."), N_("Add a table to the database design"),
	  new_table_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	 GNOMEUIINFO_END
};
static GnomeUIInfo fileopenmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Database design"), N_("Open an existing database design"),
	  open_database_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo filemenu[] = {
	GNOMEUIINFO_SUBTREE_STOCK(N_("_New"), filenewmenu, GNOME_STOCK_MENU_NEW),
	GNOMEUIINFO_SUBTREE_STOCK(N_("_Open"), fileopenmenu, GNOME_STOCK_MENU_OPEN),
	GNOMEUIINFO_END
};
static GnomeUIInfo editmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Remove"), N_("Remove selected object"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_MENU_TRASH, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo designer_control_menu[] = {
	GNOMEUIINFO_SUBTREE(N_("_File"), filemenu),
	GNOMEUIINFO_SUBTREE(N_("_Edit"), editmenu),
	GNOMEUIINFO_END
};
static GnomeUIInfo designer_control_toolbar[] = {
	{ GNOME_APP_UI_ITEM, N_("New"), N_("Create new database design"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Open"), N_("Open an existing database design"),
	  open_database_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Save"), N_("Save currently open file"),
	  save_database_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Refresh"), N_("Reload database file contents"),
	  refresh_database_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_REFRESH, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Add"), N_("Add new object to the database"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Remove"), N_("Remove selected object"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_TRASH, 0, 0, NULL },
	GNOMEUIINFO_END
};

/*
 * Callbacks
 */

static void
new_table_cb (GtkWidget *w, GnomeDbControl *control)
{
	g_return_if_fail(GNOME_DB_IS_CONTROL(control));
}

static void
open_database_cb (GtkWidget *w, GnomeDbControl *control)
{
	gchar* filename;
	
	g_return_if_fail(GNOME_DB_IS_CONTROL(control));

	filename = gnome_db_select_file(_("Select database design"));
	if (filename) {
		GtkWidget* designer;
		
		designer = gnome_db_control_get_widget(control);
		if (GNOME_DB_IS_DESIGNER(designer))
			gnome_db_designer_load_file(GNOME_DB_DESIGNER(designer), filename);
		g_free((gpointer) filename);
	}
}

static void
refresh_database_cb (GtkWidget *w, GnomeDbControl *control)
{
	GtkWidget* designer;
	
	g_return_if_fail(GNOME_DB_IS_CONTROL(control));
	
	designer = gnome_db_control_get_widget(control);
	if (GNOME_DB_IS_DESIGNER(designer))
		gnome_db_designer_refresh(GNOME_DB_DESIGNER(designer));
}

static void
save_database_cb (GtkWidget *w, GnomeDbControl *control)
{
	GtkWidget *designer;

	g_return_if_fail(GNOME_DB_IS_CONTROL(control));

	designer = gnome_db_control_get_widget(control);
	if (GNOME_DB_IS_DESIGNER(designer))
		gnome_db_designer_save(GNOME_DB_DESIGNER(designer));
}

/*
 * Public functions
 */
BonoboObject *
components_designer_new (void)
{
	GtkWidget*      designer;
	GnomeDbControl* control;

	designer = gnome_db_designer_new();
	gtk_widget_show_all(designer);
	
	/* create the control instance */
	control = gnome_db_control_new(designer);
	if (GNOME_DB_IS_CONTROL(control)) {
		gnome_db_control_set_menubar(control, designer_control_menu);
		gnome_db_control_set_toolbar(control, designer_control_toolbar);
	}
	return BONOBO_OBJECT(control);
}

