/* GNOME DB components libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_component_h__)
#  define __gnome_db_component_h__

#include <gnome.h>
#include <bonobo.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_COMPONENT            (gnome_db_component_get_type())
#define GNOME_DB_COMPONENT(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_COMPONENT, GnomeDbComponent)
#define GNOME_DB_COMPONENT_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_COMPONENT, GnomeDbComponentClass)
#define GNOME_DB_IS_COMPONENT(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_COMPONENT)
#define GNOME_DB_IS_COMPONENT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_COMPONENT))

typedef struct _GnomeDbComponent      GnomeDbComponent;
typedef struct _GnomeDbComponentClass GnomeDbComponentClass;

struct _GnomeDbComponent
{
  BonoboObject          bonobo_object;
  BonoboGenericFactory* factory;
};

struct _GnomeDbComponentClass
{
  BonoboObjectClass parent_class;
};

GtkType    gnome_db_component_get_type (void);
GtkObject* gnome_db_component_new      (const gchar *id);

END_GNOME_DECLS

#endif
