/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome-db-util.h>
#include <stdio.h>

/**
 * gnome_db_util_load_file
 * @filename: file name
 *
 * Load a file from disk, and return its contents as a newly-allocated
 * string. You must then free it yourself when no longer needed
 */
gchar *
gnome_db_util_load_file (const gchar *filename)
{
  GString* str;
  FILE*    fp;
  gchar*   ret;
  gchar    buffer[2049];
  
  g_return_val_if_fail(filename != NULL, NULL);
  
  if ((fp = fopen(filename, "r")))
    {
      str = g_string_new("");
      while (!feof(fp))
        {
          memset(buffer, 0, sizeof(buffer));
          fread((void *) buffer, sizeof(buffer) - 1, 1, fp);
          str = g_string_append(str, buffer);
        }
      fclose(fp);
      ret = g_strdup(str->str);
      g_string_free(str, TRUE);
      return ret;
    }
  else g_warning(_("Could not open file %s"), filename);
  return NULL;
}

/**
 * gnome_db_util_save_file
 * @filename: file name
 * @text: file contents
 *
 * Save the given text into a file
 */
gboolean
gnome_db_util_save_file (const gchar *filename, const gchar *text)
{
  FILE* fp;
  
  g_return_val_if_fail(filename != NULL, FALSE);
  g_return_val_if_fail(text != NULL, FALSE);
  
  if ((fp = fopen(filename, "w")))
    {
      fwrite((void *) text, strlen(text), 1, fp);
      fclose(fp);
      return TRUE;
    }
  else g_warning(_("Could not create file %s"), filename);
  return FALSE;
}
