/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_control_corba_h__)
#  define __gnome_db_control_corba_h__

#include <orb/orb.h>

#include <GnomeDB.h>
#include "gnome-db-control.h"

/*** App-specific servant structures ***/

typedef struct
{
  POA_GNOME_DB_Control servant;
  PortableServer_POA        poa;
  GnomeDbControlInstance*   control_instance;
} impl_POA_GNOME_DB_Control;

/*** Implementation stub prototypes ***/

GNOME_DB_Control impl_GNOME_DB_Control__create (GnomeDbControlInstance *control_instance,
                                                          CORBA_Environment * ev);
void impl_GNOME_DB_Control__destroy (impl_POA_GNOME_DB_Control * servant,
                                          CORBA_Environment * ev);
void impl_GNOME_DB_Control_ref (impl_POA_GNOME_DB_Control * servant,
                                     CORBA_Environment * ev);
void impl_GNOME_DB_Control_unref (impl_POA_GNOME_DB_Control * servant,
                                       CORBA_Environment * ev);
Bonobo_Unknown impl_GNOME_DB_Control_queryInterface (impl_POA_GNOME_DB_Control * servant,
                                                          CORBA_char * repoid,
                                                          CORBA_Environment *ev);
                                                      
CORBA_char* impl_GNOME_DB_Control_getVersion (impl_POA_GNOME_DB_Control *servant,
                                                   CORBA_Environment * ev);
CORBA_char* impl_GNOME_DB_Control_getAuthors (impl_POA_GNOME_DB_Control *servant,
                                                   CORBA_Environment *ev);
void impl_GNOME_DB_Control_run (impl_POA_GNOME_DB_Control *servant,
                                     CORBA_Environment *ev);

void impl_GNOME_DB_Control_doPrint (impl_POA_GNOME_DB_Control *servant,
                                         CORBA_Environment *ev);
void impl_GNOME_DB_Control_doCutClipboard (impl_POA_GNOME_DB_Control *servant,
                                                CORBA_Environment *ev);
void impl_GNOME_DB_Control_doCopyClipboard (impl_POA_GNOME_DB_Control *servant,
                                                 CORBA_Environment *ev);
void impl_GNOME_DB_Control_doPasteClipboard (impl_POA_GNOME_DB_Control *servant,
                                                  CORBA_Environment *ev);

#endif
