/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"

static guint prepare_app (void);

/* global variables */
GtkWidget* glb_App = 0;
GtkWidget* glb_Shortcut = 0;
GtkWidget* glb_Notebook = 0;
GtkWidget* glb_StatusBar = 0;

/* menus */
GnomeUIInfo filemenu[] =
{
  GNOMEUIINFO_MENU_PRINT_SETUP_ITEM(gnome_db_print_setup_dlg_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    manager_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo toolsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Database browser"), N_("Open the database browser"),
    manager_open_browser_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PROP, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Front End"), N_("The GNOME-DB front end"),
    manager_run_app_cb, "gnomedb-fe", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Builder"), N_("The GNOME-DB development environment"),
    manager_run_app_cb, "gnomedb-builder", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    manager_about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Submit bug report"), N_("About this program"),
    gnome_db_submit_bug_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Tools"), toolsmenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};

/* toolbar */
GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    manager_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

/* CORBA exception handler */
void
Exception (CORBA_Environment *ev)
{
  switch (ev->_major)
    {
    case CORBA_SYSTEM_EXCEPTION :
      gnome_db_show_error("CORBA system exception %s", CORBA_exception_id(ev));
      exit(1);
    case CORBA_USER_EXCEPTION :
      gnome_db_show_error("CORBA user exception %s", CORBA_exception_id(ev));
      exit(1);
    default :
      break;
    }
}

gint
main (gint argc, gchar *argv[])
{
  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* initialize GNOME-DB */
  gnome_db_init("gnomedb-mgr", VERSION, argc, argv);

  /* load application settings and create main window */
  manager_config_load();

  /* run application */
  gnome_db_main((GtkFunction) prepare_app);
  return (0);
}

static guint
prepare_app (void)
{
  BonoboUIHandlerMenuItem* list;
  GtkWidget*               table;

  glb_App = gnome_app_new("gda-mgr", "GDA Manager");
  gtk_widget_realize(GTK_WIDGET(glb_App));
  gtk_signal_connect(GTK_OBJECT(glb_App), "delete_event",
                     GTK_SIGNAL_FUNC(manager_quit_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(glb_App), "destroy",
                     GTK_SIGNAL_FUNC(manager_quit_cb), NULL);

  /* get saved window position */
  gdk_window_move(GTK_WIDGET(glb_App)->window,
                  gda_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_X),
                  gda_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_Y));
  gtk_widget_set_usize(GTK_WIDGET(glb_App),
                       gda_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_WIDTH),
                       gda_config_get_int(MANAGER_CONFIG_MAIN_WINDOW_HEIGHT));
  gtk_widget_show(GTK_WIDGET(glb_App));
                  
  /* set main window contents */
  gnome_app_create_toolbar(GNOME_APP(glb_App), toolbar);
  table = gnome_db_new_table_widget(5, 1, TRUE);
  glb_Shortcut = gnome_db_shortcut_new();
  gtk_widget_show(glb_Shortcut);
  gnome_db_shortcut_append(glb_Shortcut,
			            _("Data Sources"),
			            _("Configure GDA data sources"),
			            GNOME_STOCK_PIXMAP_MAIL,
			            manager_activate_dsn_cb,
			            NULL);
  gnome_db_shortcut_append(glb_Shortcut,
			   _("Providers"),
			   _("Configure GDA providers"),
			   GNOME_STOCK_PIXMAP_CONVERT,
			   manager_activate_providers_cb,
			   NULL);
  gnome_db_shortcut_append(glb_Shortcut,
			   _("Components"),
			   _("Configure GNOME-DB components"),
			   GNOME_STOCK_PIXMAP_TIMER,
			   manager_activate_components_cb,
			   NULL);
  gtk_table_attach(GTK_TABLE(table), glb_Shortcut, 0, 1, 0, 1,
		   GTK_FILL | GTK_EXPAND,
		   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		   3, 3);
  glb_Notebook = gnome_db_new_notebook_widget();
  gtk_notebook_set_show_tabs(GTK_NOTEBOOK(glb_Notebook), FALSE);
  gtk_table_attach(GTK_TABLE(table), glb_Notebook, 1, 5, 0, 1,
		   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
		   3, 3);
  gnome_app_set_contents(GNOME_APP(glb_App), table);

  /* create menus */
  glb_UIHandler = bonobo_ui_handler_new();
  bonobo_ui_handler_set_app(glb_UIHandler, GNOME_APP(glb_App));
  bonobo_ui_handler_create_menubar(glb_UIHandler);

  list = bonobo_ui_handler_menu_parse_uiinfo_list(mainmenu);
  bonobo_ui_handler_menu_add_list(glb_UIHandler, "/", list);
  bonobo_ui_handler_menu_free_list(list);

  /* create status bar */
  glb_StatusBar = gnome_appbar_new(TRUE, TRUE, GNOME_PREFERENCES_USER);
  gnome_appbar_set_default(GNOME_APPBAR(glb_StatusBar), _("Ready"));
  gnome_app_set_statusbar(GNOME_APP(glb_App), glb_StatusBar);
  gnome_app_install_menu_hints(GNOME_APP(glb_App), mainmenu);

  gtk_widget_show(glb_App);

  /* add tabs tab */
  manager_gda_init();
  manager_gda_init_providers();
  manager_gda_init_components();

  manager_gda_activate();

  return FALSE;
}

