/* GDA Manager
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-mgr.h"

/*
 * Callbacks
 */
static gint
die_session_cb (GnomeClient *client, gpointer client_data)
{
  gtk_exit(0);
  return FALSE;
}

static gint
save_yourself_cb (GnomeClient *client, 
                  gint phase, 
	          GnomeRestartStyle restart_style,
	          gint shutdown,
	          GnomeInteractStyle interact_style,
  	          gint fast, 
  	          gpointer client_data)
{
  manager_config_save();
  return TRUE;
}

void
manager_config_load (void)
{
  GnomeClient* session;

  /* init session */
  session = gnome_master_client();
  gtk_signal_connect(GTK_OBJECT(session), "save_yourself",
		     GTK_SIGNAL_FUNC(save_yourself_cb), NULL);
  gtk_signal_connect(GTK_OBJECT(session), "die",
  		     GTK_SIGNAL_FUNC(die_session_cb), NULL);
}

void
manager_config_save(void)
{
  gint x, y, width, height;

  gda_config_commit();
}
