/* GNOME DB library
 * Copyright (C) 1999-2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#if !defined(_GNOME_DB_H_)
#  define _GNOME_DB_H_

#include <gnome.h>

#include <gda-client.h>
#include <gnome-db-component.h>
#include <gnome-db-container.h>
#include <gnome-db-control-defprops.h>
#include <gnome-db-control-widget.h>
#include <gnome-db-control.h>
#include <gnome-db-embeddable.h>
#include <gnome-db-factory.h>

#include <gnome-db-browser.h>
#include <gnome-db-combo.h>
#include <gnome-db-dsn-config.h>
#include <gnome-db-error.h>
#include <gnome-db-error-dlg.h>
#include <gnome-db-grid.h>
#include <gnome-db-icon-list.h>
#include <gnome-db-dataset.h>
#include <gnome-db-log-viewer.h>
#include <gnome-db-list.h>
#include <gnome-db-login.h>
#include <gnome-db-login-dlg.h>
#include <gnome-db-report.h>
#include <gnome-db-designer.h>
#include <gnome-db-shortcut.h>

BEGIN_GNOME_DECLS

/*
 * Initialization
 */
void gnome_db_init (const gchar *app_id, const gchar *version, int nargs, char *args[]);
void gnome_db_main (GtkFunction ui_create_func);
#define gnome_db_main_quit() gtk_main_quit()

/*
 * Common widgets creation
 */
GtkWidget* gnome_db_new_button_widget             (gchar *);
GtkWidget* gnome_db_new_button_widget_with_pixmap (const gchar *, const gchar *);
GtkWidget* gnome_db_new_check_button_widget       (gchar *, gint );
GtkWidget* gnome_db_new_clist_widget              (gchar *[], gint );
GtkWidget* gnome_db_new_color_picker_widget       (void);
GtkWidget* gnome_db_new_ctree_widget              (gchar *[], gint );
GtkWidget* gnome_db_new_combo_widget              (void);
GtkWidget* gnome_db_new_entry_widget              (gint , gboolean );
GtkWidget* gnome_db_new_file_entry_widget         (const gchar *history_id);
GtkWidget* gnome_db_new_file_viewer_widget        (const gchar *file);
GtkWidget* gnome_db_new_font_picker_widget        (void);
GtkWidget* gnome_db_new_frame_widget              (const gchar *label);
GtkWidget* gnome_db_new_grid_widget               (Gda_Recordset *recset);
GtkWidget* gnome_db_new_icon_widget               (const gchar *);
GtkWidget* gnome_db_new_icon_list_widget          (void);
GtkWidget* gnome_db_new_label_widget              (const gchar *);
GtkWidget* gnome_db_new_menu_item_widget          (GtkMenu *menu, const gchar *label);
GtkWidget* gnome_db_new_notebook_widget           (void);
GtkWidget* gnome_db_new_option_menu_widget        (void);
GtkWidget* gnome_db_new_radio_button_widget       (const gchar *, GtkRadioButton *);
GtkWidget* gnome_db_new_scrolled_window_widget    (void);
GtkWidget* gnome_db_new_table_widget              (guint cols, guint rows, gboolean homogenous);
GtkWidget* gnome_db_new_text_widget               (void);
GtkWidget* gnome_db_new_toolbar_widget            (GtkOrientation orientation,
                                                   GtkToolbarStyle style,
                                                   GnomeUIInfo uiinfo[],
                                                   gpointer user_data);
GtkWidget* gnome_db_new_tree_widget               (void);

/*
 * Common dialogs
 */
gchar* gnome_db_select_file   (const gchar *title);
void   gnome_db_show_error    (const gchar *, ...);
void   gnome_db_show_file     (const gchar *);
void   gnome_db_submit_bug_cb (GtkWidget *w, gpointer data);

/*
 * Utility functions (private use)
 */
void         gnome_db_clear_clist        (GtkCList *);
GnomePixmap* gnome_db_get_pixmap         (const gchar *stock_pixmap);
GtkWidget*   gnome_db_new_popup_menu     (GtkWidget *, GnomeUIInfo *, gpointer );
void         gnome_db_show_about_dialog  (const gchar *title);
void         gnome_db_set_bg_color       (GtkWidget *w, gint red, gint green, gint blue);

void         gnome_db_load_window_config (const gchar *name, GtkWidget *window);
void         gnome_db_save_window_config (const gchar *name, GtkWidget *window);

/*
 * Printing support
 */
void gnome_db_print_setup_dlg_cb (GtkWidget *w, gpointer data);

/*
 * Repo IDs of the different GNOME-DB components
 */
#define GNOME_DB_REPO_COMPONENT  "IDL:BonoboControl/gnome-db-component:1.0"
#define GNOME_DB_REPO_LOG_VIEWER "IDL:BonoboControl/gnome-db-log:1.0"

/*
 * Configuration sections
 */
#define GNOME_DB_CONFIG_SECTION_DESIGNER         "/gnome-db/Designer"
#define GNOME_DB_CONFIG_SECTION_LAST_CONNECTIONS "/gnome-db/LastConnections"

END_GNOME_DECLS

#endif
