/* GNOME DB library
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_shortcut_h__)
#  define __gnome_db_shortcut_h__

BEGIN_GNOME_DECLS

typedef struct _GnomeDbShortcut      GnomeDbShortcut;
typedef struct _GnomeDbShortcutClass GnomeDbShortcutClass;

#define GNOME_DB_TYPE_SHORTCUT            (gnome_db_shortcut_get_type())
#define GNOME_DB_SHORTCUT(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_SHORTCUT, GnomeDbShortcut)
#define GNOME_DB_SHORTCUT_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_SHORTCUT, GnomeDbShortcutClass)
#define GNOME_DB_IS_SHORTCUT(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_SHORTCUT)
#define GNOME_DB_IS_SHORTCUT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_SHORTCUT))

struct _GnomeDbShortcut
{
  GtkVBox    vbox;

  /* private */
  GtkWidget* tb;
};

struct _GnomeDbShortcutClass
{
  GtkVBoxClass parent_class;
};

GtkWidget* gnome_db_shortcut_new    (void);
void       gnome_db_shortcut_append (GnomeDbShortcut *shortcut,
                                     const gchar *str,
                                     const gchar *tooltip,
                                     const gchar *icon_file,
                                     GtkSignalFunc select_func,
                                     gpointer user_data);
void       gnome_db_shortcut_remove (GnomeDbShortcut *shortcut, const gchar *str);

END_GNOME_DECLS

#endif
