/* GNOME DB library
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gnome-db.h>

/*
 * Public functions
 */
static void
gnome_db_shortcut_class_init (GnomeDbShortcutClass *klass)
{
}

static void
gnome_db_shortcut_init (GnomeDbShortcut *shortcut)
{
  GtkWidget* frame;

  /* set colors */
  gnome_db_set_bg_color(GTK_WIDGET(shortcut), 79, 102, 99);

  /* create the toolbar widget */
  frame = gnome_db_new_frame_widget(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
  gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
  gtk_box_pack_start(GTK_BOX(shortcut), frame, 1, 1, 0);
  shortcut->tb = gnome_db_new_toolbar_widget(GTK_ORIENTATION_VERTICAL,
					                    GTK_TOOLBAR_BOTH,
					                    NULL, NULL);
  gnome_db_set_bg_color(shortcut->tb, 79, 102, 99);
  gtk_container_add(GTK_CONTAINER(frame), shortcut->tb);
}

GtkType
gnome_db_shortcut_get_type (void)
{
  static GtkType db_shortcut_type = 0;

  if (!db_shortcut_type)
    {
      GtkTypeInfo db_shortcut_info =
      {
        "GnomeDbShortcut",
        sizeof (GnomeDbShortcut),
        sizeof (GnomeDbShortcutClass),
        (GtkClassInitFunc) gnome_db_shortcut_class_init,
        (GtkObjectInitFunc) gnome_db_shortcut_init,
        (GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL
      };
      db_shortcut_type = gtk_type_unique(gtk_vbox_get_type(),
					 &db_shortcut_info);
    }
  return (db_shortcut_type);
}

GtkWidget *
gnome_db_shortcut_new (void)
{
  GnomeDbShortcut* shortcut;

  shortcut = GNOME_DB_SHORTCUT(gtk_type_new(gnome_db_shortcut_get_type()));
  return GTK_WIDGET(shortcut);
}

void
gnome_db_shortcut_append (GnomeDbShortcut *shortcut,
			  const gchar *str,
			  const gchar *tooltip,
			  const gchar *icon_file,
			  GtkSignalFunc select_func,
			  gpointer user_data)
{
  GtkWidget* pixmap;

  g_return_if_fail(GNOME_DB_IS_SHORTCUT(shortcut));
  g_return_if_fail(str != NULL);

  pixmap = gnome_stock_new_with_icon(icon_file);
  gtk_widget_show(pixmap);
  gtk_toolbar_append_space(GTK_TOOLBAR(shortcut->tb));
  gtk_toolbar_append_item(GTK_TOOLBAR(shortcut->tb), _(str),
			  _(tooltip), NULL, pixmap, select_func, user_data);
}

void
gnome_db_shortcut_remove (GnomeDbShortcut *shortcut, const gchar *str)
{
}

