/* GNOME DB libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <gnome-db.h>
#include <gnome-db-help.h>

static void gnome_db_help_class_init (GnomeDbHelpClass *klass);
static void gnome_db_help_destroy    (GnomeDbHelp *help);
static void gnome_db_help_init       (GnomeDbHelp *help);

static GnomeUIInfo help_toolbar[] =
{
  { GNOME_APP_UI_ITEM, NULL, N_("Go to the documentation home page"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_HOME, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, NULL, N_("Go to the previous page"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_BACK, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, NULL, N_("Go to the next page"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_FORWARD, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Public functions
 */
static void
gnome_db_help_class_init (GnomeDbHelpClass *klass)
{
  GtkObjectClass* object_class = GTK_OBJECT_CLASS(klass);
  
  object_class->destroy = gnome_db_help_destroy;
}

static void
gnome_db_help_init (GnomeDbHelp *help)
{
  GtkWidget* table;
  GtkWidget* frame;
  GtkWidget* scroll;
  GtkWidget* toolbar;
  GtkWidget* pane;
  
  table = gnome_db_new_table_widget(2, 6, FALSE);
  gtk_box_pack_start(GTK_BOX(help), table, 1, 1, 0);
  
  /* add toolbar */
  toolbar = gnome_db_new_toolbar_widget(GTK_ORIENTATION_HORIZONTAL,
                                        GTK_TOOLBAR_ICONS,
                                        help_toolbar,
                                        (gpointer) help);
  gtk_table_attach(GTK_TABLE(table), toolbar, 0, 2, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  pane = gtk_hpaned_new();
  gtk_paned_set_position(GTK_PANED(pane), 0);
  gtk_widget_show(pane);
  gtk_table_attach(GTK_TABLE(table), pane, 0, 2, 1, 6,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
  
  /* add table of contents */
  frame = gnome_db_new_frame_widget(NULL);
  gtk_paned_add1(GTK_PANED(pane), frame);
  scroll = gnome_db_new_scrolled_window_widget();
  gtk_container_add(GTK_CONTAINER(frame), scroll);
  help->index_list = gnome_db_new_clist_widget(NULL, 2);
  gtk_container_add(GTK_CONTAINER(scroll), help->index_list);
  
  /* add HTML viewer */
  frame = gnome_db_new_frame_widget(NULL);
  gtk_paned_add2(GTK_PANED(pane), frame);
  scroll = gnome_db_new_scrolled_window_widget();
  gtk_container_add(GTK_CONTAINER(frame), scroll);
  
  help->html_viewer = gtk_html_new();
  gtk_html_set_editable(GTK_HTML(help->html_viewer), FALSE);
  gtk_widget_show(help->html_viewer);
  gtk_container_add(GTK_CONTAINER(scroll), help->html_viewer);
}

static void
gnome_db_help_destroy (GnomeDbHelp *help)
{
}

GtkType
gnome_db_help_get_type (void)
{
  static guint db_help_type = 0;

  if (!db_help_type)
    {
      GtkTypeInfo db_help_info =
      {
        "GnomeDbHelp",
        sizeof (GnomeDbHelp),
        sizeof (GnomeDbHelpClass),
        (GtkClassInitFunc) gnome_db_help_class_init,
        (GtkObjectInitFunc) gnome_db_help_init,
        (GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL
      };
      db_help_type = gtk_type_unique(gtk_vbox_get_type(), &db_help_info);
    }
  return (db_help_type);
}

GtkWidget *
gnome_db_help_new (void)
{
  GtkWidget* help;
  
  help = GTK_WIDGET(gtk_type_new(gnome_db_help_get_type()));
  return help;
}
