/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-common.h>
#include <gnome-db-factory.h>

typedef struct
{
  BonoboGenericFactory* bonobo_factory;
  gchar*                id;
} COMPONENTS_Factory;

static GList* l_factories = NULL;

/**
 * gnome_db_factory_new
 */
BonoboGenericFactory *
gnome_db_factory_new (const gchar *id, BonoboGenericFactoryFn func, gpointer data)
{
  COMPONENTS_Factory* factory;
  GList*              node;
#if defined(USING_OAF)
  gchar*              oafiid;
#endif

  g_return_val_if_fail(id != NULL, NULL);
  g_return_val_if_fail(func != NULL, NULL);

  node = g_list_first(l_factories);
  while (node)
    {
      factory = (COMPONENTS_Factory *) node->data;
      if (factory && !g_strcasecmp(factory->id, id))
	{
	  g_print(_("Factory %s already existing"), id);
	  /* FIXME: should I gtk_object_ref(factory) */
	  return factory->bonobo_factory;
	}
      node = g_list_next(node);
    }

  /* not found, so create new factory */
  factory = g_new0(COMPONENTS_Factory, 1);
#if defined(USING_OAF)
  oafiid = g_strdup_printf("OAFIID:%s:b04e9dc2-1cc8-4027-8cf9-27dcb6a2a63f", id);
  g_print("trying to activate %d\n", oafiid);
  factory->bonobo_factory = bonobo_generic_factory_new(oafiid, func, data);
  g_free((gpointer) oafiid);
#else
  factory->bonobo_factory = bonobo_generic_factory_new(id, func, data);
#endif
  if (factory->bonobo_factory)
    {
      factory->id = g_strdup(id);
      l_factories = g_list_append(l_factories, (gpointer) factory);
      return factory->bonobo_factory;
    }
  else g_warning(_("Could not register %s factory"), id);
  return NULL;
}


