/* GNOME DB components libary
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if !defined(__gnome_db_control_h__)
#  define __gnome_db_control_h__

#include <gnome.h>
#include <bonobo.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_CONTROL            (gnome_db_control_get_type())
#define GNOME_DB_CONTROL(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTROL, GnomeDbControl)
#define GNOME_DB_CONTROL_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL, GnomeDbControlClass)
#define GNOME_DB_IS_CONTROL(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTROL)
#define GNOME_DB_IS_CONTROL_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTROL))

typedef struct _GnomeDbControl      GnomeDbControl;
typedef struct _GnomeDbControlClass GnomeDbControlClass;

typedef GtkWidget* (*GnomeDbControlFunc)(void);

enum
{
  GNOME_DB_CONTROL_ARG_NULL,
  GNOME_DB_CONTROL_ARG_STRING,
  GNOME_DB_CONTROL_ARG_BOOLEAN,
  GNOME_DB_CONTROL_ARG_INT,
  GNOME_DB_CONTROL_ARG_LONG,
  GNOME_DB_CONTROL_ARG_FLOAT,
  GNOME_DB_CONTROL_ARG_DOUBLE
};

typedef struct _GnomeDbControlInstance      GnomeDbControlInstance;
typedef struct _GnomeDbControlInstanceClass GnomeDbControlInstanceClass;

#define GNOME_DB_TYPE_CONTROL_INSTANCE            (gnome_db_control_instance_get_type())
#define GNOME_DB_CONTROL_INSTANCE(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTROL_INSTANCE, GnomeDbControlInstance)
#define GNOME_DB_CONTROL_INSTANCE_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL_INSTANCE, GnomeDbControlInstanceClass)
#define GNOME_DB_IS_CONTROL_INSTANCE(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTROL_INSTANCE)
#define GNOME_DB_IS_CONTROL_INSTANCE_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTROL_INSTANCE))

struct _GnomeDbControlInstance
{
  BonoboObject    bonobo_object;
  GnomeDbControl* control;
  GtkWidget*      widget;
  BonoboControl*  bonobo_control;
  GList*          properties;
  guint           max_prop;
  gpointer        user_data;
};

struct _GnomeDbControlInstanceClass
{
  BonoboObjectClass parent_class;
};

GtkType gnome_db_control_instance_get_type (void);

struct _GnomeDbControl
{
  BonoboObject          bonobo_object;
  BonoboGenericFactory* factory;
  GnomeDbControlFunc    create_widget_cb;
  GList*                widgets;
};

struct _GnomeDbControlClass
{
  BonoboObjectClass parent_class;

  void              (*new_instance)(GnomeDbControl *control,
                                    GnomeDbControlInstance *control_instance);
  void              (*get_property)(GnomeDbControl *control,
                                    GnomeDbControlInstance *control_instance,
                                    const gchar *name);
  void              (*set_property)(GnomeDbControl *control,
                                    GnomeDbControlInstance *control_instance,
                                    const gchar *name,
                                    gconstpointer value);
};

GtkType    gnome_db_control_get_type           (void);
GtkObject* gnome_db_control_new                (const gchar *id,
                                                GnomeDbControlFunc func);

gpointer   gnome_db_control_get_instance_data  (GnomeDbControlInstance *control_instance);
void       gnome_db_control_set_instance_data  (GnomeDbControlInstance *control_instance,
                                                gpointer user_data);

void       gnome_db_control_set_menus          (GnomeDbControlInstance *control_instance,
                                                GnomeUIInfo *menus,
                                                gpointer user_data);
void       gnome_db_control_set_toolbar        (GnomeDbControlInstance *control_instance,
                                                GnomeUIInfo *toolbar,
                                                gpointer user_data);

/* property stuff */
void       gnome_db_control_add_property       (GnomeDbControlInstance *control_instance,
                                                const gchar *name,
                                                const gchar *desc,
                                                guint type,
                                                gconstpointer value);
void       gnome_db_control_set_property       (GnomeDbControlInstance *control_instance,
                                                const gchar *name,
                                                gconstpointer value);
gboolean   gnome_db_control_get_boolean        (GnomeDbControlInstance *control_instance,
                                                const gchar *name);
gdouble    gnome_db_control_get_double         (GnomeDbControlInstance *control_instance,
                                                const gchar *name);
gfloat     gnome_db_control_get_float          (GnomeDbControlInstance *control_instance,
                                                const gchar *name);
gint       gnome_db_control_get_int            (GnomeDbControlInstance *control_instance,
                                                const gchar *name);
glong      gnome_db_control_get_long           (GnomeDbControlInstance *control_instance,
                                                const gchar *name);
gchar*     gnome_db_control_get_string         (GnomeDbControlInstance *control_instance,
                                                const gchar *name);

/* accessor functions */
BonoboGenericFactory* gnome_db_control_get_factory   (GnomeDbControl *control);
GList*                gnome_db_control_get_instances (GnomeDbControl *control);

END_GNOME_DECLS

#endif





