/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static void close_log_cb (GtkWidget *w, FE_LogViewerInfo *log_info);

GnomeUIInfo glb_log_toolbox[] =
{
  { GNOME_APP_UI_ITEM, N_("Save"), N_("Save file under a different name"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Refresh"), N_("Refresh all lists"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_REFRESH, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Close"), N_("Close log viewer"),
    close_log_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_PIXMAP_CLOSE, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Callbacks
 */
static void
close_log_cb (GtkWidget *w, FE_LogViewerInfo *log_info)
{
  g_return_if_fail(log_info != NULL);
  
  fe_workarea_remove_tab(log_info->container);
  g_free((gpointer) log_info);
}

static void
select_component_cb (GtkButton *button, FE_LogViewerInfo *log_info)
{
  GList*      name;
  const char* ids [] = { "IDL:BonoboControl/gnome-db-log:1.0", NULL };
  
  g_return_if_fail(log_info != NULL);
  
  /* get list of components implementing our interface */
  name = bonobo_selector_select_id(_("Select log viewer component"), ids);
  if (name)
    {
      GtkWidget* log_viewer;
      
      log_viewer = gnome_db_control_widget_new(name);
      if (GNOME_DB_IS_CONTROL_WIDGET(log_viewer))
        {
          if (log_info->viewer) gtk_widget_destroy(log_info->viewer);
          log_info->viewer = log_viewer;
          gtk_notebook_append_page(GTK_NOTEBOOK(log_info->notebook),
                                   log_info->viewer,
                                   gtk_label_new(name));
          gtk_widget_show_all(log_info->viewer);
          
          gtk_entry_set_text(GTK_ENTRY(log_info->chooser), name);
        }
      else gnome_db_show_error(_("Could not activate component %s"), name);
    }
}

/*
 * Public functions
 */
FE_LogViewerInfo *
fe_log_open (void)
{
  FE_LogViewerInfo* log_info;
  GtkWidget*        label;
  GtkWidget*        button;
  
  log_info = g_new0(FE_LogViewerInfo, 1);
  log_info->container = gnome_db_new_table_widget(6, 4, FALSE);
  
  label = gnome_db_new_label_widget(_("Component"));
  gtk_table_attach(GTK_TABLE(log_info->container), label, 0, 1, 0, 1,
                   GTK_FILL, GTK_FILL, 3, 3);
  log_info->chooser = gnome_db_new_entry_widget(0, FALSE);
  gtk_table_attach(GTK_TABLE(log_info->container), log_info->chooser, 1, 2, 0, 1,
                   GTK_FILL, GTK_FILL, 3, 3);
  button = gnome_db_new_button_widget_with_pixmap(_("Select"), GNOME_STOCK_MENU_OPEN);
  gtk_table_attach(GTK_TABLE(log_info->container), button, 2, 3, 0, 1,
                   GTK_FILL, GTK_FILL, 3, 3);
  gtk_signal_connect(GTK_OBJECT(button),
                     "clicked",
                     GTK_SIGNAL_FUNC(select_component_cb),
                     (gpointer) log_info);
  
  log_info->notebook = gnome_db_new_notebook_widget();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(log_info->notebook), GTK_POS_BOTTOM);
  gtk_table_attach(GTK_TABLE(log_info->container), log_info->notebook, 0, 4, 1, 6,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   GTK_FILL | GTK_SHRINK | GTK_EXPAND,
                   3, 3);

  return log_info;
}