/*  GNOME-DB Builder
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gnomedb-builder.h>

static guint prepare_app (void);

GtkWidget* glb_mainwin = NULL;
GtkWidget* glb_notebook = NULL;
static GnomeUIInfo filemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("New..."), N_("Add new module to project"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_NEW, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Open..."), N_("Open an existing module"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_OPEN, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    builder_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
static GnomeUIInfo databasemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Connect..."), N_("Connect to database"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close database connection"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Browse"), N_("Open database browser"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PROP, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Import objects"), N_("Import database objects into repository"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
static GnomeUIInfo helpmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    builder_about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Submit bug report"), N_("About this program"),
    gnome_db_submit_bug_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
static GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Database"), databasemenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};
static GnomeUIInfo toolbar[] =
{
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    builder_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_QUIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

int
main (int argc, char *argv)
{
  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
  
  gnome_db_init("gnomedb-builder", VERSION, argc, argv);
  
  /* run application */
  gnome_db_main((GtkFunction) prepare_app);
  return 0;
}

static guint
prepare_app (void)
{
  GtkWidget* table;
  GtkWidget* bar;
  
  glb_mainwin = gnome_db_container_new("gnomedb-builder", mainmenu, toolbar, NULL);
  gtk_signal_connect(GTK_OBJECT(glb_mainwin),
                     "close",
                     GTK_SIGNAL_FUNC(builder_quit_cb),
                     NULL);
  gnome_db_load_window_config("MainWindow",
                              gnome_db_container_get_widget(GNOME_DB_CONTAINER(glb_mainwin)));
  
  /* create work area */
  table = gnome_db_new_table_widget(6, 1, TRUE);
  
  bar = gnome_db_shortcut_new();
  gnome_db_shortcut_append(GNOME_DB_SHORTCUT(bar), _("Help"), _("Open help system viewer"),
                           GNOME_STOCK_PIXMAP_HELP, builder_activate_help_cb,
                           NULL);
  gtk_widget_show(bar);
  gtk_table_attach(GTK_TABLE(table), bar, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
  
  glb_notebook = gnome_db_new_notebook_widget();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(glb_notebook), GTK_POS_BOTTOM);
  gtk_table_attach(GTK_TABLE(table), glb_notebook, 1, 6, 0, 1,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                   3, 3);
                   
  /* add tabs */
  builder_help_init();
  
  gnome_db_container_set_contents(GNOME_DB_CONTAINER(glb_mainwin), table);
  gnome_db_container_show(GNOME_DB_CONTAINER(glb_mainwin));

  return FALSE;
}