#include <config.h>

#include "util.h"

#include <cups/cups.h>

#include <stdlib.h>
#include <bonobo/bonobo-exception.h>
#include <bonobo/bonobo-listener.h>
#include <bonobo/bonobo-main.h>
#include <glade/glade.h>
#include <gtk/gtkmain.h>
#include <gtk/gtkmessagedialog.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-client.h>
#include <libgnomeui/gnome-ui-init.h>
#include <libgnomeui/gnome-icon-theme.h>

#include "view-queue.h"
#include "printer-properties.h"
#include "tray.h"

#include <libgnomecups/gnome-cups-util.h>
#include <libgnomecups/gnome-cups-ui-init.h>
#include <libgnomecups/gnome-cups-printer.h>
#include <libgnomecups/gnome-cups-request.h>
#include <libgnomecups/gnome-cups-ui-print.h>

void
gnome_cups_error_dialog (GtkWindow *window, 
			 const char *prefix,
			 GError *error)
{
	GtkWidget *dialog;
	char *msg;
	
	msg = error ? error->message : _("Unknown Error");

	dialog = gtk_message_dialog_new (window, 
					 GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, 
					 GTK_MESSAGE_ERROR,
					 GTK_BUTTONS_OK,
					 "%s: %s", prefix, error->message);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog); 
}

static void
get_test_page (GnomeCupsPrinter *printer,
	       char **filename,
	       char **paper_name)
{
	char *paper_size;
	
	paper_size = gnome_cups_printer_get_option_value (printer, "PageSize");
	
	if (paper_size && !g_ascii_strcasecmp (paper_size, "a4")) {
		if (paper_name) {
			*paper_name = g_strdup_printf ("A4");
		}
		
		if (filename) {
			*filename = g_strdup (DATADIR "/gnome-cups-manager/xd2-testpage-a4.eps");
		}
	} else {
		if (paper_name) {
			*paper_name = g_strdup_printf ("Letter");
		}
		
		if (filename) {
			*filename = g_strdup (DATADIR "/gnome-cups-manager/xd2-testpage-letter.eps");
		}
	}
	
	g_free (paper_size);
}

static void
print_dialog_response_cb (GtkWidget *dialog, 
			  int response_code, 
			  gpointer user_data)
{
	gtk_widget_destroy (dialog);
}

void
gnome_cups_print_test_page (GnomeCupsPrinter *printer,
			    GtkWidget *parent_window)
{
	gboolean result;
	char *filename;
	char *paper_size;

	get_test_page (printer, &filename, &paper_size);

	result = gnome_cups_ui_print_file (printer, 
					   GTK_WINDOW (parent_window),
					   filename,
					   _("Test Page"), NULL);
	
	if (result) {
                GtkWidget *dialog;
 
                dialog = gtk_message_dialog_new
                        (GTK_WINDOW (parent_window),
                         GTK_DIALOG_DESTROY_WITH_PARENT,
                         GTK_MESSAGE_INFO, GTK_BUTTONS_OK,
                         _("%s test page has been sent to %s."),
			 paper_size,
                         gnome_cups_printer_get_name (printer));
		gtk_widget_show (dialog);
		g_signal_connect (dialog, "response",
				  G_CALLBACK (print_dialog_response_cb),
				  NULL);
	}

	g_free (paper_size);
	g_free (filename);
}

static int active_windows = 0;

static void
window_weak_notify (gpointer user_data, GObject *old_object)
{
	active_windows--;

	if (active_windows == 0) {
		gtk_main_quit ();
	}
}

void
watch_window (GtkWidget *widget)
{
	active_windows++;
	g_object_weak_ref (G_OBJECT (widget), 
			   (GWeakNotify)window_weak_notify,
			    NULL);
}

void
set_window_icon (GtkWidget *window, const char *icon_name)
{
	GdkPixbuf *pixbuf;
	GnomeIconTheme *theme;
	int base_size;
	char *filename;

	theme = gnome_icon_theme_new ();

	filename = gnome_icon_theme_lookup_icon (theme,
						 icon_name,
						 32,
						 NULL,
						 &base_size);
	g_object_unref (theme);

	pixbuf = gdk_pixbuf_new_from_file (filename, NULL);

	gtk_window_set_icon (GTK_WINDOW (window), pixbuf);
	g_object_unref (pixbuf);
}
