# Note that this is NOT a relocatable package
%define ver      1.0.1
%define rel      1
%define prefix   /usr

Summary: The core programs for the GNOME GUI desktop environment.
Name: gnome-core
Version: %ver
Release: %rel
Copyright: GPL
Group: System Environment/Libraries
Source: ftp://ftp.gnome.org/pub/sources/gnome-core/gnome-core-%{ver}.tar.gz
BuildRoot: /var/tmp/gnome-core-root
Obsoletes: gnome

URL: http://www.gnome.org
Prereq: /sbin/install-info
Docdir: %{prefix}/doc

Requires: xscreensaver
Requires: gnome-libs >= 0.99.8
Requires: ORBit >= 0.3.90

%description
GNOME (GNU Network Object Model Environment) is a user-friendly
set of applications and desktop tools to be used in conjunction with a
window manager for the X Window System.  GNOME is similar in purpose and
scope to CDE and KDE, but GNOME is based completely on Open Source
software.  The gnome-core package includes the basic programs and
libraries that are needed to install GNOME.

You should install the gnome-core package if you would like to use the
GNOME desktop environment.  You'll also need to install the gnome-libs
package.  If you would like to develop GNOME applications, you'll also
need to install gnome-libs-devel.  If you want to use linuxconf with a
GNOME front end, you'll also need to install the gnome-linuxconf package.

%package devel
Summary: GNOME core libraries, includes and more.
Group: Development/Libraries
Requires: gnome-core
PreReq: /sbin/install-info

%description devel
Panel libraries and header files for creating GNOME panels.

%changelog

* Sat Nov 21 1998 Pablo Saratxaga <srtxg@chanae.alphanet.ch>

- Cleaned %files section
- added spanish and french translations for rpm

* Wed Sep 23 1998 Michael Fulbright <msf@redhat.com>

- Built 0.30 release

* Fri Mar 13 1998 Marc Ewing <marc@redhat.com>

- Integrate into gnome-core CVS source tree

%prep
%setup

%build
# Needed for snapshot releases.

MYCFLAGS="$RPM_OPT_FLAGS"

if [ ! -f configure ]; then
  CFLAGS="$MYCFLAGS" ./autogen.sh --prefix=%prefix --localstatedir=/var/lib --with-window-manager=enlightenment
else
  CFLAGS="$MYCFLAGS" ./configure --prefix=%prefix --localstatedir=/var/lib  --with-window-manager=enlightenment
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/*
%{prefix}/lib/lib*.so.*
%{prefix}/share/applets
%{prefix}/share/gnome
%{prefix}/share/idl
%{prefix}/share/mc/templates
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*
%{prefix}/share/xmodmap/*
%{prefix}/etc/*
%config %{prefix}/share/panelrc
%config %{prefix}/share/default.session

%files devel
%defattr(-, root, root)

%{prefix}/lib/*.sh
%{prefix}/lib/lib*.so
%{prefix}/lib/*a
%{prefix}/include/*
