/* contacts-avatar-dialog.c generated by valac 0.30.0.38-a55d, the Vala compiler
 * generated from contacts-avatar-dialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <um-crop-area.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>


#define CONTACTS_TYPE_AVATAR_DIALOG (contacts_avatar_dialog_get_type ())
#define CONTACTS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog))
#define CONTACTS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))
#define CONTACTS_IS_AVATAR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_IS_AVATAR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR_DIALOG))
#define CONTACTS_AVATAR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogClass))

typedef struct _ContactsAvatarDialog ContactsAvatarDialog;
typedef struct _ContactsAvatarDialogClass ContactsAvatarDialogClass;
typedef struct _ContactsAvatarDialogPrivate ContactsAvatarDialogPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block38Data Block38Data;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block39Data Block39Data;
typedef struct _Block40Data Block40Data;

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;
typedef struct _ContactsAppPrivate ContactsAppPrivate;

#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

struct _ContactsAvatarDialog {
	GtkDialog parent_instance;
	ContactsAvatarDialogPrivate * priv;
};

struct _ContactsAvatarDialogClass {
	GtkDialogClass parent_class;
};

struct _ContactsAvatarDialogPrivate {
	GnomeDesktopThumbnailFactory* thumbnail_factory;
	ContactsContact* contact;
	GtkStack* views_stack;
	UmCropArea* crop_area;
	GtkGrid* view_grid;
	ContactsContactFrame* main_frame;
	GdkPixbuf* new_pixbuf;
};

struct _Block38Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	GdkPixbuf* avatar_pixbuf;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block39Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	GtkFileChooserDialog* chooser;
};

struct _Block40Data {
	int _ref_count_;
	ContactsAvatarDialog* self;
	ContactsContact* contact;
};

struct _ContactsApp {
	GtkApplication parent_instance;
	ContactsAppPrivate * priv;
	GSettings* settings;
	ContactsStore* contacts_store;
	ContactsWindow* window;
};

struct _ContactsAppClass {
	GtkApplicationClass parent_class;
};


static gpointer contacts_avatar_dialog_parent_class = NULL;
extern ContactsApp* contacts_app_app;

GType contacts_avatar_dialog_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
#define CONTACTS_AVATAR_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialogPrivate))
enum  {
	CONTACTS_AVATAR_DIALOG_DUMMY_PROPERTY
};
#define CONTACTS_AVATAR_DIALOG_main_size 128
#define CONTACTS_AVATAR_DIALOG_icons_size 64
#define CONTACTS_AVATAR_DIALOG_n_columns 6
static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_frame_set_pixbuf (ContactsContactFrame* self, GdkPixbuf* a_pixbuf);
static void __lambda58_ (Block38Data* _data38_);
static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void ___lambda58__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona);
static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename);
static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self);
GType contacts_store_get_type (void) G_GNUC_CONST;
gchar** contacts_utils_get_stock_avatars (int* result_length1);
void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser);
static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf);
static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self);
static Block39Data* block39_data_ref (Block39Data* _data39_);
static void block39_data_unref (void * _userdata_);
static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
static void __lambda59_ (Block39Data* _data39_, gint response);
static void ___lambda59__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact);
ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
GType contacts_app_get_type (void) G_GNUC_CONST;
GType contacts_window_get_type (void) G_GNUC_CONST;
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static void ___lambda60_ (Block40Data* _data40_, GtkWidget* w);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
static void ____lambda60__gtk_callback (GtkWidget* widget, gpointer self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda61_ (ContactsAvatarDialog* self, GtkButton* button);
static void ___lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda62_ (ContactsAvatarDialog* self, GtkButton* button);
static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda63_ (ContactsAvatarDialog* self, gint response_id);
static void ___lambda63__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void contacts_avatar_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkPixbuf* contacts_avatar_dialog_scale_pixbuf_for_avatar_use (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* result = NULL;
	gint w = 0;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint h = 0;
	GdkPixbuf* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkPixbuf* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	GdkPixbuf* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	w = _tmp1_;
	_tmp2_ = pixbuf;
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
	h = _tmp3_;
	_tmp5_ = w;
	if (_tmp5_ <= 128) {
		gint _tmp6_ = 0;
		_tmp6_ = h;
		_tmp4_ = _tmp6_ <= 128;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GdkPixbuf* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
		_tmp7_ = pixbuf;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		result = _tmp8_;
		return result;
	}
	_tmp9_ = w;
	_tmp10_ = h;
	if (_tmp9_ > _tmp10_) {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gdouble _tmp13_ = 0.0;
		_tmp11_ = h;
		_tmp12_ = w;
		_tmp13_ = round ((_tmp11_ * 128.0) / _tmp12_);
		h = (gint) _tmp13_;
		w = 128;
	} else {
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gdouble _tmp16_ = 0.0;
		_tmp14_ = w;
		_tmp15_ = h;
		_tmp16_ = round ((_tmp14_ * 128.0) / _tmp15_);
		w = (gint) _tmp16_;
		h = 128;
	}
	_tmp17_ = pixbuf;
	_tmp18_ = w;
	_tmp19_ = h;
	_tmp20_ = gdk_pixbuf_scale_simple (_tmp17_, _tmp18_, _tmp19_, GDK_INTERP_HYPER);
	result = _tmp20_;
	return result;
}


static Block38Data* block38_data_ref (Block38Data* _data38_) {
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}


static void block38_data_unref (void * _userdata_) {
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		ContactsAvatarDialog* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->avatar_pixbuf);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}


static void __lambda58_ (Block38Data* _data38_) {
	ContactsAvatarDialog* self;
	self = _data38_->self;
	contacts_avatar_dialog_selected_pixbuf (self, _data38_->avatar_pixbuf);
}


static void ___lambda58__contacts_contact_frame_clicked (ContactsContactFrame* _sender, gpointer self) {
	__lambda58_ (self);
}


static ContactsContactFrame* contacts_avatar_dialog_create_frame (ContactsAvatarDialog* self, GdkPixbuf* source_pixbuf) {
	ContactsContactFrame* result = NULL;
	Block38Data* _data38_;
	ContactsContactFrame* image_frame = NULL;
	ContactsContactFrame* _tmp0_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_pixbuf != NULL, NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_icons_size, TRUE);
	g_object_ref_sink (_tmp0_);
	image_frame = _tmp0_;
	_tmp1_ = source_pixbuf;
	_tmp2_ = gdk_pixbuf_scale_simple (_tmp1_, CONTACTS_AVATAR_DIALOG_icons_size, CONTACTS_AVATAR_DIALOG_icons_size, GDK_INTERP_HYPER);
	pixbuf = _tmp2_;
	contacts_contact_frame_set_pixbuf (image_frame, pixbuf);
	_tmp3_ = source_pixbuf;
	_tmp4_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp3_);
	_data38_->avatar_pixbuf = _tmp4_;
	g_signal_connect_data (image_frame, "clicked", (GCallback) ___lambda58__contacts_contact_frame_clicked, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
	result = image_frame;
	_g_object_unref0 (pixbuf);
	block38_data_unref (_data38_);
	_data38_ = NULL;
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_persona (ContactsAvatarDialog* self, FolksPersona* persona) {
	ContactsContactFrame* result = NULL;
	FolksAvatarDetails* details = NULL;
	FolksPersona* _tmp0_ = NULL;
	FolksAvatarDetails* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	FolksAvatarDetails* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _tmp0_) : NULL);
	details = _tmp1_;
	_tmp3_ = details;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		FolksAvatarDetails* _tmp4_ = NULL;
		GLoadableIcon* _tmp5_ = NULL;
		GLoadableIcon* _tmp6_ = NULL;
		_tmp4_ = details;
		_tmp5_ = folks_avatar_details_get_avatar (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == NULL;
	}
	if (_tmp2_) {
		result = NULL;
		_g_object_unref0 (details);
		return result;
	}
	{
		GInputStream* stream = NULL;
		FolksAvatarDetails* _tmp7_ = NULL;
		GLoadableIcon* _tmp8_ = NULL;
		GLoadableIcon* _tmp9_ = NULL;
		GInputStream* _tmp10_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		GInputStream* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		ContactsContactFrame* _tmp14_ = NULL;
		_tmp7_ = details;
		_tmp8_ = folks_avatar_details_get_avatar (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_loadable_icon_load (_tmp9_, 128, NULL, NULL, &_inner_error_);
		stream = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
		_tmp11_ = stream;
		_tmp12_ = gdk_pixbuf_new_from_stream (_tmp11_, NULL, &_inner_error_);
		pixbuf = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch36_g_error;
		}
		_tmp13_ = pixbuf;
		_tmp14_ = contacts_avatar_dialog_create_frame (self, _tmp13_);
		result = _tmp14_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (stream);
		_g_object_unref0 (details);
		return result;
	}
	goto __finally36;
	__catch36_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (details);
	return result;
}


static ContactsContactFrame* contacts_avatar_dialog_frame_for_filename (ContactsAvatarDialog* self, const gchar* filename) {
	ContactsContactFrame* result = NULL;
	ContactsContactFrame* image_frame = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	image_frame = NULL;
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_ = NULL;
		ContactsContactFrame* _tmp2_ = NULL;
		_tmp0_ = filename;
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error_);
		pixbuf = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch37_g_error;
		}
		_tmp2_ = contacts_avatar_dialog_create_frame (self, pixbuf);
		result = _tmp2_;
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (image_frame);
		return result;
	}
	goto __finally37;
	__catch37_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (image_frame);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = image_frame;
	return result;
}


static void contacts_avatar_dialog_selected_pixbuf (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* p = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	ContactsContactFrame* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_pixbuf_scale_simple (_tmp0_, CONTACTS_AVATAR_DIALOG_main_size, CONTACTS_AVATAR_DIALOG_main_size, GDK_INTERP_HYPER);
	p = _tmp1_;
	_tmp2_ = self->priv->main_frame;
	contacts_contact_frame_set_pixbuf (_tmp2_, p);
	_tmp3_ = pixbuf;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->new_pixbuf);
	self->priv->new_pixbuf = _tmp4_;
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, TRUE);
	_g_object_unref0 (p);
}


static void contacts_avatar_dialog_update_grid (ContactsAvatarDialog* self) {
	gint i = 0;
	gint j = 0;
	ContactsContact* _tmp0_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp23_ = 0;
	gchar** stock_files = NULL;
	gint _tmp28_ = 0;
	gchar** _tmp29_ = NULL;
	gint stock_files_length1 = 0;
	gint _stock_files_size_ = 0;
	gchar** _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	GtkGrid* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	i = 0;
	j = 0;
	_tmp0_ = self->priv->contact;
	if (_tmp0_ != NULL) {
		{
			GeeIterator* _p_it = NULL;
			ContactsContact* _tmp1_ = NULL;
			FolksIndividual* _tmp2_ = NULL;
			GeeSet* _tmp3_ = NULL;
			GeeSet* _tmp4_ = NULL;
			GeeIterator* _tmp5_ = NULL;
			_tmp1_ = self->priv->contact;
			_tmp2_ = _tmp1_->individual;
			_tmp3_ = folks_individual_get_personas (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_p_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				FolksPersona* p = NULL;
				GeeIterator* _tmp8_ = NULL;
				gpointer _tmp9_ = NULL;
				ContactsContactFrame* frame = NULL;
				FolksPersona* _tmp10_ = NULL;
				ContactsContactFrame* _tmp11_ = NULL;
				ContactsContactFrame* _tmp12_ = NULL;
				_tmp6_ = _p_it;
				_tmp7_ = gee_iterator_next (_tmp6_);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = _p_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				p = (FolksPersona*) _tmp9_;
				_tmp10_ = p;
				_tmp11_ = contacts_avatar_dialog_frame_for_persona (self, _tmp10_);
				frame = _tmp11_;
				_tmp12_ = frame;
				if (_tmp12_ != NULL) {
					GtkGrid* _tmp13_ = NULL;
					ContactsContactFrame* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					_tmp13_ = self->priv->view_grid;
					_tmp14_ = frame;
					_tmp15_ = i;
					_tmp16_ = j;
					gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, _tmp15_, _tmp16_, 1, 1);
					_tmp17_ = i;
					i = _tmp17_ + 1;
					_tmp18_ = i;
					if (_tmp18_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
						gint _tmp19_ = 0;
						gint _tmp20_ = 0;
						_tmp19_ = i;
						i = _tmp19_ - CONTACTS_AVATAR_DIALOG_n_columns;
						_tmp20_ = j;
						j = _tmp20_ + 1;
					}
				}
				_g_object_unref0 (frame);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
	}
	_tmp21_ = i;
	if (_tmp21_ != 0) {
		gint _tmp22_ = 0;
		i = 0;
		_tmp22_ = j;
		j = _tmp22_ + 1;
	}
	_tmp23_ = j;
	if (_tmp23_ != 0) {
		GtkSeparator* s = NULL;
		GtkSeparator* _tmp24_ = NULL;
		GtkGrid* _tmp25_ = NULL;
		GtkSeparator* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		_tmp24_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp24_);
		s = _tmp24_;
		_tmp25_ = self->priv->view_grid;
		_tmp26_ = s;
		_tmp27_ = j;
		j = _tmp27_ + 1;
		gtk_grid_attach (_tmp25_, (GtkWidget*) _tmp26_, 0, _tmp27_, CONTACTS_AVATAR_DIALOG_n_columns, 1);
		_g_object_unref0 (s);
	}
	_tmp29_ = contacts_utils_get_stock_avatars (&_tmp28_);
	stock_files = _tmp29_;
	stock_files_length1 = _tmp28_;
	_stock_files_size_ = stock_files_length1;
	_tmp30_ = stock_files;
	_tmp30__length1 = stock_files_length1;
	{
		gchar** file_name_collection = NULL;
		gint file_name_collection_length1 = 0;
		gint _file_name_collection_size_ = 0;
		gint file_name_it = 0;
		file_name_collection = _tmp30_;
		file_name_collection_length1 = _tmp30__length1;
		for (file_name_it = 0; file_name_it < _tmp30__length1; file_name_it = file_name_it + 1) {
			gchar* _tmp31_ = NULL;
			gchar* file_name = NULL;
			_tmp31_ = g_strdup (file_name_collection[file_name_it]);
			file_name = _tmp31_;
			{
				ContactsContactFrame* frame = NULL;
				const gchar* _tmp32_ = NULL;
				ContactsContactFrame* _tmp33_ = NULL;
				ContactsContactFrame* _tmp34_ = NULL;
				_tmp32_ = file_name;
				_tmp33_ = contacts_avatar_dialog_frame_for_filename (self, _tmp32_);
				frame = _tmp33_;
				_tmp34_ = frame;
				if (_tmp34_ != NULL) {
					GtkGrid* _tmp35_ = NULL;
					ContactsContactFrame* _tmp36_ = NULL;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					_tmp35_ = self->priv->view_grid;
					_tmp36_ = frame;
					_tmp37_ = i;
					_tmp38_ = j;
					gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, _tmp37_, _tmp38_, 1, 1);
					_tmp39_ = i;
					i = _tmp39_ + 1;
					_tmp40_ = i;
					if (_tmp40_ >= CONTACTS_AVATAR_DIALOG_n_columns) {
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
						_tmp41_ = i;
						i = _tmp41_ - CONTACTS_AVATAR_DIALOG_n_columns;
						_tmp42_ = j;
						j = _tmp42_ + 1;
					}
				}
				_g_object_unref0 (frame);
				_g_free0 (file_name);
			}
		}
	}
	_tmp43_ = self->priv->view_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp43_);
	stock_files = (_vala_array_free (stock_files, stock_files_length1, (GDestroyNotify) g_free), NULL);
}


void contacts_avatar_dialog_update_preview (ContactsAvatarDialog* self, GtkFileChooser* chooser) {
	gchar* uri = NULL;
	GtkFileChooser* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooser* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chooser != NULL);
	_tmp0_ = chooser;
	_tmp1_ = gtk_file_chooser_get_preview_uri (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	if (_tmp2_ != NULL) {
		GdkPixbuf* pixbuf = NULL;
		GtkImage* preview = NULL;
		GtkFileChooser* _tmp3_ = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkImage* _tmp5_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GtkFileChooser* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
		GdkPixbuf* _tmp22_ = NULL;
		pixbuf = NULL;
		_tmp3_ = chooser;
		_tmp4_ = gtk_file_chooser_get_preview_widget (_tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_image_get_type ()) ? ((GtkImage*) _tmp4_) : NULL);
		preview = _tmp5_;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		file = _tmp7_;
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp8_ = NULL;
			GFileInfo* _tmp9_ = NULL;
			GFileInfo* _tmp10_ = NULL;
			_tmp8_ = file;
			_tmp9_ = g_file_query_info (_tmp8_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
			file_info = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch38_g_error;
			}
			_tmp10_ = file_info;
			if (_tmp10_ != NULL) {
				gchar* mime_type = NULL;
				GFileInfo* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				mime_type = _tmp13_;
				_tmp14_ = mime_type;
				if (_tmp14_ != NULL) {
					GnomeDesktopThumbnailFactory* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					GdkPixbuf* _tmp18_ = NULL;
					GdkPixbuf* _tmp19_ = NULL;
					_tmp15_ = self->priv->thumbnail_factory;
					_tmp16_ = uri;
					_tmp17_ = mime_type;
					_tmp18_ = gnome_desktop_thumbnail_factory_generate_thumbnail (_tmp15_, _tmp16_, _tmp17_);
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp19_;
				}
				_g_free0 (mime_type);
			}
			_g_object_unref0 (file_info);
		}
		goto __finally38;
		__catch38_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally38:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			_g_object_unref0 (preview);
			_g_object_unref0 (pixbuf);
			_g_free0 (uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp20_ = chooser;
		_tmp21_ = pixbuf;
		gtk_dialog_set_response_sensitive (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp20_) : NULL, (gint) GTK_RESPONSE_ACCEPT, _tmp21_ != NULL);
		_tmp22_ = pixbuf;
		if (_tmp22_ != NULL) {
			GtkImage* _tmp23_ = NULL;
			GdkPixbuf* _tmp24_ = NULL;
			_tmp23_ = preview;
			_tmp24_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp23_, _tmp24_);
		} else {
			GtkImage* _tmp25_ = NULL;
			_tmp25_ = preview;
			gtk_image_set_from_icon_name (_tmp25_, "dialog-question", GTK_ICON_SIZE_DIALOG);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (preview);
		_g_object_unref0 (pixbuf);
	}
	_tmp26_ = chooser;
	gtk_file_chooser_set_preview_widget_active (_tmp26_, TRUE);
	_g_free0 (uri);
}


static void contacts_avatar_dialog_set_crop_widget (ContactsAvatarDialog* self, GdkPixbuf* pixbuf) {
	GtkGrid* frame_grid = NULL;
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	UmCropArea* _tmp3_ = NULL;
	UmCropArea* _tmp4_ = NULL;
	UmCropArea* _tmp5_ = NULL;
	UmCropArea* _tmp6_ = NULL;
	UmCropArea* _tmp7_ = NULL;
	UmCropArea* _tmp8_ = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	UmCropArea* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->views_stack;
	_tmp1_ = gtk_stack_get_child_by_name (_tmp0_, "crop-page");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_grid_get_type ()) ? ((GtkGrid*) _tmp1_) : NULL);
	frame_grid = _tmp2_;
	_tmp3_ = (UmCropArea*) um_crop_area_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->crop_area);
	self->priv->crop_area = _tmp3_;
	_tmp4_ = self->priv->crop_area;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
	_tmp5_ = self->priv->crop_area;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->crop_area;
	um_crop_area_set_min_size (_tmp6_, 48, 48);
	_tmp7_ = self->priv->crop_area;
	um_crop_area_set_constrain_aspect (_tmp7_, TRUE);
	_tmp8_ = self->priv->crop_area;
	_tmp9_ = pixbuf;
	um_crop_area_set_picture (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->crop_area;
	gtk_grid_attach (frame_grid, (GtkWidget*) _tmp10_, 0, 0, 1, 1);
	gtk_widget_show_all ((GtkWidget*) frame_grid);
	_tmp11_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp11_, "crop-page");
	_g_object_unref0 (frame_grid);
}


static Block39Data* block39_data_ref (Block39Data* _data39_) {
	g_atomic_int_inc (&_data39_->_ref_count_);
	return _data39_;
}


static void block39_data_unref (void * _userdata_) {
	Block39Data* _data39_;
	_data39_ = (Block39Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data39_->_ref_count_)) {
		ContactsAvatarDialog* self;
		self = _data39_->self;
		_g_object_unref0 (_data39_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block39Data, _data39_);
	}
}


static void _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
	contacts_avatar_dialog_update_preview ((ContactsAvatarDialog*) self, _sender);
}


static void __lambda59_ (Block39Data* _data39_, gint response) {
	ContactsAvatarDialog* self;
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data39_->self;
	_tmp0_ = response;
	if (_tmp0_ != ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp1_ = NULL;
		_tmp1_ = _data39_->chooser;
		gtk_widget_destroy ((GtkWidget*) _tmp1_);
		return;
	}
	{
		GFile* file = NULL;
		GtkFileChooserDialog* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileInputStream* in_stream = NULL;
		GFile* _tmp7_ = NULL;
		GFileInputStream* _tmp8_ = NULL;
		GdkPixbuf* pixbuf = NULL;
		GFileInputStream* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		GFileInputStream* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GdkPixbuf* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		_tmp2_ = _data39_->chooser;
		_tmp3_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		file = _tmp6_;
		_tmp7_ = file;
		_tmp8_ = g_file_read (_tmp7_, NULL, &_inner_error_);
		in_stream = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch39_g_error;
		}
		_tmp9_ = in_stream;
		_tmp10_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp9_, NULL, &_inner_error_);
		pixbuf = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch39_g_error;
		}
		_tmp11_ = in_stream;
		g_input_stream_close ((GInputStream*) _tmp11_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (in_stream);
			_g_object_unref0 (file);
			goto __catch39_g_error;
		}
		_tmp13_ = pixbuf;
		_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
		if (_tmp14_ > 128) {
			_tmp12_ = TRUE;
		} else {
			GdkPixbuf* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			_tmp15_ = pixbuf;
			_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
			_tmp12_ = _tmp16_ > 128;
		}
		if (_tmp12_) {
			GdkPixbuf* _tmp17_ = NULL;
			_tmp17_ = pixbuf;
			contacts_avatar_dialog_set_crop_widget (self, _tmp17_);
		} else {
			GdkPixbuf* _tmp18_ = NULL;
			GdkPixbuf* _tmp19_ = NULL;
			GdkPixbuf* _tmp20_ = NULL;
			_tmp18_ = pixbuf;
			_tmp19_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, _tmp18_);
			_tmp20_ = _tmp19_;
			contacts_avatar_dialog_selected_pixbuf (self, _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
		contacts_avatar_dialog_update_grid (self);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (in_stream);
		_g_object_unref0 (file);
	}
	goto __finally39;
	__catch39_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp21_ = _data39_->chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp21_);
}


static void ___lambda59__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda59_ (self, response_id);
}


static void contacts_avatar_dialog_select_avatar_file_cb (ContactsAvatarDialog* self) {
	Block39Data* _data39_;
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkFileChooserDialog* _tmp4_ = NULL;
	GtkFileChooserDialog* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkImage* preview = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	gchar* folder = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileChooserDialog* _tmp19_ = NULL;
	GtkFileChooserDialog* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	_data39_ = g_slice_new0 (Block39Data);
	_data39_->_ref_count_ = 1;
	_data39_->self = g_object_ref (self);
	_tmp0_ = _ ("Browse for more pictures");
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _ ("_Cancel");
	_tmp3_ = _ ("_Open");
	_tmp4_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _tmp2_, GTK_RESPONSE_CANCEL, _tmp3_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp4_);
	_data39_->chooser = _tmp4_;
	_tmp5_ = _data39_->chooser;
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	_tmp6_ = _data39_->chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp6_, FALSE);
	_tmp7_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp7_);
	preview = _tmp7_;
	_tmp8_ = preview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 128, -1);
	_tmp9_ = _data39_->chooser;
	_tmp10_ = preview;
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = _data39_->chooser;
	gtk_file_chooser_set_use_preview_label ((GtkFileChooser*) _tmp11_, FALSE);
	_tmp12_ = preview;
	gtk_widget_show ((GtkWidget*) _tmp12_);
	_tmp13_ = _data39_->chooser;
	g_signal_connect_object ((GtkFileChooser*) _tmp13_, "update-preview", (GCallback) _contacts_avatar_dialog_update_preview_gtk_file_chooser_update_preview, self, 0);
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	_tmp15_ = g_strdup (_tmp14_);
	folder = _tmp15_;
	_tmp16_ = folder;
	if (_tmp16_ != NULL) {
		GtkFileChooserDialog* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = _data39_->chooser;
		_tmp18_ = folder;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp17_, _tmp18_);
	}
	_tmp19_ = _data39_->chooser;
	g_signal_connect_data ((GtkDialog*) _tmp19_, "response", (GCallback) ___lambda59__gtk_dialog_response, block39_data_ref (_data39_), (GClosureNotify) block39_data_unref, 0);
	_tmp20_ = _data39_->chooser;
	gtk_window_present ((GtkWindow*) _tmp20_);
	_g_free0 (folder);
	_g_object_unref0 (preview);
	block39_data_unref (_data39_);
	_data39_ = NULL;
}


static Block40Data* block40_data_ref (Block40Data* _data40_) {
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}


static void block40_data_unref (void * _userdata_) {
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		ContactsAvatarDialog* self;
		self = _data40_->self;
		_g_object_unref0 (_data40_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}


static void ___lambda60_ (Block40Data* _data40_, GtkWidget* w) {
	ContactsAvatarDialog* self;
	GtkWidget* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	self = _data40_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	_tmp1_ = _data40_->contact;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = _data40_->contact;
	contacts_contact_frame_set_image (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_CONTACT_FRAME) ? ((ContactsContactFrame*) _tmp0_) : NULL, (FolksAvatarDetails*) _tmp2_, _tmp3_);
}


static void ____lambda60__gtk_callback (GtkWidget* widget, gpointer self) {
	___lambda60_ (self, widget);
}


static void _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_avatar_dialog_select_avatar_file_cb ((ContactsAvatarDialog*) self);
}


static void __lambda61_ (ContactsAvatarDialog* self, GtkButton* button) {
	GdkPixbuf* pix = NULL;
	UmCropArea* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	UmCropArea* _tmp4_ = NULL;
	GtkStack* _tmp5_ = NULL;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	_tmp1_ = um_crop_area_get_picture (_tmp0_);
	pix = _tmp1_;
	_tmp2_ = contacts_avatar_dialog_scale_pixbuf_for_avatar_use (self, pix);
	_tmp3_ = _tmp2_;
	contacts_avatar_dialog_selected_pixbuf (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp5_, "thumbnail-factory");
	_g_object_unref0 (pix);
}


static void ___lambda61__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda61_ ((ContactsAvatarDialog*) self, _sender);
}


static void __lambda62_ (ContactsAvatarDialog* self, GtkButton* button) {
	UmCropArea* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->crop_area;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp1_, "thumbnail-factory");
}


static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda62_ ((ContactsAvatarDialog*) self, _sender);
}


static void __lambda63_ (ContactsAvatarDialog* self, gint response_id) {
	gint _tmp0_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		GdkPixbuf* _tmp1_ = NULL;
		_tmp1_ = self->priv->new_pixbuf;
		if (_tmp1_ != NULL) {
			{
				guint8* buffer = NULL;
				gint buffer_length1 = 0;
				gint _buffer_size_ = 0;
				gboolean _tmp2_ = FALSE;
				GdkPixbuf* _tmp3_ = NULL;
				guint8* _tmp4_ = NULL;
				gsize _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp3_ = self->priv->new_pixbuf;
				_tmp6_ = gdk_pixbuf_save_to_buffer (_tmp3_, (gchar**) (&_tmp4_), &_tmp5_, "png", &_inner_error_, NULL, NULL);
				buffer = (g_free (buffer), NULL);
				buffer = _tmp4_;
				buffer_length1 = _tmp5_;
				_buffer_size_ = buffer_length1;
				_tmp2_ = _tmp6_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					buffer = (g_free (buffer), NULL);
					goto __catch40_g_error;
				}
				if (_tmp2_) {
					GBytesIcon* icon = NULL;
					guint8* _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					GBytes* _tmp8_ = NULL;
					GBytes* _tmp9_ = NULL;
					GBytesIcon* _tmp10_ = NULL;
					GBytesIcon* _tmp11_ = NULL;
					GBytesIcon* _tmp12_ = NULL;
					_tmp7_ = buffer;
					_tmp7__length1 = buffer_length1;
					_tmp8_ = g_bytes_new (_tmp7_, _tmp7__length1);
					_tmp9_ = _tmp8_;
					_tmp10_ = (GBytesIcon*) g_bytes_icon_new (_tmp9_);
					_tmp11_ = _tmp10_;
					_g_bytes_unref0 (_tmp9_);
					icon = _tmp11_;
					_tmp12_ = icon;
					g_signal_emit_by_name (self, "set-avatar", (GIcon*) _tmp12_);
					_g_object_unref0 (icon);
				} else {
				}
				buffer = (g_free (buffer), NULL);
			}
			goto __finally40;
			__catch40_g_error:
			{
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
			}
			__finally40:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	gtk_widget_destroy ((GtkWidget*) self);
}


static void ___lambda63__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda63_ ((ContactsAvatarDialog*) self, response_id);
}


ContactsAvatarDialog* contacts_avatar_dialog_construct (GType object_type, ContactsContact* contact) {
	ContactsAvatarDialog * self = NULL;
	Block40Data* _data40_;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	GnomeDesktopThumbnailFactory* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	ContactsContact* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ContactsApp* _tmp6_ = NULL;
	ContactsWindow* _tmp7_ = NULL;
	GtkWidget* btn = NULL;
	const gchar* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkContainer* container = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkContainer* _tmp18_ = NULL;
	GtkContainer* _tmp19_ = NULL;
	GtkGrid* _tmp20_ = NULL;
	ContactsContactFrame* _tmp21_ = NULL;
	ContactsContact* _tmp22_ = NULL;
	ContactsContactFrame* _tmp26_ = NULL;
	GtkGrid* _tmp27_ = NULL;
	ContactsContactFrame* _tmp28_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp29_ = NULL;
	ContactsContact* _tmp30_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	GtkLabel* _tmp42_ = NULL;
	GtkLabel* _tmp43_ = NULL;
	GtkLabel* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkGrid* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkGrid* _tmp49_ = NULL;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp50_ = NULL;
	GtkStyleContext* _tmp51_ = NULL;
	GtkGrid* _tmp52_ = NULL;
	GtkStack* _tmp53_ = NULL;
	GtkStack* _tmp54_ = NULL;
	GtkGrid* frame_grid = NULL;
	GtkGrid* _tmp55_ = NULL;
	GtkGrid* _tmp56_ = NULL;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp57_ = NULL;
	GtkGrid* _tmp58_ = NULL;
	GtkGrid* _tmp59_ = NULL;
	GtkGrid* _tmp60_ = NULL;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp61_ = NULL;
	GtkGrid* _tmp62_ = NULL;
	GtkActionBar* _tmp63_ = NULL;
	GtkButton* the_add_button = NULL;
	GtkButton* _tmp64_ = NULL;
	GtkActionBar* _tmp65_ = NULL;
	GtkGrid* _tmp66_ = NULL;
	GtkStack* _tmp67_ = NULL;
	GtkGrid* _tmp68_ = NULL;
	GtkGrid* _tmp69_ = NULL;
	GtkGrid* _tmp70_ = NULL;
	GtkActionBar* _tmp71_ = NULL;
	GtkGrid* _tmp72_ = NULL;
	GtkActionBar* _tmp73_ = NULL;
	GtkButton* accept_button = NULL;
	GtkButton* _tmp74_ = NULL;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp75_ = NULL;
	GtkBox* bbox1 = NULL;
	GtkBox* _tmp76_ = NULL;
	GtkStyleContext* _tmp77_ = NULL;
	GtkActionBar* _tmp78_ = NULL;
	GtkGrid* _tmp79_ = NULL;
	GtkStack* _tmp80_ = NULL;
	GtkGrid* _tmp81_ = NULL;
	GtkStack* _tmp82_ = NULL;
	GtkGrid* _tmp83_ = NULL;
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data40_->contact);
	_data40_->contact = _tmp1_;
	self = (ContactsAvatarDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	_data40_->self = g_object_ref (self);
	_tmp2_ = gnome_desktop_thumbnail_factory_new (GNOME_DESKTOP_THUMBNAIL_SIZE_NORMAL);
	_g_object_unref0 (self->priv->thumbnail_factory);
	self->priv->thumbnail_factory = _tmp2_;
	_tmp3_ = _data40_->contact;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->contact);
	self->priv->contact = _tmp4_;
	_tmp5_ = _ ("Select Picture");
	gtk_window_set_title ((GtkWindow*) self, _tmp5_);
	_tmp6_ = contacts_app_app;
	_tmp7_ = _tmp6_->window;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp7_);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	_tmp8_ = _ ("Select");
	_tmp9_ = gtk_dialog_add_button ((GtkDialog*) self, _tmp8_, (gint) GTK_RESPONSE_OK);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	btn = _tmp10_;
	_tmp11_ = btn;
	_tmp12_ = gtk_widget_get_style_context (_tmp11_);
	gtk_style_context_add_class (_tmp12_, "suggested-action");
	_tmp13_ = _ ("Cancel");
	gtk_dialog_add_button ((GtkDialog*) self, _tmp13_, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, FALSE);
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp14_);
	grid = _tmp14_;
	_tmp15_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp15_, (guint) 8);
	_tmp16_ = grid;
	gtk_grid_set_column_spacing (_tmp16_, (guint) 16);
	_tmp17_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_container_get_type ()) ? ((GtkContainer*) _tmp17_) : NULL);
	container = _tmp18_;
	_tmp19_ = container;
	_tmp20_ = grid;
	gtk_container_add (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = contacts_contact_frame_new (CONTACTS_AVATAR_DIALOG_main_size, FALSE);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->main_frame);
	self->priv->main_frame = _tmp21_;
	_tmp22_ = _data40_->contact;
	if (_tmp22_ != NULL) {
		ContactsContact* _tmp23_ = NULL;
		ContactsContactFrame* _tmp24_ = NULL;
		_tmp23_ = _data40_->contact;
		_tmp24_ = self->priv->main_frame;
		contacts_contact_keep_widget_uptodate (_tmp23_, (GtkWidget*) _tmp24_, ____lambda60__gtk_callback, block40_data_ref (_data40_), block40_data_unref);
	} else {
		ContactsContactFrame* _tmp25_ = NULL;
		_tmp25_ = self->priv->main_frame;
		contacts_contact_frame_set_image (_tmp25_, NULL, NULL);
	}
	_tmp26_ = self->priv->main_frame;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp26_, FALSE);
	_tmp27_ = grid;
	_tmp28_ = self->priv->main_frame;
	gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, 0, 0, 1, 1);
	_tmp29_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp29_);
	label = _tmp29_;
	_tmp30_ = _data40_->contact;
	if (_tmp30_ != NULL) {
		GtkLabel* _tmp31_ = NULL;
		ContactsContact* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		_tmp31_ = label;
		_tmp32_ = _data40_->contact;
		_tmp33_ = contacts_contact_get_display_name (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp34_);
		_tmp36_ = _tmp35_;
		gtk_label_set_markup (_tmp31_, _tmp36_);
		_g_free0 (_tmp36_);
	} else {
		GtkLabel* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp37_ = label;
		_tmp38_ = _ ("New Contact");
		_tmp39_ = g_markup_printf_escaped ("<span font='16'>%s</span>", _tmp38_);
		_tmp40_ = _tmp39_;
		gtk_label_set_markup (_tmp37_, _tmp40_);
		_g_free0 (_tmp40_);
	}
	_tmp41_ = label;
	gtk_widget_set_valign ((GtkWidget*) _tmp41_, GTK_ALIGN_START);
	_tmp42_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp42_, GTK_ALIGN_START);
	_tmp43_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp43_, TRUE);
	_tmp44_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp44_, 4);
	_tmp45_ = label;
	gtk_label_set_xalign (_tmp45_, 0.0f);
	_tmp46_ = label;
	gtk_label_set_ellipsize (_tmp46_, PANGO_ELLIPSIZE_END);
	_tmp47_ = grid;
	_tmp48_ = label;
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 1, 0, 1, 1);
	_tmp49_ = grid;
	gtk_grid_set_row_spacing (_tmp49_, (guint) 11);
	_tmp50_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp50_);
	frame = _tmp50_;
	_tmp51_ = gtk_widget_get_style_context ((GtkWidget*) frame);
	gtk_style_context_add_class (_tmp51_, "contacts-avatar-frame");
	_tmp52_ = grid;
	gtk_grid_attach (_tmp52_, (GtkWidget*) frame, 0, 1, 2, 1);
	_tmp53_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->views_stack);
	self->priv->views_stack = _tmp53_;
	_tmp54_ = self->priv->views_stack;
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) _tmp54_);
	_tmp55_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp55_);
	frame_grid = _tmp55_;
	_tmp56_ = frame_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp56_, GTK_ORIENTATION_VERTICAL);
	_tmp57_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp57_);
	scrolled = _tmp57_;
	gtk_scrolled_window_set_policy (scrolled, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_vexpand ((GtkWidget*) scrolled, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) scrolled, TRUE);
	gtk_widget_set_size_request ((GtkWidget*) scrolled, -1, 300);
	_tmp58_ = frame_grid;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) scrolled);
	_tmp59_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->view_grid);
	self->priv->view_grid = _tmp59_;
	_tmp60_ = self->priv->view_grid;
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) _tmp60_);
	_tmp61_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp61_);
	actionbar = _tmp61_;
	_tmp62_ = frame_grid;
	_tmp63_ = actionbar;
	gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp64_);
	the_add_button = _tmp64_;
	g_signal_connect_object (the_add_button, "clicked", (GCallback) _contacts_avatar_dialog_select_avatar_file_cb_gtk_button_clicked, self, 0);
	_tmp65_ = actionbar;
	gtk_action_bar_pack_start (_tmp65_, (GtkWidget*) the_add_button);
	_tmp66_ = frame_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
	_tmp67_ = self->priv->views_stack;
	_tmp68_ = frame_grid;
	gtk_stack_add_named (_tmp67_, (GtkWidget*) _tmp68_, "thumbnail-factory");
	_tmp69_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (frame_grid);
	frame_grid = _tmp69_;
	_tmp70_ = frame_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp70_, GTK_ORIENTATION_VERTICAL);
	_tmp71_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (actionbar);
	actionbar = _tmp71_;
	_tmp72_ = frame_grid;
	_tmp73_ = actionbar;
	gtk_grid_attach (_tmp72_, (GtkWidget*) _tmp73_, 0, 1, 1, 1);
	_tmp74_ = (GtkButton*) gtk_button_new_from_icon_name ("object-select-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp74_);
	accept_button = _tmp74_;
	g_signal_connect_object (accept_button, "clicked", (GCallback) ___lambda61__gtk_button_clicked, self, 0);
	_tmp75_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-undo-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp75_);
	cancel_button = _tmp75_;
	g_signal_connect_object (cancel_button, "clicked", (GCallback) ___lambda62__gtk_button_clicked, self, 0);
	_tmp76_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp76_);
	bbox1 = _tmp76_;
	_tmp77_ = gtk_widget_get_style_context ((GtkWidget*) bbox1);
	gtk_style_context_add_class (_tmp77_, "linked");
	gtk_container_add ((GtkContainer*) bbox1, (GtkWidget*) accept_button);
	gtk_container_add ((GtkContainer*) bbox1, (GtkWidget*) cancel_button);
	_tmp78_ = actionbar;
	gtk_action_bar_pack_start (_tmp78_, (GtkWidget*) bbox1);
	_tmp79_ = frame_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp79_);
	_tmp80_ = self->priv->views_stack;
	_tmp81_ = frame_grid;
	gtk_stack_add_named (_tmp80_, (GtkWidget*) _tmp81_, "crop-page");
	_tmp82_ = self->priv->views_stack;
	gtk_stack_set_visible_child_name (_tmp82_, "thumbnail-factory");
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda63__gtk_dialog_response, self, 0);
	contacts_avatar_dialog_update_grid (self);
	_tmp83_ = grid;
	gtk_widget_show_all ((GtkWidget*) _tmp83_);
	_g_object_unref0 (bbox1);
	_g_object_unref0 (cancel_button);
	_g_object_unref0 (accept_button);
	_g_object_unref0 (the_add_button);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (frame_grid);
	_g_object_unref0 (frame);
	_g_object_unref0 (label);
	_g_object_unref0 (container);
	_g_object_unref0 (grid);
	_g_object_unref0 (btn);
	block40_data_unref (_data40_);
	_data40_ = NULL;
	return self;
}


ContactsAvatarDialog* contacts_avatar_dialog_new (ContactsContact* contact) {
	return contacts_avatar_dialog_construct (CONTACTS_TYPE_AVATAR_DIALOG, contact);
}


static void contacts_avatar_dialog_class_init (ContactsAvatarDialogClass * klass) {
	contacts_avatar_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAvatarDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_dialog_finalize;
	g_signal_new ("set_avatar", CONTACTS_TYPE_AVATAR_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, G_TYPE_ICON);
}


static void contacts_avatar_dialog_instance_init (ContactsAvatarDialog * self) {
	self->priv = CONTACTS_AVATAR_DIALOG_GET_PRIVATE (self);
}


static void contacts_avatar_dialog_finalize (GObject* obj) {
	ContactsAvatarDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR_DIALOG, ContactsAvatarDialog);
	_g_object_unref0 (self->priv->thumbnail_factory);
	_g_object_unref0 (self->priv->contact);
	_g_object_unref0 (self->priv->views_stack);
	_g_object_unref0 (self->priv->crop_area);
	_g_object_unref0 (self->priv->view_grid);
	_g_object_unref0 (self->priv->main_frame);
	_g_object_unref0 (self->priv->new_pixbuf);
	G_OBJECT_CLASS (contacts_avatar_dialog_parent_class)->finalize (obj);
}


GType contacts_avatar_dialog_get_type (void) {
	static volatile gsize contacts_avatar_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_avatar_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatarDialog), 0, (GInstanceInitFunc) contacts_avatar_dialog_instance_init, NULL };
		GType contacts_avatar_dialog_type_id;
		contacts_avatar_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ContactsAvatarDialog", &g_define_type_info, 0);
		g_once_init_leave (&contacts_avatar_dialog_type_id__volatile, contacts_avatar_dialog_type_id);
	}
	return contacts_avatar_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



