/* contacts-view.c generated by valac 0.28.0.2-022b, the Vala compiler
 * generated from contacts-view.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>


#define CONTACTS_TYPE_VIEW (contacts_view_get_type ())
#define CONTACTS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_VIEW, ContactsView))
#define CONTACTS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_VIEW, ContactsViewClass))
#define CONTACTS_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_VIEW))
#define CONTACTS_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_VIEW))
#define CONTACTS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_VIEW, ContactsViewClass))

typedef struct _ContactsView ContactsView;
typedef struct _ContactsViewClass ContactsViewClass;
typedef struct _ContactsViewPrivate ContactsViewPrivate;

#define CONTACTS_VIEW_TYPE_SUBSET (contacts_view_subset_get_type ())

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW (contacts_view_contact_data_row_get_type ())
#define CONTACTS_VIEW_CONTACT_DATA_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW, ContactsViewContactDataRow))
#define CONTACTS_VIEW_CONTACT_DATA_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW, ContactsViewContactDataRowClass))
#define CONTACTS_VIEW_IS_CONTACT_DATA_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW))
#define CONTACTS_VIEW_IS_CONTACT_DATA_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW))
#define CONTACTS_VIEW_CONTACT_DATA_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW, ContactsViewContactDataRowClass))

typedef struct _ContactsViewContactDataRow ContactsViewContactDataRow;
typedef struct _ContactsViewContactDataRowClass ContactsViewContactDataRowClass;

#define CONTACTS_VIEW_TYPE_TEXT_DISPLAY (contacts_view_text_display_get_type ())

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsViewContactDataRowPrivate ContactsViewContactDataRowPrivate;

#define CONTACTS_TYPE_CONTACT_FRAME (contacts_contact_frame_get_type ())
#define CONTACTS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrame))
#define CONTACTS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))
#define CONTACTS_IS_CONTACT_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_IS_CONTACT_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_FRAME))
#define CONTACTS_CONTACT_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_FRAME, ContactsContactFrameClass))

typedef struct _ContactsContactFrame ContactsContactFrame;
typedef struct _ContactsContactFrameClass ContactsContactFrameClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block36Data Block36Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsView {
	GtkListBox parent_instance;
	ContactsViewPrivate * priv;
};

struct _ContactsViewClass {
	GtkListBoxClass parent_class;
};

typedef enum  {
	CONTACTS_VIEW_SUBSET_MAIN,
	CONTACTS_VIEW_SUBSET_OTHER,
	CONTACTS_VIEW_SUBSET_ALL_SEPARATED,
	CONTACTS_VIEW_SUBSET_ALL
} ContactsViewSubset;

typedef enum  {
	CONTACTS_VIEW_TEXT_DISPLAY_NONE,
	CONTACTS_VIEW_TEXT_DISPLAY_PRESENCE,
	CONTACTS_VIEW_TEXT_DISPLAY_STORES
} ContactsViewTextDisplay;

struct _ContactsViewPrivate {
	ContactsViewSubset show_subset;
	GeeHashMap* contacts;
	GeeHashSet* hidden_contacts;
	gint nr_contacts_marked;
	gchar** filter_values;
	gint filter_values_length1;
	gint _filter_values_size_;
	ContactsViewTextDisplay text_display;
	gboolean selectors_visible;
	ContactsStore* _store;
};

struct _ContactsViewContactDataRow {
	GtkListBoxRow parent_instance;
	ContactsViewContactDataRowPrivate * priv;
	ContactsContact* contact;
	GtkGrid* grid;
	GtkLabel* label;
	ContactsContactFrame* image_frame;
	GtkCheckButton* selector_button;
	gint sort_prio;
	gchar* display_name;
	gunichar initial_letter;
	gboolean filtered;
};

struct _ContactsViewContactDataRowClass {
	GtkListBoxRowClass parent_class;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block36Data {
	int _ref_count_;
	ContactsView* self;
	ContactsViewContactDataRow* data;
};


static gpointer contacts_view_parent_class = NULL;
static gpointer contacts_view_contact_data_row_parent_class = NULL;

GType contacts_view_get_type (void) G_GNUC_CONST;
GType contacts_view_subset_get_type (void) G_GNUC_CONST;
GType contacts_contact_get_type (void) G_GNUC_CONST;
static GType contacts_view_contact_data_row_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType contacts_view_text_display_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
#define CONTACTS_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_VIEW, ContactsViewPrivate))
enum  {
	CONTACTS_VIEW_DUMMY_PROPERTY,
	CONTACTS_VIEW_STORE
};
static gint contacts_view_compare_data (ContactsView* self, ContactsViewContactDataRow* a_data, ContactsViewContactDataRow* b_data);
static gint contacts_view_get_sort_prio (ContactsView* self, ContactsViewContactDataRow* data);
gboolean contacts_is_set (const gchar* str);
GType contacts_contact_frame_get_type (void) G_GNUC_CONST;
static gboolean contacts_view_is_other (ContactsView* self, ContactsViewContactDataRow* data);
void contacts_view_set_show_subset (ContactsView* self, ContactsViewSubset subset);
static void contacts_view_update_all_filtered (ContactsView* self);
void contacts_view_set_custom_sort_prio (ContactsView* self, ContactsContact* c, gint prio);
void contacts_view_hide_contact (ContactsView* self, ContactsContact* contact);
void contacts_view_set_filter_values (ContactsView* self, gchar** values, int values_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gboolean contacts_view_calculate_filtered (ContactsView* self, ContactsContact* c);
gboolean contacts_contact_get_is_hidden (ContactsContact* self);
gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1);
static void contacts_view_update_data (ContactsView* self, ContactsViewContactDataRow* data);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
gunichar contacts_contact_get_initial_letter (ContactsContact* self);
static void contacts_view_contact_data_row_update_widgets (ContactsViewContactDataRow* self);
static void contacts_view_contact_changed_cb (ContactsView* self, ContactsStore* store, ContactsContact* c);
static void contacts_view_contact_added_cb (ContactsView* self, ContactsStore* store, ContactsContact* c);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static ContactsViewContactDataRow* contacts_view_contact_data_row_new (ContactsContact* c);
static ContactsViewContactDataRow* contacts_view_contact_data_row_construct (GType object_type, ContactsContact* c);
static void __lambda85_ (Block36Data* _data36_);
static void ___lambda85__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void contacts_view_contact_removed_cb (ContactsView* self, ContactsStore* store, ContactsContact* c);
static void contacts_view_real_row_selected (GtkListBox* base, GtkListBoxRow* row);
void contacts_contact_fetch_contact_info (ContactsContact* self);
static gboolean contacts_view_filter (ContactsView* self, GtkListBoxRow* row);
static void contacts_view_update_header (ContactsView* self, GtkListBoxRow* row, GtkListBoxRow* before_row);
void contacts_view_select_contact (ContactsView* self, ContactsContact* contact);
void contacts_view_show_selectors (ContactsView* self);
void contacts_view_hide_selectors (ContactsView* self);
GeeLinkedList* contacts_view_get_marked_contacts (ContactsView* self);
ContactsView* contacts_view_new (void);
ContactsView* contacts_view_construct (GType object_type);
ContactsStore* contacts_view_get_store (ContactsView* self);
void contacts_view_set_store (ContactsView* self, ContactsStore* value);
static void _contacts_view_contact_added_cb_contacts_store_added (ContactsStore* _sender, ContactsContact* c, gpointer self);
static void _contacts_view_contact_removed_cb_contacts_store_removed (ContactsStore* _sender, ContactsContact* c, gpointer self);
static void _contacts_view_contact_changed_cb_contacts_store_changed (ContactsStore* _sender, ContactsContact* c, gpointer self);
GeeCollection* contacts_store_get_contacts (ContactsStore* self);
static GObject * contacts_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gint _contacts_view___lambda86_ (ContactsView* self, GtkListBoxRow* row_a, GtkListBoxRow* row_b);
static gint __contacts_view___lambda86__gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static gboolean _contacts_view_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static void _contacts_view_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
enum  {
	CONTACTS_VIEW_CONTACT_DATA_ROW_DUMMY_PROPERTY
};
#define CONTACTS_CONTACT_LIST_AVATAR_SIZE 48
ContactsContactFrame* contacts_contact_frame_new (gint size, gboolean with_button);
ContactsContactFrame* contacts_contact_frame_construct (GType object_type, gint size, gboolean with_button);
void contacts_contact_frame_set_image (ContactsContactFrame* self, FolksAvatarDetails* details, ContactsContact* contact);
static void contacts_view_contact_data_row_finalize (GObject* obj);
static void contacts_view_finalize (GObject* obj);
static void _vala_contacts_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType contacts_view_subset_get_type (void) {
	static volatile gsize contacts_view_subset_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_view_subset_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_VIEW_SUBSET_MAIN, "CONTACTS_VIEW_SUBSET_MAIN", "main"}, {CONTACTS_VIEW_SUBSET_OTHER, "CONTACTS_VIEW_SUBSET_OTHER", "other"}, {CONTACTS_VIEW_SUBSET_ALL_SEPARATED, "CONTACTS_VIEW_SUBSET_ALL_SEPARATED", "all-separated"}, {CONTACTS_VIEW_SUBSET_ALL, "CONTACTS_VIEW_SUBSET_ALL", "all"}, {0, NULL, NULL}};
		GType contacts_view_subset_type_id;
		contacts_view_subset_type_id = g_enum_register_static ("ContactsViewSubset", values);
		g_once_init_leave (&contacts_view_subset_type_id__volatile, contacts_view_subset_type_id);
	}
	return contacts_view_subset_type_id__volatile;
}


GType contacts_view_text_display_get_type (void) {
	static volatile gsize contacts_view_text_display_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_view_text_display_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_VIEW_TEXT_DISPLAY_NONE, "CONTACTS_VIEW_TEXT_DISPLAY_NONE", "none"}, {CONTACTS_VIEW_TEXT_DISPLAY_PRESENCE, "CONTACTS_VIEW_TEXT_DISPLAY_PRESENCE", "presence"}, {CONTACTS_VIEW_TEXT_DISPLAY_STORES, "CONTACTS_VIEW_TEXT_DISPLAY_STORES", "stores"}, {0, NULL, NULL}};
		GType contacts_view_text_display_type_id;
		contacts_view_text_display_type_id = g_enum_register_static ("ContactsViewTextDisplay", values);
		g_once_init_leave (&contacts_view_text_display_type_id__volatile, contacts_view_text_display_type_id);
	}
	return contacts_view_text_display_type_id__volatile;
}


static gint contacts_view_compare_data (ContactsView* self, ContactsViewContactDataRow* a_data, ContactsViewContactDataRow* b_data) {
	gint result = 0;
	gint a_prio = 0;
	ContactsViewContactDataRow* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint b_prio = 0;
	ContactsViewContactDataRow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	ContactsViewContactDataRow* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	ContactsViewContactDataRow* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	ContactsViewContactDataRow* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a_data != NULL, 0);
	g_return_val_if_fail (b_data != NULL, 0);
	_tmp0_ = a_data;
	_tmp1_ = contacts_view_get_sort_prio (self, _tmp0_);
	a_prio = _tmp1_;
	_tmp2_ = b_data;
	_tmp3_ = contacts_view_get_sort_prio (self, _tmp2_);
	b_prio = _tmp3_;
	_tmp4_ = a_prio;
	_tmp5_ = b_prio;
	if (_tmp4_ > _tmp5_) {
		result = -1;
		return result;
	}
	_tmp6_ = a_prio;
	_tmp7_ = b_prio;
	if (_tmp6_ < _tmp7_) {
		result = 1;
		return result;
	}
	_tmp9_ = a_data;
	_tmp10_ = _tmp9_->display_name;
	_tmp11_ = contacts_is_set (_tmp10_);
	if (_tmp11_) {
		ContactsViewContactDataRow* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp12_ = b_data;
		_tmp13_ = _tmp12_->display_name;
		_tmp14_ = contacts_is_set (_tmp13_);
		_tmp8_ = _tmp14_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ContactsViewContactDataRow* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		ContactsViewContactDataRow* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp15_ = a_data;
		_tmp16_ = _tmp15_->display_name;
		_tmp17_ = b_data;
		_tmp18_ = _tmp17_->display_name;
		_tmp19_ = g_utf8_collate (_tmp16_, _tmp18_);
		result = _tmp19_;
		return result;
	}
	_tmp20_ = a_data;
	_tmp21_ = _tmp20_->display_name;
	_tmp22_ = contacts_is_set (_tmp21_);
	if (_tmp22_) {
		result = -1;
		return result;
	}
	_tmp23_ = b_data;
	_tmp24_ = _tmp23_->display_name;
	_tmp25_ = contacts_is_set (_tmp24_);
	if (_tmp25_) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}


static gboolean contacts_view_is_other (ContactsView* self, ContactsViewContactDataRow* data) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ContactsViewSubset _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp2_ = self->priv->show_subset;
	if (_tmp2_ == CONTACTS_VIEW_SUBSET_ALL_SEPARATED) {
		ContactsViewContactDataRow* _tmp3_ = NULL;
		ContactsContact* _tmp4_ = NULL;
		_tmp3_ = data;
		_tmp4_ = _tmp3_->contact;
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ContactsViewContactDataRow* _tmp5_ = NULL;
		ContactsContact* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = data;
		_tmp6_ = _tmp5_->contact;
		_tmp7_ = _tmp6_->is_main;
		_tmp0_ = !_tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gint contacts_view_get_sort_prio (ContactsView* self, ContactsViewContactDataRow* data) {
	gint result = 0;
	ContactsViewContactDataRow* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ContactsViewContactDataRow* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->sort_prio;
	if (_tmp1_ != 0) {
		ContactsViewContactDataRow* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp2_ = data;
		_tmp3_ = _tmp2_->sort_prio;
		result = _tmp3_;
		return result;
	}
	_tmp4_ = data;
	_tmp5_ = contacts_view_is_other (self, _tmp4_);
	if (_tmp5_) {
		result = -1;
		return result;
	}
	result = 0;
	return result;
}


void contacts_view_set_show_subset (ContactsView* self, ContactsViewSubset subset) {
	ContactsViewSubset _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = subset;
	self->priv->show_subset = _tmp0_;
	contacts_view_update_all_filtered (self);
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
	gtk_list_box_invalidate_sort ((GtkListBox*) self);
}


void contacts_view_set_custom_sort_prio (ContactsView* self, ContactsContact* c, gint prio) {
	gint _tmp0_ = 0;
	ContactsViewContactDataRow* data = NULL;
	GeeHashMap* _tmp1_ = NULL;
	ContactsContact* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	ContactsViewContactDataRow* _tmp4_ = NULL;
	ContactsViewContactDataRow* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	ContactsViewContactDataRow* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = prio;
	_vala_assert (_tmp0_ >= 0, "prio >= 0");
	_tmp1_ = self->priv->contacts;
	_tmp2_ = c;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	data = (ContactsViewContactDataRow*) _tmp3_;
	_tmp4_ = data;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (data);
		return;
	}
	_tmp5_ = data;
	_tmp6_ = prio;
	_tmp5_->sort_prio = _tmp6_;
	_tmp7_ = data;
	gtk_list_box_row_changed ((GtkListBoxRow*) _tmp7_);
	_g_object_unref0 (data);
}


void contacts_view_hide_contact (ContactsView* self, ContactsContact* contact) {
	GeeHashSet* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = self->priv->hidden_contacts;
	_tmp1_ = contact;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	contacts_view_update_all_filtered (self);
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void contacts_view_set_filter_values (ContactsView* self, gchar** values, int values_length1) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filter_values;
	_tmp0__length1 = self->priv->filter_values_length1;
	_tmp1_ = values;
	_tmp1__length1 = values_length1;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->filter_values;
	_tmp2__length1 = self->priv->filter_values_length1;
	if (_tmp2_ == NULL) {
		gtk_list_box_set_placeholder ((GtkListBox*) self, NULL);
	} else {
		GtkLabel* l = NULL;
		const gchar* _tmp3_ = NULL;
		GtkLabel* _tmp4_ = NULL;
		GtkLabel* _tmp5_ = NULL;
		GtkLabel* _tmp6_ = NULL;
		_tmp3_ = _ ("No results matched search");
		_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
		g_object_ref_sink (_tmp4_);
		l = _tmp4_;
		_tmp5_ = l;
		gtk_widget_show ((GtkWidget*) _tmp5_);
		_tmp6_ = l;
		gtk_list_box_set_placeholder ((GtkListBox*) self, (GtkWidget*) _tmp6_);
		_g_object_unref0 (l);
	}
	_tmp7_ = values;
	_tmp7__length1 = values_length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup1 (_tmp7_, _tmp7__length1) : ((gpointer) _tmp7_);
	_tmp8__length1 = _tmp7__length1;
	self->priv->filter_values = (_vala_array_free (self->priv->filter_values, self->priv->filter_values_length1, (GDestroyNotify) g_free), NULL);
	self->priv->filter_values = _tmp8_;
	self->priv->filter_values_length1 = _tmp8__length1;
	self->priv->_filter_values_size_ = self->priv->filter_values_length1;
	contacts_view_update_all_filtered (self);
	gtk_list_box_invalidate_filter ((GtkListBox*) self);
}


static gboolean contacts_view_calculate_filtered (ContactsView* self, ContactsContact* c) {
	gboolean result = FALSE;
	ContactsContact* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeHashSet* _tmp3_ = NULL;
	ContactsContact* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	ContactsViewSubset _tmp8_ = 0;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	ContactsContact* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gboolean _tmp20_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	_tmp1_ = contacts_contact_get_is_hidden (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->hidden_contacts;
	_tmp4_ = c;
	_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->priv->show_subset;
	if (_tmp8_ == CONTACTS_VIEW_SUBSET_MAIN) {
		ContactsContact* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = c;
		_tmp10_ = _tmp9_->is_main;
		_tmp7_ = !_tmp10_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp11_ = FALSE;
		ContactsViewSubset _tmp12_ = 0;
		_tmp12_ = self->priv->show_subset;
		if (_tmp12_ == CONTACTS_VIEW_SUBSET_OTHER) {
			ContactsContact* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = c;
			_tmp14_ = _tmp13_->is_main;
			_tmp11_ = _tmp14_;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp6_ = _tmp11_;
	}
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->filter_values;
	_tmp16__length1 = self->priv->filter_values_length1;
	if (_tmp16_ == NULL) {
		_tmp15_ = TRUE;
	} else {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		_tmp17_ = self->priv->filter_values;
		_tmp17__length1 = self->priv->filter_values_length1;
		_tmp15_ = _tmp17__length1 == 0;
	}
	if (_tmp15_) {
		result = TRUE;
		return result;
	}
	_tmp18_ = c;
	_tmp19_ = self->priv->filter_values;
	_tmp19__length1 = self->priv->filter_values_length1;
	_tmp20_ = contacts_contact_contains_strings (_tmp18_, _tmp19_, _tmp19__length1);
	result = _tmp20_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void contacts_view_update_data (ContactsView* self, ContactsViewContactDataRow* data) {
	ContactsContact* c = NULL;
	ContactsViewContactDataRow* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	ContactsContact* _tmp2_ = NULL;
	ContactsViewContactDataRow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	ContactsViewContactDataRow* _tmp7_ = NULL;
	gunichar _tmp8_ = 0U;
	gunichar _tmp9_ = 0U;
	ContactsViewContactDataRow* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	ContactsViewContactDataRow* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->contact;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	c = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = contacts_contact_get_display_name (c);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_tmp3_->display_name);
	_tmp3_->display_name = _tmp6_;
	_tmp7_ = data;
	_tmp8_ = contacts_contact_get_initial_letter (c);
	_tmp9_ = _tmp8_;
	_tmp7_->initial_letter = _tmp9_;
	_tmp10_ = data;
	_tmp11_ = contacts_view_calculate_filtered (self, c);
	_tmp10_->filtered = _tmp11_;
	_tmp12_ = data;
	contacts_view_contact_data_row_update_widgets (_tmp12_);
	_g_object_unref0 (c);
}


static void contacts_view_update_all_filtered (ContactsView* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _data_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_data_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			ContactsViewContactDataRow* data = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			ContactsViewContactDataRow* _tmp10_ = NULL;
			ContactsViewContactDataRow* _tmp11_ = NULL;
			ContactsContact* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp6_ = _data_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _data_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			data = (ContactsViewContactDataRow*) _tmp9_;
			_tmp10_ = data;
			_tmp11_ = data;
			_tmp12_ = _tmp11_->contact;
			_tmp13_ = contacts_view_calculate_filtered (self, _tmp12_);
			_tmp10_->filtered = _tmp13_;
			_g_object_unref0 (data);
		}
		_g_object_unref0 (_data_it);
	}
}


static void contacts_view_contact_changed_cb (ContactsView* self, ContactsStore* store, ContactsContact* c) {
	ContactsViewContactDataRow* data = NULL;
	GeeHashMap* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = c;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	data = (ContactsViewContactDataRow*) _tmp2_;
	contacts_view_update_data (self, data);
	gtk_list_box_row_changed ((GtkListBoxRow*) data);
	_g_object_unref0 (data);
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		ContactsView* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->data);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}


static void __lambda85_ (Block36Data* _data36_) {
	ContactsView* self;
	ContactsViewContactDataRow* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp6_ = 0;
	self = _data36_->self;
	_tmp0_ = _data36_->data;
	_tmp1_ = _tmp0_->selector_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gint _tmp4_ = 0;
		_tmp4_ = self->priv->nr_contacts_marked;
		self->priv->nr_contacts_marked = _tmp4_ + 1;
	} else {
		gint _tmp5_ = 0;
		_tmp5_ = self->priv->nr_contacts_marked;
		self->priv->nr_contacts_marked = _tmp5_ - 1;
	}
	_tmp6_ = self->priv->nr_contacts_marked;
	g_signal_emit_by_name (self, "contacts-marked", _tmp6_);
}


static void ___lambda85__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda85_ (self);
}


static void contacts_view_contact_added_cb (ContactsView* self, ContactsStore* store, ContactsContact* c) {
	Block36Data* _data36_;
	ContactsContact* _tmp0_ = NULL;
	ContactsViewContactDataRow* _tmp1_ = NULL;
	ContactsViewContactDataRow* _tmp2_ = NULL;
	ContactsViewContactDataRow* _tmp3_ = NULL;
	GtkCheckButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GeeHashMap* _tmp8_ = NULL;
	ContactsContact* _tmp9_ = NULL;
	ContactsViewContactDataRow* _tmp10_ = NULL;
	ContactsViewContactDataRow* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (c != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = c;
	_tmp1_ = contacts_view_contact_data_row_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_data36_->data = _tmp1_;
	_tmp2_ = _data36_->data;
	contacts_view_update_data (self, _tmp2_);
	_tmp3_ = _data36_->data;
	_tmp4_ = _tmp3_->selector_button;
	g_signal_connect_data ((GtkToggleButton*) _tmp4_, "toggled", (GCallback) ___lambda85__gtk_toggle_button_toggled, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp5_ = self->priv->selectors_visible;
	if (!_tmp5_) {
		ContactsViewContactDataRow* _tmp6_ = NULL;
		GtkCheckButton* _tmp7_ = NULL;
		_tmp6_ = _data36_->data;
		_tmp7_ = _tmp6_->selector_button;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
	_tmp8_ = self->priv->contacts;
	_tmp9_ = c;
	_tmp10_ = _data36_->data;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = _data36_->data;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}


static void contacts_view_contact_removed_cb (ContactsView* self, ContactsStore* store, ContactsContact* c) {
	ContactsViewContactDataRow* data = NULL;
	GeeHashMap* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	ContactsContact* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->contacts;
	_tmp1_ = c;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	data = (ContactsViewContactDataRow*) _tmp2_;
	_tmp3_ = self->priv->contacts;
	_tmp4_ = c;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, _tmp4_, NULL);
	gtk_widget_destroy ((GtkWidget*) data);
	_g_object_unref0 (data);
}


static void contacts_view_real_row_selected (GtkListBox* base, GtkListBoxRow* row) {
	ContactsView * self;
	ContactsViewContactDataRow* data = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	ContactsViewContactDataRow* _tmp1_ = NULL;
	ContactsContact* _tmp2_ = NULL;
	ContactsViewContactDataRow* _tmp3_ = NULL;
	ContactsContact* contact = NULL;
	ContactsContact* _tmp6_ = NULL;
	ContactsContact* _tmp7_ = NULL;
	ContactsContact* _tmp8_ = NULL;
	self = (ContactsView*) base;
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW) ? ((ContactsViewContactDataRow*) _tmp0_) : NULL);
	data = _tmp1_;
	_tmp3_ = data;
	if (_tmp3_ != NULL) {
		ContactsViewContactDataRow* _tmp4_ = NULL;
		ContactsContact* _tmp5_ = NULL;
		_tmp4_ = data;
		_tmp5_ = _tmp4_->contact;
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _g_object_ref0 (_tmp2_);
	contact = _tmp6_;
	_tmp7_ = contact;
	g_signal_emit_by_name (self, "selection-changed", _tmp7_);
	_tmp8_ = contact;
	if (_tmp8_ != NULL) {
		ContactsContact* _tmp9_ = NULL;
		_tmp9_ = contact;
		contacts_contact_fetch_contact_info (_tmp9_);
	}
	_g_object_unref0 (contact);
	_g_object_unref0 (data);
}


static gboolean contacts_view_filter (ContactsView* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	ContactsViewContactDataRow* data = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	ContactsViewContactDataRow* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW) ? ((ContactsViewContactDataRow*) _tmp0_) : NULL);
	data = _tmp1_;
	_tmp2_ = data->filtered;
	result = _tmp2_;
	_g_object_unref0 (data);
	return result;
}


static void contacts_view_update_header (ContactsView* self, GtkListBoxRow* row, GtkListBoxRow* before_row) {
	ContactsViewContactDataRow* row_data = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	ContactsViewContactDataRow* _tmp1_ = NULL;
	ContactsViewContactDataRow* before_data = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	ContactsViewContactDataRow* _tmp3_ = NULL;
	GtkWidget* current = NULL;
	GtkListBoxRow* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	ContactsViewContactDataRow* _tmp8_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	ContactsViewContactDataRow* _tmp26_ = NULL;
	gboolean _tmp40_ = FALSE;
	ContactsViewContactDataRow* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	ContactsViewContactDataRow* _tmp60_ = NULL;
	GtkListBoxRow* _tmp67_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = row;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW) ? ((ContactsViewContactDataRow*) _tmp0_) : NULL);
	row_data = _tmp1_;
	_tmp2_ = before_row;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW) ? ((ContactsViewContactDataRow*) _tmp2_) : NULL);
	before_data = _tmp3_;
	_tmp4_ = row;
	_tmp5_ = gtk_list_box_row_get_header (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	current = _tmp6_;
	_tmp8_ = before_data;
	if (_tmp8_ == NULL) {
		ContactsViewContactDataRow* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp9_ = row_data;
		_tmp10_ = _tmp9_->sort_prio;
		_tmp7_ = _tmp10_ > 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp11_ = FALSE;
		GtkWidget* _tmp12_ = NULL;
		_tmp12_ = current;
		if (_tmp12_ == NULL) {
			_tmp11_ = TRUE;
		} else {
			GtkWidget* _tmp13_ = NULL;
			gconstpointer _tmp14_ = NULL;
			_tmp13_ = current;
			_tmp14_ = g_object_get_data ((GObject*) _tmp13_, "contacts-suggestions-header");
			_tmp11_ = !((gboolean) ((gintptr) _tmp14_));
		}
		if (_tmp11_) {
			GtkLabel* l = NULL;
			GtkLabel* _tmp15_ = NULL;
			GtkLabel* _tmp16_ = NULL;
			GtkLabel* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			GtkLabel* _tmp21_ = NULL;
			GtkListBoxRow* _tmp22_ = NULL;
			GtkLabel* _tmp23_ = NULL;
			_tmp15_ = (GtkLabel*) gtk_label_new ("");
			g_object_ref_sink (_tmp15_);
			l = _tmp15_;
			_tmp16_ = l;
			g_object_set_data_full ((GObject*) _tmp16_, "contacts-suggestions-header", (gpointer) ((gintptr) TRUE), NULL);
			_tmp17_ = l;
			_tmp18_ = _ ("Suggestions");
			_tmp19_ = g_markup_printf_escaped ("<b>%s</b>", _tmp18_);
			_tmp20_ = _tmp19_;
			gtk_label_set_markup (_tmp17_, _tmp20_);
			_g_free0 (_tmp20_);
			_tmp21_ = l;
			gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_START);
			_tmp22_ = row;
			_tmp23_ = l;
			gtk_list_box_row_set_header (_tmp22_, (GtkWidget*) _tmp23_);
			_g_object_unref0 (l);
		}
		_g_object_unref0 (current);
		_g_object_unref0 (before_data);
		_g_object_unref0 (row_data);
		return;
	}
	_tmp26_ = before_data;
	if (_tmp26_ != NULL) {
		ContactsViewContactDataRow* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		_tmp27_ = before_data;
		_tmp28_ = _tmp27_->sort_prio;
		_tmp25_ = _tmp28_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ContactsViewContactDataRow* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		_tmp29_ = row_data;
		_tmp30_ = _tmp29_->sort_prio;
		_tmp24_ = _tmp30_ == 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gboolean _tmp31_ = FALSE;
		GtkWidget* _tmp32_ = NULL;
		_tmp32_ = current;
		if (_tmp32_ == NULL) {
			_tmp31_ = TRUE;
		} else {
			GtkWidget* _tmp33_ = NULL;
			gconstpointer _tmp34_ = NULL;
			_tmp33_ = current;
			_tmp34_ = g_object_get_data ((GObject*) _tmp33_, "contacts-rest-header");
			_tmp31_ = !((gboolean) ((gintptr) _tmp34_));
		}
		if (_tmp31_) {
			GtkLabel* l = NULL;
			GtkLabel* _tmp35_ = NULL;
			GtkLabel* _tmp36_ = NULL;
			GtkLabel* _tmp37_ = NULL;
			GtkListBoxRow* _tmp38_ = NULL;
			GtkLabel* _tmp39_ = NULL;
			_tmp35_ = (GtkLabel*) gtk_label_new ("");
			g_object_ref_sink (_tmp35_);
			l = _tmp35_;
			_tmp36_ = l;
			g_object_set_data_full ((GObject*) _tmp36_, "contacts-rest-header", (gpointer) ((gintptr) TRUE), NULL);
			_tmp37_ = l;
			gtk_widget_set_halign ((GtkWidget*) _tmp37_, GTK_ALIGN_START);
			_tmp38_ = row;
			_tmp39_ = l;
			gtk_list_box_row_set_header (_tmp38_, (GtkWidget*) _tmp39_);
			_g_object_unref0 (l);
		}
		_g_object_unref0 (current);
		_g_object_unref0 (before_data);
		_g_object_unref0 (row_data);
		return;
	}
	_tmp41_ = row_data;
	_tmp42_ = contacts_view_is_other (self, _tmp41_);
	if (_tmp42_) {
		gboolean _tmp43_ = FALSE;
		ContactsViewContactDataRow* _tmp44_ = NULL;
		_tmp44_ = before_data;
		if (_tmp44_ == NULL) {
			_tmp43_ = TRUE;
		} else {
			ContactsViewContactDataRow* _tmp45_ = NULL;
			gboolean _tmp46_ = FALSE;
			_tmp45_ = before_data;
			_tmp46_ = contacts_view_is_other (self, _tmp45_);
			_tmp43_ = !_tmp46_;
		}
		_tmp40_ = _tmp43_;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		gboolean _tmp47_ = FALSE;
		GtkWidget* _tmp48_ = NULL;
		_tmp48_ = current;
		if (_tmp48_ == NULL) {
			_tmp47_ = TRUE;
		} else {
			GtkWidget* _tmp49_ = NULL;
			gconstpointer _tmp50_ = NULL;
			_tmp49_ = current;
			_tmp50_ = g_object_get_data ((GObject*) _tmp49_, "contacts-other-header");
			_tmp47_ = !((gboolean) ((gintptr) _tmp50_));
		}
		if (_tmp47_) {
			GtkLabel* l = NULL;
			GtkLabel* _tmp51_ = NULL;
			GtkLabel* _tmp52_ = NULL;
			GtkLabel* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			GtkLabel* _tmp57_ = NULL;
			GtkListBoxRow* _tmp58_ = NULL;
			GtkLabel* _tmp59_ = NULL;
			_tmp51_ = (GtkLabel*) gtk_label_new ("");
			g_object_ref_sink (_tmp51_);
			l = _tmp51_;
			_tmp52_ = l;
			g_object_set_data_full ((GObject*) _tmp52_, "contacts-other-header", (gpointer) ((gintptr) TRUE), NULL);
			_tmp53_ = l;
			_tmp54_ = _ ("Other Contacts");
			_tmp55_ = g_markup_printf_escaped ("<b>%s</b>", _tmp54_);
			_tmp56_ = _tmp55_;
			gtk_label_set_markup (_tmp53_, _tmp56_);
			_g_free0 (_tmp56_);
			_tmp57_ = l;
			gtk_widget_set_halign ((GtkWidget*) _tmp57_, GTK_ALIGN_START);
			_tmp58_ = row;
			_tmp59_ = l;
			gtk_list_box_row_set_header (_tmp58_, (GtkWidget*) _tmp59_);
			_g_object_unref0 (l);
		}
		_g_object_unref0 (current);
		_g_object_unref0 (before_data);
		_g_object_unref0 (row_data);
		return;
	}
	_tmp60_ = before_data;
	if (_tmp60_ != NULL) {
		gboolean _tmp61_ = FALSE;
		GtkWidget* _tmp62_ = NULL;
		_tmp62_ = current;
		if (_tmp62_ == NULL) {
			_tmp61_ = TRUE;
		} else {
			GtkWidget* _tmp63_ = NULL;
			_tmp63_ = current;
			_tmp61_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, gtk_separator_get_type ());
		}
		if (_tmp61_) {
			GtkListBoxRow* _tmp64_ = NULL;
			GtkSeparator* _tmp65_ = NULL;
			GtkSeparator* _tmp66_ = NULL;
			_tmp64_ = row;
			_tmp65_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
			g_object_ref_sink (_tmp65_);
			_tmp66_ = _tmp65_;
			gtk_list_box_row_set_header (_tmp64_, (GtkWidget*) _tmp66_);
			_g_object_unref0 (_tmp66_);
		}
		_g_object_unref0 (current);
		_g_object_unref0 (before_data);
		_g_object_unref0 (row_data);
		return;
	}
	_tmp67_ = row;
	gtk_list_box_row_set_header (_tmp67_, NULL);
	_g_object_unref0 (current);
	_g_object_unref0 (before_data);
	_g_object_unref0 (row_data);
}


void contacts_view_select_contact (ContactsView* self, ContactsContact* contact) {
	ContactsContact* _tmp0_ = NULL;
	ContactsViewContactDataRow* data = NULL;
	GeeHashMap* _tmp1_ = NULL;
	ContactsContact* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	ContactsViewContactDataRow* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = contact;
	if (_tmp0_ == NULL) {
		gtk_list_box_select_row ((GtkListBox*) self, NULL);
		return;
	}
	_tmp1_ = self->priv->contacts;
	_tmp2_ = contact;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	data = (ContactsViewContactDataRow*) _tmp3_;
	_tmp4_ = data;
	gtk_list_box_select_row ((GtkListBox*) self, (GtkListBoxRow*) _tmp4_);
	_g_object_unref0 (data);
}


void contacts_view_show_selectors (ContactsView* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _data_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_data_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			ContactsViewContactDataRow* data = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			ContactsViewContactDataRow* _tmp10_ = NULL;
			GtkCheckButton* _tmp11_ = NULL;
			_tmp6_ = _data_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _data_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			data = (ContactsViewContactDataRow*) _tmp9_;
			_tmp10_ = data;
			_tmp11_ = _tmp10_->selector_button;
			gtk_widget_show ((GtkWidget*) _tmp11_);
			_g_object_unref0 (data);
		}
		_g_object_unref0 (_data_it);
	}
	self->priv->selectors_visible = TRUE;
}


void contacts_view_hide_selectors (ContactsView* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _data_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = self->priv->contacts;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_data_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			ContactsViewContactDataRow* data = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			ContactsViewContactDataRow* _tmp10_ = NULL;
			GtkCheckButton* _tmp11_ = NULL;
			ContactsViewContactDataRow* _tmp12_ = NULL;
			GtkCheckButton* _tmp13_ = NULL;
			_tmp6_ = _data_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _data_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			data = (ContactsViewContactDataRow*) _tmp9_;
			_tmp10_ = data;
			_tmp11_ = _tmp10_->selector_button;
			gtk_widget_hide ((GtkWidget*) _tmp11_);
			_tmp12_ = data;
			_tmp13_ = _tmp12_->selector_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, FALSE);
			_g_object_unref0 (data);
		}
		_g_object_unref0 (_data_it);
	}
	self->priv->selectors_visible = FALSE;
	self->priv->nr_contacts_marked = 0;
}


GeeLinkedList* contacts_view_get_marked_contacts (ContactsView* self) {
	GeeLinkedList* result = NULL;
	GeeLinkedList* cs = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (CONTACTS_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	cs = _tmp0_;
	{
		GeeIterator* _data_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = self->priv->contacts;
		_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_data_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			ContactsViewContactDataRow* data = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			ContactsViewContactDataRow* _tmp11_ = NULL;
			GtkCheckButton* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			_tmp7_ = _data_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _data_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			data = (ContactsViewContactDataRow*) _tmp10_;
			_tmp11_ = data;
			_tmp12_ = _tmp11_->selector_button;
			_tmp13_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				GeeLinkedList* _tmp15_ = NULL;
				ContactsViewContactDataRow* _tmp16_ = NULL;
				ContactsContact* _tmp17_ = NULL;
				_tmp15_ = cs;
				_tmp16_ = data;
				_tmp17_ = _tmp16_->contact;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
			}
			_g_object_unref0 (data);
		}
		_g_object_unref0 (_data_it);
	}
	result = cs;
	return result;
}


ContactsView* contacts_view_construct (GType object_type) {
	ContactsView * self = NULL;
	self = (ContactsView*) g_object_new (object_type, NULL);
	return self;
}


ContactsView* contacts_view_new (void) {
	return contacts_view_construct (CONTACTS_TYPE_VIEW);
}


ContactsStore* contacts_view_get_store (ContactsView* self) {
	ContactsStore* result;
	ContactsStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}


static void _contacts_view_contact_added_cb_contacts_store_added (ContactsStore* _sender, ContactsContact* c, gpointer self) {
	contacts_view_contact_added_cb ((ContactsView*) self, _sender, c);
}


static void _contacts_view_contact_removed_cb_contacts_store_removed (ContactsStore* _sender, ContactsContact* c, gpointer self) {
	contacts_view_contact_removed_cb ((ContactsView*) self, _sender, c);
}


static void _contacts_view_contact_changed_cb_contacts_store_changed (ContactsStore* _sender, ContactsContact* c, gpointer self) {
	contacts_view_contact_changed_cb ((ContactsView*) self, _sender, c);
}


void contacts_view_set_store (ContactsView* self, ContactsStore* value) {
	ContactsStore* _tmp0_ = NULL;
	ContactsStore* _tmp1_ = NULL;
	ContactsStore* _tmp2_ = NULL;
	ContactsStore* _tmp3_ = NULL;
	ContactsStore* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp1_;
	_tmp2_ = self->priv->_store;
	g_signal_connect_object (_tmp2_, "added", (GCallback) _contacts_view_contact_added_cb_contacts_store_added, self, 0);
	_tmp3_ = self->priv->_store;
	g_signal_connect_object (_tmp3_, "removed", (GCallback) _contacts_view_contact_removed_cb_contacts_store_removed, self, 0);
	_tmp4_ = self->priv->_store;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _contacts_view_contact_changed_cb_contacts_store_changed, self, 0);
	{
		GeeIterator* _c_it = NULL;
		ContactsStore* _tmp5_ = NULL;
		GeeCollection* _tmp6_ = NULL;
		GeeCollection* _tmp7_ = NULL;
		GeeIterator* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		_tmp5_ = self->priv->_store;
		_tmp6_ = contacts_store_get_contacts (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_c_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			ContactsContact* c = NULL;
			GeeIterator* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			ContactsStore* _tmp14_ = NULL;
			ContactsContact* _tmp15_ = NULL;
			_tmp10_ = _c_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _c_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			c = (ContactsContact*) _tmp13_;
			_tmp14_ = self->priv->_store;
			_tmp15_ = c;
			contacts_view_contact_added_cb (self, _tmp14_, _tmp15_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	g_object_notify ((GObject *) self, "store");
}


static gint _contacts_view___lambda86_ (ContactsView* self, GtkListBoxRow* row_a, GtkListBoxRow* row_b) {
	gint result = 0;
	ContactsViewContactDataRow* a = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	ContactsViewContactDataRow* _tmp1_ = NULL;
	ContactsViewContactDataRow* b = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	ContactsViewContactDataRow* _tmp3_ = NULL;
	ContactsViewContactDataRow* _tmp4_ = NULL;
	ContactsViewContactDataRow* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (row_a != NULL, 0);
	g_return_val_if_fail (row_b != NULL, 0);
	_tmp0_ = row_a;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW) ? ((ContactsViewContactDataRow*) _tmp0_) : NULL);
	a = _tmp1_;
	_tmp2_ = row_b;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW) ? ((ContactsViewContactDataRow*) _tmp2_) : NULL);
	b = _tmp3_;
	_tmp4_ = a;
	_tmp5_ = b;
	_tmp6_ = contacts_view_compare_data (self, _tmp4_, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (b);
	_g_object_unref0 (a);
	return result;
}


static gint __contacts_view___lambda86__gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = _contacts_view___lambda86_ ((ContactsView*) self, row1, row2);
	return result;
}


static gboolean _contacts_view_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = contacts_view_filter ((ContactsView*) self, row);
	return result;
}


static void _contacts_view_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	contacts_view_update_header ((ContactsView*) self, row, before);
}


static GObject * contacts_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ContactsView * self;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (contacts_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_VIEW, ContactsView);
	_tmp0_ = gee_hash_set_new (CONTACTS_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->hidden_contacts);
	self->priv->hidden_contacts = _tmp0_;
	_tmp1_ = gee_hash_map_new (CONTACTS_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, g_object_unref, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->contacts);
	self->priv->contacts = _tmp1_;
	gtk_list_box_set_sort_func ((GtkListBox*) self, __contacts_view___lambda86__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	gtk_list_box_set_filter_func ((GtkListBox*) self, _contacts_view_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	gtk_list_box_set_header_func ((GtkListBox*) self, _contacts_view_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	return obj;
}


static ContactsViewContactDataRow* contacts_view_contact_data_row_construct (GType object_type, ContactsContact* c) {
	ContactsViewContactDataRow * self = NULL;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	ContactsContactFrame* _tmp5_ = NULL;
	ContactsContactFrame* _tmp6_ = NULL;
	ContactsContactFrame* _tmp7_ = NULL;
	GtkStyleContext* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkCheckButton* _tmp13_ = NULL;
	GtkCheckButton* _tmp14_ = NULL;
	GtkCheckButton* _tmp15_ = NULL;
	GtkCheckButton* _tmp16_ = NULL;
	GtkCheckButton* _tmp17_ = NULL;
	GtkGrid* _tmp18_ = NULL;
	ContactsContactFrame* _tmp19_ = NULL;
	GtkGrid* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkGrid* _tmp22_ = NULL;
	GtkCheckButton* _tmp23_ = NULL;
	GtkGrid* _tmp24_ = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	self = (ContactsViewContactDataRow*) g_object_new (object_type, NULL);
	_tmp0_ = c;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->contact);
	self->contact = _tmp1_;
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->grid);
	self->grid = _tmp2_;
	_tmp3_ = self->grid;
	g_object_set ((GtkWidget*) _tmp3_, "margin", 6, NULL);
	_tmp4_ = self->grid;
	gtk_grid_set_column_spacing (_tmp4_, (guint) 10);
	_tmp5_ = contacts_contact_frame_new (CONTACTS_CONTACT_LIST_AVATAR_SIZE, FALSE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->image_frame);
	self->image_frame = _tmp5_;
	_tmp6_ = self->image_frame;
	gtk_frame_set_shadow_type ((GtkFrame*) _tmp6_, GTK_SHADOW_IN);
	_tmp7_ = self->image_frame;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, "main-avatar-frame");
	_tmp9_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->label);
	self->label = _tmp9_;
	_tmp10_ = self->label;
	gtk_label_set_ellipsize (_tmp10_, PANGO_ELLIPSIZE_END);
	_tmp11_ = self->label;
	gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	_tmp12_ = self->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, GTK_ALIGN_START);
	_tmp13_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->selector_button);
	self->selector_button = _tmp13_;
	_tmp14_ = self->selector_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp14_, TRUE);
	_tmp15_ = self->selector_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	_tmp16_ = self->selector_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_END);
	_tmp17_ = self->selector_button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	_tmp18_ = self->grid;
	_tmp19_ = self->image_frame;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 0, 0, 1, 1);
	_tmp20_ = self->grid;
	_tmp21_ = self->label;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, 0, 1, 1);
	_tmp22_ = self->grid;
	_tmp23_ = self->selector_button;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 2, 0, 1, 1);
	_tmp24_ = self->grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp24_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}


static ContactsViewContactDataRow* contacts_view_contact_data_row_new (ContactsContact* c) {
	return contacts_view_contact_data_row_construct (CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW, c);
}


static void contacts_view_contact_data_row_update_widgets (ContactsViewContactDataRow* self) {
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ContactsContactFrame* _tmp2_ = NULL;
	ContactsContact* _tmp3_ = NULL;
	FolksIndividual* _tmp4_ = NULL;
	ContactsContact* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label;
	_tmp1_ = self->display_name;
	gtk_label_set_text (_tmp0_, _tmp1_);
	_tmp2_ = self->image_frame;
	_tmp3_ = self->contact;
	_tmp4_ = _tmp3_->individual;
	_tmp5_ = self->contact;
	contacts_contact_frame_set_image (_tmp2_, (FolksAvatarDetails*) _tmp4_, _tmp5_);
}


static void contacts_view_contact_data_row_class_init (ContactsViewContactDataRowClass * klass) {
	contacts_view_contact_data_row_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = contacts_view_contact_data_row_finalize;
}


static void contacts_view_contact_data_row_instance_init (ContactsViewContactDataRow * self) {
}


static void contacts_view_contact_data_row_finalize (GObject* obj) {
	ContactsViewContactDataRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_VIEW_TYPE_CONTACT_DATA_ROW, ContactsViewContactDataRow);
	_g_object_unref0 (self->contact);
	_g_object_unref0 (self->grid);
	_g_object_unref0 (self->label);
	_g_object_unref0 (self->image_frame);
	_g_object_unref0 (self->selector_button);
	_g_free0 (self->display_name);
	G_OBJECT_CLASS (contacts_view_contact_data_row_parent_class)->finalize (obj);
}


static GType contacts_view_contact_data_row_get_type (void) {
	static volatile gsize contacts_view_contact_data_row_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_view_contact_data_row_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsViewContactDataRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_view_contact_data_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsViewContactDataRow), 0, (GInstanceInitFunc) contacts_view_contact_data_row_instance_init, NULL };
		GType contacts_view_contact_data_row_type_id;
		contacts_view_contact_data_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ContactsViewContactDataRow", &g_define_type_info, 0);
		g_once_init_leave (&contacts_view_contact_data_row_type_id__volatile, contacts_view_contact_data_row_type_id);
	}
	return contacts_view_contact_data_row_type_id__volatile;
}


static void contacts_view_class_init (ContactsViewClass * klass) {
	contacts_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsViewPrivate));
	((GtkListBoxClass *) klass)->row_selected = contacts_view_real_row_selected;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_VIEW_STORE, g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("selection_changed", CONTACTS_TYPE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, CONTACTS_TYPE_CONTACT);
	g_signal_new ("contacts_marked", CONTACTS_TYPE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void contacts_view_instance_init (ContactsView * self) {
	self->priv = CONTACTS_VIEW_GET_PRIVATE (self);
	self->priv->show_subset = CONTACTS_VIEW_SUBSET_ALL;
	self->priv->nr_contacts_marked = 0;
	self->priv->text_display = CONTACTS_VIEW_TEXT_DISPLAY_PRESENCE;
	self->priv->selectors_visible = FALSE;
}


static void contacts_view_finalize (GObject* obj) {
	ContactsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_VIEW, ContactsView);
	_g_object_unref0 (self->priv->contacts);
	_g_object_unref0 (self->priv->hidden_contacts);
	self->priv->filter_values = (_vala_array_free (self->priv->filter_values, self->priv->filter_values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (contacts_view_parent_class)->finalize (obj);
}


GType contacts_view_get_type (void) {
	static volatile gsize contacts_view_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsView), 0, (GInstanceInitFunc) contacts_view_instance_init, NULL };
		GType contacts_view_type_id;
		contacts_view_type_id = g_type_register_static (gtk_list_box_get_type (), "ContactsView", &g_define_type_info, 0);
		g_once_init_leave (&contacts_view_type_id__volatile, contacts_view_type_id);
	}
	return contacts_view_type_id__volatile;
}


static void _vala_contacts_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_VIEW, ContactsView);
	switch (property_id) {
		case CONTACTS_VIEW_STORE:
		g_value_set_object (value, contacts_view_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_VIEW, ContactsView);
	switch (property_id) {
		case CONTACTS_VIEW_STORE:
		contacts_view_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



