/* contacts-menu-button.c generated by valac 0.12.0.305-a4eb, the Vala compiler
 * generated from contacts-menu-button.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define CONTACTS_TYPE_MENU_BUTTON (contacts_menu_button_get_type ())
#define CONTACTS_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButton))
#define CONTACTS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButtonClass))
#define CONTACTS_IS_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_MENU_BUTTON))
#define CONTACTS_IS_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_MENU_BUTTON))
#define CONTACTS_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButtonClass))

typedef struct _ContactsMenuButton ContactsMenuButton;
typedef struct _ContactsMenuButtonClass ContactsMenuButtonClass;
typedef struct _ContactsMenuButtonPrivate ContactsMenuButtonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ContactsMenuButton {
	GtkToggleButton parent_instance;
	ContactsMenuButtonPrivate * priv;
};

struct _ContactsMenuButtonClass {
	GtkToggleButtonClass parent_class;
};

struct _ContactsMenuButtonPrivate {
	GtkMenu* menu;
	gboolean popup_in_progress;
};


static gpointer contacts_menu_button_parent_class = NULL;

GType contacts_menu_button_get_type (void) G_GNUC_CONST;
#define CONTACTS_MENU_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_MENU_BUTTON, ContactsMenuButtonPrivate))
enum  {
	CONTACTS_MENU_BUTTON_DUMMY_PROPERTY
};
void contacts_menu_button_set_menu (ContactsMenuButton* self, GtkMenu* menu);
ContactsMenuButton* contacts_menu_button_new (const gchar* label);
ContactsMenuButton* contacts_menu_button_construct (GType object_type, const gchar* label);
static void contacts_menu_button_menu_position (ContactsMenuButton* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void contacts_menu_button_real_toggled (GtkToggleButton* base);
static void _contacts_menu_button_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static gboolean contacts_menu_button_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean contacts_menu_button_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static void contacts_menu_button_menu_show (ContactsMenuButton* self, GtkWidget* menu);
static void contacts_menu_button_menu_hide (ContactsMenuButton* self, GtkWidget* menu);
static void contacts_menu_button_menu_detach (ContactsMenuButton* self, GtkMenu* menu);
static void _contacts_menu_button_menu_show_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void _contacts_menu_button_menu_hide_gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void _contacts_menu_button_menu_detach_gtk_menu_detach_func (GtkWidget* attach_widget, GtkMenu* menu);
static gboolean contacts_menu_button_real_draw (GtkWidget* base, cairo_t* cr);
static void contacts_menu_button_finalize (GObject* obj);


ContactsMenuButton* contacts_menu_button_construct (GType object_type, const gchar* label) {
	ContactsMenuButton * self = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* label_widget;
	GtkArrow* _tmp1_ = NULL;
	GtkArrow* arrow;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* grid;
	g_return_val_if_fail (label != NULL, NULL);
	self = (ContactsMenuButton*) g_object_new (object_type, NULL);
	gtk_button_set_focus_on_click ((GtkButton*) self, FALSE);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	label_widget = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_NONE);
	arrow = g_object_ref_sink (_tmp1_);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	grid = g_object_ref_sink (_tmp2_);
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) label_widget);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) arrow);
	gtk_grid_set_row_spacing (grid, (guint) 3);
	gtk_widget_set_hexpand ((GtkWidget*) grid, TRUE);
	gtk_widget_set_halign ((GtkWidget*) grid, GTK_ALIGN_CENTER);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (arrow);
	_g_object_unref0 (label_widget);
	return self;
}


ContactsMenuButton* contacts_menu_button_new (const gchar* label) {
	return contacts_menu_button_construct (CONTACTS_TYPE_MENU_BUTTON, label);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void contacts_menu_button_menu_position (ContactsMenuButton* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _x = 0;
	gint _y = 0;
	gboolean _push_in = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint sx;
	gint sy;
	gboolean _tmp1_;
	GdkWindow* _tmp2_ = NULL;
	gint _tmp3_;
	gint _tmp4_;
	GtkRequisition menu_req = {0};
	GdkRectangle monitor = {0};
	GtkRequisition _tmp5_ = {0};
	GtkTextDirection _tmp6_;
	GdkWindow* _tmp7_ = NULL;
	GdkWindow* _tmp8_;
	GdkWindow* window;
	GdkScreen* _tmp9_ = NULL;
	GdkScreen* _tmp10_;
	GdkScreen* screen;
	gint _tmp11_;
	gint monitor_num;
	GdkRectangle _tmp12_ = {0};
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* _tmp14_;
	GtkWindow* _tmp15_;
	GtkWindow* toplevel;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	sx = 0;
	sy = 0;
	_tmp1_ = gtk_widget_get_has_window ((GtkWidget*) self);
	if (!_tmp1_) {
		sx = sx + allocation.x;
		sy = sy + allocation.y;
	}
	_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_root_coords (_tmp2_, sx, sy, &_tmp3_, &_tmp4_);
	sx = _tmp3_;
	sy = _tmp4_;
	gtk_widget_get_preferred_size ((GtkWidget*) menu, NULL, &_tmp5_);
	menu_req = _tmp5_;
	_tmp6_ = gtk_widget_get_direction ((GtkWidget*) self);
	if (_tmp6_ == GTK_TEXT_DIR_LTR) {
		_x = sx;
	} else {
		_x = (sx + allocation.width) - menu_req.width;
	}
	_y = sy;
	_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	window = _tmp8_;
	_tmp9_ = gtk_widget_get_screen ((GtkWidget*) self);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	screen = _tmp10_;
	_tmp11_ = gdk_screen_get_monitor_at_window (screen, window);
	monitor_num = _tmp11_;
	if (monitor_num < 0) {
		monitor_num = 0;
	}
	gdk_screen_get_monitor_geometry (screen, monitor_num, &_tmp12_);
	monitor = _tmp12_;
	if (_x < monitor.x) {
		_x = monitor.x;
	} else {
		if ((_x + menu_req.width) > (monitor.x + monitor.width)) {
			_x = (monitor.x + monitor.width) - menu_req.width;
		}
	}
	if ((((monitor.y + monitor.height) - _y) - allocation.height) >= menu_req.height) {
		_y = _y + allocation.height;
	} else {
		if ((_y - monitor.y) >= menu_req.height) {
			_y = _y - menu_req.height;
		} else {
			if ((((monitor.y + monitor.height) - _y) - allocation.height) > (_y - monitor.y)) {
				_y = _y + allocation.height;
			} else {
				_y = _y - menu_req.height;
			}
		}
	}
	gtk_menu_set_monitor (menu, monitor_num);
	_tmp13_ = gtk_widget_get_parent ((GtkWidget*) menu);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp14_) ? ((GtkWindow*) _tmp14_) : NULL);
	toplevel = _tmp15_;
	if (toplevel != NULL) {
		gboolean _tmp17_;
		_tmp17_ = gtk_widget_get_visible ((GtkWidget*) toplevel);
		_tmp16_ = !_tmp17_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gtk_window_set_type_hint (toplevel, GDK_WINDOW_TYPE_HINT_DROPDOWN_MENU);
	}
	_push_in = FALSE;
	_g_object_unref0 (toplevel);
	_g_object_unref0 (screen);
	_g_object_unref0 (window);
	if (x) {
		*x = _x;
	}
	if (y) {
		*y = _y;
	}
	if (push_in) {
		*push_in = _push_in;
	}
}


static void _contacts_menu_button_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	contacts_menu_button_menu_position (self, menu, x, y, push_in);
}


static void contacts_menu_button_real_toggled (GtkToggleButton* base) {
	ContactsMenuButton * self;
	gboolean _tmp0_;
	self = (ContactsMenuButton*) base;
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	if (_tmp0_) {
		if (!self->priv->popup_in_progress) {
			guint32 _tmp1_;
			_tmp1_ = gtk_get_current_event_time ();
			gtk_menu_popup (self->priv->menu, NULL, NULL, _contacts_menu_button_menu_position_gtk_menu_position_func, self, (guint) 1, _tmp1_);
		}
	} else {
		gtk_menu_popdown (self->priv->menu);
	}
}


static gboolean contacts_menu_button_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ContactsMenuButton * self;
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* ewidget;
	gboolean _tmp2_ = FALSE;
	guint32 _tmp4_;
	self = (ContactsMenuButton*) base;
	_tmp0_ = gtk_get_event_widget ((GdkEvent*) (event));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ewidget = _tmp1_;
	if (ewidget != GTK_WIDGET (self)) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
		_tmp2_ = _tmp3_;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_object_unref0 (ewidget);
		return result;
	}
	_tmp4_ = gtk_get_current_event_time ();
	gtk_menu_popup (self->priv->menu, NULL, NULL, _contacts_menu_button_menu_position_gtk_menu_position_func, self, (guint) 1, _tmp4_);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, TRUE);
	self->priv->popup_in_progress = TRUE;
	result = TRUE;
	_g_object_unref0 (ewidget);
	return result;
}


static gboolean contacts_menu_button_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	ContactsMenuButton * self;
	gboolean result = FALSE;
	gboolean popup_in_progress_saved;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* ewidget;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (ContactsMenuButton*) base;
	popup_in_progress_saved = self->priv->popup_in_progress;
	self->priv->popup_in_progress = FALSE;
	_tmp0_ = gtk_get_event_widget ((GdkEvent*) (event));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ewidget = _tmp1_;
	if (ewidget == GTK_WIDGET (self)) {
		_tmp3_ = !popup_in_progress_saved;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gtk_menu_popdown (self->priv->menu);
		result = TRUE;
		_g_object_unref0 (ewidget);
		return result;
	}
	if (ewidget != GTK_WIDGET (self)) {
		gtk_menu_popdown (self->priv->menu);
		result = TRUE;
		_g_object_unref0 (ewidget);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (ewidget);
	return result;
}


static void contacts_menu_button_menu_show (ContactsMenuButton* self, GtkWidget* menu) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	self->priv->popup_in_progress = TRUE;
	gtk_toggle_button_set_active ((GtkToggleButton*) self, TRUE);
	self->priv->popup_in_progress = FALSE;
}


static void contacts_menu_button_menu_hide (ContactsMenuButton* self, GtkWidget* menu) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, FALSE);
}


static void contacts_menu_button_menu_detach (ContactsMenuButton* self, GtkMenu* menu) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
}


static void _contacts_menu_button_menu_show_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	contacts_menu_button_menu_show (self, _sender);
}


static void _contacts_menu_button_menu_hide_gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	contacts_menu_button_menu_hide (self, _sender);
}


static void _contacts_menu_button_menu_detach_gtk_menu_detach_func (GtkWidget* attach_widget, GtkMenu* menu) {
	contacts_menu_button_menu_detach (attach_widget, menu);
}


void contacts_menu_button_set_menu (ContactsMenuButton* self, GtkMenu* menu) {
	GtkMenu* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->menu != NULL) {
		guint _tmp0_;
		guint _tmp1_;
		g_signal_parse_name ("show", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->menu, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _contacts_menu_button_menu_show_gtk_widget_show, self);
		g_signal_parse_name ("hide", GTK_TYPE_WIDGET, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->menu, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _contacts_menu_button_menu_hide_gtk_widget_hide, self);
		gtk_menu_detach (self->priv->menu);
	}
	_tmp2_ = _g_object_ref0 (menu);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp2_;
	if (self->priv->menu != NULL) {
		g_signal_connect_object ((GtkWidget*) self->priv->menu, "show", (GCallback) _contacts_menu_button_menu_show_gtk_widget_show, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->menu, "hide", (GCallback) _contacts_menu_button_menu_hide_gtk_widget_hide, self, 0);
		gtk_menu_attach_to_widget (self->priv->menu, (GtkWidget*) self, _contacts_menu_button_menu_detach_gtk_menu_detach_func);
	}
}


static gboolean contacts_menu_button_real_draw (GtkWidget* base, cairo_t* cr) {
	ContactsMenuButton * self;
	gboolean result = FALSE;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* context;
	gboolean _tmp2_;
	self = (ContactsMenuButton*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	gtk_style_context_save (context);
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) self);
	if (_tmp2_) {
		gtk_style_context_add_class (context, GTK_STYLE_CLASS_MENUBAR);
		gtk_style_context_add_class (context, GTK_STYLE_CLASS_MENUITEM);
	}
	GTK_WIDGET_CLASS (contacts_menu_button_parent_class)->draw ((GtkWidget*) GTK_TOGGLE_BUTTON (self), cr);
	gtk_style_context_restore (context);
	result = FALSE;
	_g_object_unref0 (context);
	return result;
}


static void contacts_menu_button_class_init (ContactsMenuButtonClass * klass) {
	contacts_menu_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsMenuButtonPrivate));
	GTK_TOGGLE_BUTTON_CLASS (klass)->toggled = contacts_menu_button_real_toggled;
	GTK_WIDGET_CLASS (klass)->button_press_event = contacts_menu_button_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = contacts_menu_button_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->draw = contacts_menu_button_real_draw;
	G_OBJECT_CLASS (klass)->finalize = contacts_menu_button_finalize;
}


static void contacts_menu_button_instance_init (ContactsMenuButton * self) {
	self->priv = CONTACTS_MENU_BUTTON_GET_PRIVATE (self);
}


static void contacts_menu_button_finalize (GObject* obj) {
	ContactsMenuButton * self;
	self = CONTACTS_MENU_BUTTON (obj);
	contacts_menu_button_set_menu (self, NULL);
	_g_object_unref0 (self->priv->menu);
	G_OBJECT_CLASS (contacts_menu_button_parent_class)->finalize (obj);
}


GType contacts_menu_button_get_type (void) {
	static volatile gsize contacts_menu_button_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_menu_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsMenuButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_menu_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsMenuButton), 0, (GInstanceInitFunc) contacts_menu_button_instance_init, NULL };
		GType contacts_menu_button_type_id;
		contacts_menu_button_type_id = g_type_register_static (GTK_TYPE_TOGGLE_BUTTON, "ContactsMenuButton", &g_define_type_info, 0);
		g_once_init_leave (&contacts_menu_button_type_id__volatile, contacts_menu_button_type_id);
	}
	return contacts_menu_button_type_id__volatile;
}



