/* chess-view-2d.c generated by valac 0.23.1.16-ce7f, the Vala compiler
 * generated from chess-view-2d.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <librsvg/rsvg.h>
#include <stdio.h>


#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;
typedef struct _ChessViewPrivate ChessViewPrivate;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessView2DPrivate ChessView2DPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
typedef struct _ChessModelPrivate ChessModelPrivate;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
#define _chess_model_unref0(var) ((var == NULL) ? NULL : (var = (chess_model_unref (var), NULL)))
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())
typedef struct _ChessPiecePrivate ChessPiecePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_PIECE_TYPE (piece_type_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

struct _ChessView {
	GtkDrawingArea parent_instance;
	ChessViewPrivate * priv;
};

struct _ChessViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _ChessView2D {
	ChessView parent_instance;
	ChessView2DPrivate * priv;
};

struct _ChessView2DClass {
	ChessViewClass parent_class;
};

struct _ChessView2DPrivate {
	gint border;
	gint square_size;
	gint selected_square_size;
	cairo_surface_t* model_surface;
	cairo_surface_t* selected_model_surface;
	gchar* loaded_theme_name;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};

struct _ChessModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessModelPrivate * priv;
	ChessPiece* piece;
	gdouble x;
	gdouble y;
	gdouble target_x;
	gdouble target_y;
	gboolean under_threat;
	gboolean is_selected;
};

struct _ChessModelClass {
	GTypeClass parent_class;
	void (*finalize) (ChessModel *self);
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};


static gpointer chess_view2_d_parent_class = NULL;

GType chess_view_get_type (void) G_GNUC_CONST;
GType chess_view2_d_get_type (void) G_GNUC_CONST;
#define CHESS_VIEW2_D_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_VIEW2_D, ChessView2DPrivate))
enum  {
	CHESS_VIEW2_D_DUMMY_PROPERTY
};
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event);
static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset);
GType chess_scene_get_type (void) G_GNUC_CONST;
ChessScene* chess_view_get_scene (ChessView* self);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_view2_d_load_theme (ChessView2D* self, cairo_t* c);
static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c);
gdouble chess_scene_get_board_angle (ChessScene* self);
static gdouble chess_view2_d_get_border_size (ChessView2D* self);
gboolean chess_scene_get_show_numbering (ChessScene* self);
gpointer chess_model_ref (gpointer instance);
void chess_model_unref (gpointer instance);
GParamSpec* param_spec_chess_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_model (GValue* value, gpointer v_object);
void value_take_chess_model (GValue* value, gpointer v_object);
gpointer value_get_chess_model (const GValue* value);
GType chess_model_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gboolean chess_scene_get_show_move_hints (ChessScene* self);
static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha);
gboolean chess_scene_can_move (ChessScene* self, gint rank, gint file);
ChessPiece* chess_scene_get_selected_piece (ChessScene* self);
const gchar* chess_scene_get_board_side (ChessScene* self);
GType color_get_type (void) G_GNUC_CONST;
Color chess_piece_get_color (ChessPiece* self);
GType chess_player_get_type (void) G_GNUC_CONST;
GType piece_type_get_type (void) G_GNUC_CONST;
static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
ChessGame* chess_scene_get_game (ChessScene* self);
void chess_scene_select_square (ChessScene* self, gint file, gint rank);
static void chess_view2_d_finalize (GObject* obj);
static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ChessView2D* chess_view2_d_construct (GType object_type) {
	ChessView2D * self = NULL;
	self = (ChessView2D*) chess_view_construct (object_type);
	gtk_widget_add_events ((GtkWidget*) self, (gint) GDK_BUTTON_PRESS_MASK);
	return self;
}


ChessView2D* chess_view2_d_new (void) {
	return chess_view2_d_construct (TYPE_CHESS_VIEW2_D);
}


static gboolean chess_view2_d_real_configure_event (GtkWidget* base, GdkEventConfigure* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gint short_edge = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gdouble extra = 0.0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	self = (ChessView2D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = MIN (_tmp0_, _tmp1_);
	short_edge = _tmp2_;
	_tmp3_ = short_edge;
	_tmp4_ = self->priv->border;
	_tmp5_ = floor ((_tmp3_ - (2 * _tmp4_)) / 9.0);
	self->priv->square_size = (gint) _tmp5_;
	_tmp6_ = self->priv->square_size;
	extra = _tmp6_ * 0.1;
	_tmp7_ = extra;
	if (_tmp7_ < ((gdouble) 3)) {
		extra = (gdouble) 3;
	}
	_tmp8_ = self->priv->square_size;
	_tmp9_ = extra;
	self->priv->selected_square_size = _tmp8_ + (2 * ((gint) (_tmp9_ + 0.5)));
	result = TRUE;
	return result;
}


static void chess_view2_d_render_piece (ChessView2D* self, cairo_t* c1, cairo_t* c2, const gchar* name, gint offset) {
	RsvgHandle* handle = NULL;
	cairo_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	RsvgHandle* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	RsvgHandle* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	RsvgHandle* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	RsvgHandle* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	RsvgHandle* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	RsvgHandle* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	cairo_t* _tmp46_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c1 != NULL);
	g_return_if_fail (c2 != NULL);
	g_return_if_fail (name != NULL);
	{
		RsvgHandle* _tmp0_ = NULL;
		ChessScene* _tmp1_ = NULL;
		ChessScene* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		RsvgHandle* _tmp10_ = NULL;
		RsvgHandle* _tmp11_ = NULL;
		_tmp1_ = chess_view_get_scene ((ChessView*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = chess_scene_get_theme_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = name;
		_tmp6_ = g_strconcat (_tmp5_, ".svg", NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_filename (PKGDATADIR, "pieces", _tmp4_, _tmp7_, NULL, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = rsvg_handle_new_from_file (_tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_tmp0_ = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_g_object_unref0 (handle);
		handle = _tmp0_;
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Failed to load piece svg: %s", _tmp14_);
		_g_error_free0 (e);
		_g_object_unref0 (handle);
		return;
	}
	__finally18:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (handle);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = c1;
	cairo_save (_tmp15_);
	_tmp16_ = c1;
	_tmp17_ = self->priv->square_size;
	_tmp18_ = offset;
	cairo_translate (_tmp16_, (gdouble) (_tmp17_ * _tmp18_), (gdouble) 0);
	_tmp19_ = c1;
	_tmp20_ = self->priv->square_size;
	_tmp21_ = handle;
	g_object_get (_tmp21_, "width", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->square_size;
	_tmp25_ = handle;
	g_object_get (_tmp25_, "height", &_tmp26_, NULL);
	_tmp27_ = _tmp26_;
	cairo_scale (_tmp19_, ((gdouble) _tmp20_) / _tmp23_, ((gdouble) _tmp24_) / _tmp27_);
	_tmp28_ = handle;
	_tmp29_ = c1;
	rsvg_handle_render_cairo (_tmp28_, _tmp29_);
	_tmp30_ = c1;
	cairo_restore (_tmp30_);
	_tmp31_ = c2;
	cairo_save (_tmp31_);
	_tmp32_ = c2;
	_tmp33_ = self->priv->selected_square_size;
	_tmp34_ = offset;
	cairo_translate (_tmp32_, (gdouble) (_tmp33_ * _tmp34_), (gdouble) 0);
	_tmp35_ = c2;
	_tmp36_ = self->priv->selected_square_size;
	_tmp37_ = handle;
	g_object_get (_tmp37_, "width", &_tmp38_, NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->selected_square_size;
	_tmp41_ = handle;
	g_object_get (_tmp41_, "height", &_tmp42_, NULL);
	_tmp43_ = _tmp42_;
	cairo_scale (_tmp35_, ((gdouble) _tmp36_) / _tmp39_, ((gdouble) _tmp40_) / _tmp43_);
	_tmp44_ = handle;
	_tmp45_ = c2;
	rsvg_handle_render_cairo (_tmp44_, _tmp45_);
	_tmp46_ = c2;
	cairo_restore (_tmp46_);
	_g_object_unref0 (handle);
}


static void chess_view2_d_load_theme (ChessView2D* self, cairo_t* c) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessScene* _tmp2_ = NULL;
	ChessScene* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	cairo_surface_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	cairo_surface_t* _tmp20_ = NULL;
	cairo_t* c1 = NULL;
	cairo_surface_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_t* c2 = NULL;
	cairo_surface_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	cairo_t* _tmp28_ = NULL;
	cairo_t* _tmp29_ = NULL;
	cairo_t* _tmp30_ = NULL;
	cairo_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	cairo_t* _tmp39_ = NULL;
	cairo_t* _tmp40_ = NULL;
	cairo_t* _tmp41_ = NULL;
	cairo_t* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	cairo_t* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	cairo_t* _tmp46_ = NULL;
	cairo_t* _tmp47_ = NULL;
	cairo_t* _tmp48_ = NULL;
	ChessScene* _tmp49_ = NULL;
	ChessScene* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_tmp2_ = chess_view_get_scene ((ChessView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = chess_scene_get_theme_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->loaded_theme_name;
	if (g_strcmp0 (_tmp5_, _tmp6_) == 0) {
		cairo_surface_t* _tmp7_ = NULL;
		_tmp7_ = self->priv->model_surface;
		_tmp1_ = _tmp7_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		gint _tmp9_ = 0;
		cairo_surface_t* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp9_ = self->priv->square_size;
		_tmp10_ = self->priv->model_surface;
		_tmp11_ = cairo_image_surface_get_height (_tmp10_);
		_tmp0_ = _tmp9_ == _tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		return;
	}
	_tmp13_ = self->priv->square_size;
	_tmp14_ = self->priv->square_size;
	_tmp15_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 12 * _tmp13_, _tmp14_);
	_cairo_surface_destroy0 (self->priv->model_surface);
	self->priv->model_surface = _tmp15_;
	_tmp16_ = c;
	_tmp17_ = cairo_get_target (_tmp16_);
	_tmp18_ = self->priv->selected_square_size;
	_tmp19_ = self->priv->selected_square_size;
	_tmp20_ = cairo_surface_create_similar (_tmp17_, CAIRO_CONTENT_COLOR_ALPHA, 12 * _tmp18_, _tmp19_);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	self->priv->selected_model_surface = _tmp20_;
	_tmp21_ = self->priv->model_surface;
	_tmp22_ = cairo_create (_tmp21_);
	c1 = _tmp22_;
	_tmp23_ = self->priv->selected_model_surface;
	_tmp24_ = cairo_create (_tmp23_);
	c2 = _tmp24_;
	_tmp25_ = c1;
	_tmp26_ = c2;
	chess_view2_d_render_piece (self, _tmp25_, _tmp26_, "whitePawn", 0);
	_tmp27_ = c1;
	_tmp28_ = c2;
	chess_view2_d_render_piece (self, _tmp27_, _tmp28_, "whiteRook", 1);
	_tmp29_ = c1;
	_tmp30_ = c2;
	chess_view2_d_render_piece (self, _tmp29_, _tmp30_, "whiteKnight", 2);
	_tmp31_ = c1;
	_tmp32_ = c2;
	chess_view2_d_render_piece (self, _tmp31_, _tmp32_, "whiteBishop", 3);
	_tmp33_ = c1;
	_tmp34_ = c2;
	chess_view2_d_render_piece (self, _tmp33_, _tmp34_, "whiteQueen", 4);
	_tmp35_ = c1;
	_tmp36_ = c2;
	chess_view2_d_render_piece (self, _tmp35_, _tmp36_, "whiteKing", 5);
	_tmp37_ = c1;
	_tmp38_ = c2;
	chess_view2_d_render_piece (self, _tmp37_, _tmp38_, "blackPawn", 6);
	_tmp39_ = c1;
	_tmp40_ = c2;
	chess_view2_d_render_piece (self, _tmp39_, _tmp40_, "blackRook", 7);
	_tmp41_ = c1;
	_tmp42_ = c2;
	chess_view2_d_render_piece (self, _tmp41_, _tmp42_, "blackKnight", 8);
	_tmp43_ = c1;
	_tmp44_ = c2;
	chess_view2_d_render_piece (self, _tmp43_, _tmp44_, "blackBishop", 9);
	_tmp45_ = c1;
	_tmp46_ = c2;
	chess_view2_d_render_piece (self, _tmp45_, _tmp46_, "blackQueen", 10);
	_tmp47_ = c1;
	_tmp48_ = c2;
	chess_view2_d_render_piece (self, _tmp47_, _tmp48_, "blackKing", 11);
	_tmp49_ = chess_view_get_scene ((ChessView*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = chess_scene_get_theme_name (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strdup (_tmp52_);
	_g_free0 (self->priv->loaded_theme_name);
	self->priv->loaded_theme_name = _tmp53_;
	_cairo_destroy0 (c2);
	_cairo_destroy0 (c1);
}


static gpointer _chess_model_ref0 (gpointer self) {
	return self ? chess_model_ref (self) : NULL;
}


static gboolean chess_view2_d_real_draw (GtkWidget* base, cairo_t* c) {
	ChessView2D * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	ChessScene* _tmp5_ = NULL;
	ChessScene* _tmp6_ = NULL;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gint board_size = 0;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	cairo_t* _tmp19_ = NULL;
	ChessScene* _tmp42_ = NULL;
	ChessScene* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	ChessScene* _tmp188_ = NULL;
	ChessScene* _tmp189_ = NULL;
	GList* _tmp190_ = NULL;
	self = (ChessView2D*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = c;
	chess_view2_d_load_theme (self, _tmp0_);
	_tmp1_ = c;
	_tmp2_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp3_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_translate (_tmp1_, (gdouble) (_tmp2_ / 2), (gdouble) (_tmp3_ / 2));
	_tmp4_ = c;
	_tmp5_ = chess_view_get_scene ((ChessView*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = chess_scene_get_board_angle (_tmp6_);
	_tmp8_ = _tmp7_;
	cairo_rotate (_tmp4_, (G_PI * _tmp8_) / 180.0);
	_tmp9_ = self->priv->square_size;
	_tmp10_ = chess_view2_d_get_border_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = ceil ((_tmp9_ * 4) + _tmp11_);
	board_size = (gint) _tmp12_;
	_tmp13_ = c;
	cairo_set_source_rgb (_tmp13_, 0x2e / 255.0, 0x34 / 255.0, 0x36 / 255.0);
	_tmp14_ = c;
	_tmp15_ = board_size;
	_tmp16_ = board_size;
	_tmp17_ = board_size;
	_tmp18_ = board_size;
	cairo_rectangle (_tmp14_, (gdouble) (-_tmp15_), (gdouble) (-_tmp16_), (gdouble) (_tmp17_ * 2), (gdouble) (_tmp18_ * 2));
	_tmp19_ = c;
	cairo_fill (_tmp19_);
	{
		gint file = 0;
		file = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_ = FALSE;
				gint _tmp23_ = 0;
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = file;
					file = _tmp22_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp23_ = file;
				if (!(_tmp23_ < 8)) {
					break;
				}
				{
					gint rank = 0;
					rank = 0;
					{
						gboolean _tmp24_ = FALSE;
						_tmp24_ = TRUE;
						while (TRUE) {
							gboolean _tmp25_ = FALSE;
							gint _tmp27_ = 0;
							gint x = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint y = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							cairo_t* _tmp32_ = NULL;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							cairo_t* _tmp41_ = NULL;
							_tmp25_ = _tmp24_;
							if (!_tmp25_) {
								gint _tmp26_ = 0;
								_tmp26_ = rank;
								rank = _tmp26_ + 1;
							}
							_tmp24_ = FALSE;
							_tmp27_ = rank;
							if (!(_tmp27_ < 8)) {
								break;
							}
							_tmp28_ = file;
							_tmp29_ = self->priv->square_size;
							x = (gint) ((_tmp28_ - 4) * _tmp29_);
							_tmp30_ = rank;
							_tmp31_ = self->priv->square_size;
							y = (gint) ((3 - _tmp30_) * _tmp31_);
							_tmp32_ = c;
							_tmp33_ = x;
							_tmp34_ = y;
							_tmp35_ = self->priv->square_size;
							_tmp36_ = self->priv->square_size;
							cairo_rectangle (_tmp32_, (gdouble) _tmp33_, (gdouble) _tmp34_, (gdouble) _tmp35_, (gdouble) _tmp36_);
							_tmp37_ = file;
							_tmp38_ = rank;
							if (((_tmp37_ + _tmp38_) % 2) == 0) {
								cairo_t* _tmp39_ = NULL;
								_tmp39_ = c;
								cairo_set_source_rgb (_tmp39_, 0xba / 255.0, 0xbd / 255.0, 0xb6 / 255.0);
							} else {
								cairo_t* _tmp40_ = NULL;
								_tmp40_ = c;
								cairo_set_source_rgb (_tmp40_, 0xee / 255.0, 0xee / 255.0, 0xec / 255.0);
							}
							_tmp41_ = c;
							cairo_fill (_tmp41_);
						}
					}
				}
			}
		}
	}
	_tmp42_ = chess_view_get_scene ((ChessView*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = chess_scene_get_show_numbering (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_) {
		cairo_t* _tmp46_ = NULL;
		cairo_t* _tmp47_ = NULL;
		gdouble _tmp48_ = 0.0;
		gdouble _tmp49_ = 0.0;
		cairo_t* _tmp50_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp51_ = NULL;
		cairo_text_extents_t _tmp52_ = {0};
		gdouble y_offset = 0.0;
		gint _tmp53_ = 0;
		cairo_text_extents_t _tmp54_ = {0};
		gdouble _tmp55_ = 0.0;
		cairo_text_extents_t _tmp56_ = {0};
		gdouble _tmp57_ = 0.0;
		cairo_text_extents_t _tmp58_ = {0};
		gdouble _tmp59_ = 0.0;
		gdouble top = 0.0;
		gint _tmp60_ = 0;
		gdouble _tmp61_ = 0.0;
		gdouble bottom = 0.0;
		gint _tmp62_ = 0;
		gdouble _tmp63_ = 0.0;
		gdouble _tmp64_ = 0.0;
		gdouble _tmp65_ = 0.0;
		gdouble file_offset = 0.0;
		gint _tmp66_ = 0;
		gdouble rank_offset = 0.0;
		gint _tmp67_ = 0;
		gchar** files = NULL;
		gint files_length1 = 0;
		gint _files_size_ = 0;
		gchar** ranks = NULL;
		gint ranks_length1 = 0;
		gint _ranks_size_ = 0;
		cairo_matrix_t matrix = {0};
		cairo_t* _tmp68_ = NULL;
		cairo_matrix_t _tmp69_ = {0};
		ChessScene* _tmp70_ = NULL;
		ChessScene* _tmp71_ = NULL;
		gdouble _tmp72_ = 0.0;
		gdouble _tmp73_ = 0.0;
		cairo_t* _tmp110_ = NULL;
		cairo_t* _tmp111_ = NULL;
		cairo_matrix_t _tmp112_ = {0};
		cairo_t* _tmp187_ = NULL;
		_tmp46_ = c;
		cairo_set_source_rgb (_tmp46_, 0x88 / 255.0, 0x8a / 255.0, 0x85 / 255.0);
		_tmp47_ = c;
		_tmp48_ = chess_view2_d_get_border_size (self);
		_tmp49_ = _tmp48_;
		cairo_set_font_size (_tmp47_, _tmp49_ * 0.6);
		_tmp50_ = c;
		cairo_select_font_face (_tmp50_, "sans-serif", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp51_ = c;
		cairo_text_extents (_tmp51_, "abcdefgh", &_tmp52_);
		extents = _tmp52_;
		_tmp53_ = self->priv->square_size;
		_tmp54_ = extents;
		_tmp55_ = _tmp54_.height;
		_tmp56_ = extents;
		_tmp57_ = _tmp56_.height;
		_tmp58_ = extents;
		_tmp59_ = _tmp58_.y_bearing;
		y_offset = ((((_tmp53_ / 2) - _tmp55_) / 2) + _tmp57_) + _tmp59_;
		_tmp60_ = self->priv->square_size;
		_tmp61_ = y_offset;
		top = -((_tmp60_ * 4) + _tmp61_);
		_tmp62_ = self->priv->square_size;
		_tmp63_ = chess_view2_d_get_border_size (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = y_offset;
		bottom = ((_tmp62_ * 4) + _tmp64_) - _tmp65_;
		_tmp66_ = self->priv->square_size;
		file_offset = -(_tmp66_ * 3.5);
		_tmp67_ = self->priv->square_size;
		rank_offset = -(_tmp67_ * 3.5);
		_tmp68_ = c;
		cairo_get_matrix (_tmp68_, &_tmp69_);
		matrix = _tmp69_;
		_tmp70_ = chess_view_get_scene ((ChessView*) self);
		_tmp71_ = _tmp70_;
		_tmp72_ = chess_scene_get_board_angle (_tmp71_);
		_tmp73_ = _tmp72_;
		if (_tmp73_ == 180.0) {
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_ = NULL;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			gchar** _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
			gchar** _tmp91_ = NULL;
			_tmp74_ = g_strdup ("h");
			_tmp75_ = g_strdup ("g");
			_tmp76_ = g_strdup ("f");
			_tmp77_ = g_strdup ("e");
			_tmp78_ = g_strdup ("d");
			_tmp79_ = g_strdup ("c");
			_tmp80_ = g_strdup ("b");
			_tmp81_ = g_strdup ("a");
			_tmp82_ = g_new0 (gchar*, 8 + 1);
			_tmp82_[0] = _tmp74_;
			_tmp82_[1] = _tmp75_;
			_tmp82_[2] = _tmp76_;
			_tmp82_[3] = _tmp77_;
			_tmp82_[4] = _tmp78_;
			_tmp82_[5] = _tmp79_;
			_tmp82_[6] = _tmp80_;
			_tmp82_[7] = _tmp81_;
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
			files = _tmp82_;
			files_length1 = 8;
			_files_size_ = files_length1;
			_tmp83_ = g_strdup ("1");
			_tmp84_ = g_strdup ("2");
			_tmp85_ = g_strdup ("3");
			_tmp86_ = g_strdup ("4");
			_tmp87_ = g_strdup ("5");
			_tmp88_ = g_strdup ("6");
			_tmp89_ = g_strdup ("7");
			_tmp90_ = g_strdup ("8");
			_tmp91_ = g_new0 (gchar*, 8 + 1);
			_tmp91_[0] = _tmp83_;
			_tmp91_[1] = _tmp84_;
			_tmp91_[2] = _tmp85_;
			_tmp91_[3] = _tmp86_;
			_tmp91_[4] = _tmp87_;
			_tmp91_[5] = _tmp88_;
			_tmp91_[6] = _tmp89_;
			_tmp91_[7] = _tmp90_;
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
			ranks = _tmp91_;
			ranks_length1 = 8;
			_ranks_size_ = ranks_length1;
			cairo_matrix_scale (&matrix, (gdouble) (-1), (gdouble) (-1));
		} else {
			gchar* _tmp92_ = NULL;
			gchar* _tmp93_ = NULL;
			gchar* _tmp94_ = NULL;
			gchar* _tmp95_ = NULL;
			gchar* _tmp96_ = NULL;
			gchar* _tmp97_ = NULL;
			gchar* _tmp98_ = NULL;
			gchar* _tmp99_ = NULL;
			gchar** _tmp100_ = NULL;
			gchar* _tmp101_ = NULL;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			gchar* _tmp106_ = NULL;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gchar** _tmp109_ = NULL;
			_tmp92_ = g_strdup ("a");
			_tmp93_ = g_strdup ("b");
			_tmp94_ = g_strdup ("c");
			_tmp95_ = g_strdup ("d");
			_tmp96_ = g_strdup ("e");
			_tmp97_ = g_strdup ("f");
			_tmp98_ = g_strdup ("g");
			_tmp99_ = g_strdup ("h");
			_tmp100_ = g_new0 (gchar*, 8 + 1);
			_tmp100_[0] = _tmp92_;
			_tmp100_[1] = _tmp93_;
			_tmp100_[2] = _tmp94_;
			_tmp100_[3] = _tmp95_;
			_tmp100_[4] = _tmp96_;
			_tmp100_[5] = _tmp97_;
			_tmp100_[6] = _tmp98_;
			_tmp100_[7] = _tmp99_;
			files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
			files = _tmp100_;
			files_length1 = 8;
			_files_size_ = files_length1;
			_tmp101_ = g_strdup ("8");
			_tmp102_ = g_strdup ("7");
			_tmp103_ = g_strdup ("6");
			_tmp104_ = g_strdup ("5");
			_tmp105_ = g_strdup ("4");
			_tmp106_ = g_strdup ("3");
			_tmp107_ = g_strdup ("2");
			_tmp108_ = g_strdup ("1");
			_tmp109_ = g_new0 (gchar*, 8 + 1);
			_tmp109_[0] = _tmp101_;
			_tmp109_[1] = _tmp102_;
			_tmp109_[2] = _tmp103_;
			_tmp109_[3] = _tmp104_;
			_tmp109_[4] = _tmp105_;
			_tmp109_[5] = _tmp106_;
			_tmp109_[6] = _tmp107_;
			_tmp109_[7] = _tmp108_;
			ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
			ranks = _tmp109_;
			ranks_length1 = 8;
			_ranks_size_ = ranks_length1;
		}
		_tmp110_ = c;
		cairo_save (_tmp110_);
		_tmp111_ = c;
		_tmp112_ = matrix;
		cairo_set_matrix (_tmp111_, &_tmp112_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp113_ = FALSE;
				_tmp113_ = TRUE;
				while (TRUE) {
					gboolean _tmp114_ = FALSE;
					gint _tmp116_ = 0;
					cairo_t* _tmp117_ = NULL;
					gchar** _tmp118_ = NULL;
					gint _tmp118__length1 = 0;
					gint _tmp119_ = 0;
					const gchar* _tmp120_ = NULL;
					cairo_text_extents_t _tmp121_ = {0};
					cairo_t* _tmp122_ = NULL;
					cairo_t* _tmp123_ = NULL;
					gdouble _tmp124_ = 0.0;
					cairo_text_extents_t _tmp125_ = {0};
					gdouble _tmp126_ = 0.0;
					gdouble _tmp127_ = 0.0;
					cairo_t* _tmp128_ = NULL;
					gchar** _tmp129_ = NULL;
					gint _tmp129__length1 = 0;
					gint _tmp130_ = 0;
					const gchar* _tmp131_ = NULL;
					cairo_t* _tmp132_ = NULL;
					cairo_t* _tmp133_ = NULL;
					cairo_t* _tmp134_ = NULL;
					gdouble _tmp135_ = 0.0;
					cairo_text_extents_t _tmp136_ = {0};
					gdouble _tmp137_ = 0.0;
					gdouble _tmp138_ = 0.0;
					cairo_t* _tmp139_ = NULL;
					gchar** _tmp140_ = NULL;
					gint _tmp140__length1 = 0;
					gint _tmp141_ = 0;
					const gchar* _tmp142_ = NULL;
					cairo_t* _tmp143_ = NULL;
					cairo_t* _tmp144_ = NULL;
					gchar** _tmp145_ = NULL;
					gint _tmp145__length1 = 0;
					gint _tmp146_ = 0;
					const gchar* _tmp147_ = NULL;
					cairo_text_extents_t _tmp148_ = {0};
					cairo_text_extents_t _tmp149_ = {0};
					gdouble _tmp150_ = 0.0;
					cairo_text_extents_t _tmp151_ = {0};
					gdouble _tmp152_ = 0.0;
					cairo_t* _tmp153_ = NULL;
					cairo_t* _tmp154_ = NULL;
					gint _tmp155_ = 0;
					gdouble _tmp156_ = 0.0;
					gdouble _tmp157_ = 0.0;
					gdouble _tmp158_ = 0.0;
					gdouble _tmp159_ = 0.0;
					cairo_text_extents_t _tmp160_ = {0};
					gdouble _tmp161_ = 0.0;
					gdouble _tmp162_ = 0.0;
					gdouble _tmp163_ = 0.0;
					cairo_t* _tmp164_ = NULL;
					gchar** _tmp165_ = NULL;
					gint _tmp165__length1 = 0;
					gint _tmp166_ = 0;
					const gchar* _tmp167_ = NULL;
					cairo_t* _tmp168_ = NULL;
					cairo_t* _tmp169_ = NULL;
					cairo_t* _tmp170_ = NULL;
					gint _tmp171_ = 0;
					gdouble _tmp172_ = 0.0;
					gdouble _tmp173_ = 0.0;
					cairo_text_extents_t _tmp174_ = {0};
					gdouble _tmp175_ = 0.0;
					gdouble _tmp176_ = 0.0;
					gdouble _tmp177_ = 0.0;
					cairo_t* _tmp178_ = NULL;
					gchar** _tmp179_ = NULL;
					gint _tmp179__length1 = 0;
					gint _tmp180_ = 0;
					const gchar* _tmp181_ = NULL;
					cairo_t* _tmp182_ = NULL;
					gdouble _tmp183_ = 0.0;
					gint _tmp184_ = 0;
					gdouble _tmp185_ = 0.0;
					gint _tmp186_ = 0;
					_tmp114_ = _tmp113_;
					if (!_tmp114_) {
						gint _tmp115_ = 0;
						_tmp115_ = i;
						i = _tmp115_ + 1;
					}
					_tmp113_ = FALSE;
					_tmp116_ = i;
					if (!(_tmp116_ < 8)) {
						break;
					}
					_tmp117_ = c;
					_tmp118_ = ranks;
					_tmp118__length1 = ranks_length1;
					_tmp119_ = i;
					_tmp120_ = _tmp118_[_tmp119_];
					cairo_text_extents (_tmp117_, _tmp120_, &_tmp121_);
					extents = _tmp121_;
					_tmp122_ = c;
					cairo_save (_tmp122_);
					_tmp123_ = c;
					_tmp124_ = file_offset;
					_tmp125_ = extents;
					_tmp126_ = _tmp125_.width;
					_tmp127_ = top;
					cairo_move_to (_tmp123_, _tmp124_ - (_tmp126_ / 2), _tmp127_);
					_tmp128_ = c;
					_tmp129_ = files;
					_tmp129__length1 = files_length1;
					_tmp130_ = i;
					_tmp131_ = _tmp129_[_tmp130_];
					cairo_show_text (_tmp128_, _tmp131_);
					_tmp132_ = c;
					cairo_restore (_tmp132_);
					_tmp133_ = c;
					cairo_save (_tmp133_);
					_tmp134_ = c;
					_tmp135_ = file_offset;
					_tmp136_ = extents;
					_tmp137_ = _tmp136_.width;
					_tmp138_ = bottom;
					cairo_move_to (_tmp134_, _tmp135_ - (_tmp137_ / 2), _tmp138_);
					_tmp139_ = c;
					_tmp140_ = files;
					_tmp140__length1 = files_length1;
					_tmp141_ = i;
					_tmp142_ = _tmp140_[_tmp141_];
					cairo_show_text (_tmp139_, _tmp142_);
					_tmp143_ = c;
					cairo_restore (_tmp143_);
					_tmp144_ = c;
					_tmp145_ = ranks;
					_tmp145__length1 = ranks_length1;
					_tmp146_ = i;
					_tmp147_ = _tmp145_[_tmp146_];
					cairo_text_extents (_tmp144_, _tmp147_, &_tmp148_);
					extents = _tmp148_;
					_tmp149_ = extents;
					_tmp150_ = _tmp149_.y_bearing;
					_tmp151_ = extents;
					_tmp152_ = _tmp151_.height;
					y_offset = -(_tmp150_ + (_tmp152_ / 2));
					_tmp153_ = c;
					cairo_save (_tmp153_);
					_tmp154_ = c;
					_tmp155_ = self->priv->square_size;
					_tmp156_ = chess_view2_d_get_border_size (self);
					_tmp157_ = _tmp156_;
					_tmp158_ = chess_view2_d_get_border_size (self);
					_tmp159_ = _tmp158_;
					_tmp160_ = extents;
					_tmp161_ = _tmp160_.width;
					_tmp162_ = rank_offset;
					_tmp163_ = y_offset;
					cairo_move_to (_tmp154_, -(((((gdouble) _tmp155_) * 4) + _tmp157_) - ((_tmp159_ - _tmp161_) / 2)), _tmp162_ + _tmp163_);
					_tmp164_ = c;
					_tmp165_ = ranks;
					_tmp165__length1 = ranks_length1;
					_tmp166_ = i;
					_tmp167_ = _tmp165_[_tmp166_];
					cairo_show_text (_tmp164_, _tmp167_);
					_tmp168_ = c;
					cairo_restore (_tmp168_);
					_tmp169_ = c;
					cairo_save (_tmp169_);
					_tmp170_ = c;
					_tmp171_ = self->priv->square_size;
					_tmp172_ = chess_view2_d_get_border_size (self);
					_tmp173_ = _tmp172_;
					_tmp174_ = extents;
					_tmp175_ = _tmp174_.width;
					_tmp176_ = rank_offset;
					_tmp177_ = y_offset;
					cairo_move_to (_tmp170_, (((gdouble) _tmp171_) * 4) + ((_tmp173_ - _tmp175_) / 2), _tmp176_ + _tmp177_);
					_tmp178_ = c;
					_tmp179_ = ranks;
					_tmp179__length1 = ranks_length1;
					_tmp180_ = i;
					_tmp181_ = _tmp179_[_tmp180_];
					cairo_show_text (_tmp178_, _tmp181_);
					_tmp182_ = c;
					cairo_restore (_tmp182_);
					_tmp183_ = file_offset;
					_tmp184_ = self->priv->square_size;
					file_offset = _tmp183_ + _tmp184_;
					_tmp185_ = rank_offset;
					_tmp186_ = self->priv->square_size;
					rank_offset = _tmp185_ + _tmp186_;
				}
			}
		}
		_tmp187_ = c;
		cairo_restore (_tmp187_);
		ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp188_ = chess_view_get_scene ((ChessView*) self);
	_tmp189_ = _tmp188_;
	_tmp190_ = _tmp189_->pieces;
	{
		GList* model_collection = NULL;
		GList* model_it = NULL;
		model_collection = _tmp190_;
		for (model_it = model_collection; model_it != NULL; model_it = model_it->next) {
			ChessModel* _tmp191_ = NULL;
			ChessModel* model = NULL;
			_tmp191_ = _chess_model_ref0 ((ChessModel*) model_it->data);
			model = _tmp191_;
			{
				cairo_t* _tmp192_ = NULL;
				cairo_t* _tmp193_ = NULL;
				ChessModel* _tmp194_ = NULL;
				gdouble _tmp195_ = 0.0;
				gint _tmp196_ = 0;
				ChessModel* _tmp197_ = NULL;
				gdouble _tmp198_ = 0.0;
				gint _tmp199_ = 0;
				cairo_t* _tmp200_ = NULL;
				gint _tmp201_ = 0;
				gint _tmp202_ = 0;
				cairo_t* _tmp203_ = NULL;
				ChessScene* _tmp204_ = NULL;
				ChessScene* _tmp205_ = NULL;
				gdouble _tmp206_ = 0.0;
				gdouble _tmp207_ = 0.0;
				cairo_surface_t* _tmp208_ = NULL;
				ChessModel* _tmp209_ = NULL;
				gboolean _tmp210_ = FALSE;
				gint _tmp213_ = 0;
				ChessModel* _tmp214_ = NULL;
				gboolean _tmp215_ = FALSE;
				gdouble _tmp218_ = 0.0;
				gboolean _tmp219_ = FALSE;
				ChessModel* _tmp220_ = NULL;
				gboolean _tmp221_ = FALSE;
				gboolean _tmp226_ = FALSE;
				cairo_t* _tmp227_ = NULL;
				cairo_surface_t* _tmp228_ = NULL;
				gint _tmp229_ = 0;
				ChessModel* _tmp230_ = NULL;
				ChessPiece* _tmp231_ = NULL;
				gdouble _tmp232_ = 0.0;
				cairo_t* _tmp233_ = NULL;
				_tmp192_ = c;
				cairo_save (_tmp192_);
				_tmp193_ = c;
				_tmp194_ = model;
				_tmp195_ = _tmp194_->x;
				_tmp196_ = self->priv->square_size;
				_tmp197_ = model;
				_tmp198_ = _tmp197_->y;
				_tmp199_ = self->priv->square_size;
				cairo_translate (_tmp193_, (_tmp195_ - 4) * _tmp196_, (3 - _tmp198_) * _tmp199_);
				_tmp200_ = c;
				_tmp201_ = self->priv->square_size;
				_tmp202_ = self->priv->square_size;
				cairo_translate (_tmp200_, (gdouble) (_tmp201_ / 2), (gdouble) (_tmp202_ / 2));
				_tmp203_ = c;
				_tmp204_ = chess_view_get_scene ((ChessView*) self);
				_tmp205_ = _tmp204_;
				_tmp206_ = chess_scene_get_board_angle (_tmp205_);
				_tmp207_ = _tmp206_;
				cairo_rotate (_tmp203_, ((-G_PI) * _tmp207_) / 180.0);
				_tmp209_ = model;
				_tmp210_ = _tmp209_->is_selected;
				if (_tmp210_) {
					cairo_surface_t* _tmp211_ = NULL;
					_tmp211_ = self->priv->selected_model_surface;
					_tmp208_ = _tmp211_;
				} else {
					cairo_surface_t* _tmp212_ = NULL;
					_tmp212_ = self->priv->model_surface;
					_tmp208_ = _tmp212_;
				}
				_tmp214_ = model;
				_tmp215_ = _tmp214_->is_selected;
				if (_tmp215_) {
					gint _tmp216_ = 0;
					_tmp216_ = self->priv->selected_square_size;
					_tmp213_ = _tmp216_;
				} else {
					gint _tmp217_ = 0;
					_tmp217_ = self->priv->square_size;
					_tmp213_ = _tmp217_;
				}
				_tmp220_ = model;
				_tmp221_ = _tmp220_->under_threat;
				if (_tmp221_) {
					ChessScene* _tmp222_ = NULL;
					ChessScene* _tmp223_ = NULL;
					gboolean _tmp224_ = FALSE;
					gboolean _tmp225_ = FALSE;
					_tmp222_ = chess_view_get_scene ((ChessView*) self);
					_tmp223_ = _tmp222_;
					_tmp224_ = chess_scene_get_show_move_hints (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp219_ = _tmp225_;
				} else {
					_tmp219_ = FALSE;
				}
				_tmp226_ = _tmp219_;
				if (_tmp226_) {
					_tmp218_ = 0.8;
				} else {
					_tmp218_ = 1.0;
				}
				_tmp227_ = c;
				_tmp228_ = _tmp208_;
				_tmp229_ = _tmp213_;
				_tmp230_ = model;
				_tmp231_ = _tmp230_->piece;
				_tmp232_ = _tmp218_;
				chess_view2_d_draw_piece (self, _tmp227_, _tmp228_, _tmp229_, _tmp231_, _tmp232_);
				_tmp233_ = c;
				cairo_restore (_tmp233_);
				_chess_model_unref0 (model);
			}
		}
	}
	{
		gint rank = 0;
		rank = 0;
		{
			gboolean _tmp234_ = FALSE;
			_tmp234_ = TRUE;
			while (TRUE) {
				gboolean _tmp235_ = FALSE;
				gint _tmp237_ = 0;
				_tmp235_ = _tmp234_;
				if (!_tmp235_) {
					gint _tmp236_ = 0;
					_tmp236_ = rank;
					rank = _tmp236_ + 1;
				}
				_tmp234_ = FALSE;
				_tmp237_ = rank;
				if (!(_tmp237_ < 8)) {
					break;
				}
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp238_ = FALSE;
						_tmp238_ = TRUE;
						while (TRUE) {
							gboolean _tmp239_ = FALSE;
							gint _tmp241_ = 0;
							gboolean _tmp242_ = FALSE;
							ChessScene* _tmp243_ = NULL;
							ChessScene* _tmp244_ = NULL;
							gboolean _tmp245_ = FALSE;
							gboolean _tmp246_ = FALSE;
							gboolean _tmp252_ = FALSE;
							_tmp239_ = _tmp238_;
							if (!_tmp239_) {
								gint _tmp240_ = 0;
								_tmp240_ = file;
								file = _tmp240_ + 1;
							}
							_tmp238_ = FALSE;
							_tmp241_ = file;
							if (!(_tmp241_ < 8)) {
								break;
							}
							_tmp243_ = chess_view_get_scene ((ChessView*) self);
							_tmp244_ = _tmp243_;
							_tmp245_ = chess_scene_get_show_move_hints (_tmp244_);
							_tmp246_ = _tmp245_;
							if (_tmp246_) {
								ChessScene* _tmp247_ = NULL;
								ChessScene* _tmp248_ = NULL;
								gint _tmp249_ = 0;
								gint _tmp250_ = 0;
								gboolean _tmp251_ = FALSE;
								_tmp247_ = chess_view_get_scene ((ChessView*) self);
								_tmp248_ = _tmp247_;
								_tmp249_ = rank;
								_tmp250_ = file;
								_tmp251_ = chess_scene_can_move (_tmp248_, _tmp249_, _tmp250_);
								_tmp242_ = _tmp251_;
							} else {
								_tmp242_ = FALSE;
							}
							_tmp252_ = _tmp242_;
							if (_tmp252_) {
								cairo_t* _tmp253_ = NULL;
								cairo_t* _tmp254_ = NULL;
								gint _tmp255_ = 0;
								gint _tmp256_ = 0;
								gint _tmp257_ = 0;
								gint _tmp258_ = 0;
								cairo_t* _tmp259_ = NULL;
								gint _tmp260_ = 0;
								gint _tmp261_ = 0;
								cairo_t* _tmp262_ = NULL;
								ChessScene* _tmp263_ = NULL;
								ChessScene* _tmp264_ = NULL;
								gdouble _tmp265_ = 0.0;
								gdouble _tmp266_ = 0.0;
								cairo_t* _tmp267_ = NULL;
								cairo_surface_t* _tmp268_ = NULL;
								gint _tmp269_ = 0;
								ChessScene* _tmp270_ = NULL;
								ChessScene* _tmp271_ = NULL;
								ChessPiece* _tmp272_ = NULL;
								ChessPiece* _tmp273_ = NULL;
								cairo_t* _tmp274_ = NULL;
								_tmp253_ = c;
								cairo_save (_tmp253_);
								_tmp254_ = c;
								_tmp255_ = file;
								_tmp256_ = self->priv->square_size;
								_tmp257_ = rank;
								_tmp258_ = self->priv->square_size;
								cairo_translate (_tmp254_, (gdouble) ((_tmp255_ - 4) * _tmp256_), (gdouble) ((3 - _tmp257_) * _tmp258_));
								_tmp259_ = c;
								_tmp260_ = self->priv->square_size;
								_tmp261_ = self->priv->square_size;
								cairo_translate (_tmp259_, (gdouble) (_tmp260_ / 2), (gdouble) (_tmp261_ / 2));
								_tmp262_ = c;
								_tmp263_ = chess_view_get_scene ((ChessView*) self);
								_tmp264_ = _tmp263_;
								_tmp265_ = chess_scene_get_board_angle (_tmp264_);
								_tmp266_ = _tmp265_;
								cairo_rotate (_tmp262_, ((-G_PI) * _tmp266_) / 180.0);
								_tmp267_ = c;
								_tmp268_ = self->priv->model_surface;
								_tmp269_ = self->priv->square_size;
								_tmp270_ = chess_view_get_scene ((ChessView*) self);
								_tmp271_ = _tmp270_;
								_tmp272_ = chess_scene_get_selected_piece (_tmp271_);
								_tmp273_ = _tmp272_;
								chess_view2_d_draw_piece (self, _tmp267_, _tmp268_, _tmp269_, _tmp273_, 0.1);
								_chess_piece_unref0 (_tmp273_);
								_tmp274_ = c;
								cairo_restore (_tmp274_);
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void chess_view2_d_draw_piece (ChessView2D* self, cairo_t* c, cairo_surface_t* surface, gint size, ChessPiece* piece, gdouble alpha) {
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_ = NULL;
	ChessScene* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp8_ = FALSE;
	cairo_t* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint offset = 0;
	ChessPiece* _tmp13_ = NULL;
	PieceType _tmp14_ = 0;
	ChessPiece* _tmp15_ = NULL;
	Color _tmp16_ = 0;
	Color _tmp17_ = 0;
	cairo_t* _tmp19_ = NULL;
	cairo_surface_t* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	cairo_t* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (piece != NULL);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_board_side (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "facetoface") == 0) {
		ChessPiece* _tmp5_ = NULL;
		Color _tmp6_ = 0;
		Color _tmp7_ = 0;
		_tmp5_ = piece;
		_tmp6_ = chess_piece_get_color (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ == COLOR_BLACK;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		cairo_t* _tmp9_ = NULL;
		_tmp9_ = c;
		cairo_rotate (_tmp9_, G_PI);
	}
	_tmp10_ = c;
	_tmp11_ = size;
	_tmp12_ = size;
	cairo_translate (_tmp10_, (gdouble) ((-_tmp11_) / 2), (gdouble) ((-_tmp12_) / 2));
	_tmp13_ = piece;
	_tmp14_ = _tmp13_->type;
	offset = (gint) _tmp14_;
	_tmp15_ = piece;
	_tmp16_ = chess_piece_get_color (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == COLOR_BLACK) {
		gint _tmp18_ = 0;
		_tmp18_ = offset;
		offset = _tmp18_ + 6;
	}
	_tmp19_ = c;
	_tmp20_ = surface;
	_tmp21_ = offset;
	_tmp22_ = size;
	cairo_set_source_surface (_tmp19_, _tmp20_, (gdouble) ((-_tmp21_) * _tmp22_), (gdouble) 0);
	_tmp23_ = c;
	_tmp24_ = size;
	_tmp25_ = size;
	cairo_rectangle (_tmp23_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp24_, (gdouble) _tmp25_);
	_tmp26_ = c;
	cairo_clip (_tmp26_);
	_tmp27_ = c;
	_tmp28_ = alpha;
	cairo_paint_with_alpha (_tmp27_, _tmp28_);
}


static gboolean chess_view2_d_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	ChessView2D * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessScene* _tmp1_ = NULL;
	ChessScene* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	gboolean _tmp7_ = FALSE;
	gint file = 0;
	GdkEventButton _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	gint rank = 0;
	GdkEventButton _tmp14_ = {0};
	gdouble _tmp15_ = 0.0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gdouble _tmp19_ = 0.0;
	ChessScene* _tmp20_ = NULL;
	ChessScene* _tmp21_ = NULL;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_ = 0;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ChessScene* _tmp36_ = NULL;
	ChessScene* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	self = (ChessView2D*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = chess_view_get_scene ((ChessView*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = chess_scene_get_game (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp5_ = {0};
		guint _tmp6_ = 0U;
		_tmp5_ = *event;
		_tmp6_ = _tmp5_.button;
		_tmp0_ = _tmp6_ != ((guint) 1);
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = *event;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp11_ = self->priv->square_size;
	_tmp12_ = self->priv->square_size;
	_tmp13_ = floor (((_tmp9_ - (0.5 * _tmp10_)) + (_tmp11_ * 4)) / _tmp12_);
	file = (gint) _tmp13_;
	_tmp14_ = *event;
	_tmp15_ = _tmp14_.y;
	_tmp16_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp17_ = self->priv->square_size;
	_tmp18_ = self->priv->square_size;
	_tmp19_ = floor (((_tmp15_ - (0.5 * _tmp16_)) + (_tmp17_ * 4)) / _tmp18_);
	rank = 7 - ((gint) _tmp19_);
	_tmp20_ = chess_view_get_scene ((ChessView*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = chess_scene_get_board_angle (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == 180.0) {
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		_tmp24_ = rank;
		rank = 7 - _tmp24_;
		_tmp25_ = file;
		file = 7 - _tmp25_;
	}
	_tmp29_ = file;
	if (_tmp29_ < 0) {
		_tmp28_ = TRUE;
	} else {
		gint _tmp30_ = 0;
		_tmp30_ = file;
		_tmp28_ = _tmp30_ >= 8;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		_tmp27_ = TRUE;
	} else {
		gint _tmp32_ = 0;
		_tmp32_ = rank;
		_tmp27_ = _tmp32_ < 0;
	}
	_tmp33_ = _tmp27_;
	if (_tmp33_) {
		_tmp26_ = TRUE;
	} else {
		gint _tmp34_ = 0;
		_tmp34_ = rank;
		_tmp26_ = _tmp34_ >= 8;
	}
	_tmp35_ = _tmp26_;
	if (_tmp35_) {
		result = FALSE;
		return result;
	}
	_tmp36_ = chess_view_get_scene ((ChessView*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = file;
	_tmp39_ = rank;
	chess_scene_select_square (_tmp37_, _tmp38_, _tmp39_);
	result = TRUE;
	return result;
}


static gdouble chess_view2_d_get_border_size (ChessView2D* self) {
	gdouble result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->square_size;
	result = (gdouble) (_tmp0_ / 2);
	return result;
}


static void chess_view2_d_class_init (ChessView2DClass * klass) {
	chess_view2_d_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessView2DPrivate));
	GTK_WIDGET_CLASS (klass)->configure_event = chess_view2_d_real_configure_event;
	GTK_WIDGET_CLASS (klass)->draw = chess_view2_d_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = chess_view2_d_real_button_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_view2_d_get_property;
	G_OBJECT_CLASS (klass)->finalize = chess_view2_d_finalize;
}


static void chess_view2_d_instance_init (ChessView2D * self) {
	gchar* _tmp0_ = NULL;
	self->priv = CHESS_VIEW2_D_GET_PRIVATE (self);
	self->priv->border = 6;
	_tmp0_ = g_strdup ("");
	self->priv->loaded_theme_name = _tmp0_;
}


static void chess_view2_d_finalize (GObject* obj) {
	ChessView2D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_VIEW2_D, ChessView2D);
	_cairo_surface_destroy0 (self->priv->model_surface);
	_cairo_surface_destroy0 (self->priv->selected_model_surface);
	_g_free0 (self->priv->loaded_theme_name);
	G_OBJECT_CLASS (chess_view2_d_parent_class)->finalize (obj);
}


GType chess_view2_d_get_type (void) {
	static volatile gsize chess_view2_d_type_id__volatile = 0;
	if (g_once_init_enter (&chess_view2_d_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessView2DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_view2_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessView2D), 0, (GInstanceInitFunc) chess_view2_d_instance_init, NULL };
		GType chess_view2_d_type_id;
		chess_view2_d_type_id = g_type_register_static (TYPE_CHESS_VIEW, "ChessView2D", &g_define_type_info, 0);
		g_once_init_leave (&chess_view2_d_type_id__volatile, chess_view2_d_type_id);
	}
	return chess_view2_d_type_id__volatile;
}


static void _vala_chess_view2_d_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessView2D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_VIEW2_D, ChessView2D);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



