/* chess-engine.c generated by valac 0.23.1.16-ce7f, the Vala compiler
 * generated from chess-engine.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include "sys/prctl.h"
#include "linux/prctl.h"
#include <signal.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
	gchar* binary;
	gchar* args;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*undo) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	guint stdout_watch_id;
	gboolean started;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY
};
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
gboolean chess_engine_start (ChessEngine* self);
static void ___lambda2_ (ChessEngine* self);
static void ____lambda2__gspawn_child_setup_func (gpointer self);
static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status);
static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
static void chess_engine_real_undo (ChessEngine* self);
void chess_engine_stop (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
ChessEngine* chess_engine_new (void);
ChessEngine* chess_engine_construct (GType object_type);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject* obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
}


static void ___lambda2_ (ChessEngine* self) {
	prctl (PR_SET_PDEATHSIG, SIGTERM);
}


static void ____lambda2__gspawn_child_setup_func (gpointer self) {
	___lambda2_ ((ChessEngine*) self);
}


static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
	chess_engine_engine_stopped_cb ((ChessEngine*) self, pid, status);
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb ((ChessEngine*) self, source, condition);
	return result;
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	gchar** argv = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gint stdout_fd = 0;
	GPid _tmp13_ = 0;
	gint _tmp14_ = 0;
	GIOChannel* _tmp15_ = NULL;
	GIOChannel* _tmp20_ = NULL;
	GIOChannel* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->binary;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = self->args;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = g_new0 (gchar*, 3 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp3_;
	_tmp4_[2] = NULL;
	argv = _tmp4_;
	argv_length1 = 3;
	_argv_size_ = argv_length1;
	{
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		GPid _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp5_ = argv;
		_tmp5__length1 = argv_length1;
		g_spawn_async_with_pipes (NULL, _tmp5_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, ____lambda2__gspawn_child_setup_func, self, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_inner_error_);
		self->priv->pid = _tmp6_;
		self->priv->stdin_fd = _tmp7_;
		stdout_fd = _tmp8_;
		self->priv->stderr_fd = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch13_g_spawn_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally13;
	__catch13_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = stderr;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		fprintf (_tmp10_, "Failed to execute chess engine: %s\n", _tmp12_);
		result = FALSE;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp13_ = self->priv->pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, _chess_engine_engine_stopped_cb_gchild_watch_func, g_object_ref (self), g_object_unref);
	_tmp14_ = stdout_fd;
	_tmp15_ = g_io_channel_unix_new (_tmp14_);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = _tmp15_;
	{
		GIOChannel* _tmp16_ = NULL;
		_tmp16_ = self->priv->stdout_channel;
		g_io_channel_set_flags (_tmp16_, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch14_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally14;
	__catch14_g_io_channel_error:
	{
		GError* e = NULL;
		FILE* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stderr;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "Failed to set input from chess engine to non-blocking: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp20_ = self->priv->stdout_channel;
	g_io_channel_set_close_on_unref (_tmp20_, TRUE);
	_tmp21_ = self->priv->stdout_channel;
	_tmp22_ = g_io_add_watch (_tmp21_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
	self->priv->stdout_watch_id = _tmp22_;
	self->priv->started = TRUE;
	g_signal_emit_by_name (self, "starting");
	result = TRUE;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status) {
	GPid _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = pid;
	g_spawn_close_pid (_tmp0_);
	g_signal_emit_by_name (self, "stopped");
}


static void chess_engine_real_start_game (ChessEngine* self) {
}


void chess_engine_start_game (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
}


static void chess_engine_real_request_move (ChessEngine* self) {
}


void chess_engine_request_move (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
	g_return_if_fail (move != NULL);
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
}


static void chess_engine_real_undo (ChessEngine* self) {
}


void chess_engine_undo (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->undo (self);
}


void chess_engine_stop (ChessEngine* self) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GPid _tmp13_ = 0;
	gint _tmp14_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->started;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->stdout_watch_id;
	g_source_remove (_tmp1_);
	{
		GIOChannel* _tmp2_ = NULL;
		_tmp2_ = self->priv->stdout_channel;
		g_io_channel_shutdown (_tmp2_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch15_g_io_channel_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally15;
	__catch15_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("chess-engine.vala:111: Failed to close channel to engine's stdout: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = self->priv->stdin_fd;
	_tmp6_ = close (_tmp5_);
	if (_tmp6_ == (-1)) {
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = errno;
		_tmp8_ = g_strerror (_tmp7_);
		g_warning ("chess-engine.vala:115: Failed to close pipe to engine's stdin: %s", _tmp8_);
	}
	_tmp9_ = self->priv->stderr_fd;
	_tmp10_ = close (_tmp9_);
	if (_tmp10_ == (-1)) {
		gint _tmp11_ = 0;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = errno;
		_tmp12_ = g_strerror (_tmp11_);
		g_warning ("chess-engine.vala:119: Failed to close pipe to engine's stderr: %s", _tmp12_);
	}
	_tmp13_ = self->priv->pid;
	_tmp14_ = kill ((pid_t) _tmp13_, SIGTERM);
	if (_tmp14_ == (-1)) {
		gint _tmp15_ = 0;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = errno;
		_tmp16_ = g_strerror (_tmp15_);
		g_warning ("chess-engine.vala:123: Failed to kill engine: %s", _tmp16_);
	}
	self->priv->started = FALSE;
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp0_ = NULL;
	GIOStatus _tmp6_ = 0;
	GIOStatus _tmp8_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_new0 (gchar, 1024);
	buf = (g_free (buf), NULL);
	buf = _tmp0_;
	buf_length1 = 1024;
	_buf_size_ = buf_length1;
	{
		GIOStatus _tmp1_ = 0;
		GIOChannel* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gsize _tmp4_ = 0UL;
		GIOStatus _tmp5_ = 0;
		_tmp2_ = source;
		_tmp3_ = buf;
		_tmp3__length1 = buf_length1;
		_tmp5_ = g_io_channel_read_chars (_tmp2_, _tmp3_, _tmp3__length1, &_tmp4_, &_inner_error_);
		n_read = _tmp4_;
		_tmp1_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch16_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch16_g_io_channel_error;
			}
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		status = _tmp1_;
	}
	goto __finally16;
	__catch16_g_convert_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	goto __finally16;
	__catch16_g_io_channel_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		buf = (g_free (buf), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = status;
	if (_tmp6_ == G_IO_STATUS_EOF) {
		FILE* _tmp7_ = NULL;
		_tmp7_ = stdout;
		fprintf (_tmp7_, "EOF\n");
		result = FALSE;
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp8_ = status;
	if (_tmp8_ == G_IO_STATUS_NORMAL) {
		gsize _tmp9_ = 0UL;
		gint _tmp10_ = 0;
		gchar* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		_tmp9_ = n_read;
		_tmp10_ = (gint) _tmp9_;
		buf = g_renew (gchar, buf, (gint) _tmp9_);
		(_tmp10_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp10_ - buf_length1)) : NULL;
		buf_length1 = _tmp10_;
		_buf_size_ = _tmp10_;
		_tmp11_ = buf;
		_tmp11__length1 = buf_length1;
		chess_engine_process_input (self, _tmp11_, _tmp11__length1);
	}
	result = TRUE;
	buf = (g_free (buf), NULL);
	return result;
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset = 0UL;
	gsize n_written = 0UL;
	g_return_if_fail (self != NULL);
	offset = (gsize) 0;
	while (TRUE) {
		gsize _tmp0_ = 0UL;
		gchar* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		gchar* d = NULL;
		gchar* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gsize _tmp3_ = 0UL;
		gchar* _tmp4_ = NULL;
		gint d_length1 = 0;
		gint _d_size_ = 0;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gchar* _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gssize _tmp21_ = 0L;
		gsize _tmp22_ = 0UL;
		gsize _tmp23_ = 0UL;
		gsize _tmp24_ = 0UL;
		_tmp0_ = offset;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		if (!(_tmp0_ < ((gsize) _tmp1__length1))) {
			break;
		}
		_tmp2_ = data;
		_tmp2__length1 = data_length1;
		_tmp3_ = offset;
		_tmp4_ = g_new0 (gchar, _tmp2__length1 - _tmp3_);
		d = _tmp4_;
		d_length1 = _tmp2__length1 - _tmp3_;
		_d_size_ = d_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gboolean _tmp6_ = FALSE;
					gint _tmp8_ = 0;
					gchar* _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gsize _tmp10_ = 0UL;
					gchar* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					gsize _tmp14_ = 0UL;
					gint _tmp15_ = 0;
					gchar _tmp16_ = '\0';
					gchar _tmp17_ = '\0';
					_tmp6_ = _tmp5_;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp8_ = i;
					_tmp9_ = data;
					_tmp9__length1 = data_length1;
					_tmp10_ = offset;
					if (!(((gsize) _tmp8_) < (_tmp9__length1 - _tmp10_))) {
						break;
					}
					_tmp11_ = d;
					_tmp11__length1 = d_length1;
					_tmp12_ = i;
					_tmp13_ = data;
					_tmp13__length1 = data_length1;
					_tmp14_ = offset;
					_tmp15_ = i;
					_tmp16_ = _tmp13_[_tmp14_ + _tmp15_];
					_tmp11_[_tmp12_] = _tmp16_;
					_tmp17_ = _tmp11_[_tmp12_];
				}
			}
		}
		_tmp18_ = self->priv->stdin_fd;
		_tmp19_ = d;
		_tmp19__length1 = d_length1;
		_tmp20_ = d;
		_tmp20__length1 = d_length1;
		_tmp21_ = write (_tmp18_, _tmp19_, (gsize) _tmp20__length1);
		n_written = (gsize) _tmp21_;
		_tmp22_ = n_written;
		if (_tmp22_ < ((gsize) 0)) {
			d = (g_free (d), NULL);
			return;
		}
		_tmp23_ = offset;
		_tmp24_ = n_written;
		offset = _tmp23_ + _tmp24_;
		d = (g_free (d), NULL);
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	gchar* l = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* d = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gint d_length1 = 0;
	gint _d_size_ = 0;
	gchar* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = g_strconcat (_tmp0_, "\n", NULL);
	l = _tmp1_;
	_tmp2_ = line;
	g_debug ("chess-engine.vala:188: Writing line to engine: '%s'", _tmp2_);
	_tmp3_ = l;
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
	d = _tmp5_;
	d_length1 = _tmp4_;
	_d_size_ = d_length1;
	_tmp6_ = d;
	_tmp6__length1 = d_length1;
	if (_tmp6_ != NULL) {
		gchar* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		_tmp7_ = d;
		_tmp7__length1 = d_length1;
		chess_engine_write (self, _tmp7_, _tmp7__length1);
	}
	d = (g_free (d), NULL);
	_g_free0 (l);
}


ChessEngine* chess_engine_construct (GType object_type) {
	ChessEngine * self = NULL;
	self = (ChessEngine*) g_object_new (object_type, NULL);
	return self;
}


ChessEngine* chess_engine_new (void) {
	return chess_engine_construct (TYPE_CHESS_ENGINE);
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ready;
	result = _tmp0_;
	return result;
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ready = _tmp0_;
	g_signal_emit_by_name (self, "ready-changed");
	g_object_notify ((GObject *) self, "ready");
}


static void chess_engine_class_init (ChessEngineClass * klass) {
	chess_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
	CHESS_ENGINE_CLASS (klass)->process_input = chess_engine_real_process_input;
	CHESS_ENGINE_CLASS (klass)->start_game = chess_engine_real_start_game;
	CHESS_ENGINE_CLASS (klass)->request_move = chess_engine_real_request_move;
	CHESS_ENGINE_CLASS (klass)->report_move = chess_engine_real_report_move;
	CHESS_ENGINE_CLASS (klass)->undo = chess_engine_real_undo;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("ready_changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("stopped", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_engine_instance_init (ChessEngine * self) {
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->_ready = FALSE;
}


static void chess_engine_finalize (GObject* obj) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE, ChessEngine);
	_g_free0 (self->binary);
	_g_free0 (self->args);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, 0);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		g_value_set_boolean (value, chess_engine_get_ready (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		chess_engine_set_ready (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



