/* gnome-chess.c generated by valac 0.29.3.11-7fa8, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libchess.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <cairo.h>
#include <librsvg/rsvg.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <locale.h>


#define TYPE_CHESS_APPLICATION (chess_application_get_type ())
#define CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_APPLICATION, ChessApplication))
#define CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_APPLICATION, ChessApplicationClass))
#define IS_CHESS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_APPLICATION))
#define IS_CHESS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_APPLICATION))
#define CHESS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_APPLICATION, ChessApplicationClass))

typedef struct _ChessApplication ChessApplication;
typedef struct _ChessApplicationClass ChessApplicationClass;
typedef struct _ChessApplicationPrivate ChessApplicationPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;

#define CHESS_APPLICATION_TYPE_PROMOTION_TYPE_SELECTED (chess_application_promotion_type_selected_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _ChessScenePrivate ChessScenePrivate;

#define TYPE_CHESS_MODEL (chess_model_get_type ())
#define CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MODEL, ChessModel))
#define CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MODEL, ChessModelClass))
#define IS_CHESS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MODEL))
#define IS_CHESS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MODEL))
#define CHESS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MODEL, ChessModelClass))

typedef struct _ChessModel ChessModel;
typedef struct _ChessModelClass ChessModelClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ChessApplication {
	GtkApplication parent_instance;
	ChessApplicationPrivate * priv;
};

struct _ChessApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ChessApplicationPrivate {
	gboolean is_tiled;
	gboolean is_maximized;
	gint window_width;
	gint window_height;
	GSettings* settings;
	GtkApplicationWindow* window;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkButton* pause_resume_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkWidget* timer_increment_label;
	GtkHeaderBar* headerbar;
	GtkDialog* preferences_dialog;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* duration_combo;
	GtkComboBox* clock_type_combo;
	GtkAdjustment* duration_adjustment;
	GtkAdjustment* timer_increment_adjustment;
	GtkBox* custom_duration_box;
	GtkBox* timer_increment_box;
	GtkComboBox* timer_increment_units_combo;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gboolean allow_claim_draw_dialog;
	gboolean starting;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
	gint engine_timeout_counter;
};

typedef enum  {
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK,
	CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP
} ChessApplicationPromotionTypeSelected;

struct _Block1Data {
	int _ref_count_;
	ChessApplication* self;
	gchar* move;
};

struct _Block2Data {
	int _ref_count_;
	ChessApplication* self;
	ChessGame* original_game;
};

struct _ChessScene {
	GObject parent_instance;
	ChessScenePrivate * priv;
	GList* pieces;
	gboolean animating;
	gint selected_rank;
	gint selected_file;
};

struct _ChessSceneClass {
	GObjectClass parent_class;
};


static gpointer chess_application_parent_class = NULL;

GType chess_application_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_APPLICATION, ChessApplicationPrivate))
enum  {
	CHESS_APPLICATION_DUMMY_PROPERTY
};
static GType chess_application_promotion_type_selected_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void chess_application_preferences_cb (ChessApplication* self);
static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_help_cb (ChessApplication* self);
static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_about_cb (ChessApplication* self);
static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_quit_cb (ChessApplication* self);
static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
#define CHESS_APPLICATION_NEW_GAME_ACTION_NAME "new"
#define CHESS_APPLICATION_OPEN_GAME_ACTION_NAME "open"
#define CHESS_APPLICATION_SAVE_GAME_ACTION_NAME "save"
#define CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME "save-as"
#define CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME "undo"
#define CHESS_APPLICATION_RESIGN_ACTION_NAME "resign"
#define CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME "pause-resume"
void chess_application_new_game_cb (ChessApplication* self);
static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_open_game_cb (ChessApplication* self);
static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_cb (ChessApplication* self);
static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_save_game_as_cb (ChessApplication* self);
static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_undo_move_cb (ChessApplication* self);
static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_resign_cb (ChessApplication* self);
static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void chess_application_pause_resume_cb (ChessApplication* self);
static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static ChessApplication* chess_application_new (void);
static ChessApplication* chess_application_construct (GType object_type);
static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options);
static void chess_application_run_no_engine_dialog (ChessApplication* self);
static void chess_application_real_startup (GApplication* base);
static void chess_application_size_allocate_cb (ChessApplication* self, GtkAllocation* allocation);
static void _chess_application_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean chess_application_window_state_event_cb (ChessApplication* self, GdkEventWindowState* event);
static gboolean _chess_application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void chess_application_update_pause_resume_button (ChessApplication* self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static gboolean __lambda10_ (ChessApplication* self, ChessPlayer* p);
static gboolean ___lambda10__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self);
static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene);
static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
PieceType* chess_application_show_promotion_type_selector (ChessApplication* self);
static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self);
ChessView* chess_view_new (void);
ChessView* chess_view_construct (GType object_type);
void chess_view_set_scene (ChessView* self, ChessScene* value);
GList* ai_profile_load_ai_profiles (const gchar* filename);
const gchar* ai_profile_get_name (AIProfile* self);
const gchar* ai_profile_get_path (AIProfile* self);
static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
static void chess_application_real_activate (GApplication* base);
static void chess_application_start_new_game (ChessApplication* self);
static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error);
static void chess_application_real_shutdown (GApplication* base);
void chess_engine_stop (ChessEngine* self, gboolean kill_engine);
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename);
static PieceType* _piece_type_dup (PieceType* self);
void chess_application_quit_game (ChessApplication* self);
static gboolean chess_application_save_duration_cb (ChessApplication* self);
static void chess_application_autosave (ChessApplication* self);
static void chess_application_update_pgn_time_remaining (ChessApplication* self);
static void chess_application_update_history_panel (ChessApplication* self);
gint chess_scene_get_move_number (ChessScene* self);
static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move);
static void chess_application_start_game (ChessApplication* self);
static void chess_application_run_invalid_move_dialog (ChessApplication* self, const gchar* error_message);
static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player);
static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move);
static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game);
static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void chess_application_game_end_cb (ChessApplication* self);
static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock);
static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move);
static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self);
static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender, gpointer self);
static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self);
static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self);
static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine);
static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self);
static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty);
gboolean chess_engine_start (ChessEngine* self);
static void chess_application_disable_window_action (ChessApplication* self, const gchar* name);
static void chess_application_enable_window_action (ChessApplication* self, const gchar* name);
void chess_engine_start_game (ChessEngine* self);
static void chess_application_update_action_status (ChessApplication* self);
static void chess_application_update_headerbar_title (ChessApplication* self);
void chess_engine_move (ChessEngine* self);
gchar** ai_profile_get_easy_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar** ai_profile_get_easy_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** ai_profile_get_easy_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** ai_profile_get_hard_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar** ai_profile_get_hard_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
gchar** ai_profile_get_hard_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
gchar** ai_profile_get_normal_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar** ai_profile_get_normal_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gchar** ai_profile_get_normal_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
const gchar* ai_profile_get_protocol (AIProfile* self);
const gchar* ai_profile_get_binary (AIProfile* self);
guint ai_profile_get_delay_seconds (AIProfile* self);
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
gboolean chess_engine_get_ready (ChessEngine* self);
static void chess_application_do_engine_move (ChessApplication* self, const gchar* move);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda7_ (Block1Data* _data1_);
static gboolean ____lambda7__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block2Data* _data2_);
static gboolean ___lambda8__gsource_func (gpointer self);
static void chess_application_check_engine_timeout (ChessApplication* self);
static void chess_application_present_claim_draw_dialog (ChessApplication* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text);
static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label);
GType chess_model_get_type (void) G_GNUC_CONST;
gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color);
gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self);
static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c);
void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self);
void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, ChessApplication* self);
static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify);
static void chess_application_set_clock_type (ChessApplication* self, gint clock_type);
static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment);
static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index);
void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gint chess_application_get_duration (ChessApplication* self);
void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self);
static void chess_application_save_duration (ChessApplication* self);
void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, ChessApplication* self);
static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self);
void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self);
gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self);
void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self);
static void chess_application_about_response_cb (ChessApplication* self, gint response_id);
static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void chess_application_run_invalid_pgn_dialog (ChessApplication* self);
static void chess_application_add_info_bar_to_dialog (ChessApplication* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label);
static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id);
static void __lambda6_ (ChessApplication* self);
static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void __lambda9_ (ChessApplication* self);
static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id);
static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gint chess_application_main (gchar** args, int args_length1);
static void chess_application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CHESS_APPLICATION_app_entries[4] = {{"preferences", _chess_application_preferences_cb_gsimple_action_activate_callback}, {"help", _chess_application_help_cb_gsimple_action_activate_callback}, {"about", _chess_application_about_cb_gsimple_action_activate_callback}, {"quit", _chess_application_quit_cb_gsimple_action_activate_callback}};
static const GActionEntry CHESS_APPLICATION_window_entries[7] = {{CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _chess_application_new_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _chess_application_open_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _chess_application_save_game_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _chess_application_save_game_as_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _chess_application_undo_move_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_RESIGN_ACTION_NAME, _chess_application_resign_cb_gsimple_action_activate_callback}, {CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _chess_application_pause_resume_cb_gsimple_action_activate_callback}};
static const GOptionEntry CHESS_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};
static const gchar* CHESS_APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* CHESS_APPLICATION_artists[3] = {"Max Froumentin (pieces)", "Jakub Steiner (icon)", NULL};

static GType chess_application_promotion_type_selected_get_type (void) {
	static volatile gsize chess_application_promotion_type_selected_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_promotion_type_selected_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN", "queen"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT", "knight"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK", "rook"}, {CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP, "CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP", "bishop"}, {0, NULL, NULL}};
		GType chess_application_promotion_type_selected_type_id;
		chess_application_promotion_type_selected_type_id = g_enum_register_static ("ChessApplicationPromotionTypeSelected", values);
		g_once_init_leave (&chess_application_promotion_type_selected_type_id__volatile, chess_application_promotion_type_selected_type_id);
	}
	return chess_application_promotion_type_selected_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 462 "gnome-chess.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_list_free (self);
#line 471 "gnome-chess.c"
}


static void _chess_application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_preferences_cb ((ChessApplication*) self);
#line 478 "gnome-chess.c"
}


static void _chess_application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_help_cb ((ChessApplication*) self);
#line 485 "gnome-chess.c"
}


static void _chess_application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_about_cb ((ChessApplication*) self);
#line 492 "gnome-chess.c"
}


static void _chess_application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_cb ((ChessApplication*) self);
#line 499 "gnome-chess.c"
}


static void _chess_application_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_new_game_cb ((ChessApplication*) self);
#line 506 "gnome-chess.c"
}


static void _chess_application_open_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_open_game_cb ((ChessApplication*) self);
#line 513 "gnome-chess.c"
}


static void _chess_application_save_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_game_cb ((ChessApplication*) self);
#line 520 "gnome-chess.c"
}


static void _chess_application_save_game_as_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_game_as_cb ((ChessApplication*) self);
#line 527 "gnome-chess.c"
}


static void _chess_application_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_undo_move_cb ((ChessApplication*) self);
#line 534 "gnome-chess.c"
}


static void _chess_application_resign_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_resign_cb ((ChessApplication*) self);
#line 541 "gnome-chess.c"
}


static void _chess_application_pause_resume_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_pause_resume_cb ((ChessApplication*) self);
#line 548 "gnome-chess.c"
}


static ChessApplication* chess_application_construct (GType object_type) {
	ChessApplication * self = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) g_object_new (object_type, "application-id", "org.gnome.chess", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_application_add_main_option_entries ((GApplication*) self, CHESS_APPLICATION_option_entries);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return self;
#line 560 "gnome-chess.c"
}


static ChessApplication* chess_application_new (void) {
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return chess_application_construct (TYPE_CHESS_APPLICATION);
#line 567 "gnome-chess.c"
}


static gint chess_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	ChessApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = options;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 586 "gnome-chess.c"
		FILE* _tmp2_ = NULL;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = stderr;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		fprintf (_tmp2_, "gnome-chess %s\n", VERSION);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = EXIT_SUCCESS;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 596 "gnome-chess.c"
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = -1;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 602 "gnome-chess.c"
}


static void chess_application_run_no_engine_dialog (ChessApplication* self) {
	GtkMessageDialog* no_engine_dialog = NULL;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _ ("No chess engine is installed. You will not be able to play against the" \
" computer.");
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, _tmp1_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	no_engine_dialog = _tmp2_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _ ("_OK");
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) no_engine_dialog, _tmp3_, (gint) GTK_RESPONSE_OK);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) no_engine_dialog);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) no_engine_dialog);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (no_engine_dialog);
#line 634 "gnome-chess.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return self ? g_object_ref (self) : NULL;
#line 641 "gnome-chess.c"
}


static void _chess_application_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_size_allocate_cb ((ChessApplication*) self, allocation);
#line 648 "gnome-chess.c"
}


static gboolean _chess_application_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = chess_application_window_state_event_cb ((ChessApplication*) self, event);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 657 "gnome-chess.c"
}


static gboolean __lambda10_ (ChessApplication* self, ChessPlayer* p) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (p != NULL, FALSE);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = p;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->human_player;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = _tmp0_ == _tmp1_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 675 "gnome-chess.c"
}


static gboolean ___lambda10__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self) {
	gboolean result;
	result = __lambda10_ ((ChessApplication*) self, player);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 684 "gnome-chess.c"
}


static void _chess_application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_scene_changed_cb ((ChessApplication*) self, _sender);
#line 691 "gnome-chess.c"
}


static PieceType* _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self) {
	PieceType* result;
	result = chess_application_show_promotion_type_selector ((ChessApplication*) self);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 700 "gnome-chess.c"
}


static void chess_application_real_startup (GApplication* base) {
	ChessApplication * self;
	GSettings* _tmp0_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	GtkApplicationWindow* _tmp4_ = NULL;
	GtkApplicationWindow* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GSettings* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GSettings* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkApplicationWindow* _tmp13_ = NULL;
	GtkApplicationWindow* _tmp14_ = NULL;
	GtkBuilder* _tmp15_ = NULL;
	GObject* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GtkWidget* _tmp20_ = NULL;
	GtkBuilder* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GtkWidget* _tmp23_ = NULL;
	GtkBuilder* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkWidget* _tmp26_ = NULL;
	GtkBuilder* _tmp27_ = NULL;
	GObject* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	GtkBuilder* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	GtkComboBox* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkWidget* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkWidget* _tmp38_ = NULL;
	GtkBuilder* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkContainer* _tmp41_ = NULL;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkHeaderBar* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GtkApplicationWindow* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar** _tmp48_ = NULL;
	gchar** _tmp49_ = NULL;
	gint _tmp49__length1 = 0;
	gchar* _tmp50_ = NULL;
	gchar** _tmp51_ = NULL;
	gchar** _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	gchar* _tmp53_ = NULL;
	gchar** _tmp54_ = NULL;
	gchar** _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	gchar* _tmp56_ = NULL;
	gchar** _tmp57_ = NULL;
	gchar** _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	gchar* _tmp59_ = NULL;
	gchar** _tmp60_ = NULL;
	gchar** _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	gchar* _tmp62_ = NULL;
	gchar** _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gint _tmp64__length1 = 0;
	GtkApplicationWindow* _tmp65_ = NULL;
	ChessScene* _tmp66_ = NULL;
	ChessScene* _tmp67_ = NULL;
	ChessScene* _tmp68_ = NULL;
	ChessScene* _tmp69_ = NULL;
	GSettings* _tmp70_ = NULL;
	ChessScene* _tmp71_ = NULL;
	GSettings* _tmp72_ = NULL;
	ChessScene* _tmp73_ = NULL;
	GSettings* _tmp74_ = NULL;
	ChessScene* _tmp75_ = NULL;
	GSettings* _tmp76_ = NULL;
	ChessScene* _tmp77_ = NULL;
	GSettings* _tmp78_ = NULL;
	ChessScene* _tmp79_ = NULL;
	ChessView* _tmp80_ = NULL;
	ChessView* _tmp81_ = NULL;
	ChessView* _tmp82_ = NULL;
	ChessScene* _tmp83_ = NULL;
	GtkContainer* _tmp84_ = NULL;
	ChessView* _tmp85_ = NULL;
	ChessView* _tmp86_ = NULL;
	gchar* system_engine_cfg = NULL;
	gchar* _tmp87_ = NULL;
	gchar* user_engine_cfg = NULL;
	const gchar* _tmp88_ = NULL;
	gchar* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	GList* _tmp98_ = NULL;
	GList* _tmp99_ = NULL;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (chess_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_settings_new ("org.gnome.chess");
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->settings = _tmp0_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_action_map_add_action_entries ((GActionMap*) self, CHESS_APPLICATION_app_entries, G_N_ELEMENTS (CHESS_APPLICATION_app_entries), self);
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/gnome-chess.ui");
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	builder = _tmp1_;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = builder;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = gtk_builder_get_object (_tmp2_, "gnome_chess_app");
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->window = _tmp4_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->settings;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = g_settings_get_int (_tmp6_, "width");
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->settings;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = g_settings_get_int (_tmp8_, "height");
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp5_, _tmp7_, _tmp9_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->settings;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_settings_get_boolean (_tmp10_, "maximized");
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_) {
#line 852 "gnome-chess.c"
		GtkApplicationWindow* _tmp12_ = NULL;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->window;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_maximize ((GtkWindow*) _tmp12_);
#line 858 "gnome-chess.c"
	}
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->window;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkWidget*) _tmp13_, "size-allocate", (GCallback) _chess_application_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->window;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkWidget*) _tmp14_, "window-state-event", (GCallback) _chess_application_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = builder;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = gtk_builder_get_object (_tmp15_, "pause_button");
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_button_get_type (), GtkButton));
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_resume_button);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->pause_resume_button = _tmp17_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = builder;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = gtk_builder_get_object (_tmp18_, "first_move_button");
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->first_move_button = _tmp20_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = builder;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "prev_move_button");
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->prev_move_button = _tmp23_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = builder;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = gtk_builder_get_object (_tmp24_, "next_move_button");
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->next_move_button = _tmp26_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = builder;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_builder_get_object (_tmp27_, "last_move_button");
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->last_move_button = _tmp29_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = builder;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "history_combo");
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_combo_box_get_type (), GtkComboBox));
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->history_combo = _tmp32_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = builder;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "white_time_label");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget));
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->white_time_label = _tmp35_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = builder;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "black_time_label");
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->black_time_label = _tmp38_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = builder;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "view_container");
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_container_get_type (), GtkContainer));
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->view_container = _tmp41_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = builder;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "headerbar");
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->headerbar = _tmp44_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = builder;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp45_, self);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = self->priv->window;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_action_map_add_action_entries ((GActionMap*) _tmp46_, CHESS_APPLICATION_window_entries, G_N_ELEMENTS (CHESS_APPLICATION_window_entries), self);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = g_strdup ("<Primary>N");
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = g_new0 (gchar*, 1 + 1);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_[0] = _tmp47_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = _tmp48_;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49__length1 = 1;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_NEW_GAME_ACTION_NAME, _tmp49_);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = g_strdup ("<Primary>O");
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = g_new0 (gchar*, 1 + 1);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp51_[0] = _tmp50_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = _tmp51_;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp52__length1 = 1;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_OPEN_GAME_ACTION_NAME, _tmp52_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = g_strdup ("<Primary>S");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = g_new0 (gchar*, 1 + 1);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_[0] = _tmp53_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = _tmp54_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55__length1 = 1;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_ACTION_NAME, _tmp55_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = g_strdup ("<Shift><Primary>S");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = g_new0 (gchar*, 1 + 1);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp57_[0] = _tmp56_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = _tmp57_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58__length1 = 1;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME, _tmp58_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = g_strdup ("<Primary>Z");
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = g_new0 (gchar*, 1 + 1);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_[0] = _tmp59_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = _tmp60_;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61__length1 = 1;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME, _tmp61_);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = g_strdup ("Pause");
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = g_new0 (gchar*, 1 + 1);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp63_[0] = _tmp62_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = _tmp63_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp64__length1 = 1;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win." CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME, _tmp64_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = self->priv->window;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp65_);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = chess_scene_new ();
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->scene = _tmp66_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = self->priv->scene;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp67_, "is-human", (GCallback) ___lambda10__chess_scene_is_human, self, 0);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = self->priv->scene;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp68_, "changed", (GCallback) _chess_application_scene_changed_cb_chess_scene_changed, self, 0);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = self->priv->scene;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp69_, "choose-promotion-type", (GCallback) _chess_application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = self->priv->settings;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = self->priv->scene;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp70_, "show-move-hints", (GObject*) _tmp71_, "show-move-hints", G_SETTINGS_BIND_GET);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = self->priv->settings;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = self->priv->scene;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp72_, "show-numbering", (GObject*) _tmp73_, "show-numbering", G_SETTINGS_BIND_GET);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = self->priv->settings;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = self->priv->scene;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp74_, "piece-theme", (GObject*) _tmp75_, "theme-name", G_SETTINGS_BIND_GET);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = self->priv->settings;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = self->priv->scene;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp76_, "move-format", (GObject*) _tmp77_, "move-format", G_SETTINGS_BIND_GET);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = self->priv->settings;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = self->priv->scene;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp78_, "board-side", (GObject*) _tmp79_, "board-side", G_SETTINGS_BIND_GET);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = chess_view_new ();
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp80_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->view = _tmp80_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = self->priv->view;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp81_, 400, 400);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = self->priv->view;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = self->priv->scene;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_view_set_scene (_tmp82_, _tmp83_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = self->priv->view_container;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = self->priv->view;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (_tmp84_, (GtkWidget*) _tmp85_);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->view;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp86_);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = g_build_filename (SYSCONFDIR, "gnome-chess", "engines.conf", NULL, NULL);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	system_engine_cfg = _tmp87_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = g_get_user_config_dir ();
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = g_build_filename (_tmp88_, "gnome-chess", "engines.conf", NULL, NULL);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	user_engine_cfg = _tmp89_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = user_engine_cfg;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = g_file_test (_tmp90_, G_FILE_TEST_EXISTS);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp91_) {
#line 1158 "gnome-chess.c"
		const gchar* _tmp92_ = NULL;
		GList* _tmp93_ = NULL;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp92_ = user_engine_cfg;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp93_ = ai_profile_load_ai_profiles (_tmp92_);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->ai_profiles = _tmp93_;
#line 1169 "gnome-chess.c"
	} else {
		const gchar* _tmp94_ = NULL;
		gboolean _tmp95_ = FALSE;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp94_ = system_engine_cfg;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp95_ = g_file_test (_tmp94_, G_FILE_TEST_EXISTS);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp95_) {
#line 1179 "gnome-chess.c"
			const gchar* _tmp96_ = NULL;
			GList* _tmp97_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp96_ = system_engine_cfg;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp97_ = ai_profile_load_ai_profiles (_tmp96_);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->ai_profiles = _tmp97_;
#line 1190 "gnome-chess.c"
		} else {
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:201: engines.conf not found");
#line 1194 "gnome-chess.c"
		}
	}
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = self->priv->ai_profiles;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp98_ == NULL) {
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_run_no_engine_dialog (self);
#line 1203 "gnome-chess.c"
	}
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = self->priv->ai_profiles;
#line 1207 "gnome-chess.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		profile_collection = _tmp99_;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 1215 "gnome-chess.c"
			AIProfile* _tmp100_ = NULL;
			AIProfile* profile = NULL;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp100_ = _g_object_ref0 ((AIProfile*) profile_it->data);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			profile = _tmp100_;
#line 1222 "gnome-chess.c"
			{
				AIProfile* _tmp101_ = NULL;
				const gchar* _tmp102_ = NULL;
				const gchar* _tmp103_ = NULL;
				AIProfile* _tmp104_ = NULL;
				const gchar* _tmp105_ = NULL;
				const gchar* _tmp106_ = NULL;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp101_ = profile;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp102_ = ai_profile_get_name (_tmp101_);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp103_ = _tmp102_;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp104_ = profile;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp105_ = ai_profile_get_path (_tmp104_);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp106_ = _tmp105_;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				g_debug ("gnome-chess.vala:207: Detected AI profile %s in %s", _tmp103_, _tmp106_);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (profile);
#line 1246 "gnome-chess.c"
			}
		}
	}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (user_engine_cfg);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (system_engine_cfg);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (builder);
#line 1256 "gnome-chess.c"
}


static void chess_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	ChessApplication * self;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GFile** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (hint != NULL);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = files;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0__length1 = files_length1;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0__length1 != 1) {
#line 1278 "gnome-chess.c"
		const gchar* _tmp1_ = NULL;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _ ("GNOME Chess can only open one PGN at a time.");
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:215: %s", _tmp1_);
#line 1284 "gnome-chess.c"
	}
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = files;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2__length1 = files_length1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_[0];
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = _tmp4_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_application_activate ((GApplication*) self);
#line 1300 "gnome-chess.c"
}


static void chess_application_real_activate (GApplication* base) {
	ChessApplication * self;
	GtkApplicationWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkApplicationWindow* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1321 "gnome-chess.c"
		GFile* data_dir = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_ = NULL;
		GFile* _tmp21_ = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_get_user_data_dir ();
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = g_build_filename (_tmp3_, "gnome-chess", NULL, NULL);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = g_file_new_for_path (_tmp5_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp5_);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		data_dir = _tmp7_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = data_dir;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_mkdir_with_parents (_tmp10_, 0755);
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp10_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = data_dir;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = g_file_get_path (_tmp11_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = g_strconcat (_tmp13_, "/autosave.pgn", NULL);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (self->priv->autosave_filename);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->autosave_filename = _tmp14_;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp13_);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game_file;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp16_ == NULL) {
#line 1380 "gnome-chess.c"
			const gchar* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = self->priv->autosave_filename;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = g_file_test (_tmp17_, G_FILE_TEST_EXISTS);
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = _tmp18_;
#line 1389 "gnome-chess.c"
		} else {
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = FALSE;
#line 1393 "gnome-chess.c"
		}
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp15_) {
#line 1397 "gnome-chess.c"
			const gchar* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = self->priv->autosave_filename;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = g_file_new_for_path (_tmp19_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp20_;
#line 1408 "gnome-chess.c"
		}
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game_file;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp21_ == NULL) {
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_start_new_game (self);
#line 1416 "gnome-chess.c"
		} else {
			{
				GFile* _tmp22_ = NULL;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp22_ = self->priv->game_file;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				chess_application_load_game (self, _tmp22_, &_inner_error_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1426 "gnome-chess.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GFile* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				GError* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				e = _inner_error_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_inner_error_ = NULL;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp23_ = self->priv->game_file;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = g_file_get_path (_tmp23_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = _tmp24_;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = e;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = _tmp26_->message;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				g_warning ("gnome-chess.vala:247: Failed to load %s: %s\n", _tmp25_, _tmp27_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (_tmp25_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				g_application_quit ((GApplication*) self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_error_free0 (e);
#line 1461 "gnome-chess.c"
			}
			__finally0:
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (data_dir);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				g_clear_error (&_inner_error_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				return;
#line 1474 "gnome-chess.c"
			}
		}
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (data_dir);
#line 1479 "gnome-chess.c"
	}
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->window;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp28_);
#line 1485 "gnome-chess.c"
}


static void chess_application_real_shutdown (GApplication* base) {
	ChessApplication * self;
	ChessEngine* _tmp0_ = NULL;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = (ChessApplication*) base;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 1504 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp1_, TRUE);
#line 1510 "gnome-chess.c"
	}
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (chess_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->settings;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window_width;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp2_, "width", _tmp3_);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->settings;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window_height;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp4_, "height", _tmp5_);
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->settings;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->is_maximized;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_boolean (_tmp6_, "maximized", _tmp7_);
#line 1532 "gnome-chess.c"
}


static void chess_application_size_allocate_cb (ChessApplication* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (allocation != NULL);
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->is_maximized;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = TRUE;
#line 1553 "gnome-chess.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->is_tiled;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp2_;
#line 1560 "gnome-chess.c"
	}
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 1566 "gnome-chess.c"
	}
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = *allocation;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_.width;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->window_width = _tmp4_;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = *allocation;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_.height;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->window_height = _tmp6_;
#line 1580 "gnome-chess.c"
}


static gboolean chess_application_window_state_event_cb (ChessApplication* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = event;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1600 "gnome-chess.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = event;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1609 "gnome-chess.c"
	}
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = event;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1617 "gnome-chess.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = event;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1626 "gnome-chess.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1632 "gnome-chess.c"
}


static PieceType* _piece_type_dup (PieceType* self) {
	PieceType* dup;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	dup = g_new0 (PieceType, 1);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (dup, self, sizeof (PieceType));
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return dup;
#line 1644 "gnome-chess.c"
}


static gpointer __piece_type_dup0 (gpointer self) {
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return self ? _piece_type_dup (self) : NULL;
#line 1651 "gnome-chess.c"
}


PieceType* chess_application_show_promotion_type_selector (ChessApplication* self) {
	PieceType* result = NULL;
	GtkBuilder* promotion_type_selector_builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkDialog* promotion_type_selector_dialog = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkApplicationWindow* _tmp5_ = NULL;
	gchar* color = NULL;
	ChessGame* _tmp6_ = NULL;
	ChessPlayer* _tmp7_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	Color _tmp9_ = 0;
	gchar* filename = NULL;
	ChessScene* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	ChessScene* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GtkBuilder* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	ChessScene* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	GtkBuilder* _tmp40_ = NULL;
	GObject* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	ChessScene* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	GtkBuilder* _tmp50_ = NULL;
	GObject* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	PieceType* selection = NULL;
	gint choice = 0;
	GtkDialog* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	GtkDialog* _tmp65_ = NULL;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/promotion-type-selector.ui");
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_builder = _tmp0_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = promotion_type_selector_builder;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_builder_get_object (_tmp1_, "dialog_promotion_type_selector");
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp2_) : NULL);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_dialog = _tmp3_;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = promotion_type_selector_dialog;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, (GtkWindow*) _tmp5_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->game;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_game_get_current_player (_tmp6_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_->color;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp9_ == COLOR_WHITE) {
#line 1749 "gnome-chess.c"
		gchar* _tmp10_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = g_strdup ("white");
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		color = _tmp10_;
#line 1757 "gnome-chess.c"
	} else {
		gchar* _tmp11_ = NULL;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = g_strdup ("black");
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		color = _tmp11_;
#line 1766 "gnome-chess.c"
	}
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->scene;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = chess_scene_get_theme_name (_tmp12_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = color;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = g_strdup_printf ("%sQueen.svg", _tmp15_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = g_build_filename (PKGDATADIR, "pieces", _tmp14_, _tmp17_, NULL);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp17_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp19_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = promotion_type_selector_builder;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_builder_get_object (_tmp20_, "image_queen");
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = filename;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_image_get_type ()) ? ((GtkImage*) _tmp21_) : NULL, _tmp22_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->scene;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = chess_scene_get_theme_name (_tmp23_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = color;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = g_strdup_printf ("%sKnight.svg", _tmp26_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _tmp27_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = g_build_filename (PKGDATADIR, "pieces", _tmp25_, _tmp28_, NULL);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp29_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp28_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = promotion_type_selector_builder;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "image_knight");
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = filename;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_image_get_type ()) ? ((GtkImage*) _tmp31_) : NULL, _tmp32_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = self->priv->scene;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = chess_scene_get_theme_name (_tmp33_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = _tmp34_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = color;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = g_strdup_printf ("%sRook.svg", _tmp36_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = g_build_filename (PKGDATADIR, "pieces", _tmp35_, _tmp38_, NULL);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp39_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp38_);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = promotion_type_selector_builder;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = gtk_builder_get_object (_tmp40_, "image_rook");
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = filename;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, gtk_image_get_type ()) ? ((GtkImage*) _tmp41_) : NULL, _tmp42_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = self->priv->scene;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = chess_scene_get_theme_name (_tmp43_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = _tmp44_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = color;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = g_strdup_printf ("%sBishop.svg", _tmp46_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = _tmp47_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = g_build_filename (PKGDATADIR, "pieces", _tmp45_, _tmp48_, NULL);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	filename = _tmp49_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp48_);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = promotion_type_selector_builder;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = gtk_builder_get_object (_tmp50_, "image_bishop");
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = filename;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, gtk_image_get_type ()) ? ((GtkImage*) _tmp51_) : NULL, _tmp52_);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = promotion_type_selector_builder;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp53_, self);
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	selection = NULL;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = promotion_type_selector_dialog;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = gtk_dialog_run (_tmp54_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	choice = _tmp55_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = choice;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp56_) {
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN:
#line 1898 "gnome-chess.c"
		{
			PieceType _tmp57_ = 0;
			PieceType* _tmp58_ = NULL;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp57_ = PIECE_TYPE_QUEEN;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp58_ = __piece_type_dup0 (&_tmp57_);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = _tmp58_;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1912 "gnome-chess.c"
		}
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT:
#line 1916 "gnome-chess.c"
		{
			PieceType _tmp59_ = 0;
			PieceType* _tmp60_ = NULL;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp59_ = PIECE_TYPE_KNIGHT;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp60_ = __piece_type_dup0 (&_tmp59_);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = _tmp60_;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1930 "gnome-chess.c"
		}
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_ROOK:
#line 1934 "gnome-chess.c"
		{
			PieceType _tmp61_ = 0;
			PieceType* _tmp62_ = NULL;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp61_ = PIECE_TYPE_ROOK;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp62_ = __piece_type_dup0 (&_tmp61_);
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = _tmp62_;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1948 "gnome-chess.c"
		}
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP:
#line 1952 "gnome-chess.c"
		{
			PieceType _tmp63_ = 0;
			PieceType* _tmp64_ = NULL;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp63_ = PIECE_TYPE_BISHOP;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp64_ = __piece_type_dup0 (&_tmp63_);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (selection);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			selection = _tmp64_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 1966 "gnome-chess.c"
		}
		default:
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		break;
#line 1971 "gnome-chess.c"
	}
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = promotion_type_selector_dialog;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp65_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = selection;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (color);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_dialog);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_builder);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1989 "gnome-chess.c"
}


static void chess_application_set_piece_image (ChessApplication* self, GtkImage* image, const gchar* filename) {
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (image != NULL);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (filename != NULL);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp0_, &_tmp1_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	width = _tmp0_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	height = _tmp1_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2016 "gnome-chess.c"
	}
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp3_ = NULL;
		RsvgHandle* _tmp4_ = NULL;
		cairo_surface_t* s = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		cairo_surface_t* _tmp7_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp10_ = 0;
		RsvgHandle* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		RsvgHandle* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		cairo_t* _tmp18_ = NULL;
		cairo_matrix_t _tmp19_ = {0};
		RsvgHandle* _tmp20_ = NULL;
		cairo_t* _tmp21_ = NULL;
		GdkPixbuf* p = NULL;
		cairo_surface_t* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GdkPixbuf* _tmp25_ = NULL;
		GtkImage* _tmp26_ = NULL;
		GdkPixbuf* _tmp27_ = NULL;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = filename;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = rsvg_handle_new_from_file (_tmp3_, &_inner_error_);
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		h = _tmp4_;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2057 "gnome-chess.c"
			goto __catch1_g_error;
		}
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = width;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = height;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp5_, _tmp6_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		s = _tmp7_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = s;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = cairo_create (_tmp8_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		c = _tmp9_;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		cairo_matrix_init_identity (&m);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = width;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = h;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_get (_tmp11_, "width", &_tmp12_, NULL);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = height;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = h;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_get (_tmp15_, "height", &_tmp16_, NULL);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		cairo_matrix_scale (&m, ((gdouble) _tmp10_) / _tmp13_, ((gdouble) _tmp14_) / _tmp17_);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = c;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = m;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		cairo_set_matrix (_tmp18_, &_tmp19_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = h;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = c;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		rsvg_handle_render_cairo (_tmp20_, _tmp21_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = s;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = width;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = height;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = gdk_pixbuf_get_from_surface (_tmp22_, 0, 0, _tmp23_, _tmp24_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		p = _tmp25_;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = image;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = p;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_image_set_from_pixbuf (_tmp26_, _tmp27_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (p);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_cairo_destroy0 (c);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_cairo_surface_destroy0 (s);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (h);
#line 2130 "gnome-chess.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp28_ = NULL;
		GError* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = filename;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = e;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_->message;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:358: Failed to load image %s: %s", _tmp28_, _tmp30_);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2155 "gnome-chess.c"
	}
	__finally1:
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2166 "gnome-chess.c"
	}
}


void chess_application_quit_game (ChessApplication* self) {
	guint _tmp0_ = 0U;
	GtkApplicationWindow* _tmp1_ = NULL;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_save_duration_cb (self);
#line 2182 "gnome-chess.c"
	}
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_autosave (self);
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 2190 "gnome-chess.c"
}


static void chess_application_autosave (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game_needs_saving;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 2203 "gnome-chess.c"
		const gchar* _tmp1_ = NULL;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->autosave_filename;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_remove (_tmp1_);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2211 "gnome-chess.c"
	}
	{
		GFile* autosave_file = NULL;
		const gchar* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		PGNGame* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->autosave_filename;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_new_for_path (_tmp2_);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		autosave_file = _tmp3_;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = autosave_file;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_debug ("gnome-chess.vala:392: Writing current game to %s", _tmp6_);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp6_);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_update_pgn_time_remaining (self);
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->pgn_game;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = autosave_file;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_write (_tmp7_, _tmp8_, &_inner_error_);
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (autosave_file);
#line 2250 "gnome-chess.c"
			goto __catch2_g_error;
		}
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (autosave_file);
#line 2255 "gnome-chess.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = e;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_->message;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:398: Failed to autosave: %s", _tmp10_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 2275 "gnome-chess.c"
	}
	__finally2:
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2286 "gnome-chess.c"
	}
}


static void chess_application_update_history_panel (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gint move_number = 0;
	ChessScene* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint n_moves = 0;
	ChessGame* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	GtkWidget* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	GtkWidget* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GtkWidget* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_ = 0;
	GtkWidget* _tmp39_ = NULL;
	GtkComboBox* _tmp40_ = NULL;
	ChessGame* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	gint i = 0;
	gint _tmp44_ = 0;
	ChessGame* _tmp45_ = NULL;
	GList* _tmp46_ = NULL;
	GtkComboBox* _tmp60_ = NULL;
	gint _tmp61_ = 0;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 2335 "gnome-chess.c"
	}
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp3_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	n_moves = (gint) _tmp6_;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = move_number;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ < 0) {
#line 2357 "gnome-chess.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = move_number;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = n_moves;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		move_number = _tmp8_ + (1 + _tmp9_);
#line 2366 "gnome-chess.c"
	}
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = n_moves;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > 0) {
#line 2372 "gnome-chess.c"
		gint _tmp13_ = 0;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = move_number;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp13_ != 0;
#line 2378 "gnome-chess.c"
	} else {
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = FALSE;
#line 2382 "gnome-chess.c"
	}
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_) {
#line 2386 "gnome-chess.c"
		ChessGame* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->game;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_game_get_is_paused (_tmp14_);
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = !_tmp16_;
#line 2398 "gnome-chess.c"
	} else {
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = FALSE;
#line 2402 "gnome-chess.c"
	}
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->first_move_button;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp17_, _tmp10_);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = move_number;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp19_ > 0) {
#line 2412 "gnome-chess.c"
		ChessGame* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->game;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_game_get_is_paused (_tmp20_);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = !_tmp22_;
#line 2424 "gnome-chess.c"
	} else {
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = FALSE;
#line 2428 "gnome-chess.c"
	}
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->prev_move_button;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp23_, _tmp18_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = move_number;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = n_moves;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp25_ < _tmp26_) {
#line 2440 "gnome-chess.c"
		ChessGame* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_ = FALSE;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = self->priv->game;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = chess_game_get_is_paused (_tmp27_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp28_;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = !_tmp29_;
#line 2452 "gnome-chess.c"
	} else {
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = FALSE;
#line 2456 "gnome-chess.c"
	}
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = self->priv->next_move_button;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp30_, _tmp24_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = n_moves;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp33_ > 0) {
#line 2466 "gnome-chess.c"
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = move_number;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = n_moves;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = _tmp34_ != _tmp35_;
#line 2475 "gnome-chess.c"
	} else {
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = FALSE;
#line 2479 "gnome-chess.c"
	}
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp32_) {
#line 2483 "gnome-chess.c"
		ChessGame* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = self->priv->game;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = chess_game_get_is_paused (_tmp36_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp37_;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = !_tmp38_;
#line 2495 "gnome-chess.c"
	} else {
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = FALSE;
#line 2499 "gnome-chess.c"
	}
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = self->priv->last_move_button;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp39_, _tmp31_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = self->priv->history_combo;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = self->priv->game;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = chess_game_get_is_paused (_tmp41_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = _tmp42_;
#line 416 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, !_tmp43_);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = n_moves;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	i = _tmp44_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = self->priv->game;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = _tmp45_->move_stack;
#line 2523 "gnome-chess.c"
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		state_collection = _tmp46_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
#line 2531 "gnome-chess.c"
			ChessState* _tmp47_ = NULL;
			ChessState* state = NULL;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = _g_object_ref0 ((ChessState*) state_it->data);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			state = _tmp47_;
#line 2538 "gnome-chess.c"
			{
				ChessState* _tmp48_ = NULL;
				ChessMove* _tmp49_ = NULL;
				gint _tmp59_ = 0;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = state;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = _tmp48_->last_move;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp49_ != NULL) {
#line 2549 "gnome-chess.c"
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp50_ = NULL;
					GtkTreeModel* _tmp51_ = NULL;
					GtkTreeModel* _tmp52_ = NULL;
					gint _tmp53_ = 0;
					GtkTreeIter _tmp54_ = {0};
					gboolean _tmp55_ = FALSE;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp50_ = self->priv->history_combo;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp51_ = gtk_combo_box_get_model (_tmp50_);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp52_ = _tmp51_;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp53_ = i;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp55_ = gtk_tree_model_iter_nth_child (_tmp52_, &_tmp54_, NULL, _tmp53_);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					iter = _tmp54_;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp55_) {
#line 2571 "gnome-chess.c"
						GtkTreeIter _tmp56_ = {0};
						ChessState* _tmp57_ = NULL;
						ChessMove* _tmp58_ = NULL;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp56_ = iter;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp57_ = state;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp58_ = _tmp57_->last_move;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						chess_application_set_move_text (self, &_tmp56_, _tmp58_);
#line 2583 "gnome-chess.c"
					}
				}
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp59_ = i;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				i = _tmp59_ - 1;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (state);
#line 2592 "gnome-chess.c"
			}
		}
	}
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = self->priv->history_combo;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = move_number;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp60_, _tmp61_);
#line 2602 "gnome-chess.c"
}


static void chess_application_scene_changed_cb (ChessApplication* self, ChessScene* scene) {
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (scene != NULL);
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 2613 "gnome-chess.c"
}


static void _chess_application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_turn_cb ((ChessApplication*) self, _sender, player);
#line 2620 "gnome-chess.c"
}


static void _chess_application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_move_cb ((ChessApplication*) self, _sender, move);
#line 2627 "gnome-chess.c"
}


static void _chess_application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_undo_cb ((ChessApplication*) self, _sender);
#line 2634 "gnome-chess.c"
}


static void _chess_application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_end_cb ((ChessApplication*) self);
#line 2641 "gnome-chess.c"
}


static void _chess_application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_game_clock_tick_cb ((ChessApplication*) self, _sender);
#line 2648 "gnome-chess.c"
}


static void _chess_application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_ready_cb ((ChessApplication*) self, _sender);
#line 2655 "gnome-chess.c"
}


static void _chess_application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_move_cb ((ChessApplication*) self, _sender, move);
#line 2662 "gnome-chess.c"
}


static void _chess_application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self) {
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_resigned_cb ((ChessApplication*) self, _sender);
#line 2669 "gnome-chess.c"
}


static void _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly (ChessEngine* _sender, gpointer self) {
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_stopped_unexpectedly_cb ((ChessApplication*) self, _sender);
#line 2676 "gnome-chess.c"
}


static void _chess_application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self) {
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_error_cb ((ChessApplication*) self, _sender);
#line 2683 "gnome-chess.c"
}


static void _chess_application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self) {
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_claim_draw_cb ((ChessApplication*) self, _sender);
#line 2690 "gnome-chess.c"
}


static void _chess_application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self) {
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_engine_offer_draw_cb ((ChessApplication*) self, _sender);
#line 2697 "gnome-chess.c"
}


static void chess_application_start_game (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeModel* _tmp13_ = NULL;
	GtkListStore* _tmp14_ = NULL;
	GtkListStore* _tmp15_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp16_ = NULL;
	GtkTreeIter _tmp17_ = {0};
	GtkListStore* _tmp18_ = NULL;
	GtkTreeIter _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	gchar* fen = NULL;
	gchar* _tmp23_ = NULL;
	gchar** moves = NULL;
	PGNGame* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	gchar** _tmp27_ = NULL;
	gint moves_length1 = 0;
	gint _moves_size_ = 0;
	gint i = 0;
	PGNGame* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	PGNGame* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp53_ = FALSE;
	PGNGame* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	ChessGame* _tmp84_ = NULL;
	ChessGame* _tmp85_ = NULL;
	ChessGame* _tmp86_ = NULL;
	ChessGame* _tmp87_ = NULL;
	ChessGame* _tmp88_ = NULL;
	ChessClock* _tmp89_ = NULL;
	ChessClock* _tmp90_ = NULL;
	ChessScene* _tmp94_ = NULL;
	ChessGame* _tmp95_ = NULL;
	gchar* white_engine = NULL;
	PGNGame* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	gchar* white_level = NULL;
	PGNGame* _tmp100_ = NULL;
	const gchar* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	gchar* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	gchar* black_engine = NULL;
	PGNGame* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	gchar* _tmp109_ = NULL;
	gchar* black_level = NULL;
	PGNGame* _tmp110_ = NULL;
	const gchar* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	gchar* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	ChessEngine* _tmp116_ = NULL;
	const gchar* _tmp132_ = NULL;
	ChessEngine* _tmp160_ = NULL;
	gboolean _tmp192_ = FALSE;
	GFile* _tmp193_ = NULL;
	ChessGame* _tmp198_ = NULL;
	gint timer_increment_adj_value = 0;
	PGNGame* _tmp199_ = NULL;
	const gchar* _tmp200_ = NULL;
	const gchar* _tmp201_ = NULL;
	ClockType clock_type = 0;
	PGNGame* _tmp212_ = NULL;
	const gchar* _tmp213_ = NULL;
	const gchar* _tmp214_ = NULL;
	ChessGame* _tmp227_ = NULL;
	ChessClock* _tmp228_ = NULL;
	ChessClock* _tmp229_ = NULL;
	PGNGame* _tmp238_ = NULL;
	const gchar* _tmp239_ = NULL;
	const gchar* _tmp240_ = NULL;
	const gchar* _tmp241_ = NULL;
	ChessEngine* _tmp253_ = NULL;
	gboolean _tmp255_ = FALSE;
	gchar** _tmp256_ = NULL;
	gint _tmp256__length1 = 0;
	GtkWidget* _tmp263_ = NULL;
	GtkWidget* _tmp264_ = NULL;
	gboolean _tmp265_ = FALSE;
	gboolean _tmp266_ = FALSE;
	const gchar* _tmp267_ = NULL;
	ChessGame* _tmp280_ = NULL;
	ChessResult _tmp281_ = 0;
	GError * _inner_error_ = NULL;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = TRUE;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game_file;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ != NULL) {
#line 2809 "gnome-chess.c"
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game_file;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->autosave_filename;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp4_);
#line 2826 "gnome-chess.c"
	} else {
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 2830 "gnome-chess.c"
	}
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 2834 "gnome-chess.c"
		GtkHeaderBar* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->headerbar;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game_file;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = g_file_get_basename (_tmp7_);
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_header_bar_set_subtitle (_tmp6_, _tmp9_);
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp9_);
#line 2851 "gnome-chess.c"
	} else {
		GtkHeaderBar* _tmp10_ = NULL;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->headerbar;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_header_bar_set_subtitle (_tmp10_, NULL);
#line 2858 "gnome-chess.c"
	}
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->history_combo;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_combo_box_get_model (_tmp11_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_list_store_get_type (), GtkListStore));
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp14_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = model;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_clear (_tmp15_);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = model;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp16_, &_tmp17_);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp17_;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = model;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = iter;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _ ("Game Start");
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp18_, &_tmp19_, 0, _tmp20_, 1, 0, -1, -1);
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->history_combo;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = iter;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	fen = _tmp23_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = self->priv->pgn_game;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_->moves;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = g_list_length (_tmp25_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = g_new0 (gchar*, _tmp26_ + 1);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	moves = _tmp27_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	moves_length1 = _tmp26_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_moves_size_ = moves_length1;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	i = 0;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->pgn_game;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _tmp28_->moves;
#line 2918 "gnome-chess.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		move_collection = _tmp29_;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 2926 "gnome-chess.c"
			gchar* _tmp30_ = NULL;
			gchar* move = NULL;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = g_strdup ((const gchar*) move_it->data);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			move = _tmp30_;
#line 2933 "gnome-chess.c"
			{
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = moves;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31__length1 = moves_length1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = i;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				i = _tmp32_ + 1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = move;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = g_strdup (_tmp33_);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (_tmp31_[_tmp32_]);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_[_tmp32_] = _tmp34_;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = _tmp31_[_tmp32_];
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move);
#line 2961 "gnome-chess.c"
			}
		}
	}
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->pgn_game;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = pgn_game_get_set_up (_tmp36_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp38_) {
#line 2973 "gnome-chess.c"
		PGNGame* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = self->priv->pgn_game;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = pgn_game_get_fen (_tmp39_);
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = _tmp40_;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp41_ != NULL) {
#line 2985 "gnome-chess.c"
			PGNGame* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = self->priv->pgn_game;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = pgn_game_get_fen (_tmp42_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = _tmp43_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = g_strdup (_tmp44_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (fen);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			fen = _tmp45_;
#line 3002 "gnome-chess.c"
		} else {
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:468: Chess game has SetUp tag but no FEN tag");
#line 3006 "gnome-chess.c"
		}
	}
	{
		ChessGame* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gchar** _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		ChessGame* _tmp49_ = NULL;
		ChessGame* _tmp50_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = fen;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp48_ = moves;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp48__length1 = moves_length1;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp49_ = chess_game_new (_tmp47_, _tmp48_, _tmp48__length1, &_inner_error_);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp46_ = _tmp49_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3028 "gnome-chess.c"
			goto __catch3_g_error;
		}
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp50_ = _tmp46_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp46_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->game);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game = _tmp50_;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp46_);
#line 3041 "gnome-chess.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp51_ = e;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp52_ = _tmp51_->message;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_run_invalid_move_dialog (self, _tmp52_);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_start_new_game (self);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (fen);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 3071 "gnome-chess.c"
	}
	__finally3:
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (fen);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 3088 "gnome-chess.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = self->priv->pgn_game;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = pgn_game_get_time_control (_tmp54_);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = _tmp55_;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp56_ != NULL) {
#line 3098 "gnome-chess.c"
		PGNGame* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		gint _tmp60_ = 0;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp57_ = self->priv->pgn_game;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp58_ = pgn_game_get_time_control (_tmp57_);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp59_ = _tmp58_;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp60_ = atoi (_tmp59_);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = _tmp60_ != 0;
#line 3113 "gnome-chess.c"
	} else {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = FALSE;
#line 3117 "gnome-chess.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp53_) {
#line 3121 "gnome-chess.c"
		gboolean _tmp61_ = FALSE;
		PGNGame* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = self->priv->pgn_game;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = pgn_game_get_white_time_left (_tmp62_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp64_ = _tmp63_;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp64_ != NULL) {
#line 3134 "gnome-chess.c"
			PGNGame* _tmp65_ = NULL;
			const gchar* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp65_ = self->priv->pgn_game;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp66_ = pgn_game_get_black_time_left (_tmp65_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp67_ = _tmp66_;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp61_ = _tmp67_ != NULL;
#line 3146 "gnome-chess.c"
		} else {
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp61_ = FALSE;
#line 3150 "gnome-chess.c"
		}
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp61_) {
#line 3154 "gnome-chess.c"
			gint white_seconds = 0;
			PGNGame* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gint black_seconds = 0;
			PGNGame* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			const gchar* _tmp74_ = NULL;
			gint _tmp75_ = 0;
			gboolean _tmp76_ = FALSE;
			gint _tmp77_ = 0;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp68_ = self->priv->pgn_game;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp69_ = pgn_game_get_white_time_left (_tmp68_);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp70_ = _tmp69_;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp71_ = atoi (_tmp70_);
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			white_seconds = _tmp71_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp72_ = self->priv->pgn_game;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp73_ = pgn_game_get_black_time_left (_tmp72_);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp74_ = _tmp73_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp75_ = atoi (_tmp74_);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			black_seconds = _tmp75_;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp77_ = white_seconds;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp77_ >= 0) {
#line 3191 "gnome-chess.c"
				gint _tmp78_ = 0;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp78_ = black_seconds;
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp76_ = _tmp78_ >= 0;
#line 3197 "gnome-chess.c"
			} else {
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp76_ = FALSE;
#line 3201 "gnome-chess.c"
			}
#line 493 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp76_) {
#line 3205 "gnome-chess.c"
				ChessGame* _tmp79_ = NULL;
				gint _tmp80_ = 0;
				gint _tmp81_ = 0;
				ChessClock* _tmp82_ = NULL;
				ChessClock* _tmp83_ = NULL;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp79_ = self->priv->game;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp80_ = white_seconds;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp81_ = black_seconds;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp82_ = chess_clock_new (_tmp80_, _tmp81_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp83_ = _tmp82_;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				chess_game_set_clock (_tmp79_, _tmp83_);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (_tmp83_);
#line 3225 "gnome-chess.c"
			}
		}
	}
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = self->priv->game;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp84_, "turn-started", (GCallback) _chess_application_game_turn_cb_chess_game_turn_started, self, 0);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = self->priv->game;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp85_, "moved", (GCallback) _chess_application_game_move_cb_chess_game_moved, self, 0);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->game;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp86_, "undo", (GCallback) _chess_application_game_undo_cb_chess_game_undo, self, 0);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = self->priv->game;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp87_, "ended", (GCallback) _chess_application_game_end_cb_chess_game_ended, self, 0);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = self->priv->game;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = chess_game_get_clock (_tmp88_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = _tmp89_;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp90_ != NULL) {
#line 3253 "gnome-chess.c"
		ChessGame* _tmp91_ = NULL;
		ChessClock* _tmp92_ = NULL;
		ChessClock* _tmp93_ = NULL;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp91_ = self->priv->game;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp92_ = chess_game_get_clock (_tmp91_);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp93_ = _tmp92_;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp93_, "tick", (GCallback) _chess_application_game_clock_tick_cb_chess_clock_tick, self, 0);
#line 3265 "gnome-chess.c"
	}
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = self->priv->scene;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = self->priv->game;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_game (_tmp94_, _tmp95_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = self->priv->pgn_game;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = pgn_game_get_white_ai (_tmp96_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = _tmp97_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = g_strdup (_tmp98_);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	white_engine = _tmp99_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp100_ = self->priv->pgn_game;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp101_ = pgn_game_get_white_level (_tmp100_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp102_ = _tmp101_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp103_ = g_strdup (_tmp102_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	white_level = _tmp103_;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp104_ = white_level;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp104_ == NULL) {
#line 3297 "gnome-chess.c"
		gchar* _tmp105_ = NULL;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp105_ = g_strdup ("normal");
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (white_level);
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		white_level = _tmp105_;
#line 3305 "gnome-chess.c"
	}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = self->priv->pgn_game;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = pgn_game_get_black_ai (_tmp106_);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp108_ = _tmp107_;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp109_ = g_strdup (_tmp108_);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	black_engine = _tmp109_;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp110_ = self->priv->pgn_game;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp111_ = pgn_game_get_black_level (_tmp110_);
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp112_ = _tmp111_;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp113_ = g_strdup (_tmp112_);
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	black_level = _tmp113_;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp114_ = black_level;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp114_ == NULL) {
#line 3331 "gnome-chess.c"
		gchar* _tmp115_ = NULL;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp115_ = g_strdup ("normal");
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (black_level);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		black_level = _tmp115_;
#line 3339 "gnome-chess.c"
	}
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp116_ = self->priv->opponent_engine;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp116_ != NULL) {
#line 3353 "gnome-chess.c"
		ChessEngine* _tmp117_ = NULL;
		ChessEngine* _tmp118_ = NULL;
		guint _tmp119_ = 0U;
		ChessEngine* _tmp120_ = NULL;
		guint _tmp121_ = 0U;
		ChessEngine* _tmp122_ = NULL;
		guint _tmp123_ = 0U;
		ChessEngine* _tmp124_ = NULL;
		guint _tmp125_ = 0U;
		ChessEngine* _tmp126_ = NULL;
		guint _tmp127_ = 0U;
		ChessEngine* _tmp128_ = NULL;
		guint _tmp129_ = 0U;
		ChessEngine* _tmp130_ = NULL;
		guint _tmp131_ = 0U;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp117_ = self->priv->opponent_engine;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp117_, TRUE);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp118_ = self->priv->opponent_engine;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("ready-changed", TYPE_CHESS_ENGINE, &_tmp119_, NULL, FALSE);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp118_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp119_, 0, NULL, (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp120_ = self->priv->opponent_engine;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp121_, NULL, FALSE);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp120_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp121_, 0, NULL, (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp122_ = self->priv->opponent_engine;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp123_, NULL, FALSE);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp122_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp123_, 0, NULL, (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp124_ = self->priv->opponent_engine;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("stopped-unexpectedly", TYPE_CHESS_ENGINE, &_tmp125_, NULL, FALSE);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp124_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp125_, 0, NULL, (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp126_ = self->priv->opponent_engine;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp127_, NULL, FALSE);
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp126_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp127_, 0, NULL, (GCallback) _chess_application_engine_error_cb_chess_engine_error, self);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp128_ = self->priv->opponent_engine;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp129_, NULL, FALSE);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp128_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp129_, 0, NULL, (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self);
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp130_ = self->priv->opponent_engine;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp131_, NULL, FALSE);
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp130_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp131_, 0, NULL, (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self);
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = NULL;
#line 3419 "gnome-chess.c"
	}
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp132_ = white_engine;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp132_ != NULL) {
#line 3425 "gnome-chess.c"
		ChessGame* _tmp133_ = NULL;
		ChessPlayer* _tmp134_ = NULL;
		ChessPlayer* _tmp135_ = NULL;
		ChessPlayer* _tmp136_ = NULL;
		ChessGame* _tmp137_ = NULL;
		ChessPlayer* _tmp138_ = NULL;
		ChessPlayer* _tmp139_ = NULL;
		ChessPlayer* _tmp140_ = NULL;
		const gchar* _tmp141_ = NULL;
		const gchar* _tmp142_ = NULL;
		ChessEngine* _tmp143_ = NULL;
		ChessPlayer* _tmp144_ = NULL;
		ChessPlayer* _tmp145_ = NULL;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp133_ = self->priv->game;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp134_ = chess_game_get_white (_tmp133_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp135_ = _tmp134_;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp136_ = _g_object_ref0 (_tmp135_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent = _tmp136_;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp137_ = self->priv->game;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp138_ = chess_game_get_black (_tmp137_);
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp139_ = _tmp138_;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp140_ = _g_object_ref0 (_tmp139_);
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->human_player);
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->human_player = _tmp140_;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp141_ = white_engine;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp142_ = white_level;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp143_ = chess_application_get_engine (self, _tmp141_, _tmp142_);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = _tmp143_;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp144_ = self->priv->opponent;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp144_, FALSE);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp145_ = self->priv->human_player;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp145_, TRUE);
#line 3481 "gnome-chess.c"
	} else {
		const gchar* _tmp146_ = NULL;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp146_ = black_engine;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp146_ != NULL) {
#line 3488 "gnome-chess.c"
			ChessGame* _tmp147_ = NULL;
			ChessPlayer* _tmp148_ = NULL;
			ChessPlayer* _tmp149_ = NULL;
			ChessPlayer* _tmp150_ = NULL;
			ChessGame* _tmp151_ = NULL;
			ChessPlayer* _tmp152_ = NULL;
			ChessPlayer* _tmp153_ = NULL;
			ChessPlayer* _tmp154_ = NULL;
			const gchar* _tmp155_ = NULL;
			const gchar* _tmp156_ = NULL;
			ChessEngine* _tmp157_ = NULL;
			ChessPlayer* _tmp158_ = NULL;
			ChessPlayer* _tmp159_ = NULL;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp147_ = self->priv->game;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp148_ = chess_game_get_black (_tmp147_);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp149_ = _tmp148_;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp150_ = _g_object_ref0 (_tmp149_);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent = _tmp150_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp151_ = self->priv->game;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp152_ = chess_game_get_white (_tmp151_);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp153_ = _tmp152_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp154_ = _g_object_ref0 (_tmp153_);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->human_player);
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->human_player = _tmp154_;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp155_ = black_engine;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp156_ = black_level;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp157_ = chess_application_get_engine (self, _tmp155_, _tmp156_);
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent_engine);
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent_engine = _tmp157_;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp158_ = self->priv->opponent;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp158_, FALSE);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp159_ = self->priv->human_player;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp159_, TRUE);
#line 3544 "gnome-chess.c"
		}
	}
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp160_ = self->priv->opponent_engine;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp160_ == NULL) {
#line 3551 "gnome-chess.c"
		ChessGame* _tmp161_ = NULL;
		ChessPlayer* _tmp162_ = NULL;
		ChessPlayer* _tmp163_ = NULL;
		ChessGame* _tmp164_ = NULL;
		ChessPlayer* _tmp165_ = NULL;
		ChessPlayer* _tmp166_ = NULL;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp161_ = self->priv->game;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp162_ = chess_game_get_black (_tmp161_);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp163_ = _tmp162_;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp163_, TRUE);
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp164_ = self->priv->game;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp165_ = chess_game_get_white (_tmp164_);
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp166_ = _tmp165_;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp166_, TRUE);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->human_player);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->human_player = NULL;
#line 3578 "gnome-chess.c"
	} else {
		ChessEngine* _tmp167_ = NULL;
		ChessEngine* _tmp168_ = NULL;
		ChessEngine* _tmp169_ = NULL;
		ChessEngine* _tmp170_ = NULL;
		ChessEngine* _tmp171_ = NULL;
		ChessEngine* _tmp172_ = NULL;
		ChessEngine* _tmp173_ = NULL;
		ChessEngine* _tmp174_ = NULL;
		gboolean _tmp175_ = FALSE;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp167_ = self->priv->opponent_engine;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp167_, "ready-changed", (GCallback) _chess_application_engine_ready_cb_chess_engine_ready_changed, self, 0);
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp168_ = self->priv->opponent_engine;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp168_, "moved", (GCallback) _chess_application_engine_move_cb_chess_engine_moved, self, 0);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp169_ = self->priv->opponent_engine;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp169_, "resigned", (GCallback) _chess_application_engine_resigned_cb_chess_engine_resigned, self, 0);
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp170_ = self->priv->opponent_engine;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp170_, "stopped-unexpectedly", (GCallback) _chess_application_engine_stopped_unexpectedly_cb_chess_engine_stopped_unexpectedly, self, 0);
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp171_ = self->priv->opponent_engine;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp171_, "error", (GCallback) _chess_application_engine_error_cb_chess_engine_error, self, 0);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp172_ = self->priv->opponent_engine;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp172_, "claim-draw", (GCallback) _chess_application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp173_ = self->priv->opponent_engine;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp173_, "offer-draw", (GCallback) _chess_application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp174_ = self->priv->opponent_engine;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp175_ = chess_engine_start (_tmp174_);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (!_tmp175_) {
#line 3623 "gnome-chess.c"
			ChessGame* _tmp176_ = NULL;
			ChessGame* _tmp177_ = NULL;
#line 568 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp176_ = self->priv->game;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp176_->result = CHESS_RESULT_BUG;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp177_ = self->priv->game;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp177_->rule = CHESS_RULE_BUG;
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_game_end_cb (self);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (black_level);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (black_engine);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (white_level);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (white_engine);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (fen);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (model);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 3654 "gnome-chess.c"
		}
	}
	{
		gint j = 0;
		ChessGame* _tmp178_ = NULL;
		GList* _tmp179_ = NULL;
		guint _tmp180_ = 0U;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp178_ = self->priv->game;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp179_ = _tmp178_->move_stack;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp180_ = g_list_length (_tmp179_);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		j = ((gint) _tmp180_) - 2;
#line 3670 "gnome-chess.c"
		{
			gboolean _tmp181_ = FALSE;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp181_ = TRUE;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 3677 "gnome-chess.c"
				gint _tmp183_ = 0;
				ChessState* state = NULL;
				ChessGame* _tmp184_ = NULL;
				GList* _tmp185_ = NULL;
				gint _tmp186_ = 0;
				gconstpointer _tmp187_ = NULL;
				ChessState* _tmp188_ = NULL;
				ChessGame* _tmp189_ = NULL;
				ChessState* _tmp190_ = NULL;
				ChessMove* _tmp191_ = NULL;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp181_) {
#line 3690 "gnome-chess.c"
					gint _tmp182_ = 0;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp182_ = j;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					j = _tmp182_ - 1;
#line 3696 "gnome-chess.c"
				}
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp181_ = FALSE;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp183_ = j;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!(_tmp183_ >= 0)) {
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 3706 "gnome-chess.c"
				}
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp184_ = self->priv->game;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp185_ = _tmp184_->move_stack;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp186_ = j;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp187_ = g_list_nth_data (_tmp185_, (guint) _tmp186_);
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp188_ = _g_object_ref0 ((ChessState*) _tmp187_);
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				state = _tmp188_;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp189_ = self->priv->game;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp190_ = state;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp191_ = _tmp190_->last_move;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				chess_application_game_move_cb (self, _tmp189_, _tmp191_);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (state);
#line 3730 "gnome-chess.c"
			}
		}
	}
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp193_ = self->priv->game_file;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp193_ != NULL) {
#line 3738 "gnome-chess.c"
		GFile* _tmp194_ = NULL;
		gchar* _tmp195_ = NULL;
		gchar* _tmp196_ = NULL;
		const gchar* _tmp197_ = NULL;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp194_ = self->priv->game_file;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp195_ = g_file_get_path (_tmp194_);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp196_ = _tmp195_;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp197_ = self->priv->autosave_filename;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp192_ = g_strcmp0 (_tmp196_, _tmp197_) == 0;
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp196_);
#line 3755 "gnome-chess.c"
	} else {
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp192_ = FALSE;
#line 3759 "gnome-chess.c"
	}
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp192_) {
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = TRUE;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 3767 "gnome-chess.c"
	} else {
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 591 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 3773 "gnome-chess.c"
	}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp198_ = self->priv->game;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_start (_tmp198_);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	timer_increment_adj_value = 0;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp199_ = self->priv->pgn_game;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp200_ = pgn_game_get_timer_increment (_tmp199_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp201_ = _tmp200_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp201_ != NULL) {
#line 3789 "gnome-chess.c"
		PGNGame* _tmp202_ = NULL;
		const gchar* _tmp203_ = NULL;
		const gchar* _tmp204_ = NULL;
		gint _tmp205_ = 0;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp202_ = self->priv->pgn_game;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp203_ = pgn_game_get_timer_increment (_tmp202_);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp204_ = _tmp203_;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp205_ = atoi (_tmp204_);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		timer_increment_adj_value = _tmp205_;
#line 3804 "gnome-chess.c"
	} else {
		GSettings* _tmp206_ = NULL;
		gint _tmp207_ = 0;
		PGNGame* _tmp208_ = NULL;
		gint _tmp209_ = 0;
		gchar* _tmp210_ = NULL;
		gchar* _tmp211_ = NULL;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp206_ = self->priv->settings;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp207_ = g_settings_get_int (_tmp206_, "timer-increment");
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		timer_increment_adj_value = _tmp207_;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp208_ = self->priv->pgn_game;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp209_ = timer_increment_adj_value;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp210_ = g_strdup_printf ("%i", _tmp209_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp211_ = _tmp210_;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_timer_increment (_tmp208_, _tmp211_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp211_);
#line 3830 "gnome-chess.c"
	}
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	clock_type = CLOCK_TYPE_SIMPLE;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp212_ = self->priv->pgn_game;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp213_ = pgn_game_get_clock_type (_tmp212_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp214_ = _tmp213_;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp214_ != NULL) {
#line 3842 "gnome-chess.c"
		PGNGame* _tmp215_ = NULL;
		const gchar* _tmp216_ = NULL;
		const gchar* _tmp217_ = NULL;
		ClockType _tmp218_ = 0;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp215_ = self->priv->pgn_game;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp216_ = pgn_game_get_clock_type (_tmp215_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp217_ = _tmp216_;
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp218_ = clock_type_string_to_enum (_tmp217_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		clock_type = _tmp218_;
#line 3857 "gnome-chess.c"
	} else {
		GSettings* _tmp219_ = NULL;
		gchar* _tmp220_ = NULL;
		gchar* _tmp221_ = NULL;
		ClockType _tmp222_ = 0;
		PGNGame* _tmp223_ = NULL;
		ClockType _tmp224_ = 0;
		gchar* _tmp225_ = NULL;
		gchar* _tmp226_ = NULL;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp219_ = self->priv->settings;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp220_ = g_settings_get_string (_tmp219_, "clock-type");
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp221_ = _tmp220_;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp222_ = clock_type_string_to_enum (_tmp221_);
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		clock_type = _tmp222_;
#line 610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp221_);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp223_ = self->priv->pgn_game;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp224_ = clock_type;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp225_ = clock_type_to_string (_tmp224_);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp226_ = _tmp225_;
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_clock_type (_tmp223_, _tmp226_);
#line 611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp226_);
#line 3891 "gnome-chess.c"
	}
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp227_ = self->priv->game;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp228_ = chess_game_get_clock (_tmp227_);
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp229_ = _tmp228_;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp229_ != NULL) {
#line 3901 "gnome-chess.c"
		ChessGame* _tmp230_ = NULL;
		ChessClock* _tmp231_ = NULL;
		ChessClock* _tmp232_ = NULL;
		gint _tmp233_ = 0;
		ChessGame* _tmp234_ = NULL;
		ChessClock* _tmp235_ = NULL;
		ChessClock* _tmp236_ = NULL;
		ClockType _tmp237_ = 0;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp230_ = self->priv->game;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp231_ = chess_game_get_clock (_tmp230_);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp232_ = _tmp231_;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp233_ = timer_increment_adj_value;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_clock_set_extra_seconds (_tmp232_, (gint) _tmp233_);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp234_ = self->priv->game;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp235_ = chess_game_get_clock (_tmp234_);
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp236_ = _tmp235_;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp237_ = clock_type;
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_clock_set_clock_type (_tmp236_, _tmp237_);
#line 3930 "gnome-chess.c"
	}
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp238_ = self->priv->pgn_game;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp239_ = pgn_game_get_result (_tmp238_);
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp240_ = _tmp239_;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp241_ = pgn_game_RESULT_WHITE;
#line 621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp240_, _tmp241_) == 0) {
#line 3942 "gnome-chess.c"
		ChessGame* _tmp242_ = NULL;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp242_ = self->priv->game;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp242_->result = CHESS_RESULT_WHITE_WON;
#line 3948 "gnome-chess.c"
	} else {
		PGNGame* _tmp243_ = NULL;
		const gchar* _tmp244_ = NULL;
		const gchar* _tmp245_ = NULL;
		const gchar* _tmp246_ = NULL;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp243_ = self->priv->pgn_game;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp244_ = pgn_game_get_result (_tmp243_);
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp245_ = _tmp244_;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp246_ = pgn_game_RESULT_BLACK;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp245_, _tmp246_) == 0) {
#line 3964 "gnome-chess.c"
			ChessGame* _tmp247_ = NULL;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp247_ = self->priv->game;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp247_->result = CHESS_RESULT_BLACK_WON;
#line 3970 "gnome-chess.c"
		} else {
			PGNGame* _tmp248_ = NULL;
			const gchar* _tmp249_ = NULL;
			const gchar* _tmp250_ = NULL;
			const gchar* _tmp251_ = NULL;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp248_ = self->priv->pgn_game;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp249_ = pgn_game_get_result (_tmp248_);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp250_ = _tmp249_;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp251_ = pgn_game_RESULT_DRAW;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp250_, _tmp251_) == 0) {
#line 3986 "gnome-chess.c"
				ChessGame* _tmp252_ = NULL;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp252_ = self->priv->game;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp252_->result = CHESS_RESULT_DRAW;
#line 3992 "gnome-chess.c"
			}
		}
	}
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp253_ = self->priv->opponent_engine;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp253_ != NULL) {
#line 4000 "gnome-chess.c"
		ChessEngine* _tmp254_ = NULL;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp254_ = self->priv->opponent_engine;
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_start_game (_tmp254_);
#line 4006 "gnome-chess.c"
	}
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp256_ = moves;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp256__length1 = moves_length1;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp256__length1 > 0) {
#line 4014 "gnome-chess.c"
		ChessGame* _tmp257_ = NULL;
		ChessClock* _tmp258_ = NULL;
		ChessClock* _tmp259_ = NULL;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp257_ = self->priv->game;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp258_ = chess_game_get_clock (_tmp257_);
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp259_ = _tmp258_;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp255_ = _tmp259_ != NULL;
#line 4026 "gnome-chess.c"
	} else {
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp255_ = FALSE;
#line 4030 "gnome-chess.c"
	}
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp255_) {
#line 4034 "gnome-chess.c"
		ChessGame* _tmp260_ = NULL;
		ChessClock* _tmp261_ = NULL;
		ChessClock* _tmp262_ = NULL;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp260_ = self->priv->game;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp261_ = chess_game_get_clock (_tmp260_);
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp262_ = _tmp261_;
#line 633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_clock_start (_tmp262_);
#line 634 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 4048 "gnome-chess.c"
	} else {
#line 638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 4052 "gnome-chess.c"
	}
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp263_ = self->priv->white_time_label;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp263_);
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp264_ = self->priv->black_time_label;
#line 647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp264_);
#line 649 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = FALSE;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp267_ = white_engine;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp267_ != NULL) {
#line 4076 "gnome-chess.c"
		ChessGame* _tmp268_ = NULL;
		ChessPlayer* _tmp269_ = NULL;
		ChessPlayer* _tmp270_ = NULL;
		Color _tmp271_ = 0;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp268_ = self->priv->game;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp269_ = chess_game_get_current_player (_tmp268_);
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp270_ = _tmp269_;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp271_ = _tmp270_->color;
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp266_ = _tmp271_ == COLOR_WHITE;
#line 4091 "gnome-chess.c"
	} else {
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp266_ = FALSE;
#line 4095 "gnome-chess.c"
	}
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp266_) {
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp265_ = TRUE;
#line 4101 "gnome-chess.c"
	} else {
		gboolean _tmp272_ = FALSE;
		const gchar* _tmp273_ = NULL;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp273_ = black_engine;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp273_ != NULL) {
#line 4109 "gnome-chess.c"
			ChessGame* _tmp274_ = NULL;
			ChessPlayer* _tmp275_ = NULL;
			ChessPlayer* _tmp276_ = NULL;
			Color _tmp277_ = 0;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp274_ = self->priv->game;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp275_ = chess_game_get_current_player (_tmp274_);
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp276_ = _tmp275_;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp277_ = _tmp276_->color;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp272_ = _tmp277_ == COLOR_BLACK;
#line 4124 "gnome-chess.c"
		} else {
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp272_ = FALSE;
#line 4128 "gnome-chess.c"
		}
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp265_ = _tmp272_;
#line 4132 "gnome-chess.c"
	}
#line 651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp265_) {
#line 4136 "gnome-chess.c"
		ChessEngine* _tmp278_ = NULL;
		ChessEngine* _tmp279_ = NULL;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp278_ = self->priv->opponent_engine;
#line 654 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_vala_assert (_tmp278_ != NULL, "opponent_engine != null");
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp279_ = self->priv->opponent_engine;
#line 655 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_move (_tmp279_);
#line 4147 "gnome-chess.c"
	}
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp280_ = self->priv->game;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp281_ = _tmp280_->result;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp281_ != CHESS_RESULT_IN_PROGRESS) {
#line 4155 "gnome-chess.c"
		ChessGame* _tmp282_ = NULL;
		ChessGame* _tmp283_ = NULL;
		ChessResult _tmp284_ = 0;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp282_ = self->priv->game;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp283_ = self->priv->game;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp284_ = _tmp283_->result;
#line 660 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp282_, _tmp284_, CHESS_RULE_UNKNOWN);
#line 4167 "gnome-chess.c"
	}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_level);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_engine);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_level);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_engine);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (fen);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 4183 "gnome-chess.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4194 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4200 "gnome-chess.c"
	}
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4204 "gnome-chess.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4215 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4221 "gnome-chess.c"
	}
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4225 "gnome-chess.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4236 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4242 "gnome-chess.c"
	}
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4246 "gnome-chess.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4257 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4263 "gnome-chess.c"
	}
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4267 "gnome-chess.c"
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4278 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4284 "gnome-chess.c"
	}
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4288 "gnome-chess.c"
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4299 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4305 "gnome-chess.c"
	}
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4309 "gnome-chess.c"
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4320 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4326 "gnome-chess.c"
	}
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4330 "gnome-chess.c"
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4341 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4347 "gnome-chess.c"
	}
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4351 "gnome-chess.c"
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4362 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4368 "gnome-chess.c"
	}
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4372 "gnome-chess.c"
}


static ChessEngine* chess_application_get_engine (ChessApplication* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	AIProfile* _tmp12_ = NULL;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GQuark _tmp21_ = 0U;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label0 = 0;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label1 = 0;
#line 4400 "gnome-chess.c"
	AIProfile* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (difficulty != NULL, NULL);
#line 666 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	profile = NULL;
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = name;
#line 668 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp0_, "human") == 0) {
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (profile);
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 4424 "gnome-chess.c"
	}
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp1_, "GNUchess") == 0) {
#line 673 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		name = "GNU Chess";
#line 4432 "gnome-chess.c"
	}
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->ai_profiles;
#line 4436 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp2_;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 4444 "gnome-chess.c"
			AIProfile* _tmp3_ = NULL;
			AIProfile* p = NULL;
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = _g_object_ref0 ((AIProfile*) p_it->data);
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			p = _tmp3_;
#line 4451 "gnome-chess.c"
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_ = NULL;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp5_ = name;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp5_, "") == 0) {
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp4_ = TRUE;
#line 4461 "gnome-chess.c"
				} else {
					AIProfile* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp6_ = p;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp7_ = ai_profile_get_name (_tmp6_);
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = _tmp7_;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = name;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp9_) == 0;
#line 4477 "gnome-chess.c"
				}
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp4_) {
#line 4481 "gnome-chess.c"
					AIProfile* _tmp10_ = NULL;
					AIProfile* _tmp11_ = NULL;
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = p;
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp11_ = _g_object_ref0 (_tmp10_);
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_object_unref0 (profile);
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					profile = _tmp11_;
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_object_unref0 (p);
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 4496 "gnome-chess.c"
				}
#line 675 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (p);
#line 4500 "gnome-chess.c"
			}
		}
	}
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = profile;
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ == NULL) {
#line 4508 "gnome-chess.c"
		const gchar* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		AIProfile* _tmp17_ = NULL;
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = name;
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:685: Unknown AI profile %s", _tmp13_);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->ai_profiles;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp14_ == NULL) {
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (profile);
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 687 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return result;
#line 4530 "gnome-chess.c"
		}
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->ai_profiles;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_->data;
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _g_object_ref0 ((AIProfile*) _tmp16_);
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (profile);
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		profile = _tmp17_;
#line 4542 "gnome-chess.c"
	}
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = difficulty;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("easy")))) {
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4554 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				AIProfile* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gchar** _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				AIProfile* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp22_ = profile;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp23_ = ai_profile_get_easy_options (_tmp22_, &_tmp23__length1);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = _tmp23_;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24__length1 = _tmp23__length1;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup1 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25__length1 = _tmp24__length1;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = _tmp25_;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp25__length1;
#line 695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = profile;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = ai_profile_get_easy_uci_go_options (_tmp26_, &_tmp27__length1);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = _tmp27_;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28__length1 = _tmp27__length1;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup2 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp29__length1 = _tmp28__length1;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp29_;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp29__length1;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = profile;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = ai_profile_get_easy_args (_tmp30_, &_tmp31__length1);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = _tmp31_;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32__length1 = _tmp31__length1;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup3 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33__length1 = _tmp32__length1;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = _tmp33_;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp33__length1;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 4640 "gnome-chess.c"
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hard")))) {
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4646 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp34_ = NULL;
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gchar** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				AIProfile* _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				AIProfile* _tmp42_ = NULL;
				gchar** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gchar** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = profile;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = ai_profile_get_hard_options (_tmp34_, &_tmp35__length1);
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _tmp35_;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36__length1 = _tmp35__length1;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup4 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37__length1 = _tmp36__length1;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = _tmp37_;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp37__length1;
#line 706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = profile;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = ai_profile_get_hard_uci_go_options (_tmp38_, &_tmp39__length1);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp39_;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40__length1 = _tmp39__length1;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup5 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41__length1 = _tmp40__length1;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp41_;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp41__length1;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = profile;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = ai_profile_get_hard_args (_tmp42_, &_tmp43__length1);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = _tmp43_;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44__length1 = _tmp43__length1;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup6 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45__length1 = _tmp44__length1;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = _tmp45_;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp45__length1;
#line 708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 709 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 4732 "gnome-chess.c"
			}
		}
	} else {
#line 692 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4738 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				AIProfile* _tmp50_ = NULL;
				gchar** _tmp51_ = NULL;
				gint _tmp51__length1 = 0;
				gchar** _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				gchar** _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				AIProfile* _tmp54_ = NULL;
				gchar** _tmp55_ = NULL;
				gint _tmp55__length1 = 0;
				gchar** _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				gchar** _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = profile;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp47__length1);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = _tmp47_;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48__length1 = _tmp47__length1;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup7 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49__length1 = _tmp48__length1;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options = _tmp49_;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp49__length1;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = profile;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = ai_profile_get_normal_uci_go_options (_tmp50_, &_tmp51__length1);
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp52_ = _tmp51_;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp52__length1 = _tmp51__length1;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup8 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp53__length1 = _tmp52__length1;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp53_;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp53__length1;
#line 702 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp54_ = profile;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp55_ = ai_profile_get_normal_args (_tmp54_, &_tmp55__length1);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp56_ = _tmp55_;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp56__length1 = _tmp55__length1;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup9 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp57__length1 = _tmp56__length1;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args = _tmp57_;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp57__length1;
#line 703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 4824 "gnome-chess.c"
			}
		}
	}
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = profile;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = ai_profile_get_protocol (_tmp58_);
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = _tmp59_;
#line 712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp60_, "cecp") == 0) {
#line 4836 "gnome-chess.c"
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		AIProfile* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gchar** _tmp65_ = NULL;
		gint _tmp65__length1 = 0;
		AIProfile* _tmp66_ = NULL;
		guint _tmp67_ = 0U;
		guint _tmp68_ = 0U;
		gchar** _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		ChessEngineCECP* _tmp70_ = NULL;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = uci_go_options;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp61__length1 = uci_go_options_length1;
#line 714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warn_if_fail (_tmp61__length1 == 0);
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = profile;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = ai_profile_get_binary (_tmp62_);
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp64_ = _tmp63_;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = args;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65__length1 = args_length1;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp66_ = profile;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp67_ = ai_profile_get_delay_seconds (_tmp66_);
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp68_ = _tmp67_;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = options;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp69__length1 = options_length1;
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = chess_engine_cecp_new (_tmp64_, _tmp65_, _tmp65__length1, _tmp68_, _tmp69_, _tmp69__length1);
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		engine = (ChessEngine*) _tmp70_;
#line 4882 "gnome-chess.c"
	} else {
		AIProfile* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = profile;
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp72_ = ai_profile_get_protocol (_tmp71_);
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp73_ = _tmp72_;
#line 717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp73_, "uci") == 0) {
#line 4895 "gnome-chess.c"
			AIProfile* _tmp74_ = NULL;
			const gchar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar** _tmp77_ = NULL;
			gint _tmp77__length1 = 0;
			AIProfile* _tmp78_ = NULL;
			guint _tmp79_ = 0U;
			guint _tmp80_ = 0U;
			gchar** _tmp81_ = NULL;
			gint _tmp81__length1 = 0;
			gchar** _tmp82_ = NULL;
			gint _tmp82__length1 = 0;
			ChessEngineUCI* _tmp83_ = NULL;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp74_ = profile;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp75_ = ai_profile_get_binary (_tmp74_);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp76_ = _tmp75_;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp77_ = args;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp77__length1 = args_length1;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp78_ = profile;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp79_ = ai_profile_get_delay_seconds (_tmp78_);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp80_ = _tmp79_;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp81_ = options;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp81__length1 = options_length1;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp82_ = uci_go_options;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp82__length1 = uci_go_options_length1;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp83_ = chess_engine_uci_new (_tmp76_, _tmp77_, _tmp77__length1, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp82__length1);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			engine = (ChessEngine*) _tmp83_;
#line 4939 "gnome-chess.c"
		} else {
			AIProfile* _tmp84_ = NULL;
			const gchar* _tmp85_ = NULL;
			const gchar* _tmp86_ = NULL;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp84_ = profile;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp85_ = ai_profile_get_protocol (_tmp84_);
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp86_ = _tmp85_;
#line 723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:723: Unknown AI protocol %s", _tmp86_);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (profile);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return result;
#line 4966 "gnome-chess.c"
		}
	}
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = engine;
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (profile);
#line 727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4981 "gnome-chess.c"
}


static void chess_application_engine_ready_cb (ChessApplication* self, ChessEngine* engine) {
	ChessEngine* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_engine_get_ready (_tmp0_);
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 732 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 5001 "gnome-chess.c"
		ChessView* _tmp3_ = NULL;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->view;
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
#line 5007 "gnome-chess.c"
	}
}


static void chess_application_do_engine_move (ChessApplication* self, const gchar* move) {
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = move;
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_player_move (_tmp0_, _tmp1_, TRUE);
#line 740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 5028 "gnome-chess.c"
		const gchar* _tmp3_ = NULL;
		ChessGame* _tmp4_ = NULL;
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = move;
#line 742 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:742: Engine's move %s is illegal! Engine desync?", _tmp3_);
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5039 "gnome-chess.c"
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return _data1_;
#line 5049 "gnome-chess.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 5058 "gnome-chess.c"
		ChessApplication* self;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self = _data1_->self;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_data1_->move);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_slice_free (Block1Data, _data1_);
#line 5068 "gnome-chess.c"
	}
}


static gboolean ___lambda7_ (Block1Data* _data1_) {
	ChessApplication* self;
	gboolean result = FALSE;
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = _data1_->self;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = G_SOURCE_CONTINUE;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 5093 "gnome-chess.c"
	} else {
		const gchar* _tmp3_ = NULL;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _data1_->move;
#line 762 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_do_engine_move (self, _tmp3_);
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = G_SOURCE_REMOVE;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 5104 "gnome-chess.c"
	}
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ (self);
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 5114 "gnome-chess.c"
}


static void chess_application_engine_move_cb (ChessApplication* self, ChessEngine* engine, const gchar* move) {
	Block1Data* _data1_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	ChessGame* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_->_ref_count_ = 1;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_->self = g_object_ref (self);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = move;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_data1_->move);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_->move = _tmp1_;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->game;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = chess_game_get_is_paused (_tmp2_);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp4_) {
#line 5153 "gnome-chess.c"
		const gchar* _tmp5_ = NULL;
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _data1_->move;
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_do_engine_move (self, _tmp5_);
#line 5159 "gnome-chess.c"
	} else {
#line 755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda7__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 5163 "gnome-chess.c"
	}
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	block1_data_unref (_data1_);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data1_ = NULL;
#line 5169 "gnome-chess.c"
}


static void chess_application_engine_resigned_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_player_resign (_tmp0_);
#line 5183 "gnome-chess.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return _data2_;
#line 5192 "gnome-chess.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 5201 "gnome-chess.c"
		ChessApplication* self;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self = _data2_->self;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_data2_->original_game);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_slice_free (Block2Data, _data2_);
#line 5211 "gnome-chess.c"
	}
}


static gboolean __lambda8_ (Block2Data* _data2_) {
	ChessApplication* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = _data2_->self;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == _data2_->original_game) {
#line 5227 "gnome-chess.c"
		ChessGame* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_->is_started;
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp3_;
#line 5236 "gnome-chess.c"
	} else {
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 5240 "gnome-chess.c"
	}
#line 790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 5244 "gnome-chess.c"
		ChessGame* _tmp4_ = NULL;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp4_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5250 "gnome-chess.c"
	}
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = G_SOURCE_REMOVE;
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 5256 "gnome-chess.c"
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 5265 "gnome-chess.c"
}


static void chess_application_engine_stopped_unexpectedly_cb (ChessApplication* self, ChessEngine* engine) {
	Block2Data* _data2_;
	ChessGame* _tmp0_ = NULL;
	ChessGame* _tmp1_ = NULL;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_->_ref_count_ = 1;
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_->self = g_object_ref (self);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_->original_game = _tmp1_;
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda8__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	block2_data_unref (_data2_);
#line 774 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_data2_ = NULL;
#line 5295 "gnome-chess.c"
}


static void chess_application_engine_error_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 798 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5309 "gnome-chess.c"
}


static void chess_application_engine_claim_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 5326 "gnome-chess.c"
		ChessGame* _tmp2_ = NULL;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp2_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 5332 "gnome-chess.c"
	}
}


static void chess_application_engine_offer_draw_cb (ChessApplication* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_player_claim_draw (_tmp0_);
#line 5347 "gnome-chess.c"
}


static void chess_application_check_engine_timeout (ChessApplication* self) {
	gint _tmp0_ = 0;
	ChessEngine* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	PGNGame* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint _tmp23_ = 0;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->engine_timeout_counter;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_return_if_fail (_tmp0_ >= 0, "engine_timeout_counter >= 0");
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->opponent_engine;
#line 824 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == NULL) {
#line 5370 "gnome-chess.c"
		gint _tmp2_ = 0;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->engine_timeout_counter;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_vala_warn_if_fail (_tmp2_ >= 0, "engine_timeout_counter >= 0");
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 5378 "gnome-chess.c"
	}
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->pgn_game;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = pgn_game_get_white_ai (_tmp5_);
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ != NULL) {
#line 5388 "gnome-chess.c"
		ChessGame* _tmp8_ = NULL;
		ChessPlayer* _tmp9_ = NULL;
		ChessPlayer* _tmp10_ = NULL;
		Color _tmp11_ = 0;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_get_current_player (_tmp8_);
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_->color;
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp11_ == COLOR_WHITE;
#line 5403 "gnome-chess.c"
	} else {
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = FALSE;
#line 5407 "gnome-chess.c"
	}
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp4_) {
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = TRUE;
#line 5413 "gnome-chess.c"
	} else {
		gboolean _tmp12_ = FALSE;
		PGNGame* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->pgn_game;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = pgn_game_get_black_ai (_tmp13_);
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp15_ != NULL) {
#line 5427 "gnome-chess.c"
			ChessGame* _tmp16_ = NULL;
			ChessPlayer* _tmp17_ = NULL;
			ChessPlayer* _tmp18_ = NULL;
			Color _tmp19_ = 0;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = self->priv->game;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = chess_game_get_current_player (_tmp16_);
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = _tmp17_;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = _tmp18_->color;
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = _tmp19_ == COLOR_BLACK;
#line 5442 "gnome-chess.c"
		} else {
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = FALSE;
#line 5446 "gnome-chess.c"
		}
#line 828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp12_;
#line 5450 "gnome-chess.c"
	}
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_) {
#line 5454 "gnome-chess.c"
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 830 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->engine_timeout_counter;
#line 830 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->engine_timeout_counter = _tmp20_ - 1;
#line 832 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->engine_timeout_counter;
#line 832 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp21_ == 0) {
#line 5465 "gnome-chess.c"
			ChessEngine* _tmp22_ = NULL;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = self->priv->opponent_engine;
#line 836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_engine_error_cb (self, _tmp22_);
#line 5471 "gnome-chess.c"
		}
	} else {
#line 842 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->engine_timeout_counter = 10;
#line 5476 "gnome-chess.c"
	}
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->engine_timeout_counter;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_warn_if_fail (_tmp23_ >= 0, "engine_timeout_counter >= 0");
#line 5482 "gnome-chess.c"
}


static void chess_application_game_clock_tick_cb (ChessApplication* self, ChessClock* clock) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 846 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (clock != NULL);
#line 848 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_check_engine_timeout (self);
#line 849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->white_time_label;
#line 849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp0_);
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->black_time_label;
#line 850 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp1_);
#line 5503 "gnome-chess.c"
}


static void chess_application_game_turn_cb (ChessApplication* self, ChessGame* game, ChessPlayer* player) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ChessGame* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	ChessClock* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (player != NULL);
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = game;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_->is_started;
#line 868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 5530 "gnome-chess.c"
	}
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = game;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = chess_game_get_clock (_tmp2_);
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 871 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp4_ != NULL) {
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 5542 "gnome-chess.c"
	}
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = game;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_game_can_claim_draw (_tmp6_);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 5550 "gnome-chess.c"
		gboolean _tmp8_ = FALSE;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->allow_claim_draw_dialog;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp8_;
#line 5556 "gnome-chess.c"
	} else {
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = FALSE;
#line 5560 "gnome-chess.c"
	}
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_) {
#line 875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_present_claim_draw_dialog (self);
#line 5566 "gnome-chess.c"
	}
}


static void chess_application_set_move_text (ChessApplication* self, GtkTreeIter* iter, ChessMove* move) {
#line 881 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static const gchar* human_descriptions[] = {"White pawn moves from %1$s to %2$s", "White pawn at %1$s takes the black pawn at %2$s", "White pawn at %1$s takes the black rook at %2$s", "White pawn at %1$s takes the black knight at %2$s", "White pawn at %1$s takes the black bishop at %2$s", "White pawn at %1$s takes the black queen at %2$s", "White rook moves from %1$s to %2$s", "White rook at %1$s takes the black pawn at %2$s", "White rook at %1$s takes the black rook at %2$s", "White rook at %1$s takes the black knight at %2$s", "White rook at %1$s takes the black bishop at %2$s", "White rook at %1$s takes the black queen at %2$s", "White knight moves from %1$s to %2$s", "White knight at %1$s takes the black pawn at %2$s", "White knight at %1$s takes the black rook at %2$s", "White knight at %1$s takes the black knight at %2$s", "White knight at %1$s takes the black bishop at %2$s", "White knight at %1$s takes the black queen at %2$s", "White bishop moves from %1$s to %2$s", "White bishop at %1$s takes the black pawn at %2$s", "White bishop at %1$s takes the black rook at %2$s", "White bishop at %1$s takes the black knight at %2$s", "White bishop at %1$s takes the black bishop at %2$s", "White bishop at %1$s takes the black queen at %2$s", "White queen moves from %1$s to %2$s", "White queen at %1$s takes the black pawn at %2$s", "White queen at %1$s takes the black rook at %2$s", "White queen at %1$s takes the black knight at %2$s", "White queen at %1$s takes the black bishop at %2$s", "White queen at %1$s takes the black queen at %2$s", "White king moves from %1$s to %2$s", "White king at %1$s takes the black pawn at %2$s", "White king at %1$s takes the black rook at %2$s", "White king at %1$s takes the black knight at %2$s", "White king at %1$s takes the black bishop at %2$s", "White king at %1$s takes the black queen at %2$s", "Black pawn moves from %1$s to %2$s", "Black pawn at %1$s takes the white pawn at %2$s", "Black pawn at %1$s takes the white rook at %2$s", "Black pawn at %1$s takes the white knight at %2$s", "Black pawn at %1$s takes the white bishop at %2$s", "Black pawn at %1$s takes the white queen at %2$s", "Black rook moves from %1$s to %2$s", "Black rook at %1$s takes the white pawn at %2$s", "Black rook at %1$s takes the white rook at %2$s", "Black rook at %1$s takes the white knight at %2$s", "Black rook at %1$s takes the white bishop at %2$s", "Black rook at %1$s takes the white queen at %2$s", "Black knight moves from %1$s to %2$s", "Black knight at %1$s takes the white pawn at %2$s", "Black knight at %1$s takes the white rook at %2$s", "Black knight at %1$s takes the white knight at %2$s", "Black knight at %1$s takes the white bishop at %2$s", "Black knight at %1$s takes the white queen at %2$s", "Black bishop moves from %1$s to %2$s", "Black bishop at %1$s takes the white pawn at %2$s", "Black bishop at %1$s takes the white rook at %2$s", "Black bishop at %1$s takes the white knight at %2$s", "Black bishop at %1$s takes the white bishop at %2$s", "Black bishop at %1$s takes the white queen at %2$s", "Black queen moves from %1$s to %2$s", "Black queen at %1$s takes the white pawn at %2$s", "Black queen at %1$s takes the white rook at %2$s", "Black queen at %1$s takes the white knight at %2$s", "Black queen at %1$s takes the white bishop at %2$s", "Black queen at %1$s takes the white queen at %2$s", "Black king moves from %1$s to %2$s", "Black king at %1$s takes the white pawn at %2$s", "Black king at %1$s takes the white rook at %2$s", "Black king at %1$s takes the white knight at %2$s", "Black king at %1$s takes the white bishop at %2$s", "Black king at %1$s takes the white queen at %2$s"};
#line 5574 "gnome-chess.c"
	gchar* move_text = NULL;
	gchar* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label0 = 0;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label1 = 0;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label2 = 0;
#line 5588 "gnome-chess.c"
	GtkListStore* model = NULL;
	GtkComboBox* _tmp81_ = NULL;
	GtkTreeModel* _tmp82_ = NULL;
	GtkTreeModel* _tmp83_ = NULL;
	GtkListStore* _tmp84_ = NULL;
	gchar _tmp85_ = '\0';
	ChessMove* _tmp86_ = NULL;
	gint _tmp87_ = 0;
	gchar* label = NULL;
	ChessMove* _tmp88_ = NULL;
	gint _tmp89_ = 0;
	const gchar* _tmp90_ = NULL;
	gchar* _tmp91_ = NULL;
	GtkListStore* _tmp92_ = NULL;
	GtkTreeIter _tmp93_ = {0};
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (iter != NULL);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_strdup ("");
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_text = _tmp0_;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5628 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp7_ = NULL;
				ChessPiece* _tmp8_ = NULL;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = move;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = _tmp7_->moved_rook;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp8_ == NULL) {
#line 5639 "gnome-chess.c"
					gint index = 0;
					ChessMove* _tmp9_ = NULL;
					ChessPiece* _tmp10_ = NULL;
					gint _tmp14_ = 0;
					ChessMove* _tmp15_ = NULL;
					ChessPiece* _tmp16_ = NULL;
					PieceType _tmp17_ = 0;
					ChessMove* _tmp18_ = NULL;
					ChessPiece* _tmp19_ = NULL;
					ChessPlayer* _tmp20_ = NULL;
					Color _tmp21_ = 0;
					gchar* start = NULL;
					ChessMove* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					ChessMove* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gchar* _tmp27_ = NULL;
					gchar* end = NULL;
					ChessMove* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					ChessMove* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = move;
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = _tmp9_->victim;
#line 1033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp10_ == NULL) {
#line 1034 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						index = 0;
#line 5677 "gnome-chess.c"
					} else {
						ChessMove* _tmp11_ = NULL;
						ChessPiece* _tmp12_ = NULL;
						PieceType _tmp13_ = 0;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp11_ = move;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp12_ = _tmp11_->victim;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = _tmp12_->type;
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						index = (gint) (_tmp13_ + 1);
#line 5690 "gnome-chess.c"
					}
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = index;
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = move;
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp16_ = _tmp15_->piece;
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = _tmp16_->type;
#line 1037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					index = _tmp14_ + (_tmp17_ * 6);
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = move;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp19_ = _tmp18_->piece;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp20_ = _tmp19_->player;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp21_ = _tmp20_->color;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp21_ == COLOR_BLACK) {
#line 5712 "gnome-chess.c"
						gint _tmp22_ = 0;
#line 1039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = index;
#line 1039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						index = _tmp22_ + 36;
#line 5718 "gnome-chess.c"
					}
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp23_ = move;
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp24_ = _tmp23_->f0;
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp25_ = move;
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp26_ = _tmp25_->r0;
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp27_ = g_strdup_printf ("%c%d", 'a' + _tmp24_, _tmp26_ + 1);
#line 1041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					start = _tmp27_;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = move;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp29_ = _tmp28_->f1;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp30_ = move;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp31_ = _tmp30_->r1;
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp32_ = g_strdup_printf ("%c%d", 'a' + _tmp29_, _tmp31_ + 1);
#line 1042 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					end = _tmp32_;
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp33_ = index;
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp34_ = human_descriptions[_tmp33_];
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp35_ = _ (_tmp34_);
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp36_ = start;
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp37_ = end;
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp38_ = g_strdup_printf (_tmp35_, _tmp36_, _tmp37_);
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (move_text);
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					move_text = _tmp38_;
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (end);
#line 1030 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (start);
#line 5764 "gnome-chess.c"
				} else {
					gboolean _tmp39_ = FALSE;
					ChessMove* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					ChessMove* _tmp42_ = NULL;
					gint _tmp43_ = 0;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp40_ = move;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp41_ = _tmp40_->f0;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp42_ = move;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp43_ = _tmp42_->f1;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp41_ < _tmp43_) {
#line 5781 "gnome-chess.c"
						ChessMove* _tmp44_ = NULL;
						gint _tmp45_ = 0;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp44_ = move;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp45_ = _tmp44_->r0;
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp39_ = _tmp45_ == 0;
#line 5790 "gnome-chess.c"
					} else {
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp39_ = FALSE;
#line 5794 "gnome-chess.c"
					}
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (_tmp39_) {
#line 5798 "gnome-chess.c"
						const gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp46_ = _ ("White castles kingside");
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp47_ = g_strdup (_tmp46_);
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_g_free0 (move_text);
#line 1047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						move_text = _tmp47_;
#line 5809 "gnome-chess.c"
					} else {
						gboolean _tmp48_ = FALSE;
						ChessMove* _tmp49_ = NULL;
						gint _tmp50_ = 0;
						ChessMove* _tmp51_ = NULL;
						gint _tmp52_ = 0;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp49_ = move;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp50_ = _tmp49_->f1;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp51_ = move;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp52_ = _tmp51_->f0;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						if (_tmp50_ < _tmp52_) {
#line 5826 "gnome-chess.c"
							ChessMove* _tmp53_ = NULL;
							gint _tmp54_ = 0;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp53_ = move;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp54_ = _tmp53_->r0;
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp48_ = _tmp54_ == 0;
#line 5835 "gnome-chess.c"
						} else {
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp48_ = FALSE;
#line 5839 "gnome-chess.c"
						}
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						if (_tmp48_) {
#line 5843 "gnome-chess.c"
							const gchar* _tmp55_ = NULL;
							gchar* _tmp56_ = NULL;
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp55_ = _ ("White castles queenside");
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp56_ = g_strdup (_tmp55_);
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_g_free0 (move_text);
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							move_text = _tmp56_;
#line 5854 "gnome-chess.c"
						} else {
							gboolean _tmp57_ = FALSE;
							ChessMove* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							ChessMove* _tmp60_ = NULL;
							gint _tmp61_ = 0;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp58_ = move;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp59_ = _tmp58_->f0;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp60_ = move;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							_tmp61_ = _tmp60_->f1;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							if (_tmp59_ < _tmp61_) {
#line 5871 "gnome-chess.c"
								ChessMove* _tmp62_ = NULL;
								gint _tmp63_ = 0;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp62_ = move;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp63_ = _tmp62_->r0;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp57_ = _tmp63_ == 7;
#line 5880 "gnome-chess.c"
							} else {
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp57_ = FALSE;
#line 5884 "gnome-chess.c"
							}
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
							if (_tmp57_) {
#line 5888 "gnome-chess.c"
								const gchar* _tmp64_ = NULL;
								gchar* _tmp65_ = NULL;
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp64_ = _ ("Black castles kingside");
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp65_ = g_strdup (_tmp64_);
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_g_free0 (move_text);
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								move_text = _tmp65_;
#line 5899 "gnome-chess.c"
							} else {
								gboolean _tmp66_ = FALSE;
								ChessMove* _tmp67_ = NULL;
								gint _tmp68_ = 0;
								ChessMove* _tmp69_ = NULL;
								gint _tmp70_ = 0;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp67_ = move;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp68_ = _tmp67_->f1;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp69_ = move;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								_tmp70_ = _tmp69_->f0;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								if (_tmp68_ < _tmp70_) {
#line 5916 "gnome-chess.c"
									ChessMove* _tmp71_ = NULL;
									gint _tmp72_ = 0;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp71_ = move;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp72_ = _tmp71_->r0;
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp66_ = _tmp72_ == 7;
#line 5925 "gnome-chess.c"
								} else {
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp66_ = FALSE;
#line 5929 "gnome-chess.c"
								}
#line 1057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
								if (_tmp66_) {
#line 5933 "gnome-chess.c"
									const gchar* _tmp73_ = NULL;
									gchar* _tmp74_ = NULL;
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp73_ = _ ("Black castles queenside");
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_tmp74_ = g_strdup (_tmp73_);
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									_g_free0 (move_text);
#line 1059 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									move_text = _tmp74_;
#line 5944 "gnome-chess.c"
								} else {
#line 1061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
									g_assert_not_reached ();
#line 5948 "gnome-chess.c"
								}
							}
						}
					}
				}
#line 1062 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 5956 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5962 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp75_ = move;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp76_ = chess_move_get_san (_tmp75_);
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp76_;
#line 1066 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 5977 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5983 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
#line 1069 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp77_ = move;
#line 1069 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp78_ = chess_move_get_fan (_tmp77_);
#line 1069 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 1069 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp78_;
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 5998 "gnome-chess.c"
			}
		}
	} else {
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 6004 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp79_ = move;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp80_ = chess_move_get_lan (_tmp79_);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp80_;
#line 1075 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				break;
#line 6019 "gnome-chess.c"
			}
		}
	}
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = self->priv->history_combo;
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = gtk_combo_box_get_model (_tmp81_);
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = _tmp82_;
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, gtk_list_store_get_type (), GtkListStore));
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp84_;
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = move;
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = _tmp86_->number;
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if ((_tmp87_ % 2) == 0) {
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp85_ = 'b';
#line 6041 "gnome-chess.c"
	} else {
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp85_ = 'a';
#line 6045 "gnome-chess.c"
	}
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = move;
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = _tmp88_->number;
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = move_text;
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp89_ + 1) / 2), (gint) _tmp85_, _tmp90_);
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	label = _tmp91_;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = model;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = *iter;
#line 1080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp92_, &_tmp93_, 0, label, -1, -1);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (label);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (move_text);
#line 6069 "gnome-chess.c"
}


static void chess_application_game_move_cb (ChessApplication* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ChessMove* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	PGNGame* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	ChessScene* _tmp15_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp16_ = NULL;
	GtkTreeModel* _tmp17_ = NULL;
	GtkTreeModel* _tmp18_ = NULL;
	GtkListStore* _tmp19_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_ = NULL;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_ = NULL;
	GtkTreeIter _tmp23_ = {0};
	ChessMove* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GtkTreeIter _tmp26_ = {0};
	ChessMove* _tmp27_ = NULL;
	ChessMove* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	ChessGame* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	guint _tmp32_ = 0U;
	ChessView* _tmp35_ = NULL;
	ChessEngine* _tmp36_ = NULL;
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 1087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1090 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = TRUE;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = move;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_->number;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ == 1) {
#line 6121 "gnome-chess.c"
		ChessPlayer* _tmp4_ = NULL;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->opponent;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 6127 "gnome-chess.c"
	} else {
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = FALSE;
#line 6131 "gnome-chess.c"
	}
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 6135 "gnome-chess.c"
		ChessPlayer* _tmp5_ = NULL;
		Color _tmp6_ = 0;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->opponent;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_->color;
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp6_ == COLOR_WHITE;
#line 6144 "gnome-chess.c"
	} else {
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6148 "gnome-chess.c"
	}
#line 1093 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 1094 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 6154 "gnome-chess.c"
	}
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = move;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_->number;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->pgn_game;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_->moves;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp8_) > _tmp11_) {
#line 6168 "gnome-chess.c"
		PGNGame* _tmp12_ = NULL;
		ChessMove* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->pgn_game;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = move;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_move_get_san (_tmp13_);
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_->moves = g_list_append (_tmp12_->moves, _tmp14_);
#line 6180 "gnome-chess.c"
	}
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->scene;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp15_, -1);
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->history_combo;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = gtk_combo_box_get_model (_tmp16_);
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = _tmp17_;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_list_store_get_type (), GtkListStore));
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp19_;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = model;
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp20_, &_tmp21_);
#line 1104 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp21_;
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = model;
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = iter;
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = move;
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_->number;
#line 1105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp22_, &_tmp23_, 1, _tmp25_, -1, -1);
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = iter;
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = move;
#line 1106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_move_text (self, &_tmp26_, _tmp27_);
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = move;
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _tmp28_->number;
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = game;
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = chess_game_get_n_moves (_tmp30_);
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_;
#line 1109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp29_) == _tmp32_) {
#line 6230 "gnome-chess.c"
		GtkComboBox* _tmp33_ = NULL;
		GtkTreeIter _tmp34_ = {0};
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = self->priv->history_combo;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = iter;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp33_, &_tmp34_);
#line 6239 "gnome-chess.c"
	}
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 1114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 1116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->view;
#line 1118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp35_);
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->opponent_engine;
#line 1120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp36_ != NULL) {
#line 6259 "gnome-chess.c"
		ChessEngine* _tmp37_ = NULL;
		ChessMove* _tmp38_ = NULL;
		gboolean _tmp39_ = FALSE;
		ChessMove* _tmp40_ = NULL;
		ChessPiece* _tmp41_ = NULL;
		Color _tmp42_ = 0;
		Color _tmp43_ = 0;
		ChessPlayer* _tmp44_ = NULL;
		Color _tmp45_ = 0;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = self->priv->opponent_engine;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = move;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_report_move (_tmp37_, _tmp38_);
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = move;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = _tmp40_->piece;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = chess_piece_get_color (_tmp41_);
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = _tmp42_;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = self->priv->opponent;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = _tmp44_->color;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp43_ != _tmp45_) {
#line 6289 "gnome-chess.c"
			gboolean _tmp46_ = FALSE;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->starting;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = !_tmp46_;
#line 6295 "gnome-chess.c"
		} else {
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = FALSE;
#line 6299 "gnome-chess.c"
		}
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp39_) {
#line 6303 "gnome-chess.c"
			ChessEngine* _tmp47_ = NULL;
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = self->priv->opponent_engine;
#line 1125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_engine_move (_tmp47_);
#line 6309 "gnome-chess.c"
		}
	}
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 6314 "gnome-chess.c"
}


static void chess_application_game_undo_cb (ChessApplication* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	PGNGame* _tmp2_ = NULL;
	PGNGame* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkListStore* _tmp9_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_ = NULL;
	GtkListStore* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	ChessScene* _tmp16_ = NULL;
	GtkListStore* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkTreeIter _tmp20_ = {0};
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	ChessView* _tmp23_ = NULL;
	ChessGame* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 1132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 6355 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 1133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_undo (_tmp1_);
#line 6361 "gnome-chess.c"
	}
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->pgn_game;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_->moves;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = g_list_last (_tmp4_);
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->history_combo;
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_list_store_get_type (), GtkListStore));
#line 1139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp9_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = model;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = model;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp13_;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = model;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = iter;
#line 1142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_remove (_tmp14_, &_tmp15_);
#line 1145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->scene;
#line 1145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp16_, -1);
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = model;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = model;
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp18_, NULL);
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp17_, &_tmp20_, NULL, _tmp19_ - 1);
#line 1148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp20_;
#line 1149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->history_combo;
#line 1149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = iter;
#line 1149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->view;
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp23_);
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = game;
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = chess_game_get_n_moves (_tmp24_);
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _tmp25_;
#line 1152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp26_ > ((guint) 0)) {
#line 1154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = TRUE;
#line 1155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 6437 "gnome-chess.c"
	} else {
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 1161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 1163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 6447 "gnome-chess.c"
	}
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 1168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_headerbar_title (self);
#line 1129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 6457 "gnome-chess.c"
}


static void chess_application_update_action_status (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean can_resign = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ChessGame* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gboolean can_undo = FALSE;
	gboolean _tmp15_ = FALSE;
	ChessPlayer* _tmp16_ = NULL;
	gboolean _tmp26_ = FALSE;
#line 1171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_game_get_n_moves (_tmp1_);
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ > ((guint) 0)) {
#line 6486 "gnome-chess.c"
		ChessGame* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = chess_game_get_is_paused (_tmp4_);
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = !_tmp6_;
#line 6498 "gnome-chess.c"
	} else {
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6502 "gnome-chess.c"
	}
#line 1173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	can_resign = _tmp0_;
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = can_resign;
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 1175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 6512 "gnome-chess.c"
	} else {
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 6516 "gnome-chess.c"
	}
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->game;
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = chess_game_get_n_moves (_tmp9_);
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = _tmp10_;
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_ > ((guint) 0)) {
#line 6526 "gnome-chess.c"
		ChessGame* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_is_paused (_tmp12_);
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = !_tmp14_;
#line 6538 "gnome-chess.c"
	} else {
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = FALSE;
#line 6542 "gnome-chess.c"
	}
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	can_undo = _tmp8_;
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->opponent;
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp16_ != NULL) {
#line 6550 "gnome-chess.c"
		ChessPlayer* _tmp17_ = NULL;
		Color _tmp18_ = 0;
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->opponent;
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_->color;
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp18_ == COLOR_WHITE;
#line 6559 "gnome-chess.c"
	} else {
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = FALSE;
#line 6563 "gnome-chess.c"
	}
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp15_) {
#line 6567 "gnome-chess.c"
		gboolean _tmp19_ = FALSE;
		ChessGame* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->game;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_game_get_n_moves (_tmp20_);
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp22_ > ((guint) 1)) {
#line 6580 "gnome-chess.c"
			ChessGame* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = self->priv->game;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp24_ = chess_game_get_is_paused (_tmp23_);
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp25_ = _tmp24_;
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = !_tmp25_;
#line 6592 "gnome-chess.c"
		} else {
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = FALSE;
#line 6596 "gnome-chess.c"
		}
#line 1182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		can_undo = _tmp19_;
#line 6600 "gnome-chess.c"
	}
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = can_undo;
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp26_) {
#line 1185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_enable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 6608 "gnome-chess.c"
	} else {
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 6612 "gnome-chess.c"
	}
}


static void chess_application_update_headerbar_title (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessPlayer* _tmp2_ = NULL;
#line 1190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->human_player;
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == NULL) {
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = TRUE;
#line 6629 "gnome-chess.c"
	} else {
		ChessPlayer* _tmp3_ = NULL;
		Color _tmp4_ = 0;
		ChessGame* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		ChessPlayer* _tmp7_ = NULL;
		Color _tmp8_ = 0;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->human_player;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->color;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->game;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = chess_game_get_current_player (_tmp5_);
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_->color;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _tmp4_ == _tmp8_;
#line 6651 "gnome-chess.c"
	}
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 6655 "gnome-chess.c"
		ChessGame* _tmp9_ = NULL;
		ChessState* _tmp10_ = NULL;
		ChessState* _tmp11_ = NULL;
		ChessGame* _tmp12_ = NULL;
		ChessPlayer* _tmp13_ = NULL;
		ChessPlayer* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->game;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_game_get_current_state (_tmp9_);
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_current_player (_tmp12_);
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_state_is_in_check (_tmp11_, _tmp14_);
#line 1194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp15_;
#line 6679 "gnome-chess.c"
	} else {
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6683 "gnome-chess.c"
	}
#line 1192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 6687 "gnome-chess.c"
		ChessGame* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
		ChessPlayer* _tmp18_ = NULL;
		Color _tmp19_ = 0;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = chess_game_get_current_player (_tmp16_);
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp18_->color;
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp19_ == COLOR_WHITE) {
#line 6702 "gnome-chess.c"
			GtkHeaderBar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
#line 1198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = self->priv->headerbar;
#line 1198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp21_ = _ ("White is in Check");
#line 1198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_title (_tmp20_, _tmp21_);
#line 6711 "gnome-chess.c"
		} else {
			GtkHeaderBar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = self->priv->headerbar;
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = _ ("Black is in Check");
#line 1201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_title (_tmp22_, _tmp23_);
#line 6721 "gnome-chess.c"
		}
	} else {
		ChessGame* _tmp24_ = NULL;
		ChessPlayer* _tmp25_ = NULL;
		ChessPlayer* _tmp26_ = NULL;
		Color _tmp27_ = 0;
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = self->priv->game;
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = chess_game_get_current_player (_tmp24_);
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_;
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _tmp26_->color;
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp27_ == COLOR_WHITE) {
#line 6738 "gnome-chess.c"
			gboolean _tmp28_ = FALSE;
			ChessPlayer* _tmp29_ = NULL;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = self->priv->human_player;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp29_ == NULL) {
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = TRUE;
#line 6747 "gnome-chess.c"
			} else {
				ChessPlayer* _tmp30_ = NULL;
				Color _tmp31_ = 0;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = self->priv->human_player;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = _tmp30_->color;
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = _tmp31_ == COLOR_WHITE;
#line 6757 "gnome-chess.c"
			}
#line 1205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp28_) {
#line 6761 "gnome-chess.c"
				GtkHeaderBar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = self->priv->headerbar;
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = _ ("White to Move");
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp32_, _tmp33_);
#line 6770 "gnome-chess.c"
			} else {
				GtkHeaderBar* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
#line 1210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = self->priv->headerbar;
#line 1210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = _ ("White is Thinking…");
#line 1210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp34_, _tmp35_);
#line 6780 "gnome-chess.c"
			}
		} else {
			gboolean _tmp36_ = FALSE;
			ChessPlayer* _tmp37_ = NULL;
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp37_ = self->priv->human_player;
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp37_ == NULL) {
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = TRUE;
#line 6791 "gnome-chess.c"
			} else {
				ChessPlayer* _tmp38_ = NULL;
				Color _tmp39_ = 0;
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = self->priv->human_player;
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp38_->color;
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _tmp39_ == COLOR_BLACK;
#line 6801 "gnome-chess.c"
			}
#line 1214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp36_) {
#line 6805 "gnome-chess.c"
				GtkHeaderBar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = self->priv->headerbar;
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = _ ("Black to Move");
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp40_, _tmp41_);
#line 6814 "gnome-chess.c"
			} else {
				GtkHeaderBar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
#line 1219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = self->priv->headerbar;
#line 1219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = _ ("Black is Thinking…");
#line 1219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_header_bar_set_title (_tmp42_, _tmp43_);
#line 6824 "gnome-chess.c"
			}
		}
	}
}


static void chess_application_update_pause_resume_button (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	ChessGame* _tmp1_ = NULL;
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
#line 1223 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ != NULL) {
#line 6842 "gnome-chess.c"
		ChessGame* _tmp2_ = NULL;
		ChessClock* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = chess_game_get_clock (_tmp2_);
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp4_ == NULL;
#line 6854 "gnome-chess.c"
	} else {
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6858 "gnome-chess.c"
	}
#line 1225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 6862 "gnome-chess.c"
		GtkButton* _tmp5_ = NULL;
#line 1226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->pause_resume_button;
#line 1226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_hide ((GtkWidget*) _tmp5_);
#line 6868 "gnome-chess.c"
	} else {
		GtkButton* _tmp6_ = NULL;
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->pause_resume_button;
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_show ((GtkWidget*) _tmp6_);
#line 6875 "gnome-chess.c"
	}
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->game;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ != NULL) {
#line 6881 "gnome-chess.c"
		ChessGame* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->game;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_game_get_is_paused (_tmp9_);
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp11_;
#line 6893 "gnome-chess.c"
	} else {
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = FALSE;
#line 6897 "gnome-chess.c"
	}
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 6901 "gnome-chess.c"
		GtkButton* _tmp12_ = NULL;
		GtkImage* _tmp13_ = NULL;
		GtkImage* _tmp14_ = NULL;
		GtkButton* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->pause_resume_button;
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-start-symbolic", GTK_ICON_SIZE_BUTTON);
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_ref_sink (_tmp13_);
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_button_set_image (_tmp12_, (GtkWidget*) _tmp14_);
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp14_);
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->pause_resume_button;
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _ ("Unpause the game");
#line 1234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp16_);
#line 6925 "gnome-chess.c"
	} else {
		GtkButton* _tmp17_ = NULL;
		GtkImage* _tmp18_ = NULL;
		GtkImage* _tmp19_ = NULL;
		GtkButton* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pause_resume_button;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playback-pause-symbolic", GTK_ICON_SIZE_BUTTON);
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_object_ref_sink (_tmp18_);
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp18_;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_button_set_image (_tmp17_, (GtkWidget*) _tmp19_);
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_tmp19_);
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->pause_resume_button;
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = _ ("Pause the game");
#line 1240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp20_, _tmp21_);
#line 6950 "gnome-chess.c"
	}
}


static void chess_application_game_end_cb (ChessApplication* self) {
	ChessEngine* _tmp0_ = NULL;
	gchar* title = NULL;
	gchar* _tmp2_ = NULL;
	ChessGame* _tmp3_ = NULL;
	ChessResult _tmp4_ = 0;
	gchar* reason = NULL;
	gchar* _tmp19_ = NULL;
	ChessGame* _tmp20_ = NULL;
	ChessRule _tmp21_ = 0;
	GtkHeaderBar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	GtkHeaderBar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	GtkWidget* _tmp70_ = NULL;
	GtkWidget* _tmp71_ = NULL;
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_RESIGN_ACTION_NAME);
#line 1247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_UNDO_MOVE_ACTION_NAME);
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_PAUSE_RESUME_ACTION_NAME);
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 1253 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = FALSE;
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 6987 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp1_, TRUE);
#line 6993 "gnome-chess.c"
	}
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_strdup ("");
#line 1258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	title = _tmp2_;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->game;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_->result;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp4_) {
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_WHITE_WON:
#line 7007 "gnome-chess.c"
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			PGNGame* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = _ ("White Wins");
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = g_strdup (_tmp5_);
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1263 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp6_;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = self->priv->pgn_game;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = pgn_game_RESULT_WHITE;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp7_, _tmp8_);
#line 1265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7029 "gnome-chess.c"
		}
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BLACK_WON:
#line 7033 "gnome-chess.c"
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			PGNGame* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = _ ("Black Wins");
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp10_;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->pgn_game;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = pgn_game_RESULT_BLACK;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp11_, _tmp12_);
#line 1270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7055 "gnome-chess.c"
		}
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_DRAW:
#line 7059 "gnome-chess.c"
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			PGNGame* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = _ ("Game is Drawn");
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1273 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp14_;
#line 1274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = self->priv->pgn_game;
#line 1274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = pgn_game_RESULT_DRAW;
#line 1274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp15_, _tmp16_);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7081 "gnome-chess.c"
		}
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BUG:
#line 7085 "gnome-chess.c"
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = _ ("Oops! Something has gone wrong.");
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			title = _tmp18_;
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7099 "gnome-chess.c"
		}
		default:
		{
#line 1289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7105 "gnome-chess.c"
		}
	}
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = g_strdup ("");
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	reason = _tmp19_;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->game;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = _tmp20_->rule;
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp21_) {
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_CHECKMATE:
#line 7120 "gnome-chess.c"
		{
			ChessGame* _tmp22_ = NULL;
			ChessResult _tmp23_ = 0;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = self->priv->game;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = _tmp22_->result;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp23_ == CHESS_RESULT_WHITE_WON) {
#line 7130 "gnome-chess.c"
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = _ ("Black is in check and cannot move.");
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = g_strdup (_tmp24_);
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				reason = _tmp25_;
#line 7141 "gnome-chess.c"
			} else {
				ChessGame* _tmp26_ = NULL;
				ChessResult _tmp27_ = 0;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = self->priv->game;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = _tmp26_->result;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp27_ == CHESS_RESULT_BLACK_WON) {
#line 7151 "gnome-chess.c"
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = _ ("White is in check and cannot move.");
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp29_ = g_strdup (_tmp28_);
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1301 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					reason = _tmp29_;
#line 7162 "gnome-chess.c"
				} else {
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 7166 "gnome-chess.c"
				}
			}
#line 1304 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7171 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_STALEMATE:
#line 7175 "gnome-chess.c"
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _ ("Opponent cannot move.");
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1307 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp31_;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7189 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_FIFTY_MOVES:
#line 7193 "gnome-chess.c"
		{
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _ ("No piece was taken or pawn moved in fifty moves.");
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_tmp32_);
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp33_;
#line 1312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7207 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_TIMEOUT:
#line 7211 "gnome-chess.c"
		{
			ChessGame* _tmp34_ = NULL;
			ChessResult _tmp35_ = 0;
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = self->priv->game;
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = _tmp34_->result;
#line 1314 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp35_ == CHESS_RESULT_WHITE_WON) {
#line 7221 "gnome-chess.c"
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _ ("Black has run out of time.");
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = g_strdup (_tmp36_);
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				reason = _tmp37_;
#line 7232 "gnome-chess.c"
			} else {
				ChessGame* _tmp38_ = NULL;
				ChessResult _tmp39_ = 0;
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = self->priv->game;
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp38_->result;
#line 1317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp39_ == CHESS_RESULT_BLACK_WON) {
#line 7242 "gnome-chess.c"
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp40_ = _ ("White has run out of time.");
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp41_ = g_strdup (_tmp40_);
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					reason = _tmp41_;
#line 7253 "gnome-chess.c"
				} else {
#line 1321 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 7257 "gnome-chess.c"
				}
			}
#line 1322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7262 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_THREE_FOLD_REPETITION:
#line 7266 "gnome-chess.c"
		{
			const gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = _ ("The same board state has occurred three times.");
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = g_strdup (_tmp42_);
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp43_;
#line 1326 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7280 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
#line 7284 "gnome-chess.c"
		{
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = _ ("Neither player can checkmate.");
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = g_strdup (_tmp44_);
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp45_;
#line 1330 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7298 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_RESIGN:
#line 7302 "gnome-chess.c"
		{
			ChessGame* _tmp46_ = NULL;
			ChessResult _tmp47_ = 0;
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->game;
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = _tmp46_->result;
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp47_ == CHESS_RESULT_WHITE_WON) {
#line 7312 "gnome-chess.c"
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = _ ("Black has resigned.");
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = g_strdup (_tmp48_);
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				reason = _tmp49_;
#line 7323 "gnome-chess.c"
			} else {
				ChessGame* _tmp50_ = NULL;
				ChessResult _tmp51_ = 0;
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = self->priv->game;
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = _tmp50_->result;
#line 1335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp51_ == CHESS_RESULT_BLACK_WON) {
#line 7333 "gnome-chess.c"
					const gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp52_ = _ ("White has resigned.");
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp53_ = g_strdup (_tmp52_);
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_g_free0 (reason);
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					reason = _tmp53_;
#line 7344 "gnome-chess.c"
				} else {
#line 1339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					g_assert_not_reached ();
#line 7348 "gnome-chess.c"
				}
			}
#line 1340 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7353 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_ABANDONMENT:
#line 7357 "gnome-chess.c"
		{
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			PGNGame* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp54_ = _ ("The game has been abandoned.");
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp55_ = g_strdup (_tmp54_);
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp55_;
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp56_ = self->priv->pgn_game;
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp57_ = pgn_game_TERMINATE_ABANDONED;
#line 1344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp56_, _tmp57_);
#line 1345 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7379 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_DEATH:
#line 7383 "gnome-chess.c"
		{
			const gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			PGNGame* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp58_ = _ ("The game log says a player died!");
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp59_ = g_strdup (_tmp58_);
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp59_;
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp60_ = self->priv->pgn_game;
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp61_ = pgn_game_TERMINATE_DEATH;
#line 1350 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp60_, _tmp61_);
#line 1351 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7405 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_BUG:
#line 7409 "gnome-chess.c"
		{
			const gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp62_ = _ ("The computer player is confused. The game cannot continue.");
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp63_ = g_strdup (_tmp62_);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp63_;
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7423 "gnome-chess.c"
		}
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_UNKNOWN:
#line 7427 "gnome-chess.c"
		{
			GFile* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp64_ = self->priv->game_file;
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp65_ = g_file_get_basename (_tmp64_);
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1362 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp65_;
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 7441 "gnome-chess.c"
		}
		default:
#line 1293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		break;
#line 7446 "gnome-chess.c"
	}
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = self->priv->headerbar;
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = title;
#line 1366 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_header_bar_set_title (_tmp66_, _tmp67_);
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = self->priv->headerbar;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = reason;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_header_bar_set_subtitle (_tmp68_, _tmp69_);
#line 1369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = self->priv->white_time_label;
#line 1369 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp70_);
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = self->priv->black_time_label;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp71_);
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (reason);
#line 1244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (title);
#line 7472 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1374 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1376 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_game (self);
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7490 "gnome-chess.c"
}


static gboolean chess_application_prompt_save_game (ChessApplication* self, const gchar* prompt_text) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ChessGame* _tmp6_ = NULL;
	ChessResult _tmp7_ = 0;
	gint _result_ = 0;
	GtkMessageDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GtkMessageDialog* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gint _tmp20_ = 0;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (prompt_text != NULL, FALSE);
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game_needs_saving;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 1383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = TRUE;
#line 1383 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7523 "gnome-chess.c"
	}
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = prompt_text;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp2_);
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp3_);
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp3_;
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = dialog;
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _ ("_Cancel");
#line 1390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp4_, _tmp5_, (gint) GTK_RESPONSE_CANCEL);
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->game;
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_->result;
#line 1392 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ == CHESS_RESULT_IN_PROGRESS) {
#line 7547 "gnome-chess.c"
		GtkMessageDialog* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkMessageDialog* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = dialog;
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _ ("_Abandon game");
#line 1394 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp8_, _tmp9_, (gint) GTK_RESPONSE_NO);
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = dialog;
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _ ("_Save game for later");
#line 1395 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_YES);
#line 7564 "gnome-chess.c"
	} else {
		GtkMessageDialog* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 1399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = dialog;
#line 1399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _ ("_Discard game");
#line 1399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp12_, _tmp13_, (gint) GTK_RESPONSE_NO);
#line 1400 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = dialog;
#line 1400 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _ ("_Save game log");
#line 1400 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp14_, _tmp15_, (gint) GTK_RESPONSE_YES);
#line 7582 "gnome-chess.c"
	}
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = dialog;
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = gtk_dialog_run ((GtkDialog*) _tmp16_);
#line 1403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_result_ = _tmp17_;
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = dialog;
#line 1404 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp18_);
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _result_;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp20_ == ((gint) GTK_RESPONSE_CANCEL)) {
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = TRUE;
#line 7600 "gnome-chess.c"
	} else {
		gint _tmp21_ = 0;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = _result_;
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp21_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 7607 "gnome-chess.c"
	}
#line 1406 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp19_) {
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = FALSE;
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (dialog);
#line 1408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7617 "gnome-chess.c"
	} else {
		gint _tmp22_ = 0;
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _result_;
#line 1410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp22_ == ((gint) GTK_RESPONSE_YES)) {
#line 7624 "gnome-chess.c"
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
#line 1413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = _ ("_Discard");
#line 1413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp24_ = _ ("_Save");
#line 1413 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_present_save_dialog (self, _tmp23_, _tmp24_);
#line 7633 "gnome-chess.c"
		} else {
			gint _tmp25_ = 0;
#line 1417 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp25_ = _result_;
#line 1417 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warn_if_fail (_tmp25_ == ((gint) GTK_RESPONSE_NO));
#line 1419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 1420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_autosave (self);
#line 7644 "gnome-chess.c"
		}
	}
#line 1423 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 1423 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 1423 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7653 "gnome-chess.c"
}


static void chess_application_present_claim_draw_dialog (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ChessGame* _tmp2_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_ = NULL;
	gchar* reason = NULL;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkMessageDialog* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkMessageDialog* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	GtkMessageDialog* _tmp22_ = NULL;
	gint _tmp23_ = 0;
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_can_claim_draw (_tmp0_);
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_return_if_fail (_tmp1_, "game.can_claim_draw ()");
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->game;
#line 1429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_pause (_tmp2_, FALSE);
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _ ("Would you like to claim a draw?");
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp4_);
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp5_);
#line 1431 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp5_;
#line 1439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->game;
#line 1439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_game_is_fifty_move_rule_fulfilled (_tmp6_);
#line 1439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 7707 "gnome-chess.c"
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _ ("Fifty moves have passed without a capture or pawn advancement.");
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (reason);
#line 1442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		reason = _tmp9_;
#line 7718 "gnome-chess.c"
	} else {
		ChessGame* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->game;
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_game_is_three_fold_repeat (_tmp10_);
#line 1444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp11_) {
#line 7728 "gnome-chess.c"
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = _ ("The current board position has occurred three times.");
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1447 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			reason = _tmp13_;
#line 7739 "gnome-chess.c"
		} else {
#line 1449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_assert_not_reached ();
#line 7743 "gnome-chess.c"
		}
	}
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = dialog;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = reason;
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("(You will not be offered this choice again.)");
#line 1451 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_message_dialog_format_secondary_text (_tmp14_, "%s\n%s", _tmp15_, _tmp16_);
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = dialog;
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = _ ("_Keep Playing");
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _ ("_Claim Draw");
#line 1455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp17_, _tmp18_, GTK_RESPONSE_REJECT, _tmp19_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = dialog;
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_dialog_run ((GtkDialog*) _tmp20_);
#line 1461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	response = _tmp21_;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = dialog;
#line 1462 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp22_);
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = response;
#line 1464 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp23_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 7776 "gnome-chess.c"
		ChessGame* _tmp24_ = NULL;
		ChessPlayer* _tmp25_ = NULL;
		ChessPlayer* _tmp26_ = NULL;
#line 1466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = self->priv->game;
#line 1466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = chess_game_get_current_player (_tmp24_);
#line 1466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_;
#line 1466 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_claim_draw (_tmp26_);
#line 7788 "gnome-chess.c"
	} else {
		ChessGame* _tmp27_ = NULL;
#line 1471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->allow_claim_draw_dialog = FALSE;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = self->priv->game;
#line 1472 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp27_);
#line 7797 "gnome-chess.c"
	}
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (reason);
#line 1426 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 7803 "gnome-chess.c"
}


void chess_application_new_game_cb (ChessApplication* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1476 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Save this game before starting a new one?");
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_prompt_save_game (self, _tmp0_);
#line 1478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 1479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_start_new_game (self);
#line 7820 "gnome-chess.c"
	}
}


void chess_application_resign_cb (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	GtkMessageDialog* dialog = NULL;
	GtkApplicationWindow* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint response = 0;
	GtkMessageDialog* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkMessageDialog* _tmp11_ = NULL;
	gint _tmp12_ = 0;
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1484 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_game_pause (_tmp0_, FALSE);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _ ("Are you sure you want to resign?");
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp2_);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp3_);
#line 1486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp3_;
#line 1492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = dialog;
#line 1492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _ ("This makes sense if you plan to save the game as a record of your loss" \
".");
#line 1492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_message_dialog_format_secondary_text (_tmp4_, "%s", _tmp5_);
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = dialog;
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("_Keep Playing");
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _ ("_Resign");
#line 1495 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp6_, _tmp7_, GTK_RESPONSE_REJECT, _tmp8_, GTK_RESPONSE_ACCEPT, NULL, NULL);
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = dialog;
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_dialog_run ((GtkDialog*) _tmp9_);
#line 1501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	response = _tmp10_;
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = dialog;
#line 1502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = response;
#line 1504 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 7885 "gnome-chess.c"
		ChessPlayer* _tmp13_ = NULL;
#line 1506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->human_player;
#line 1506 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp13_ != NULL) {
#line 7891 "gnome-chess.c"
			ChessPlayer* _tmp14_ = NULL;
#line 1507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = self->priv->human_player;
#line 1507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_resign (_tmp14_);
#line 7897 "gnome-chess.c"
		} else {
			ChessGame* _tmp15_ = NULL;
			ChessPlayer* _tmp16_ = NULL;
			ChessPlayer* _tmp17_ = NULL;
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = self->priv->game;
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = chess_game_get_current_player (_tmp15_);
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = _tmp16_;
#line 1509 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_player_resign (_tmp17_);
#line 7910 "gnome-chess.c"
		}
	} else {
		ChessGame* _tmp18_ = NULL;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game;
#line 1513 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp18_);
#line 7918 "gnome-chess.c"
	}
#line 1482 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 7922 "gnome-chess.c"
}


void chess_application_undo_move_cb (ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
#line 1517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1520 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_->selected_rank = -1;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 1521 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_->selected_file = -1;
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->opponent;
#line 1523 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 7944 "gnome-chess.c"
		ChessPlayer* _tmp3_ = NULL;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->human_player;
#line 1524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp3_);
#line 7950 "gnome-chess.c"
	} else {
		ChessGame* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = chess_game_get_opponent (_tmp4_);
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = _tmp5_;
#line 1526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp6_);
#line 7963 "gnome-chess.c"
	}
}


void chess_application_pause_resume_cb (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 1529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1531 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 7982 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp3_);
#line 7988 "gnome-chess.c"
	} else {
		ChessGame* _tmp4_ = NULL;
#line 1534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1534 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_game_pause (_tmp4_, TRUE);
#line 7995 "gnome-chess.c"
	}
#line 1536 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pause_resume_button (self);
#line 1537 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_history_panel (self);
#line 1538 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_action_status (self);
#line 8003 "gnome-chess.c"
}


void chess_application_quit_cb (ChessApplication* self) {
#line 1541 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1543 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_quit_game (self);
#line 8012 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 1547 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1547 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1547 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 0.0;
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 0.0;
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 0.0;
#line 1549 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 1.0;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 1.0;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 1.0;
#line 1550 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_WHITE);
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1552 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1553 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 8073 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, ChessApplication* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1557 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 1.0;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 1.0;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 1.0;
#line 1559 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 0.0;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 0.0;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 0.0;
#line 1560 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = chess_application_make_clock_text (self, _tmp6_, COLOR_BLACK);
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1562 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1563 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 8134 "gnome-chess.c"
}


static gchar* chess_application_make_clock_text (ChessApplication* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_ = NULL;
	gint time = 0;
	Color _tmp2_ = 0;
	gint _tmp33_ = 0;
#line 1566 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1568 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = clock;
#line 1568 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 8150 "gnome-chess.c"
		gchar* _tmp1_ = NULL;
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = g_strdup ("∞");
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = _tmp1_;
#line 1569 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 8158 "gnome-chess.c"
	}
#line 1572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = color;
#line 1572 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 8164 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessClock* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		ChessGame* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		ChessClock* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		ChessGame* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		ChessClock* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = chess_game_get_clock (_tmp3_);
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = chess_clock_get_white_initial_seconds (_tmp5_);
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_get_clock (_tmp8_);
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_clock_get_white_seconds_used (_tmp10_);
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->game;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_game_get_clock (_tmp13_);
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = chess_clock_get_white_extra_seconds (_tmp15_);
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 1573 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		time = (_tmp7_ - _tmp12_) + _tmp17_;
#line 8212 "gnome-chess.c"
	} else {
		ChessGame* _tmp18_ = NULL;
		ChessClock* _tmp19_ = NULL;
		ChessClock* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		ChessGame* _tmp23_ = NULL;
		ChessClock* _tmp24_ = NULL;
		ChessClock* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		ChessGame* _tmp28_ = NULL;
		ChessClock* _tmp29_ = NULL;
		ChessClock* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = chess_game_get_clock (_tmp18_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_clock_get_black_initial_seconds (_tmp20_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = self->priv->game;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = chess_game_get_clock (_tmp23_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _tmp24_;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = chess_clock_get_black_seconds_used (_tmp25_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _tmp26_;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->game;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = chess_game_get_clock (_tmp28_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = chess_clock_get_black_extra_seconds (_tmp30_);
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = _tmp31_;
#line 1575 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		time = (_tmp22_ - _tmp27_) + _tmp32_;
#line 8261 "gnome-chess.c"
	}
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = time;
#line 1577 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp33_ >= 60) {
#line 8267 "gnome-chess.c"
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gchar* _tmp36_ = NULL;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = time;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = time;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = g_strdup_printf ("%d∶\xE2\x80\x8E%02d", _tmp34_ / 60, _tmp35_ % 60);
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = _tmp36_;
#line 1578 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 8281 "gnome-chess.c"
	} else {
		gint _tmp37_ = 0;
		gchar* _tmp38_ = NULL;
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = time;
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = g_strdup_printf ("∶\xE2\x80\x8E%02d", _tmp37_);
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = _tmp38_;
#line 1580 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 8293 "gnome-chess.c"
	}
}


static gint chess_application_compute_time_label_width_request (ChessApplication* self, cairo_t* c) {
	gint result = 0;
	cairo_text_extents_t extents = {0};
	gdouble max = 0.0;
	cairo_t* _tmp0_ = NULL;
	cairo_text_extents_t _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	cairo_text_extents_t _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	cairo_t* _tmp9_ = NULL;
	cairo_text_extents_t _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_text_extents_t _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	cairo_t* _tmp18_ = NULL;
	cairo_text_extents_t _tmp19_ = {0};
	gdouble _tmp20_ = 0.0;
	gdouble _tmp21_ = 0.0;
	cairo_text_extents_t _tmp22_ = {0};
	gdouble _tmp23_ = 0.0;
	cairo_t* _tmp27_ = NULL;
	cairo_text_extents_t _tmp28_ = {0};
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	cairo_t* _tmp36_ = NULL;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	cairo_text_extents_t _tmp40_ = {0};
	gdouble _tmp41_ = 0.0;
	cairo_t* _tmp45_ = NULL;
	cairo_text_extents_t _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_text_extents_t _tmp49_ = {0};
	gdouble _tmp50_ = 0.0;
	cairo_t* _tmp54_ = NULL;
	cairo_text_extents_t _tmp55_ = {0};
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_ = 0.0;
	cairo_text_extents_t _tmp58_ = {0};
	gdouble _tmp59_ = 0.0;
	cairo_t* _tmp63_ = NULL;
	cairo_text_extents_t _tmp64_ = {0};
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_ = 0.0;
	cairo_text_extents_t _tmp67_ = {0};
	gdouble _tmp68_ = 0.0;
	cairo_t* _tmp72_ = NULL;
	cairo_text_extents_t _tmp73_ = {0};
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_ = 0.0;
	cairo_text_extents_t _tmp76_ = {0};
	gdouble _tmp77_ = 0.0;
	cairo_t* _tmp81_ = NULL;
	cairo_text_extents_t _tmp82_ = {0};
	gdouble _tmp83_ = 0.0;
	gdouble _tmp84_ = 0.0;
	cairo_text_extents_t _tmp85_ = {0};
	gdouble _tmp86_ = 0.0;
	gdouble _tmp90_ = 0.0;
	gdouble _tmp91_ = 0.0;
	gint _tmp92_ = 0;
	gint _tmp93_ = 0;
#line 1588 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1588 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, 0);
#line 1592 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = (gdouble) 0;
#line 1594 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = c;
#line 1594 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp0_, "000∶00", &_tmp1_);
#line 1594 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp1_;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = max;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = extents;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_.width;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ > _tmp5_) {
#line 8386 "gnome-chess.c"
		gdouble _tmp6_ = 0.0;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = max;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = _tmp6_;
#line 8392 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = extents;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_.width;
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = _tmp8_;
#line 8402 "gnome-chess.c"
	}
#line 1595 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp2_;
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = c;
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp9_, "111∶11", &_tmp10_);
#line 1596 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp10_;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = max;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = extents;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_.width;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > _tmp14_) {
#line 8420 "gnome-chess.c"
		gdouble _tmp15_ = 0.0;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = max;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp15_;
#line 8426 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp16_ = {0};
		gdouble _tmp17_ = 0.0;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = extents;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_.width;
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp17_;
#line 8436 "gnome-chess.c"
	}
#line 1597 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp11_;
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = c;
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp18_, "222∶22", &_tmp19_);
#line 1598 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp19_;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = max;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = extents;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _tmp22_.width;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ > _tmp23_) {
#line 8454 "gnome-chess.c"
		gdouble _tmp24_ = 0.0;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = max;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp24_;
#line 8460 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp25_ = {0};
		gdouble _tmp26_ = 0.0;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = extents;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_.width;
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp26_;
#line 8470 "gnome-chess.c"
	}
#line 1599 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp20_;
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = c;
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp27_, "333∶33", &_tmp28_);
#line 1600 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp28_;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = max;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = extents;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_.width;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp30_ > _tmp32_) {
#line 8488 "gnome-chess.c"
		gdouble _tmp33_ = 0.0;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = max;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp33_;
#line 8494 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp34_ = {0};
		gdouble _tmp35_ = 0.0;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = extents;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = _tmp34_.width;
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp35_;
#line 8504 "gnome-chess.c"
	}
#line 1601 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp29_;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = c;
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp36_, "444∶44", &_tmp37_);
#line 1602 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp37_;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = max;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = extents;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _tmp40_.width;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp39_ > _tmp41_) {
#line 8522 "gnome-chess.c"
		gdouble _tmp42_ = 0.0;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = max;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp42_;
#line 8528 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp43_ = {0};
		gdouble _tmp44_ = 0.0;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = extents;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = _tmp43_.width;
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _tmp44_;
#line 8538 "gnome-chess.c"
	}
#line 1603 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp38_;
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = c;
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp45_, "555∶55", &_tmp46_);
#line 1604 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp46_;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = max;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = extents;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = _tmp49_.width;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp48_ > _tmp50_) {
#line 8556 "gnome-chess.c"
		gdouble _tmp51_ = 0.0;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp51_ = max;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = _tmp51_;
#line 8562 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp52_ = {0};
		gdouble _tmp53_ = 0.0;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp52_ = extents;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = _tmp52_.width;
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = _tmp53_;
#line 8572 "gnome-chess.c"
	}
#line 1605 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp47_;
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = c;
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp54_, "666∶66", &_tmp55_);
#line 1606 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp55_;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = max;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = extents;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = _tmp58_.width;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp57_ > _tmp59_) {
#line 8590 "gnome-chess.c"
		gdouble _tmp60_ = 0.0;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp60_ = max;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = _tmp60_;
#line 8596 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp61_ = {0};
		gdouble _tmp62_ = 0.0;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = extents;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = _tmp61_.width;
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = _tmp62_;
#line 8606 "gnome-chess.c"
	}
#line 1607 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp56_;
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = c;
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp63_, "777∶77", &_tmp64_);
#line 1608 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp64_;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = max;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = extents;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = _tmp67_.width;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp66_ > _tmp68_) {
#line 8624 "gnome-chess.c"
		gdouble _tmp69_ = 0.0;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = max;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = _tmp69_;
#line 8630 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp70_ = {0};
		gdouble _tmp71_ = 0.0;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = extents;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = _tmp70_.width;
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = _tmp71_;
#line 8640 "gnome-chess.c"
	}
#line 1609 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp65_;
#line 1610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = c;
#line 1610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp72_, "888∶88", &_tmp73_);
#line 1610 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp73_;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = max;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = extents;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = _tmp76_.width;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp75_ > _tmp77_) {
#line 8658 "gnome-chess.c"
		gdouble _tmp78_ = 0.0;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp78_ = max;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp74_ = _tmp78_;
#line 8664 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp79_ = {0};
		gdouble _tmp80_ = 0.0;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp79_ = extents;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp80_ = _tmp79_.width;
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp74_ = _tmp80_;
#line 8674 "gnome-chess.c"
	}
#line 1611 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp74_;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = c;
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp81_, "999∶99", &_tmp82_);
#line 1612 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp82_;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = max;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = extents;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = _tmp85_.width;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp84_ > _tmp86_) {
#line 8692 "gnome-chess.c"
		gdouble _tmp87_ = 0.0;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp87_ = max;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp83_ = _tmp87_;
#line 8698 "gnome-chess.c"
	} else {
		cairo_text_extents_t _tmp88_ = {0};
		gdouble _tmp89_ = 0.0;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp88_ = extents;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp89_ = _tmp88_.width;
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp83_ = _tmp89_;
#line 8708 "gnome-chess.c"
	}
#line 1613 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max = _tmp83_;
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = max;
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = ceil (_tmp90_);
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = ((gint) _tmp91_) + 6;
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = result;
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_warn_if_fail (_tmp92_ > 0, "result > 0");
#line 1616 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 8724 "gnome-chess.c"
}


static void chess_application_draw_time (ChessApplication* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha = 0.0;
	GtkWidget* _tmp0_ = NULL;
	GtkStateFlags _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	gdouble* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gdouble _tmp4_ = 0.0;
	gdouble* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gdouble _tmp6_ = 0.0;
	gdouble* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gdouble* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gdouble _tmp13_ = 0.0;
	gdouble* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gdouble _tmp15_ = 0.0;
	gdouble* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_text_extents_t _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	GtkWidget* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	cairo_text_extents_t _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	cairo_t* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gint width = 0;
	GtkWidget* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (c != NULL);
#line 1619 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (text != NULL);
#line 1621 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	alpha = 1.0;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_widget_get_state_flags (_tmp0_);
#line 1623 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if ((_tmp1_ & GTK_STATE_FLAG_INSENSITIVE) != 0) {
#line 1624 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		alpha = 0.5;
#line 8800 "gnome-chess.c"
	}
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = c;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = bg;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3__length1 = bg_length1;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_[0];
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = bg;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5__length1 = bg_length1;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_[1];
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = bg;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7__length1 = bg_length1;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_[2];
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = alpha;
#line 1625 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
#line 1626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = c;
#line 1626 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_paint (_tmp10_);
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = c;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = fg;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12__length1 = fg_length1;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_[0];
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = fg;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14__length1 = fg_length1;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _tmp14_[1];
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = fg;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16__length1 = fg_length1;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_[2];
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = alpha;
#line 1628 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = c;
#line 1629 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = c;
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = widget;
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
#line 1630 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = c;
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = text;
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
#line 1632 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	extents = _tmp25_;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = c;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = widget;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = extents;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_.width;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = extents;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_.x_bearing;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = widget;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = extents;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = _tmp35_.height;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = extents;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_.y_bearing;
#line 1633 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = c;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = text;
#line 1635 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	cairo_show_text (_tmp39_, _tmp40_);
#line 1638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = widget;
#line 1638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_get_size_request (_tmp41_, &_tmp42_, NULL);
#line 1638 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	width = _tmp42_;
#line 1639 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = width;
#line 1639 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp43_ == -1) {
#line 8918 "gnome-chess.c"
		GtkWidget* _tmp44_ = NULL;
		cairo_t* _tmp45_ = NULL;
		gint _tmp46_ = 0;
#line 1640 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = widget;
#line 1640 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = c;
#line 1640 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp46_ = chess_application_compute_time_label_width_request (self, _tmp45_);
#line 1640 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_size_request (_tmp44_, _tmp46_, -1);
#line 8930 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint move_number = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
	ChessScene* _tmp13_ = NULL;
	gint _tmp14_ = 0;
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1644 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1647 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1648 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 8963 "gnome-chess.c"
	}
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1650 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->game;
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ == NULL) {
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 8981 "gnome-chess.c"
	} else {
		gint _tmp9_ = 0;
		ChessGame* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = move_number;
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->game;
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
#line 8997 "gnome-chess.c"
	}
#line 1651 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 1652 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		move_number = -1;
#line 9003 "gnome-chess.c"
	}
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->scene;
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = move_number;
#line 1653 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp13_, _tmp14_);
#line 9011 "gnome-chess.c"
}


void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
#line 1657 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1657 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1659 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, -1);
#line 9025 "gnome-chess.c"
}


void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint move_number = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ChessGame* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
#line 1663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1663 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1665 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == -1) {
#line 1666 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9055 "gnome-chess.c"
	}
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1668 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp5_ + 1;
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = move_number;
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->game;
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 1669 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp6_) >= _tmp9_) {
#line 9075 "gnome-chess.c"
		ChessScene* _tmp10_ = NULL;
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1670 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, -1);
#line 9081 "gnome-chess.c"
	} else {
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 1672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = move_number;
#line 1672 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp11_, _tmp12_);
#line 9091 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 1676 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1676 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1678 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == 0) {
#line 1679 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9117 "gnome-chess.c"
	}
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1681 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_ == -1) {
#line 9127 "gnome-chess.c"
		ChessScene* _tmp6_ = NULL;
		ChessGame* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->scene;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 1682 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
#line 9142 "gnome-chess.c"
	} else {
		ChessScene* _tmp10_ = NULL;
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 1684 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
#line 9158 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, ChessApplication* self) {
	ChessScene* _tmp0_ = NULL;
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1688 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1690 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, 0);
#line 9173 "gnome-chess.c"
}


void chess_application_preferences_cb (ChessApplication* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkBuilder* preferences_builder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkDialog* _tmp6_ = NULL;
	GtkApplicationWindow* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	GtkBuilder* _tmp9_ = NULL;
	GObject* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	GtkBuilder* _tmp12_ = NULL;
	GObject* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkComboBox* _tmp16_ = NULL;
	GtkComboBox* _tmp17_ = NULL;
	GSettings* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkComboBox* ai_combo = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GtkComboBox* _tmp22_ = NULL;
	GtkListStore* ai_model = NULL;
	GtkComboBox* _tmp23_ = NULL;
	GtkTreeModel* _tmp24_ = NULL;
	GtkTreeModel* _tmp25_ = NULL;
	GtkListStore* _tmp26_ = NULL;
	gchar* opponent_name = NULL;
	GSettings* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GList* _tmp31_ = NULL;
	GtkComboBox* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkComboBox* _tmp60_ = NULL;
	GtkComboBox* _tmp61_ = NULL;
	GSettings* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	GtkBuilder* _tmp65_ = NULL;
	GObject* _tmp66_ = NULL;
	GtkComboBox* _tmp67_ = NULL;
	GtkBuilder* _tmp68_ = NULL;
	GObject* _tmp69_ = NULL;
	GtkComboBox* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	GObject* _tmp72_ = NULL;
	GtkAdjustment* _tmp73_ = NULL;
	GtkBuilder* _tmp74_ = NULL;
	GObject* _tmp75_ = NULL;
	GtkAdjustment* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	GObject* _tmp78_ = NULL;
	GtkBox* _tmp79_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkBox* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	GObject* _tmp84_ = NULL;
	GtkComboBox* _tmp85_ = NULL;
	GSettings* _tmp86_ = NULL;
	gint _tmp87_ = 0;
	GtkBuilder* _tmp88_ = NULL;
	GObject* _tmp89_ = NULL;
	GtkWidget* _tmp90_ = NULL;
	GtkBuilder* _tmp91_ = NULL;
	GObject* _tmp92_ = NULL;
	GtkComboBox* _tmp93_ = NULL;
	PGNGame* _tmp94_ = NULL;
	const gchar* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	PGNGame* _tmp105_ = NULL;
	const gchar* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	GtkComboBox* orientation_combo = NULL;
	GtkBuilder* _tmp114_ = NULL;
	GObject* _tmp115_ = NULL;
	GtkComboBox* _tmp116_ = NULL;
	GtkComboBox* _tmp117_ = NULL;
	GSettings* _tmp118_ = NULL;
	gchar* _tmp119_ = NULL;
	gchar* _tmp120_ = NULL;
	GtkComboBox* move_combo = NULL;
	GtkBuilder* _tmp121_ = NULL;
	GObject* _tmp122_ = NULL;
	GtkComboBox* _tmp123_ = NULL;
	GtkComboBox* _tmp124_ = NULL;
	GSettings* _tmp125_ = NULL;
	gchar* _tmp126_ = NULL;
	gchar* _tmp127_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkBuilder* _tmp128_ = NULL;
	GObject* _tmp129_ = NULL;
	GtkComboBox* _tmp130_ = NULL;
	GtkComboBox* _tmp131_ = NULL;
	GSettings* _tmp132_ = NULL;
	gchar* _tmp133_ = NULL;
	gchar* _tmp134_ = NULL;
	GtkBuilder* _tmp135_ = NULL;
	GtkComboBox* _tmp136_ = NULL;
	gint _tmp137_ = 0;
	GtkDialog* _tmp140_ = NULL;
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 1695 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 9290 "gnome-chess.c"
		GtkDialog* _tmp1_ = NULL;
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->preferences_dialog;
#line 1697 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 1698 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9298 "gnome-chess.c"
	}
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_builder_new_from_resource ("/org/gnome/chess/ui/preferences.ui");
#line 1701 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	preferences_builder = _tmp2_;
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = preferences_builder;
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_builder_get_object (_tmp3_, "preferences");
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_dialog_get_type (), GtkDialog));
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1703 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = _tmp5_;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->preferences_dialog;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->window;
#line 1704 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, (GtkWindow*) _tmp7_);
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->settings;
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = preferences_builder;
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_builder_get_object (_tmp9_, "show_numbering_check");
#line 1706 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp8_, "show-numbering", _tmp10_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->settings;
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = preferences_builder;
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_builder_get_object (_tmp12_, "show_move_hints_check");
#line 1708 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp11_, "show-move-hints", _tmp13_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = preferences_builder;
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = gtk_builder_get_object (_tmp14_, "side_combo");
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_combo_box_get_type (), GtkComboBox));
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 1711 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->side_combo = _tmp16_;
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->side_combo;
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->settings;
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = g_settings_get_enum (_tmp18_, "play-as");
#line 1712 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp17_, _tmp19_);
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = preferences_builder;
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_builder_get_object (_tmp20_, "opponent_combo");
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_combo_box_get_type (), GtkComboBox));
#line 1714 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	ai_combo = _tmp22_;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = ai_combo;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = gtk_combo_box_get_model (_tmp23_);
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_;
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_list_store_get_type (), GtkListStore));
#line 1715 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	ai_model = _tmp26_;
#line 1716 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = self->priv->settings;
#line 1716 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = g_settings_get_string (_tmp27_, "opponent");
#line 1716 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	opponent_name = _tmp28_;
#line 1717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = opponent_name;
#line 1717 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp29_, "human") == 0) {
#line 9382 "gnome-chess.c"
		GtkComboBox* _tmp30_ = NULL;
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = ai_combo;
#line 1718 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp30_, 0);
#line 9388 "gnome-chess.c"
	}
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = self->priv->ai_profiles;
#line 9392 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp31_;
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 9400 "gnome-chess.c"
			AIProfile* _tmp32_ = NULL;
			AIProfile* p = NULL;
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _g_object_ref0 ((AIProfile*) p_it->data);
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			p = _tmp32_;
#line 9407 "gnome-chess.c"
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp33_ = NULL;
				GtkTreeIter _tmp34_ = {0};
				GtkListStore* _tmp35_ = NULL;
				GtkTreeIter _tmp36_ = {0};
				AIProfile* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				AIProfile* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				gboolean _tmp43_ = FALSE;
				AIProfile* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = ai_model;
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_append (_tmp33_, &_tmp34_);
#line 1722 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				iter = _tmp34_;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = ai_model;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = iter;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = p;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = ai_profile_get_name (_tmp37_);
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp38_;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = p;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = ai_profile_get_name (_tmp40_);
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = _tmp41_;
#line 1723 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_set (_tmp35_, &_tmp36_, 0, _tmp39_, 1, _tmp42_, -1, -1);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = p;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = ai_profile_get_name (_tmp44_);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = _tmp45_;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = opponent_name;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp46_, _tmp47_) == 0) {
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp43_ = TRUE;
#line 9461 "gnome-chess.c"
				} else {
					gboolean _tmp48_ = FALSE;
					const gchar* _tmp49_ = NULL;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp49_ = opponent_name;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (g_strcmp0 (_tmp49_, "") == 0) {
#line 9469 "gnome-chess.c"
						GtkComboBox* _tmp50_ = NULL;
						gint _tmp51_ = 0;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp50_ = ai_combo;
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp51_ = gtk_combo_box_get_active (_tmp50_);
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp48_ = _tmp51_ == -1;
#line 9478 "gnome-chess.c"
					} else {
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp48_ = FALSE;
#line 9482 "gnome-chess.c"
					}
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp43_ = _tmp48_;
#line 9486 "gnome-chess.c"
				}
#line 1724 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp43_) {
#line 9490 "gnome-chess.c"
					GtkComboBox* _tmp52_ = NULL;
					GtkTreeIter _tmp53_ = {0};
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp52_ = ai_combo;
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp53_ = iter;
#line 1725 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					gtk_combo_box_set_active_iter (_tmp52_, &_tmp53_);
#line 9499 "gnome-chess.c"
				}
#line 1719 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (p);
#line 9503 "gnome-chess.c"
			}
		}
	}
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = ai_combo;
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = gtk_combo_box_get_active (_tmp54_);
#line 1727 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp55_ == -1) {
#line 9513 "gnome-chess.c"
		GtkComboBox* _tmp56_ = NULL;
		GSettings* _tmp57_ = NULL;
#line 1729 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = ai_combo;
#line 1729 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp56_, 0);
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp57_ = self->priv->settings;
#line 1730 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_settings_set_string (_tmp57_, "opponent", "human");
#line 9524 "gnome-chess.c"
	}
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = preferences_builder;
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "difficulty_combo");
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_combo_box_get_type (), GtkComboBox));
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 1733 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->difficulty_combo = _tmp60_;
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = self->priv->difficulty_combo;
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = self->priv->settings;
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = g_settings_get_string (_tmp62_, "difficulty");
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = _tmp63_;
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp61_, 1, _tmp64_);
#line 1734 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp64_);
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = preferences_builder;
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = gtk_builder_get_object (_tmp65_, "duration_combo");
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_combo_box_get_type (), GtkComboBox));
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 1736 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_combo = _tmp67_;
#line 1737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = preferences_builder;
#line 1737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = gtk_builder_get_object (_tmp68_, "clock_type_combo");
#line 1737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_combo_box_get_type (), GtkComboBox));
#line 1737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->clock_type_combo);
#line 1737 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->clock_type_combo = _tmp70_;
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = preferences_builder;
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = gtk_builder_get_object (_tmp71_, "duration_adjustment");
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 1738 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_adjustment = _tmp73_;
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = preferences_builder;
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = gtk_builder_get_object (_tmp74_, "timer_increment_adjustment");
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_adjustment_get_type (), GtkAdjustment));
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_adjustment);
#line 1739 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_adjustment = _tmp76_;
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = preferences_builder;
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = gtk_builder_get_object (_tmp77_, "custom_duration_box");
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, gtk_box_get_type (), GtkBox));
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 1740 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_box = _tmp79_;
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = preferences_builder;
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = gtk_builder_get_object (_tmp80_, "timer_increment_box");
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, gtk_box_get_type (), GtkBox));
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_box);
#line 1741 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_box = _tmp82_;
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = preferences_builder;
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = gtk_builder_get_object (_tmp83_, "custom_duration_units_combo");
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, gtk_combo_box_get_type (), GtkComboBox));
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 1742 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_units_combo = _tmp85_;
#line 1743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->settings;
#line 1743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = g_settings_get_int (_tmp86_, "duration");
#line 1743 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_duration (self, _tmp87_, TRUE);
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = preferences_builder;
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = gtk_builder_get_object (_tmp88_, "timer_increment_label");
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_widget_get_type (), GtkWidget));
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_label);
#line 1744 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_label = _tmp90_;
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = preferences_builder;
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = gtk_builder_get_object (_tmp91_, "timer_increment_units_combo");
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_combo_box_get_type (), GtkComboBox));
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_units_combo);
#line 1745 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->timer_increment_units_combo = _tmp93_;
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = self->priv->pgn_game;
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = pgn_game_get_clock_type (_tmp94_);
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = _tmp95_;
#line 1747 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp96_ != NULL) {
#line 9652 "gnome-chess.c"
		PGNGame* _tmp97_ = NULL;
		const gchar* _tmp98_ = NULL;
		const gchar* _tmp99_ = NULL;
		ClockType _tmp100_ = 0;
#line 1748 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp97_ = self->priv->pgn_game;
#line 1748 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp98_ = pgn_game_get_clock_type (_tmp97_);
#line 1748 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp99_ = _tmp98_;
#line 1748 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp100_ = clock_type_string_to_enum (_tmp99_);
#line 1748 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_set_clock_type (self, (gint) _tmp100_);
#line 9667 "gnome-chess.c"
	} else {
		GSettings* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		gchar* _tmp103_ = NULL;
		ClockType _tmp104_ = 0;
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp101_ = self->priv->settings;
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp102_ = g_settings_get_string (_tmp101_, "clock-type");
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp103_ = _tmp102_;
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp104_ = clock_type_string_to_enum (_tmp103_);
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_set_clock_type (self, (gint) _tmp104_);
#line 1750 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp103_);
#line 9685 "gnome-chess.c"
	}
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = self->priv->pgn_game;
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = pgn_game_get_timer_increment (_tmp105_);
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = _tmp106_;
#line 1752 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp107_ != NULL) {
#line 9695 "gnome-chess.c"
		PGNGame* _tmp108_ = NULL;
		const gchar* _tmp109_ = NULL;
		const gchar* _tmp110_ = NULL;
		gint _tmp111_ = 0;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp108_ = self->priv->pgn_game;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp109_ = pgn_game_get_timer_increment (_tmp108_);
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp110_ = _tmp109_;
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp111_ = atoi (_tmp110_);
#line 1753 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_set_timer_increment (self, _tmp111_);
#line 9710 "gnome-chess.c"
	} else {
		GSettings* _tmp112_ = NULL;
		gint _tmp113_ = 0;
#line 1755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp112_ = self->priv->settings;
#line 1755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp113_ = g_settings_get_int (_tmp112_, "timer-increment");
#line 1755 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_set_timer_increment (self, _tmp113_);
#line 9720 "gnome-chess.c"
	}
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp114_ = preferences_builder;
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp115_ = gtk_builder_get_object (_tmp114_, "orientation_combo");
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, gtk_combo_box_get_type (), GtkComboBox));
#line 1757 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	orientation_combo = _tmp116_;
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp117_ = orientation_combo;
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp118_ = self->priv->settings;
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp119_ = g_settings_get_string (_tmp118_, "board-side");
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp120_ = _tmp119_;
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp117_, 1, _tmp120_);
#line 1758 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp120_);
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp121_ = preferences_builder;
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp122_ = gtk_builder_get_object (_tmp121_, "move_format_combo");
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp123_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, gtk_combo_box_get_type (), GtkComboBox));
#line 1760 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	move_combo = _tmp123_;
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp124_ = move_combo;
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp125_ = self->priv->settings;
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp126_ = g_settings_get_string (_tmp125_, "move-format");
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp127_ = _tmp126_;
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp124_, 1, _tmp127_);
#line 1761 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp127_);
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp128_ = preferences_builder;
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp129_ = gtk_builder_get_object (_tmp128_, "piece_style_combo");
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp130_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, gtk_combo_box_get_type (), GtkComboBox));
#line 1763 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	theme_combo = _tmp130_;
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp131_ = theme_combo;
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp132_ = self->priv->settings;
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp133_ = g_settings_get_string (_tmp132_, "piece-theme");
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp134_ = _tmp133_;
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_set_combo (self, _tmp131_, 1, _tmp134_);
#line 1764 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp134_);
#line 1766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp135_ = preferences_builder;
#line 1766 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp135_, self);
#line 1769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp136_ = ai_combo;
#line 1769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp137_ = gtk_combo_box_get_active (_tmp136_);
#line 1769 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp137_ == 0) {
#line 9792 "gnome-chess.c"
		GtkComboBox* _tmp138_ = NULL;
		GtkComboBox* _tmp139_ = NULL;
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp138_ = self->priv->side_combo;
#line 1771 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp138_, FALSE);
#line 1772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp139_ = self->priv->difficulty_combo;
#line 1772 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp139_, FALSE);
#line 9803 "gnome-chess.c"
	}
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp140_ = self->priv->preferences_dialog;
#line 1775 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp140_);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (theme_combo);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (move_combo);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (orientation_combo);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent_name);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_model);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_combo);
#line 1693 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (preferences_builder);
#line 9823 "gnome-chess.c"
}


static void chess_application_set_combo (ChessApplication* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (value != NULL);
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1781 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1782 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 1782 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
#line 1782 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 1782 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp6_) {
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1783 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 9865 "gnome-chess.c"
	}
	{
		gboolean _tmp7_ = FALSE;
#line 1784 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 1784 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 9873 "gnome-chess.c"
			gchar* v = NULL;
			GtkTreeModel* _tmp10_ = NULL;
			GtkTreeIter _tmp11_ = {0};
			gint _tmp12_ = 0;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 1784 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (!_tmp7_) {
#line 9882 "gnome-chess.c"
				GtkTreeModel* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 1793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = model;
#line 1793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp9_ = gtk_tree_model_iter_next (_tmp8_, &iter);
#line 1793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp9_) {
#line 1793 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 9893 "gnome-chess.c"
				}
			}
#line 1784 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = FALSE;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = model;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = iter;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = value_index;
#line 1787 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp10_, &_tmp11_, _tmp12_, &v, -1, -1);
#line 1788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = v;
#line 1788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = value;
#line 1788 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
#line 9912 "gnome-chess.c"
				GtkComboBox* _tmp15_ = NULL;
				GtkTreeIter _tmp16_ = {0};
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp15_ = combo;
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp16_ = iter;
#line 1790 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp15_, &_tmp16_);
#line 1791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_free0 (v);
#line 1791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1791 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				return;
#line 9927 "gnome-chess.c"
			}
#line 1784 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (v);
#line 9931 "gnome-chess.c"
		}
	}
#line 1778 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 9936 "gnome-chess.c"
}


static gchar* chess_application_get_combo (ChessApplication* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gint _tmp7_ = 0;
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1796 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (combo != NULL, NULL);
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1800 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (value);
#line 1801 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return result;
#line 9970 "gnome-chess.c"
	}
#line 1802 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1802 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1802 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1802 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1802 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = value_index;
#line 1802 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = value;
#line 1803 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9988 "gnome-chess.c"
}


void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint player = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1807 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1810 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1811 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10018 "gnome-chess.c"
	}
#line 1813 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1813 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1813 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1813 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1813 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &player, -1, -1);
#line 1815 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1815 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = player;
#line 1815 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_enum (_tmp7_, "play-as", _tmp8_);
#line 10036 "gnome-chess.c"
}


void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean vs_human = FALSE;
	GtkComboBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkComboBox* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkComboBox* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1822 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1822 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1822 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1822 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1823 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10073 "gnome-chess.c"
	}
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1825 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
#line 1826 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1826 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = opponent;
#line 1826 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = combo;
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_combo_box_get_active (_tmp9_);
#line 1827 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	vs_human = _tmp10_ == 0;
#line 1828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->side_combo;
#line 1828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = vs_human;
#line 1828 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_);
#line 1829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->difficulty_combo;
#line 1829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = vs_human;
#line 1829 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp14_);
#line 1819 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent);
#line 10111 "gnome-chess.c"
}


void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 1833 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1833 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1836 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1837 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10141 "gnome-chess.c"
	}
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1839 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = difficulty;
#line 1840 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
#line 1833 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (difficulty);
#line 10161 "gnome-chess.c"
}


static void chess_application_set_clock_type (ChessApplication* self, gint clock_type) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter active_iter_clock_type = {0};
	GtkTreeIter _tmp4_ = {0};
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	GtkComboBox* _tmp16_ = NULL;
	GtkTreeIter _tmp17_ = {0};
	GtkComboBox* _tmp18_ = NULL;
#line 1843 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->clock_type_combo;
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1845 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1846 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	active_iter_clock_type = _tmp4_;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = model;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp6_;
#line 1849 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 10202 "gnome-chess.c"
		{
			gboolean _tmp8_ = FALSE;
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = TRUE;
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10209 "gnome-chess.c"
				gint type = 0;
				GtkTreeModel* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp8_) {
#line 10217 "gnome-chess.c"
					GtkTreeModel* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
#line 1859 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = model;
#line 1859 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
#line 1859 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (!_tmp10_) {
#line 1859 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 10228 "gnome-chess.c"
					}
				}
#line 1851 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = FALSE;
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = model;
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = iter;
#line 1854 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &type, -1, -1);
#line 1855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp13_ = type;
#line 1855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp14_ = clock_type;
#line 1855 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp13_ == _tmp14_) {
#line 10245 "gnome-chess.c"
					GtkTreeIter _tmp15_ = {0};
#line 1857 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = iter;
#line 1857 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					active_iter_clock_type = _tmp15_;
#line 10251 "gnome-chess.c"
				}
			}
		}
	}
#line 1862 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->clock_type_combo;
#line 1862 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = active_iter_clock_type;
#line 1862 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp16_, &_tmp17_);
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->clock_type_combo;
#line 1863 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_MODULE_EXPORT clock_type_changed_cb (_tmp18_, self);
#line 1843 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10268 "gnome-chess.c"
}


static void chess_application_set_timer_increment (ChessApplication* self, gint timer_increment) {
	gint timer_increment_multiplier = 0;
	gint _tmp0_ = 0;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter reqd_iter = {0};
	GtkTreeIter _tmp9_ = {0};
	GtkTreeModel* _tmp10_ = NULL;
	GtkTreeIter _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	GtkComboBox* _tmp23_ = NULL;
#line 1866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1868 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	timer_increment_multiplier = 1;
#line 1870 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = timer_increment;
#line 1870 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ >= 60) {
#line 10297 "gnome-chess.c"
		GtkAdjustment* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->timer_increment_adjustment;
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = timer_increment;
#line 1872 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp1_, (gdouble) (_tmp2_ / 60));
#line 1873 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		timer_increment_multiplier = 60;
#line 10308 "gnome-chess.c"
	} else {
		GtkAdjustment* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->timer_increment_adjustment;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = timer_increment;
#line 1875 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp3_, (gdouble) _tmp4_);
#line 10318 "gnome-chess.c"
	}
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->timer_increment_units_combo;
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_;
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 1877 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp8_;
#line 1878 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	reqd_iter = _tmp9_;
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = model;
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_tree_model_get_iter_first (_tmp10_, &_tmp11_);
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp11_;
#line 1881 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_) {
#line 10340 "gnome-chess.c"
		{
			gboolean _tmp13_ = FALSE;
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = TRUE;
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10347 "gnome-chess.c"
				gint multiplier = 0;
				GtkTreeModel* _tmp16_ = NULL;
				GtkTreeIter _tmp17_ = {0};
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp13_) {
#line 10355 "gnome-chess.c"
					GtkTreeModel* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
#line 1891 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = model;
#line 1891 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
#line 1891 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (!_tmp15_) {
#line 1891 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 10366 "gnome-chess.c"
					}
				}
#line 1883 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp13_ = FALSE;
#line 1886 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp16_ = model;
#line 1886 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp17_ = iter;
#line 1886 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp18_ = multiplier;
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp19_ = timer_increment_multiplier;
#line 1887 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp18_ == _tmp19_) {
#line 10383 "gnome-chess.c"
					GtkTreeIter _tmp20_ = {0};
#line 1889 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp20_ = iter;
#line 1889 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					reqd_iter = _tmp20_;
#line 10389 "gnome-chess.c"
				}
			}
		}
	}
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->timer_increment_units_combo;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = reqd_iter;
#line 1894 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 1895 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->timer_increment_units_combo;
#line 1895 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_MODULE_EXPORT timer_increment_units_changed_cb ((GtkWidget*) _tmp23_, self);
#line 1866 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10406 "gnome-chess.c"
}


static void chess_application_set_duration (ChessApplication* self, gint duration, gboolean simplify) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier = 0;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gint value = 0;
	gint _tmp20_ = 0;
	gboolean _tmp27_ = FALSE;
	GtkComboBox* _tmp28_ = NULL;
	GtkTreeModel* _tmp29_ = NULL;
	GtkTreeModel* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_ = NULL;
	GtkTreeModel* _tmp32_ = NULL;
	GtkTreeIter _tmp33_ = {0};
	gboolean _tmp34_ = FALSE;
#line 1898 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1900 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1901 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max_iter = _tmp4_;
#line 1904 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	max_multiplier = 0;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = model;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp6_;
#line 1905 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 10457 "gnome-chess.c"
		{
			gboolean _tmp8_ = FALSE;
#line 1907 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = TRUE;
#line 1907 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10464 "gnome-chess.c"
				gint multiplier = 0;
				GtkTreeModel* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
#line 1907 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp8_) {
#line 10473 "gnome-chess.c"
					GtkTreeModel* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = model;
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (!_tmp10_) {
#line 1916 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 10484 "gnome-chess.c"
					}
				}
#line 1907 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = FALSE;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = model;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = iter;
#line 1910 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp14_ = multiplier;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp15_ = max_multiplier;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp14_ > _tmp15_) {
#line 10501 "gnome-chess.c"
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp16_ = duration;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = multiplier;
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp13_ = (_tmp16_ % _tmp17_) == 0;
#line 10510 "gnome-chess.c"
				} else {
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp13_ = FALSE;
#line 10514 "gnome-chess.c"
				}
#line 1911 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp13_) {
#line 10518 "gnome-chess.c"
					gint _tmp18_ = 0;
					GtkTreeIter _tmp19_ = {0};
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = multiplier;
#line 1913 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					max_multiplier = _tmp18_;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp19_ = iter;
#line 1914 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					max_iter = _tmp19_;
#line 10529 "gnome-chess.c"
				}
			}
		}
	}
#line 1920 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	value = 0;
#line 1921 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = max_multiplier;
#line 1921 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp20_ > 0) {
#line 10540 "gnome-chess.c"
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		GtkAdjustment* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		GtkComboBox* _tmp25_ = NULL;
		GtkTreeIter _tmp26_ = {0};
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = duration;
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = max_multiplier;
#line 1923 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		value = _tmp21_ / _tmp22_;
#line 1924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = self->priv->duration_adjustment;
#line 1924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = value;
#line 1924 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp23_, (gdouble) _tmp24_);
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = self->priv->custom_duration_units_combo;
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = max_iter;
#line 1925 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
#line 10565 "gnome-chess.c"
	}
#line 1928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = simplify;
#line 1928 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp27_) {
#line 1929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1929 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10575 "gnome-chess.c"
	}
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->duration_combo;
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = gtk_combo_box_get_model (_tmp28_);
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_;
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = _g_object_ref0 (_tmp30_);
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 1931 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp31_;
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = model;
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_tree_model_get_iter_first (_tmp32_, &_tmp33_);
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp33_;
#line 1932 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp34_) {
#line 1933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1933 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 10601 "gnome-chess.c"
	}
	{
		gboolean _tmp35_ = FALSE;
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = TRUE;
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 10609 "gnome-chess.c"
			gint v = 0;
			GtkTreeModel* _tmp38_ = NULL;
			GtkTreeIter _tmp39_ = {0};
			gboolean _tmp40_ = FALSE;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (!_tmp35_) {
#line 10618 "gnome-chess.c"
				GtkTreeModel* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = model;
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = gtk_tree_model_iter_next (_tmp36_, &iter);
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp37_) {
#line 1944 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					break;
#line 10629 "gnome-chess.c"
				}
			}
#line 1934 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = FALSE;
#line 1937 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp38_ = model;
#line 1937 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = iter;
#line 1937 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp38_, &_tmp39_, 1, &v, -1, -1);
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp41_ = v;
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = duration;
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp41_ == _tmp42_) {
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = TRUE;
#line 10648 "gnome-chess.c"
			} else {
				gint _tmp43_ = 0;
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = v;
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp43_ == -1;
#line 10655 "gnome-chess.c"
			}
#line 1938 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp40_) {
#line 10659 "gnome-chess.c"
				GtkComboBox* _tmp44_ = NULL;
				GtkTreeIter _tmp45_ = {0};
				GtkBox* _tmp46_ = NULL;
				gint _tmp47_ = 0;
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = self->priv->duration_combo;
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = iter;
#line 1940 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp44_, &_tmp45_);
#line 1941 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = self->priv->custom_duration_box;
#line 1941 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = v;
#line 1941 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp46_, _tmp47_ == -1);
#line 1942 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1942 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				return;
#line 10680 "gnome-chess.c"
			}
		}
	}
#line 1898 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 10686 "gnome-chess.c"
}


static gint chess_application_get_duration (ChessApplication* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint magnitude = 0;
	GtkAdjustment* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gint multiplier = 0;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	gint _tmp18_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
#line 1947 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->duration_combo;
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1950 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 10717 "gnome-chess.c"
		gint duration = 0;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gint _tmp7_ = 0;
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->duration_combo;
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = iter;
#line 1953 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 1954 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = duration;
#line 1954 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp7_ >= 0) {
#line 1955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			result = duration;
#line 1955 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return result;
#line 10742 "gnome-chess.c"
		}
	}
#line 1958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->duration_adjustment;
#line 1958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
#line 1958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 1958 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	magnitude = (gint) _tmp10_;
#line 1959 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	multiplier = 1;
#line 1960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->custom_duration_units_combo;
#line 1960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
#line 1960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp12_;
#line 1960 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp13_) {
#line 10763 "gnome-chess.c"
		GtkComboBox* _tmp14_ = NULL;
		GtkTreeModel* _tmp15_ = NULL;
		GtkTreeModel* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->custom_duration_units_combo;
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = iter;
#line 1961 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
#line 10778 "gnome-chess.c"
	}
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = multiplier;
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp18_) {
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case 60:
#line 10786 "gnome-chess.c"
		{
			GtkAdjustment* _tmp19_ = NULL;
			gdouble _tmp20_ = 0.0;
#line 1966 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = self->priv->duration_adjustment;
#line 1966 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = gtk_adjustment_get_upper (_tmp19_);
#line 1966 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp20_ != ((gdouble) 600)) {
#line 10796 "gnome-chess.c"
				GtkAdjustment* _tmp21_ = NULL;
#line 1967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp21_ = self->priv->duration_adjustment;
#line 1967 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp21_, (gdouble) 600);
#line 10802 "gnome-chess.c"
			}
#line 1968 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 10806 "gnome-chess.c"
		}
#line 1963 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case 3600:
#line 10810 "gnome-chess.c"
		{
			GtkAdjustment* _tmp22_ = NULL;
			gdouble _tmp23_ = 0.0;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = self->priv->duration_adjustment;
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = gtk_adjustment_get_upper (_tmp22_);
#line 1970 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp23_ != ((gdouble) 10)) {
#line 10820 "gnome-chess.c"
				GtkAdjustment* _tmp24_ = NULL;
				GtkAdjustment* _tmp25_ = NULL;
				gdouble _tmp26_ = 0.0;
				gdouble _tmp27_ = 0.0;
#line 1972 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = self->priv->duration_adjustment;
#line 1972 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp24_, (gdouble) 10);
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = self->priv->duration_adjustment;
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = gtk_adjustment_get_value (_tmp25_);
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = _tmp26_;
#line 1973 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp27_ > ((gdouble) 10)) {
#line 10837 "gnome-chess.c"
					GtkAdjustment* _tmp28_ = NULL;
#line 1975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = self->priv->duration_adjustment;
#line 1975 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					gtk_adjustment_set_value (_tmp28_, (gdouble) 10);
#line 1976 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					magnitude = 10;
#line 10845 "gnome-chess.c"
				}
			}
#line 1979 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 10850 "gnome-chess.c"
		}
		default:
		{
#line 1981 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_assert_not_reached ();
#line 10856 "gnome-chess.c"
		}
	}
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = magnitude;
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = multiplier;
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = _tmp29_ * _tmp30_;
#line 1984 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10867 "gnome-chess.c"
}


static gboolean chess_application_save_duration_cb (ChessApplication* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint _tmp2_ = 0U;
#line 1987 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1989 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1989 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_get_duration (self);
#line 1989 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
#line 1990 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->save_duration_timeout;
#line 1990 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_source_remove (_tmp2_);
#line 1991 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 1992 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = G_SOURCE_REMOVE;
#line 1992 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10894 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, ChessApplication* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 1996 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1996 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (adjustment != NULL);
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
#line 1998 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 2001 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 10930 "gnome-chess.c"
		{
			gboolean _tmp7_ = FALSE;
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = TRUE;
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 10937 "gnome-chess.c"
				gint multiplier = 0;
				GtkListStore* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				gint _tmp12_ = 0;
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp7_) {
#line 10944 "gnome-chess.c"
					GtkListStore* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = model;
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (!_tmp9_) {
#line 2020 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 10955 "gnome-chess.c"
					}
				}
#line 2003 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = FALSE;
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp10_ = model;
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = iter;
#line 2006 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
#line 2007 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = multiplier;
#line 2007 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				switch (_tmp12_) {
#line 2007 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					case 60:
#line 10972 "gnome-chess.c"
					{
						GtkListStore* _tmp13_ = NULL;
						GtkTreeIter _tmp14_ = {0};
						GtkAdjustment* _tmp15_ = NULL;
						gdouble _tmp16_ = 0.0;
						gdouble _tmp17_ = 0.0;
						const gchar* _tmp18_ = NULL;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = model;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp14_ = iter;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp15_ = adjustment;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp17_ = _tmp16_;
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp18_ = ngettext ("minute", "minutes", (gulong) _tmp17_);
#line 2010 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp18_, -1, -1);
#line 2012 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 10996 "gnome-chess.c"
					}
#line 2007 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					case 3600:
#line 11000 "gnome-chess.c"
					{
						GtkListStore* _tmp19_ = NULL;
						GtkTreeIter _tmp20_ = {0};
						GtkAdjustment* _tmp21_ = NULL;
						gdouble _tmp22_ = 0.0;
						gdouble _tmp23_ = 0.0;
						const gchar* _tmp24_ = NULL;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp19_ = model;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp20_ = iter;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp21_ = adjustment;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = gtk_adjustment_get_value (_tmp21_);
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp23_ = _tmp22_;
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp24_ = ngettext ("hour", "hours", (gulong) _tmp23_);
#line 2014 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp24_, -1, -1);
#line 2016 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 11024 "gnome-chess.c"
					}
					default:
					{
#line 2018 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						g_assert_not_reached ();
#line 11030 "gnome-chess.c"
					}
				}
			}
		}
	}
#line 2023 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 1996 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 11040 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
#line 2027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2027 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 2029 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 11051 "gnome-chess.c"
}


void G_MODULE_EXPORT timer_increment_units_changed_cb (GtkWidget* widget, ChessApplication* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	gint multiplier = 0;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkComboBox* _tmp25_ = NULL;
	GtkTreeIter _tmp26_ = {0};
	gboolean _tmp27_ = FALSE;
	gint _tmp32_ = 0;
	GSettings* _tmp43_ = NULL;
	GtkAdjustment* _tmp44_ = NULL;
	gdouble _tmp45_ = 0.0;
	gdouble _tmp46_ = 0.0;
	gint _tmp47_ = 0;
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 2035 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->timer_increment_units_combo;
#line 2035 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 2035 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 2035 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_store_get_type (), GtkListStore));
#line 2035 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 2037 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	multiplier = 0;
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 2039 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 11099 "gnome-chess.c"
		{
			gboolean _tmp7_ = FALSE;
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = TRUE;
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 11106 "gnome-chess.c"
				GtkListStore* _tmp10_ = NULL;
				GtkTreeIter _tmp11_ = {0};
				gint _tmp12_ = 0;
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (!_tmp7_) {
#line 11112 "gnome-chess.c"
					GtkListStore* _tmp8_ = NULL;
					gboolean _tmp9_ = FALSE;
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = model;
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp8_, &iter);
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					if (!_tmp9_) {
#line 2057 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 11123 "gnome-chess.c"
					}
				}
#line 2041 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = FALSE;
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp10_ = model;
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = iter;
#line 2043 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 1, &multiplier, -1, -1);
#line 2044 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = multiplier;
#line 2044 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				switch (_tmp12_) {
#line 2044 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					case 1:
#line 11140 "gnome-chess.c"
					{
						GtkListStore* _tmp13_ = NULL;
						GtkTreeIter _tmp14_ = {0};
						GtkAdjustment* _tmp15_ = NULL;
						gdouble _tmp16_ = 0.0;
						gdouble _tmp17_ = 0.0;
						const gchar* _tmp18_ = NULL;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = model;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp14_ = iter;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp15_ = self->priv->timer_increment_adjustment;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp16_ = gtk_adjustment_get_value (_tmp15_);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp17_ = _tmp16_;
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp18_ = ngettext ("second", "seconds", (gulong) _tmp17_);
#line 2047 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp18_, -1, -1);
#line 2049 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 11164 "gnome-chess.c"
					}
#line 2044 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					case 60:
#line 11168 "gnome-chess.c"
					{
						GtkListStore* _tmp19_ = NULL;
						GtkTreeIter _tmp20_ = {0};
						GtkAdjustment* _tmp21_ = NULL;
						gdouble _tmp22_ = 0.0;
						gdouble _tmp23_ = 0.0;
						const gchar* _tmp24_ = NULL;
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp19_ = model;
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp20_ = iter;
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp21_ = self->priv->timer_increment_adjustment;
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = gtk_adjustment_get_value (_tmp21_);
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp23_ = _tmp22_;
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						_tmp24_ = ngettext ("minute", "minutes", (gulong) _tmp23_);
#line 2051 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp24_, -1, -1);
#line 2053 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						break;
#line 11192 "gnome-chess.c"
					}
					default:
					{
#line 2055 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
						g_assert_not_reached ();
#line 11198 "gnome-chess.c"
					}
				}
			}
		}
	}
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->timer_increment_units_combo;
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = gtk_combo_box_get_active_iter (_tmp25_, &_tmp26_);
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp26_;
#line 2060 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp27_) {
#line 11212 "gnome-chess.c"
		GtkComboBox* _tmp28_ = NULL;
		GtkTreeModel* _tmp29_ = NULL;
		GtkTreeModel* _tmp30_ = NULL;
		GtkTreeIter _tmp31_ = {0};
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->timer_increment_units_combo;
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = gtk_combo_box_get_model (_tmp28_);
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_;
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = iter;
#line 2061 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp30_, &_tmp31_, 1, &multiplier, -1, -1);
#line 11227 "gnome-chess.c"
	}
#line 2063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = multiplier;
#line 2063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	switch (_tmp32_) {
#line 2063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case 1:
#line 11235 "gnome-chess.c"
		{
			GtkAdjustment* _tmp33_ = NULL;
			gdouble _tmp34_ = 0.0;
#line 2066 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = self->priv->timer_increment_adjustment;
#line 2066 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = gtk_adjustment_get_upper (_tmp33_);
#line 2066 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp34_ != ((gdouble) 59)) {
#line 11245 "gnome-chess.c"
				GtkAdjustment* _tmp35_ = NULL;
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = self->priv->timer_increment_adjustment;
#line 2067 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp35_, (gdouble) 59);
#line 11251 "gnome-chess.c"
			}
#line 2068 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 11255 "gnome-chess.c"
		}
#line 2063 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		case 60:
#line 11259 "gnome-chess.c"
		{
			GtkAdjustment* _tmp36_ = NULL;
			gdouble _tmp37_ = 0.0;
#line 2070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp36_ = self->priv->timer_increment_adjustment;
#line 2070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp37_ = gtk_adjustment_get_upper (_tmp36_);
#line 2070 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (_tmp37_ != ((gdouble) 10)) {
#line 11269 "gnome-chess.c"
				GtkAdjustment* _tmp38_ = NULL;
				GtkAdjustment* _tmp39_ = NULL;
				gdouble _tmp40_ = 0.0;
				gdouble _tmp41_ = 0.0;
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = self->priv->timer_increment_adjustment;
#line 2072 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				gtk_adjustment_set_upper (_tmp38_, (gdouble) 10);
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = self->priv->timer_increment_adjustment;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = gtk_adjustment_get_value (_tmp39_);
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = _tmp40_;
#line 2073 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				if (_tmp41_ > ((gdouble) 10)) {
#line 11286 "gnome-chess.c"
					GtkAdjustment* _tmp42_ = NULL;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					_tmp42_ = self->priv->timer_increment_adjustment;
#line 2074 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
					gtk_adjustment_set_value (_tmp42_, (gdouble) 10);
#line 11292 "gnome-chess.c"
				}
			}
#line 2076 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			break;
#line 11297 "gnome-chess.c"
		}
		default:
		{
#line 2078 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_assert_not_reached ();
#line 11303 "gnome-chess.c"
		}
	}
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = self->priv->settings;
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = self->priv->timer_increment_adjustment;
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = gtk_adjustment_get_value (_tmp44_);
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = _tmp45_;
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = multiplier;
#line 2080 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp43_, "timer-increment", ((gint) _tmp46_) * _tmp47_);
#line 2033 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 11320 "gnome-chess.c"
}


static gboolean _chess_application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_application_save_duration_cb ((ChessApplication*) self);
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 11329 "gnome-chess.c"
}


static void chess_application_save_duration (ChessApplication* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
#line 2083 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2086 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 2086 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 11342 "gnome-chess.c"
		guint _tmp1_ = 0U;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_duration_timeout;
#line 2087 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_source_remove (_tmp1_);
#line 11348 "gnome-chess.c"
	}
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _chess_application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 2088 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = _tmp2_;
#line 11354 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint duration = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkBox* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GtkComboBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 2092 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2092 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 2095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 2095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 2095 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 2096 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11388 "gnome-chess.c"
	}
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 2098 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->custom_duration_box;
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = duration;
#line 2099 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->clock_type_combo;
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = duration;
#line 2100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_ != 0);
#line 2102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = duration;
#line 2102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_ == 0) {
#line 2103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_set_clock_type (self, (gint) CLOCK_TYPE_SIMPLE);
#line 11418 "gnome-chess.c"
	}
#line 2105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = duration;
#line 2105 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ >= 0) {
#line 11424 "gnome-chess.c"
		gint _tmp13_ = 0;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = duration;
#line 2106 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_set_duration (self, _tmp13_, FALSE);
#line 11430 "gnome-chess.c"
	} else {
		gint _tmp14_ = 0;
#line 2108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_application_get_duration (self);
#line 2108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp14_ <= 0) {
#line 2109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_set_duration (self, 60 * 60, FALSE);
#line 11439 "gnome-chess.c"
		}
	}
#line 2111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_duration (self);
#line 11444 "gnome-chess.c"
}


void G_MODULE_EXPORT clock_type_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	ClockType clock_type = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkBox* _tmp7_ = NULL;
	ClockType _tmp8_ = 0;
	GtkWidget* _tmp9_ = NULL;
	ClockType _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	ClockType _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 2115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 2118 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 2119 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11480 "gnome-chess.c"
	}
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 2121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &clock_type, -1, -1);
#line 2123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->timer_increment_box;
#line 2123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = clock_type;
#line 2123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ > 0);
#line 2124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->timer_increment_label;
#line 2124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = clock_type;
#line 2124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible (_tmp9_, _tmp10_ > 0);
#line 2125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->settings;
#line 2125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = clock_type;
#line 2125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = clock_type_to_string (_tmp12_);
#line 2125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_;
#line 2125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp11_, "clock-type", _tmp14_);
#line 2125 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp14_);
#line 11516 "gnome-chess.c"
}


void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, ChessApplication* self) {
	GtkDialog* _tmp0_ = NULL;
#line 2129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 2131 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 11530 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, ChessApplication* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 2135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 2137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_MODULE_EXPORT preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
#line 2138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 2138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 11551 "gnome-chess.c"
}


void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 2144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 2144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 2144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 2144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
#line 2144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 11576 "gnome-chess.c"
}


void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 2148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 2150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 2150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 2150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 2150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
#line 2150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 11601 "gnome-chess.c"
}


void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, ChessApplication* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_application_get_combo (self, _tmp1_, 1);
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
#line 2156 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 11626 "gnome-chess.c"
}


void chess_application_help_cb (ChessApplication* self) {
	GError * _inner_error_ = NULL;
#line 2159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 11634 "gnome-chess.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 2163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = self->priv->window;
#line 2163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 2163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 2163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_show_uri (_tmp1_, "help:gnome-chess", _tmp2_, &_inner_error_);
#line 2163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 11649 "gnome-chess.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 2167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = e;
#line 2167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->message;
#line 2167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:2167: Unable to open help: %s", _tmp4_);
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 11671 "gnome-chess.c"
	}
	__finally4:
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 2161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11682 "gnome-chess.c"
	}
}


static void _chess_application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_about_response_cb ((ChessApplication*) self, response_id);
#line 11690 "gnome-chess.c"
}


void chess_application_about_cb (ChessApplication* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp2_ = NULL;
	GtkAboutDialog* _tmp3_ = NULL;
	GtkApplicationWindow* _tmp4_ = NULL;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkAboutDialog* _tmp8_ = NULL;
	GtkAboutDialog* _tmp9_ = NULL;
	GtkAboutDialog* _tmp10_ = NULL;
	GtkAboutDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkAboutDialog* _tmp13_ = NULL;
	GtkAboutDialog* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkAboutDialog* _tmp17_ = NULL;
	GtkAboutDialog* _tmp18_ = NULL;
	GtkAboutDialog* _tmp19_ = NULL;
	GtkAboutDialog* _tmp20_ = NULL;
#line 2174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 2176 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 11721 "gnome-chess.c"
		GtkAboutDialog* _tmp1_ = NULL;
#line 2178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->about_dialog;
#line 2178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 2179 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 11729 "gnome-chess.c"
	}
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 2182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = _tmp2_;
#line 2183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->about_dialog;
#line 2183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->window;
#line 2183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp4_);
#line 2184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->about_dialog;
#line 2184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->about_dialog;
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("Chess");
#line 2185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_program_name (_tmp6_, _tmp7_);
#line 2186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->about_dialog;
#line 2186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_version (_tmp8_, VERSION);
#line 2187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->about_dialog;
#line 2187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_copyright (_tmp9_, "Copyright © 2010–2013 Robert Ancell\n" \
"Copyright © 2013–2014 Michael Catanzaro");
#line 2188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->about_dialog;
#line 2188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_2_0);
#line 2189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->about_dialog;
#line 2189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = _ ("A classic game of positional strategy");
#line 2189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_comments (_tmp11_, _tmp12_);
#line 2190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->about_dialog;
#line 2190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_authors (_tmp13_, CHESS_APPLICATION_authors);
#line 2191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->about_dialog;
#line 2191 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_artists (_tmp14_, CHESS_APPLICATION_artists);
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->about_dialog;
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("translator-credits");
#line 2192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_translator_credits (_tmp15_, _tmp16_);
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->about_dialog;
#line 2193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_website (_tmp17_, "https://wiki.gnome.org/Apps/Chess");
#line 2194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->about_dialog;
#line 2194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_logo_icon_name (_tmp18_, "gnome-chess");
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = self->priv->about_dialog;
#line 2195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp19_, "response", (GCallback) _chess_application_about_response_cb_gtk_dialog_response, self, 0);
#line 2196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->about_dialog;
#line 2196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp20_);
#line 11803 "gnome-chess.c"
}


static void chess_application_run_invalid_pgn_dialog (ChessApplication* self) {
	GtkMessageDialog* invalid_pgn_dialog = NULL;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 2199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _ ("This does not look like a valid PGN game.");
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, _tmp1_);
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 2201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	invalid_pgn_dialog = _tmp2_;
#line 2206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _ ("_OK");
#line 2206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) invalid_pgn_dialog, _tmp3_, (gint) GTK_RESPONSE_OK);
#line 2208 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) invalid_pgn_dialog);
#line 2209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) invalid_pgn_dialog);
#line 2199 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (invalid_pgn_dialog);
#line 11835 "gnome-chess.c"
}


static void chess_application_run_invalid_move_dialog (ChessApplication* self, const gchar* error_message) {
	GtkMessageDialog* invalid_move_dialog = NULL;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 2212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (error_message != NULL);
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = error_message;
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, _tmp1_);
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 2214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	invalid_move_dialog = _tmp2_;
#line 2219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _ ("_OK");
#line 2219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) invalid_move_dialog, _tmp3_, (gint) GTK_RESPONSE_OK);
#line 2221 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) invalid_move_dialog);
#line 2222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) invalid_move_dialog);
#line 2212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (invalid_move_dialog);
#line 11869 "gnome-chess.c"
}


static void chess_application_about_response_cb (ChessApplication* self, gint response_id) {
	GtkAboutDialog* _tmp0_ = NULL;
#line 2225 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 2227 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 2228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 2228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 11885 "gnome-chess.c"
}


static void chess_application_add_info_bar_to_dialog (ChessApplication* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkInfoBar* _tmp1_ = NULL;
	GtkContainer* content_area = NULL;
	GtkContainer* _tmp2_ = NULL;
	GtkContainer* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkContainer* child = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GtkDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (dialog != NULL);
#line 2233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 2233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp0_);
#line 2233 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	vbox = _tmp0_;
#line 2234 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 2236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 2236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp1_);
#line 2236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_info_bar);
#line 2236 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_info_bar = _tmp1_;
#line 2237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_info_bar_get_content_area (_vala_info_bar);
#line 2237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
#line 2237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	content_area = _tmp3_;
#line 2238 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp4_);
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_label);
#line 2240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_vala_label = _tmp4_;
#line 2241 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
#line 2242 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _vala_label);
#line 2244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = dialog;
#line 2244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
#line 2244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer));
#line 2244 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	child = _tmp7_;
#line 2245 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
#line 2246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = dialog;
#line 2246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_container_get_border_width ((GtkContainer*) _tmp8_);
#line 2246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 2246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width (child, _tmp10_);
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = dialog;
#line 2247 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 0);
#line 2249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_box_set_child_packing (vbox, (GtkWidget*) child, TRUE, TRUE, (guint) 0, GTK_PACK_START);
#line 2250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = dialog;
#line 2250 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) vbox);
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (child);
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (content_area);
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (vbox);
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (info_bar) {
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		*info_bar = _vala_info_bar;
#line 11986 "gnome-chess.c"
	} else {
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_info_bar);
#line 11990 "gnome-chess.c"
	}
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (label) {
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		*label = _vala_label;
#line 11996 "gnome-chess.c"
	} else {
#line 2231 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_label);
#line 12000 "gnome-chess.c"
	}
}


static void chess_application_update_pgn_time_remaining (ChessApplication* self) {
	ChessGame* _tmp0_ = NULL;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
#line 2253 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2255 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 2255 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_clock (_tmp0_);
#line 2255 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 2255 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 12019 "gnome-chess.c"
		guint white_initial_time = 0U;
		PGNGame* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		guint black_initial_time = 0U;
		PGNGame* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		guint white_used = 0U;
		ChessGame* _tmp11_ = NULL;
		ChessClock* _tmp12_ = NULL;
		ChessClock* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		guint black_used = 0U;
		ChessGame* _tmp16_ = NULL;
		ChessClock* _tmp17_ = NULL;
		ChessClock* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		guint white_extra = 0U;
		ChessGame* _tmp21_ = NULL;
		ChessClock* _tmp22_ = NULL;
		ChessClock* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		guint black_extra = 0U;
		ChessGame* _tmp26_ = NULL;
		ChessClock* _tmp27_ = NULL;
		ChessClock* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		PGNGame* _tmp31_ = NULL;
		guint _tmp32_ = 0U;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		PGNGame* _tmp37_ = NULL;
		guint _tmp38_ = 0U;
		guint _tmp39_ = 0U;
		guint _tmp40_ = 0U;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
#line 2258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->pgn_game;
#line 2258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = pgn_game_get_white_time_left (_tmp3_);
#line 2258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 2258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = atoi (_tmp5_);
#line 2258 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		white_initial_time = (guint) _tmp6_;
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->pgn_game;
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = pgn_game_get_black_time_left (_tmp7_);
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = atoi (_tmp9_);
#line 2259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		black_initial_time = (guint) _tmp10_;
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->game;
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = chess_game_get_clock (_tmp11_);
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_clock_get_white_seconds_used (_tmp13_);
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 2261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		white_used = (guint) _tmp15_;
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game;
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = chess_game_get_clock (_tmp16_);
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = chess_clock_get_black_seconds_used (_tmp18_);
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 2262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		black_used = (guint) _tmp20_;
#line 2264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game;
#line 2264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = chess_game_get_clock (_tmp21_);
#line 2264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = _tmp22_;
#line 2264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = chess_clock_get_white_extra_seconds (_tmp23_);
#line 2264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _tmp24_;
#line 2264 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		white_extra = (guint) _tmp25_;
#line 2265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = self->priv->game;
#line 2265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = chess_game_get_clock (_tmp26_);
#line 2265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = _tmp27_;
#line 2265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = chess_clock_get_black_extra_seconds (_tmp28_);
#line 2265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = _tmp29_;
#line 2265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		black_extra = (guint) _tmp30_;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = self->priv->pgn_game;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = white_initial_time;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = white_used;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = white_extra;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = g_strdup_printf ("%u", (_tmp32_ - _tmp33_) + _tmp34_);
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = _tmp35_;
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp31_, _tmp36_);
#line 2267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp36_);
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = self->priv->pgn_game;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = black_initial_time;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = black_used;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = black_extra;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = g_strdup_printf ("%u", (_tmp38_ - _tmp39_) + _tmp40_);
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = _tmp41_;
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp37_, _tmp42_);
#line 2268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp42_);
#line 12166 "gnome-chess.c"
	}
}


static void chess_application_save_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 2272 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 2274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_update_pgn_time_remaining (self);
#line 12183 "gnome-chess.c"
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			PGNGame* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GtkHeaderBar* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
#line 2280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->save_dialog;
#line 2280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
#line 2280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 2280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp2_;
#line 2281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->pgn_game;
#line 2281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = self->priv->game_file;
#line 2281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_write (_tmp3_, _tmp4_, &_inner_error_);
#line 2281 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12209 "gnome-chess.c"
				goto __catch5_g_error;
			}
#line 2282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = self->priv->headerbar;
#line 2282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->game_file;
#line 2282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = g_file_get_basename (_tmp6_);
#line 2282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = _tmp7_;
#line 2282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_header_bar_set_subtitle (_tmp5_, _tmp8_);
#line 2282 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (_tmp8_);
#line 2283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 2284 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 12228 "gnome-chess.c"
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			GtkLabel* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GtkInfoBar* _tmp13_ = NULL;
			GtkInfoBar* _tmp14_ = NULL;
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 2288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = e;
#line 2288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = _tmp9_->message;
#line 2288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:2288: Failed to save game: %s", _tmp10_);
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->save_dialog_error_label;
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = _ ("Failed to save game");
#line 2289 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp11_, _tmp12_);
#line 2290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = self->priv->save_dialog_info_bar;
#line 2290 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp13_, GTK_MESSAGE_ERROR);
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = self->priv->save_dialog_info_bar;
#line 2291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp14_);
#line 2292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 2292 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 12268 "gnome-chess.c"
		}
		__finally5:
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 2278 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 12279 "gnome-chess.c"
		}
	}
#line 2296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->save_dialog;
#line 2296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
#line 2297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 2297 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 2298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 2299 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 12298 "gnome-chess.c"
}


static void __lambda6_ (ChessApplication* self) {
#line 2319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_dialog_cb (self, (gint) GTK_RESPONSE_OK);
#line 12305 "gnome-chess.c"
}


static void ___lambda6__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 2319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	__lambda6_ ((ChessApplication*) self);
#line 12312 "gnome-chess.c"
}


static void _chess_application_save_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_save_dialog_cb ((ChessApplication*) self, response_id);
#line 12319 "gnome-chess.c"
}


static void chess_application_present_save_dialog (ChessApplication* self, const gchar* cancel_button_label, const gchar* save_button_label) {
	GtkFileChooserDialog* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GFile* _tmp15_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp28_ = NULL;
	GtkFileFilter* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GtkFileFilter* _tmp31_ = NULL;
	GtkFileChooserDialog* _tmp32_ = NULL;
	GtkFileFilter* _tmp33_ = NULL;
	GtkFileFilter* _tmp34_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp35_ = NULL;
	GtkFileFilter* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	GtkFileFilter* _tmp38_ = NULL;
	GtkFileChooserDialog* _tmp39_ = NULL;
	GtkFileFilter* _tmp40_ = NULL;
	GtkFileFilter* _tmp41_ = NULL;
	GtkFileChooserDialog* _tmp42_ = NULL;
#line 2302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (cancel_button_label != NULL);
#line 2302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (save_button_label != NULL);
#line 2306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_dialog;
#line 2306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 12366 "gnome-chess.c"
		GtkFileChooserDialog* _tmp1_ = NULL;
#line 2308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_dialog;
#line 2308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_run ((GtkDialog*) _tmp1_);
#line 2309 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 12374 "gnome-chess.c"
	}
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _ ("Save Chess Game");
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = cancel_button_label;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _ (_tmp4_);
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = save_button_label;
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ (_tmp6_);
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, (GtkWindow*) _tmp3_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp5_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp8_);
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 2312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = _tmp8_;
#line 2317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->save_dialog;
#line 2317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
#line 2317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 2317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = _tmp10_;
#line 2317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 2317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = _tmp11_;
#line 2319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->save_dialog;
#line 2319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) ___lambda6__gtk_file_chooser_file_activated, self, 0);
#line 2320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->save_dialog;
#line 2320 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _chess_application_save_dialog_cb_gtk_dialog_response, self, 0);
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->game_file;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp15_ != NULL) {
#line 12420 "gnome-chess.c"
		GFile* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->game_file;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = g_file_get_path (_tmp16_);
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = self->priv->autosave_filename;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = g_strcmp0 (_tmp18_, _tmp19_) != 0;
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp18_);
#line 12437 "gnome-chess.c"
	} else {
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = FALSE;
#line 12441 "gnome-chess.c"
	}
#line 2322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp14_) {
#line 12445 "gnome-chess.c"
		GtkFileChooserDialog* _tmp20_ = NULL;
		GFile* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
#line 2323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = self->priv->save_dialog;
#line 2323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game_file;
#line 2323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = g_file_get_path (_tmp21_);
#line 2323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = _tmp22_;
#line 2323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_filename ((GtkFileChooser*) _tmp20_, _tmp23_);
#line 2323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp23_);
#line 12462 "gnome-chess.c"
	} else {
		GtkFileChooserDialog* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = self->priv->save_dialog;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _ ("Untitled Chess Game");
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = g_strconcat (_tmp25_, ".pgn", NULL);
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _tmp26_;
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp24_, _tmp27_);
#line 2325 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp27_);
#line 12480 "gnome-chess.c"
	}
#line 2329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_file_filter_new ();
#line 2329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp28_);
#line 2329 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp28_;
#line 2331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = pgn_filter;
#line 2331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _ ("PGN files");
#line 2331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp29_, _tmp30_);
#line 2332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = pgn_filter;
#line 2332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp31_, "*.pgn");
#line 2333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = self->priv->save_dialog;
#line 2333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = pgn_filter;
#line 2333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = _g_object_ref0 (_tmp33_);
#line 2333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp32_, _tmp34_);
#line 2335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = gtk_file_filter_new ();
#line 2335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp35_);
#line 2335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp35_;
#line 2337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = all_filter;
#line 2337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = _ ("All files");
#line 2337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp36_, _tmp37_);
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = all_filter;
#line 2338 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp38_, "*");
#line 2339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = self->priv->save_dialog;
#line 2339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = all_filter;
#line 2339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _g_object_ref0 (_tmp40_);
#line 2339 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp39_, _tmp41_);
#line 2341 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = self->priv->save_dialog;
#line 2341 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) _tmp42_);
#line 2302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 2302 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 12538 "gnome-chess.c"
}


void chess_application_save_game_cb (ChessApplication* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 2344 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game_file;
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == NULL) {
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = TRUE;
#line 12554 "gnome-chess.c"
	} else {
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game_file;
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->autosave_filename;
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp4_);
#line 12572 "gnome-chess.c"
	}
#line 2346 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 2348 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_present_save_dialog (self, "_Cancel", "_Save");
#line 2349 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 12580 "gnome-chess.c"
	}
#line 2352 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_update_pgn_time_remaining (self);
#line 12584 "gnome-chess.c"
	{
		PGNGame* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
#line 2356 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->pgn_game;
#line 2356 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game_file;
#line 2356 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_write (_tmp6_, _tmp7_, &_inner_error_);
#line 2356 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12596 "gnome-chess.c"
			goto __catch6_g_error;
		}
#line 2357 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_ACTION_NAME);
#line 12601 "gnome-chess.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
#line 2354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 2354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 2361 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_present_save_dialog (self, "_Cancel", "_Save");
#line 2354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 12615 "gnome-chess.c"
	}
	__finally6:
#line 2354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 2354 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 12626 "gnome-chess.c"
	}
}


void chess_application_save_game_as_cb (ChessApplication* self) {
#line 2365 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2367 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_present_save_dialog (self, "_Cancel", "_Save");
#line 12636 "gnome-chess.c"
}


static void __lambda9_ (ChessApplication* self) {
#line 2389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_open_dialog_cb (self, (gint) GTK_RESPONSE_OK);
#line 12643 "gnome-chess.c"
}


static void ___lambda9__gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 2389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	__lambda9_ ((ChessApplication*) self);
#line 12650 "gnome-chess.c"
}


static void _chess_application_open_dialog_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 2390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_open_dialog_cb ((ChessApplication*) self, response_id);
#line 12657 "gnome-chess.c"
}


void chess_application_open_game_cb (ChessApplication* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkFileChooserDialog* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkApplicationWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	GtkFileChooserDialog* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileChooserDialog* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	GtkFileChooserDialog* _tmp28_ = NULL;
#line 2370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2372 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Save this game before loading another one?");
#line 2372 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_prompt_save_game (self, _tmp0_);
#line 2372 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 2373 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 12702 "gnome-chess.c"
	}
#line 2376 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->open_dialog;
#line 2376 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 12708 "gnome-chess.c"
		GtkFileChooserDialog* _tmp3_ = NULL;
#line 2378 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->open_dialog;
#line 2378 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp3_);
#line 2379 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 12716 "gnome-chess.c"
	}
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _ ("Load Chess Game");
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window;
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _ ("_Cancel");
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("_Open");
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp4_, (GtkWindow*) _tmp5_, GTK_FILE_CHOOSER_ACTION_OPEN, _tmp6_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp8_);
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 2382 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = _tmp8_;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->open_dialog;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = _tmp10_;
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 2387 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = _tmp11_;
#line 2389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->open_dialog;
#line 2389 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) ___lambda9__gtk_file_chooser_file_activated, self, 0);
#line 2390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->open_dialog;
#line 2390 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _chess_application_open_dialog_cb_gtk_dialog_response, self, 0);
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = gtk_file_filter_new ();
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp14_);
#line 2393 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp14_;
#line 2395 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = pgn_filter;
#line 2395 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("PGN files");
#line 2395 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp15_, _tmp16_);
#line 2396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = pgn_filter;
#line 2396 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp17_, "*.pgn");
#line 2397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->open_dialog;
#line 2397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = pgn_filter;
#line 2397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _g_object_ref0 (_tmp19_);
#line 2397 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp18_, _tmp20_);
#line 2399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_file_filter_new ();
#line 2399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp21_);
#line 2399 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp21_;
#line 2401 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = all_filter;
#line 2401 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _ ("All files");
#line 2401 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp22_, _tmp23_);
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = all_filter;
#line 2402 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp24_, "*");
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->open_dialog;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = all_filter;
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = _g_object_ref0 (_tmp26_);
#line 2403 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp25_, _tmp27_);
#line 2405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->open_dialog;
#line 2405 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp28_);
#line 2370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 2370 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 12810 "gnome-chess.c"
}


static void chess_application_open_dialog_cb (ChessApplication* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 2408 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 2410 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 12824 "gnome-chess.c"
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
#line 2414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->open_dialog;
#line 2414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
#line 2414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 2414 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp2_;
#line 2415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->game_file;
#line 2415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			chess_application_load_game (self, _tmp3_, &_inner_error_);
#line 2415 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12843 "gnome-chess.c"
				goto __catch7_g_error;
			}
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GtkInfoBar* _tmp8_ = NULL;
			GtkInfoBar* _tmp9_ = NULL;
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 2419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = e;
#line 2419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = _tmp4_->message;
#line 2419 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:2419: Failed to open game: %s", _tmp5_);
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->open_dialog_error_label;
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = _ ("Failed to open game");
#line 2420 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp6_, _tmp7_);
#line 2421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = self->priv->open_dialog_info_bar;
#line 2421 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp8_, GTK_MESSAGE_ERROR);
#line 2422 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = self->priv->open_dialog_info_bar;
#line 2422 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp9_);
#line 2423 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 2423 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 12885 "gnome-chess.c"
		}
		__finally7:
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 2412 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			return;
#line 12896 "gnome-chess.c"
		}
	}
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->open_dialog;
#line 2427 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
#line 2428 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 2428 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 2429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 2429 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 2430 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 2430 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 12915 "gnome-chess.c"
}


static void chess_application_start_new_game (ChessApplication* self) {
	PGNGame* _tmp0_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp1_ = NULL;
	PGNGame* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PGNGame* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gint duration = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* engine_name = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* engine_level = NULL;
	GSettings* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
#line 2433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2435 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 2435 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = NULL;
#line 2437 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->allow_claim_draw_dialog = TRUE;
#line 2438 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 2439 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_disable_window_action (self, CHESS_APPLICATION_SAVE_GAME_AS_ACTION_NAME);
#line 2441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = pgn_game_new ();
#line 2441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 2441 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp0_;
#line 2442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_date_time_new_now_local ();
#line 2442 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	now = _tmp1_;
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = now;
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_date (_tmp2_, _tmp5_);
#line 2443 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp5_);
#line 2444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->pgn_game;
#line 2444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = now;
#line 2444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
#line 2444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 2444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_time (_tmp6_, _tmp9_);
#line 2444 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp9_);
#line 2445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->settings;
#line 2445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
#line 2445 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	duration = _tmp11_;
#line 2446 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = duration;
#line 2446 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > 0) {
#line 13000 "gnome-chess.c"
		PGNGame* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		PGNGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PGNGame* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->pgn_game;
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = duration;
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_time_control (_tmp13_, _tmp16_);
#line 2448 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp16_);
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pgn_game;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = duration;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = g_strdup_printf ("%i", _tmp18_);
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp17_, _tmp20_);
#line 2449 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp20_);
#line 2450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->pgn_game;
#line 2450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = duration;
#line 2450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
#line 2450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = _tmp23_;
#line 2450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp21_, _tmp24_);
#line 2450 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp24_);
#line 13049 "gnome-chess.c"
	}
#line 2452 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->settings;
#line 2452 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = g_settings_get_string (_tmp25_, "opponent");
#line 2452 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	engine_name = _tmp26_;
#line 2453 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = engine_name;
#line 2453 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp27_, "") == 0) {
#line 13061 "gnome-chess.c"
		GList* _tmp28_ = NULL;
#line 2455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->ai_profiles;
#line 2455 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (_tmp28_ != NULL) {
#line 13067 "gnome-chess.c"
			GList* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
#line 2456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = self->priv->ai_profiles;
#line 2456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _tmp29_->data;
#line 2456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = ai_profile_get_name ((AIProfile*) _tmp30_);
#line 2456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _tmp31_;
#line 2456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_tmp32_);
#line 2456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2456 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp33_;
#line 13087 "gnome-chess.c"
		} else {
			gchar* _tmp34_ = NULL;
#line 2458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = g_strdup ("human");
#line 2458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2458 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp34_;
#line 13096 "gnome-chess.c"
		}
	}
#line 2460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->settings;
#line 2460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = g_settings_get_string (_tmp35_, "difficulty");
#line 2460 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	engine_level = _tmp36_;
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = engine_name;
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp38_ != NULL) {
#line 13109 "gnome-chess.c"
		const gchar* _tmp39_ = NULL;
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = engine_name;
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = g_strcmp0 (_tmp39_, "human") != 0;
#line 13115 "gnome-chess.c"
	} else {
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = FALSE;
#line 13119 "gnome-chess.c"
	}
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp37_) {
#line 13123 "gnome-chess.c"
		gchar* play_as = NULL;
		GSettings* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		const gchar* _tmp48_ = NULL;
		GSettings* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
#line 2463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = self->priv->settings;
#line 2463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = g_settings_get_string (_tmp40_, "play-as");
#line 2463 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		play_as = _tmp41_;
#line 2465 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = play_as;
#line 2465 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp42_, "alternate") == 0) {
#line 13141 "gnome-chess.c"
			gchar* last_side = NULL;
			GSettings* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = self->priv->settings;
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = g_settings_get_string (_tmp43_, "last-played-as");
#line 2467 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			last_side = _tmp44_;
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = last_side;
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp46_, "white") == 0) {
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = "black";
#line 13160 "gnome-chess.c"
			} else {
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = "white";
#line 13164 "gnome-chess.c"
			}
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = g_strdup (_tmp45_);
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (play_as);
#line 2468 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			play_as = _tmp47_;
#line 2465 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_g_free0 (last_side);
#line 13174 "gnome-chess.c"
		}
#line 2471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp48_ = play_as;
#line 2471 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp48_, "white") == 0) {
#line 13180 "gnome-chess.c"
			PGNGame* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			PGNGame* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
#line 2473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp49_ = self->priv->pgn_game;
#line 2473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp50_ = engine_name;
#line 2473 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_ai (_tmp49_, _tmp50_);
#line 2474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp51_ = self->priv->pgn_game;
#line 2474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp52_ = engine_level;
#line 2474 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_level (_tmp51_, _tmp52_);
#line 13197 "gnome-chess.c"
		} else {
			const gchar* _tmp53_ = NULL;
#line 2476 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			_tmp53_ = play_as;
#line 2476 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp53_, "black") == 0) {
#line 13204 "gnome-chess.c"
				PGNGame* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				PGNGame* _tmp56_ = NULL;
				const gchar* _tmp57_ = NULL;
#line 2478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp54_ = self->priv->pgn_game;
#line 2478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp55_ = engine_name;
#line 2478 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				pgn_game_set_white_ai (_tmp54_, _tmp55_);
#line 2479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp56_ = self->priv->pgn_game;
#line 2479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				_tmp57_ = engine_level;
#line 2479 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				pgn_game_set_white_level (_tmp56_, _tmp57_);
#line 13221 "gnome-chess.c"
			} else {
#line 2483 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
				g_assert_not_reached ();
#line 13225 "gnome-chess.c"
			}
		}
#line 2486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp58_ = self->priv->settings;
#line 2486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp59_ = play_as;
#line 2486 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_settings_set_string (_tmp58_, "last-played-as", _tmp59_);
#line 2461 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_free0 (play_as);
#line 13236 "gnome-chess.c"
	}
#line 2489 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_start_game (self);
#line 2433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_level);
#line 2433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_name);
#line 2433 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_date_time_unref0 (now);
#line 13246 "gnome-chess.c"
}


static void chess_application_load_game (ChessApplication* self, GFile* file, GError** error) {
	PGN* pgn = NULL;
	GFile* _tmp0_ = NULL;
	PGN* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	PGNGame* _tmp4_ = NULL;
	PGNGame* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 2492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (file != NULL);
#line 2494 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_enable_window_action (self, CHESS_APPLICATION_NEW_GAME_ACTION_NAME);
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = file;
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	pgn = _tmp1_;
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		g_propagate_error (error, _inner_error_);
#line 2496 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		return;
#line 13277 "gnome-chess.c"
	}
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = pgn->games;
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _g_object_ref0 ((PGNGame*) _tmp3_);
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 2497 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp4_;
#line 2499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->pgn_game;
#line 2499 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_ == NULL) {
#line 13293 "gnome-chess.c"
		PGNGame* _tmp6_ = NULL;
#line 2501 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_run_invalid_pgn_dialog (self);
#line 2502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = pgn_game_new ();
#line 2502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->pgn_game);
#line 2502 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->pgn_game = _tmp6_;
#line 2503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->game_file);
#line 2503 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_file = NULL;
#line 13307 "gnome-chess.c"
	} else {
		GFile* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
#line 2507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = file;
#line 2507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 2507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->game_file);
#line 2507 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		self->priv->game_file = _tmp8_;
#line 2508 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
		chess_application_start_game (self);
#line 13321 "gnome-chess.c"
	}
#line 2492 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn);
#line 13325 "gnome-chess.c"
}


static void chess_application_enable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
#line 2512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2512 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (name != NULL);
#line 2514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 2514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
#line 2514 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), TRUE);
#line 13345 "gnome-chess.c"
}


static void chess_application_disable_window_action (ChessApplication* self, const gchar* name) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
#line 2517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2517 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (name != NULL);
#line 2519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 2519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = name;
#line 2519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp0_, _tmp1_);
#line 2519 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction), FALSE);
#line 13365 "gnome-chess.c"
}


gint chess_application_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	ChessApplication* _tmp1_ = NULL;
	ChessApplication* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 2524 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	setlocale (LC_ALL, "");
#line 2525 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 2526 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 2527 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	textdomain (GETTEXT_PACKAGE);
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Chess");
#line 2529 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_set_application_name (_tmp0_);
#line 2530 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_default_icon_name ("gnome-chess");
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_application_new ();
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = args;
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp3__length1 = args_length1;
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = g_application_run ((GApplication*) _tmp2_, _tmp3__length1, _tmp3_);
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_tmp2_);
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	result = _tmp5_;
#line 2532 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return result;
#line 13410 "gnome-chess.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 2522 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	return chess_application_main (argv, argc);
#line 13420 "gnome-chess.c"
}


static void chess_application_class_init (ChessApplicationClass * klass) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	chess_application_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	g_type_class_add_private (klass, sizeof (ChessApplicationPrivate));
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->handle_local_options = chess_application_real_handle_local_options;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->startup = chess_application_real_startup;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->open = chess_application_real_open;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->activate = chess_application_real_activate;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	((GApplicationClass *) klass)->shutdown = chess_application_real_shutdown;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_application_finalize;
#line 13441 "gnome-chess.c"
}


static void chess_application_instance_init (ChessApplication * self) {
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv = CHESS_APPLICATION_GET_PRIVATE (self);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = NULL;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = FALSE;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->allow_claim_draw_dialog = TRUE;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->starting = TRUE;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent_engine = NULL;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self->priv->engine_timeout_counter = 10;
#line 13480 "gnome-chess.c"
}


static void chess_application_finalize (GObject* obj) {
	ChessApplication * self;
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_APPLICATION, ChessApplication);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 21 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_resume_button);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_label);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->clock_type_combo);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_adjustment);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_box);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->timer_increment_units_combo);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pgn_game);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->autosave_filename);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	__g_list_free__g_object_unref0_0 (self->priv->ai_profiles);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent_engine);
#line 13 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (chess_application_parent_class)->finalize (obj);
#line 13572 "gnome-chess.c"
}


GType chess_application_get_type (void) {
	static volatile gsize chess_application_type_id__volatile = 0;
	if (g_once_init_enter (&chess_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessApplication), 0, (GInstanceInitFunc) chess_application_instance_init, NULL };
		GType chess_application_type_id;
		chess_application_type_id = g_type_register_static (gtk_application_get_type (), "ChessApplication", &g_define_type_info, 0);
		g_once_init_leave (&chess_application_type_id__volatile, chess_application_type_id);
	}
	return chess_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



