/* chess-game.c generated by valac 0.29.3.11-7fa8, the Vala compiler
 * generated from chess-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_UNKNOWN,
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

struct _ChessGame {
	GObject parent_instance;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GObjectClass parent_class;
};

struct _ChessGamePrivate {
	gint hold_count;
	gboolean _is_paused;
	gboolean _should_show_paused_overlay;
	ChessClock* _clock;
};

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()
typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_game_parent_class = NULL;

GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_game_get_type (void) G_GNUC_CONST;
GType chess_state_get_type (void) G_GNUC_CONST;
GType chess_clock_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_GAME, ChessGamePrivate))
enum  {
	CHESS_GAME_DUMMY_PROPERTY,
	CHESS_GAME_IS_PAUSED,
	CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY,
	CHESS_GAME_CURRENT_STATE,
	CHESS_GAME_WHITE,
	CHESS_GAME_BLACK,
	CHESS_GAME_CURRENT_PLAYER,
	CHESS_GAME_OPPONENT,
	CHESS_GAME_CLOCK,
	CHESS_GAME_N_MOVES
};
void chess_clock_stop (ChessClock* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
GQuark pgn_error_quark (void);
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1, GError** error);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1, GError** error);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
GType chess_player_get_type (void) G_GNUC_CONST;
static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self);
static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player);
static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self);
static void chess_game_claim_draw_cb (ChessGame* self);
static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
ChessState* chess_state_copy (ChessState* self);
GType check_state_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType chess_move_get_type (void) G_GNUC_CONST;
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static void chess_game_complete_move (ChessGame* self);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
GType color_get_type (void) G_GNUC_CONST;
void chess_clock_set_active_color (ChessClock* self, Color value);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gboolean chess_game_is_three_fold_repeat (ChessGame* self);
gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self);
gboolean chess_game_can_claim_draw (ChessGame* self);
void chess_game_start (ChessGame* self);
static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock);
static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
void chess_game_pause (ChessGame* self, gboolean show_overlay);
ChessClock* chess_game_get_clock (ChessGame* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_clock_pause (ChessClock* self);
static void chess_game_set_is_paused (ChessGame* self, gboolean value);
static void chess_game_set_should_show_paused_overlay (ChessGame* self, gboolean value);
void chess_game_unpause (ChessGame* self);
void chess_clock_unpause (ChessClock* self);
gboolean chess_game_get_should_show_paused_overlay (ChessGame* self);
ChessPlayer* chess_state_get_opponent (ChessState* self);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
static void chess_game_finalize (GObject* obj);
static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType chess_result_get_type (void) {
	static volatile gsize chess_result_type_id__volatile = 0;
	if (g_once_init_enter (&chess_result_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RESULT_IN_PROGRESS, "CHESS_RESULT_IN_PROGRESS", "in-progress"}, {CHESS_RESULT_WHITE_WON, "CHESS_RESULT_WHITE_WON", "white-won"}, {CHESS_RESULT_BLACK_WON, "CHESS_RESULT_BLACK_WON", "black-won"}, {CHESS_RESULT_DRAW, "CHESS_RESULT_DRAW", "draw"}, {CHESS_RESULT_BUG, "CHESS_RESULT_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_result_type_id;
		chess_result_type_id = g_enum_register_static ("ChessResult", values);
		g_once_init_leave (&chess_result_type_id__volatile, chess_result_type_id);
	}
	return chess_result_type_id__volatile;
}


GType chess_rule_get_type (void) {
	static volatile gsize chess_rule_type_id__volatile = 0;
	if (g_once_init_enter (&chess_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RULE_UNKNOWN, "CHESS_RULE_UNKNOWN", "unknown"}, {CHESS_RULE_CHECKMATE, "CHESS_RULE_CHECKMATE", "checkmate"}, {CHESS_RULE_STALEMATE, "CHESS_RULE_STALEMATE", "stalemate"}, {CHESS_RULE_FIFTY_MOVES, "CHESS_RULE_FIFTY_MOVES", "fifty-moves"}, {CHESS_RULE_TIMEOUT, "CHESS_RULE_TIMEOUT", "timeout"}, {CHESS_RULE_THREE_FOLD_REPETITION, "CHESS_RULE_THREE_FOLD_REPETITION", "three-fold-repetition"}, {CHESS_RULE_INSUFFICIENT_MATERIAL, "CHESS_RULE_INSUFFICIENT_MATERIAL", "insufficient-material"}, {CHESS_RULE_RESIGN, "CHESS_RULE_RESIGN", "resign"}, {CHESS_RULE_ABANDONMENT, "CHESS_RULE_ABANDONMENT", "abandonment"}, {CHESS_RULE_DEATH, "CHESS_RULE_DEATH", "death"}, {CHESS_RULE_BUG, "CHESS_RULE_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_rule_type_id;
		chess_rule_type_id = g_enum_register_static ("ChessRule", values);
		g_once_init_leave (&chess_rule_type_id__volatile, chess_rule_type_id);
	}
	return chess_rule_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 315 "chess-game.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_list_free (self);
#line 324 "chess-game.c"
}


static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self) {
	gboolean result;
	result = chess_game_move_cb ((ChessGame*) self, _sender, move, apply);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 333 "chess-game.c"
}


static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self) {
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	chess_game_undo_cb ((ChessGame*) self, _sender);
#line 340 "chess-game.c"
}


static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_resign_cb ((ChessGame*) self, _sender);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 349 "chess-game.c"
}


static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self) {
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	chess_game_claim_draw_cb ((ChessGame*) self);
#line 356 "chess-game.c"
}


ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1, GError** error) {
	ChessGame * self = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	ChessPlayer* _tmp18_ = NULL;
	ChessPlayer* _tmp19_ = NULL;
	ChessPlayer* _tmp20_ = NULL;
	ChessPlayer* _tmp21_ = NULL;
	ChessPlayer* _tmp22_ = NULL;
	ChessPlayer* _tmp23_ = NULL;
	ChessPlayer* _tmp24_ = NULL;
	ChessPlayer* _tmp25_ = NULL;
	ChessPlayer* _tmp26_ = NULL;
	ChessPlayer* _tmp27_ = NULL;
	ChessPlayer* _tmp28_ = NULL;
	ChessPlayer* _tmp29_ = NULL;
	ChessPlayer* _tmp30_ = NULL;
	ChessPlayer* _tmp31_ = NULL;
	ChessPlayer* _tmp32_ = NULL;
	ChessPlayer* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (fen != NULL, NULL);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self = (ChessGame*) g_object_new (object_type, NULL);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->is_started = FALSE;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = fen;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_state_new (_tmp0_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->move_stack = g_list_prepend (self->move_stack, _tmp1_);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->result = CHESS_RESULT_IN_PROGRESS;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = moves;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2__length1 = moves_length1;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ != NULL) {
#line 403 "chess-game.c"
		{
			gint i = 0;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			i = 0;
#line 408 "chess-game.c"
			{
				gboolean _tmp3_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				_tmp3_ = TRUE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				while (TRUE) {
#line 415 "chess-game.c"
					gint _tmp5_ = 0;
					gchar** _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					ChessPlayer* _tmp7_ = NULL;
					ChessPlayer* _tmp8_ = NULL;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					const gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					if (!_tmp3_) {
#line 428 "chess-game.c"
						gint _tmp4_ = 0;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_tmp4_ = i;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						i = _tmp4_ + 1;
#line 434 "chess-game.c"
					}
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp3_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp5_ = i;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp6_ = moves;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp6__length1 = moves_length1;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					if (!(_tmp5_ < _tmp6__length1)) {
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						break;
#line 448 "chess-game.c"
					}
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp7_ = chess_game_get_current_player (self);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp8_ = _tmp7_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp9_ = moves;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp9__length1 = moves_length1;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp10_ = i;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp11_ = _tmp9_[_tmp10_];
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp12_ = chess_game_do_move (self, _tmp8_, _tmp11_, TRUE);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					if (!_tmp12_) {
#line 466 "chess-game.c"
						const gchar* _tmp13_ = NULL;
						gchar** _tmp14_ = NULL;
						gint _tmp14__length1 = 0;
						gint _tmp15_ = 0;
						const gchar* _tmp16_ = NULL;
						GError* _tmp17_ = NULL;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_tmp13_ = _ ("Failed to load PGN: move %s is invalid.");
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_tmp14_ = moves;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_tmp14__length1 = moves_length1;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_tmp15_ = i;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_tmp16_ = _tmp14_[_tmp15_];
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_tmp17_ = g_error_new (PGN_ERROR, PGN_ERROR_LOAD_ERROR, _tmp13_, _tmp16_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						_inner_error_ = _tmp17_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
						if (_inner_error_->domain == PGN_ERROR) {
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
							g_propagate_error (error, _inner_error_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
							_g_object_unref0 (self);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
							return NULL;
#line 495 "chess-game.c"
						} else {
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
							g_clear_error (&_inner_error_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
							return NULL;
#line 503 "chess-game.c"
						}
					}
				}
			}
		}
	}
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp18_ = chess_game_get_white (self);
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp19_ = _tmp18_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp19_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp20_ = chess_game_get_white (self);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp21_ = _tmp20_;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp21_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp22_ = chess_game_get_white (self);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp23_ = _tmp22_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp23_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp24_ = chess_game_get_white (self);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp25_ = _tmp24_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp25_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp26_ = chess_game_get_black (self);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp27_ = _tmp26_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp27_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp28_ = chess_game_get_black (self);
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp29_ = _tmp28_;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp29_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp30_ = chess_game_get_black (self);
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp31_ = _tmp30_;
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp31_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp32_ = chess_game_get_black (self);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp33_ = _tmp32_;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp33_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return self;
#line 560 "chess-game.c"
}


ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1, GError** error) {
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return chess_game_construct (TYPE_CHESS_GAME, fen, moves, moves_length1, error);
#line 567 "chess-game.c"
}


static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->is_started;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (!_tmp0_) {
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return result;
#line 592 "chess-game.c"
	}
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = player;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = move;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp3_ = apply;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp4_ = chess_game_do_move (self, _tmp1_, _tmp2_, _tmp3_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp4_;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 606 "chess-game.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 613 "chess-game.c"
}


static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessState* state = NULL;
	ChessState* _tmp3_ = NULL;
	ChessState* _tmp4_ = NULL;
	ChessState* _tmp5_ = NULL;
	ChessState* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	ChessState* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ChessState* _tmp13_ = NULL;
	ChessState* _tmp14_ = NULL;
	ChessState* _tmp15_ = NULL;
	ChessMove* _tmp16_ = NULL;
	ChessPiece* _tmp17_ = NULL;
	ChessState* _tmp21_ = NULL;
	ChessMove* _tmp22_ = NULL;
	ChessPiece* _tmp23_ = NULL;
	ChessState* _tmp24_ = NULL;
	ChessMove* _tmp25_ = NULL;
	ChessPiece* _tmp26_ = NULL;
	ChessState* _tmp30_ = NULL;
	ChessMove* _tmp31_ = NULL;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = player;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_game_get_current_player (self);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ != _tmp2_) {
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return result;
#line 662 "chess-game.c"
	}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp3_ = chess_game_get_current_state (self);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp4_ = _tmp3_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp5_ = chess_state_copy (_tmp4_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	state = _tmp5_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp6_ = state;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp7_ = _tmp6_->number;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp6_->number = _tmp7_ + 1;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp8_ = state;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp9_ = move;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp10_ = apply;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp11_ = chess_state_move (_tmp8_, _tmp9_, _tmp10_);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (!_tmp11_) {
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_g_object_unref0 (state);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return result;
#line 694 "chess-game.c"
	}
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp12_ = apply;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (!_tmp12_) {
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		result = TRUE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_g_object_unref0 (state);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return result;
#line 706 "chess-game.c"
	}
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp13_ = state;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->move_stack = g_list_prepend (self->move_stack, _tmp14_);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp15_ = state;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp16_ = _tmp15_->last_move;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp17_ = _tmp16_->victim;
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp17_ != NULL) {
#line 722 "chess-game.c"
		ChessState* _tmp18_ = NULL;
		ChessMove* _tmp19_ = NULL;
		ChessPiece* _tmp20_ = NULL;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp18_ = state;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp19_ = _tmp18_->last_move;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp20_ = _tmp19_->victim;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_signal_emit_by_name (_tmp20_, "died");
#line 734 "chess-game.c"
	}
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp21_ = state;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp22_ = _tmp21_->last_move;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp23_ = _tmp22_->piece;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_emit_by_name (_tmp23_, "moved");
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp24_ = state;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp25_ = _tmp24_->last_move;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp26_ = _tmp25_->moved_rook;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp26_ != NULL) {
#line 752 "chess-game.c"
		ChessState* _tmp27_ = NULL;
		ChessMove* _tmp28_ = NULL;
		ChessPiece* _tmp29_ = NULL;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp27_ = state;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp28_ = _tmp27_->last_move;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp29_ = _tmp28_->moved_rook;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_signal_emit_by_name (_tmp29_, "moved");
#line 764 "chess-game.c"
	}
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp30_ = state;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp31_ = _tmp30_->last_move;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_emit_by_name (self, "moved", _tmp31_);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	chess_game_complete_move (self);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = TRUE;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_g_object_unref0 (state);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 780 "chess-game.c"
}


void chess_game_add_hold (ChessGame* self) {
	gint _tmp0_ = 0;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->hold_count = _tmp0_ + 1;
#line 792 "chess-game.c"
}


void chess_game_remove_hold (ChessGame* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (_tmp0_ > 0);
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = self->priv->hold_count;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->hold_count = _tmp1_ - 1;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = self->priv->hold_count;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ == 0) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_complete_move (self);
#line 816 "chess-game.c"
	}
}


static void chess_game_complete_move (ChessGame* self) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ChessRule rule = 0;
	ChessResult _result_ = 0;
	ChessState* _tmp2_ = NULL;
	ChessState* _tmp3_ = NULL;
	ChessRule _tmp4_ = 0;
	ChessResult _tmp5_ = 0;
	ChessResult _tmp6_ = 0;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ > 0) {
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return;
#line 839 "chess-game.c"
	}
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = self->is_started;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (!_tmp1_) {
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return;
#line 847 "chess-game.c"
	}
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_game_get_current_state (self);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp5_ = chess_state_get_result (_tmp3_, &_tmp4_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	rule = _tmp4_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_result_ = _tmp5_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp6_ = _result_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp6_ != CHESS_RESULT_IN_PROGRESS) {
#line 863 "chess-game.c"
		ChessResult _tmp7_ = 0;
		ChessRule _tmp8_ = 0;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _result_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp8_ = rule;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, _tmp7_, _tmp8_);
#line 872 "chess-game.c"
	} else {
		ChessClock* _tmp9_ = NULL;
		ChessPlayer* _tmp14_ = NULL;
		ChessPlayer* _tmp15_ = NULL;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp9_ = self->priv->_clock;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		if (_tmp9_ != NULL) {
#line 881 "chess-game.c"
			ChessClock* _tmp10_ = NULL;
			ChessPlayer* _tmp11_ = NULL;
			ChessPlayer* _tmp12_ = NULL;
			Color _tmp13_ = 0;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			_tmp10_ = self->priv->_clock;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			_tmp11_ = chess_game_get_current_player (self);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			_tmp12_ = _tmp11_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			_tmp13_ = _tmp12_->color;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			chess_clock_set_active_color (_tmp10_, _tmp13_);
#line 896 "chess-game.c"
		}
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp14_ = chess_game_get_current_player (self);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp15_ = _tmp14_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_signal_emit_by_name (self, "turn-started", _tmp15_);
#line 904 "chess-game.c"
	}
}


static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (player != NULL);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = player;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_game_get_current_player (self);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ == _tmp2_) {
#line 928 "chess-game.c"
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp3_ = chess_game_get_opponent (self);
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp4_ = _tmp3_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_undo_cb (self, _tmp4_);
#line 937 "chess-game.c"
	}
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp5_ = self->move_stack;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp6_ = _tmp5_->next;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp6_ == NULL) {
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return;
#line 947 "chess-game.c"
	}
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp7_ = self->move_stack;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->move_stack = g_list_remove_link (self->move_stack, _tmp7_);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_emit_by_name (self, "undo");
#line 955 "chess-game.c"
}


static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->is_started;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (!_tmp0_) {
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return result;
#line 976 "chess-game.c"
	}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = player;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_RESIGN);
#line 986 "chess-game.c"
	} else {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_RESIGN);
#line 990 "chess-game.c"
	}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = TRUE;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 996 "chess-game.c"
}


static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1) {
	gint result = 0;
	gint count = 0;
	GList* _tmp0_ = NULL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (s1 != NULL, 0);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	count = 1;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 1012 "chess-game.c"
	{
		GList* s2_collection = NULL;
		GList* s2_it = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		s2_collection = _tmp0_;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		for (s2_it = s2_collection; s2_it != NULL; s2_it = s2_it->next) {
#line 1020 "chess-game.c"
			ChessState* _tmp1_ = NULL;
			ChessState* s2 = NULL;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			_tmp1_ = _g_object_ref0 ((ChessState*) s2_it->data);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			s2 = _tmp1_;
#line 1027 "chess-game.c"
			{
				gboolean _tmp2_ = FALSE;
				ChessState* _tmp3_ = NULL;
				ChessState* _tmp4_ = NULL;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				_tmp3_ = s1;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				_tmp4_ = s2;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				if (_tmp3_ != _tmp4_) {
#line 1038 "chess-game.c"
					ChessState* _tmp5_ = NULL;
					ChessState* _tmp6_ = NULL;
					gboolean _tmp7_ = FALSE;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp5_ = s1;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp6_ = s2;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp7_ = chess_state_equals (_tmp5_, _tmp6_);
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp2_ = _tmp7_;
#line 1050 "chess-game.c"
				} else {
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp2_ = FALSE;
#line 1054 "chess-game.c"
				}
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				if (_tmp2_) {
#line 1058 "chess-game.c"
					gint _tmp8_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_tmp8_ = count;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					count = _tmp8_ + 1;
#line 1064 "chess-game.c"
				}
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				_g_object_unref0 (s2);
#line 1068 "chess-game.c"
			}
		}
	}
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = count;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1076 "chess-game.c"
}


gboolean chess_game_is_three_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 1087 "chess-game.c"
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		state_collection = _tmp0_;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
#line 1095 "chess-game.c"
			ChessState* _tmp1_ = NULL;
			ChessState* state = NULL;
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			_tmp1_ = _g_object_ref0 ((ChessState*) state_it->data);
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			state = _tmp1_;
#line 1102 "chess-game.c"
			{
				ChessState* _tmp2_ = NULL;
				gint _tmp3_ = 0;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				_tmp2_ = state;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				_tmp3_ = chess_game_state_repeated_times (self, _tmp2_);
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				if (_tmp3_ >= 3) {
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					result = TRUE;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					_g_object_unref0 (state);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
					return result;
#line 1118 "chess-game.c"
				}
#line 237 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
				_g_object_unref0 (state);
#line 1122 "chess-game.c"
			}
		}
	}
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = FALSE;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1130 "chess-game.c"
}


gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self) {
	gboolean result = FALSE;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->halfmove_clock;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp2_ >= 100;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1151 "chess-game.c"
}


gboolean chess_game_can_claim_draw (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_game_is_fifty_move_rule_fulfilled (self);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp0_ = TRUE;
#line 1167 "chess-game.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp2_ = chess_game_is_three_fold_repeat (self);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp0_ = _tmp2_;
#line 1174 "chess-game.c"
	}
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1180 "chess-game.c"
}


static void chess_game_claim_draw_cb (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_is_fifty_move_rule_fulfilled (self);
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIFTY_MOVES);
#line 1194 "chess-game.c"
	} else {
		gboolean _tmp1_ = FALSE;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp1_ = chess_game_is_three_fold_repeat (self);
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		if (_tmp1_) {
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
			chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_THREE_FOLD_REPETITION);
#line 1203 "chess-game.c"
		}
	}
}


static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self) {
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	chess_game_clock_expired_cb ((ChessGame*) self, _sender);
#line 1212 "chess-game.c"
}


void chess_game_start (ChessGame* self) {
	ChessResult _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	ChessPlayer* _tmp9_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->result;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ != CHESS_RESULT_IN_PROGRESS) {
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return;
#line 1230 "chess-game.c"
	}
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = self->is_started;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return;
#line 1238 "chess-game.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->is_started = TRUE;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = self->priv->_clock;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ != NULL) {
#line 1246 "chess-game.c"
		ChessClock* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		Color _tmp7_ = 0;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp3_ = self->priv->_clock;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_signal_connect_object (_tmp3_, "expired", (GCallback) _chess_game_clock_expired_cb_chess_clock_expired, self, 0);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->priv->_clock;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp5_ = chess_game_get_current_player (self);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp6_ = _tmp5_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _tmp6_->color;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_clock_set_active_color (_tmp4_, _tmp7_);
#line 1266 "chess-game.c"
	}
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp8_ = chess_game_get_current_player (self);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp9_ = _tmp8_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_emit_by_name (self, "turn-started", _tmp9_);
#line 1274 "chess-game.c"
}


static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (clock != NULL);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_player (self);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_TIMEOUT);
#line 1296 "chess-game.c"
	} else {
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_TIMEOUT);
#line 1300 "chess-game.c"
	}
}


ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number) {
	ChessPiece* result = NULL;
	gint _tmp0_ = 0;
	ChessState* state = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
	ChessState* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	ChessPiece* _tmp13_ = NULL;
	ChessPiece* _tmp14_ = NULL;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = move_number;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ < 0) {
#line 1326 "chess-game.c"
		gint _tmp1_ = 0;
		GList* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp1_ = move_number;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp2_ = self->move_stack;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp3_ = g_list_length (_tmp2_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		move_number = _tmp1_ + ((gint) _tmp3_);
#line 1338 "chess-game.c"
	}
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp4_ = self->move_stack;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp5_ = self->move_stack;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp6_ = g_list_length (_tmp5_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp7_ = move_number;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp8_ = g_list_nth_data (_tmp4_, (_tmp6_ - _tmp7_) - 1);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp9_ = _g_object_ref0 ((ChessState*) _tmp8_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	state = _tmp9_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp10_ = rank;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp11_ = file;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp12_ = chess_state_get_index (state, _tmp10_, _tmp11_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp13_ = state->board[_tmp12_];
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp14_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_g_object_unref0 (state);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1370 "chess-game.c"
}


void chess_game_pause (ChessGame* self, gboolean show_overlay) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_game_get_clock (self);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 1387 "chess-game.c"
		ChessResult _tmp4_ = 0;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->result;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
#line 1393 "chess-game.c"
	} else {
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp1_ = FALSE;
#line 1397 "chess-game.c"
	}
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 1401 "chess-game.c"
		gboolean _tmp5_ = FALSE;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp5_ = self->priv->_is_paused;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp0_ = !_tmp5_;
#line 1407 "chess-game.c"
	} else {
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp0_ = FALSE;
#line 1411 "chess-game.c"
	}
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_) {
#line 1415 "chess-game.c"
		ChessClock* _tmp6_ = NULL;
		ChessClock* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp6_ = chess_game_get_clock (self);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _tmp6_;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_clock_pause (_tmp7_);
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_set_is_paused (self, TRUE);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp8_ = show_overlay;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_set_should_show_paused_overlay (self, _tmp8_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_signal_emit_by_name (self, "paused");
#line 1433 "chess-game.c"
	}
}


void chess_game_unpause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_game_get_clock (self);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 1451 "chess-game.c"
		ChessResult _tmp4_ = 0;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->result;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
#line 1457 "chess-game.c"
	} else {
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp1_ = FALSE;
#line 1461 "chess-game.c"
	}
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 1465 "chess-game.c"
		gboolean _tmp5_ = FALSE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp5_ = self->priv->_is_paused;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp0_ = _tmp5_;
#line 1471 "chess-game.c"
	} else {
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp0_ = FALSE;
#line 1475 "chess-game.c"
	}
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_) {
#line 1479 "chess-game.c"
		ChessClock* _tmp6_ = NULL;
		ChessClock* _tmp7_ = NULL;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp6_ = chess_game_get_clock (self);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _tmp6_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_clock_unpause (_tmp7_);
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_set_is_paused (self, FALSE);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_set_should_show_paused_overlay (self, FALSE);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_signal_emit_by_name (self, "unpaused");
#line 1494 "chess-game.c"
	}
}


void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule) {
	gboolean _tmp0_ = FALSE;
	ChessResult _tmp1_ = 0;
	ChessRule _tmp2_ = 0;
	ChessClock* _tmp3_ = NULL;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->is_started;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (!_tmp0_) {
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return;
#line 1512 "chess-game.c"
	}
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _result_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->result = _tmp1_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = rule;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->rule = _tmp2_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->is_started = FALSE;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp3_ = self->priv->_clock;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 1528 "chess-game.c"
		ChessClock* _tmp4_ = NULL;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->priv->_clock;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_clock_stop (_tmp4_);
#line 1534 "chess-game.c"
	}
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_emit_by_name (self, "ended");
#line 1538 "chess-game.c"
}


gboolean chess_game_get_is_paused (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_is_paused;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1553 "chess-game.c"
}


static void chess_game_set_is_paused (ChessGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = value;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->_is_paused = _tmp0_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_notify ((GObject *) self, "is-paused");
#line 1567 "chess-game.c"
}


gboolean chess_game_get_should_show_paused_overlay (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_should_show_paused_overlay;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1582 "chess-game.c"
}


static void chess_game_set_should_show_paused_overlay (ChessGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = value;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->_should_show_paused_overlay = _tmp0_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_notify ((GObject *) self, "should-show-paused-overlay");
#line 1596 "chess-game.c"
}


ChessState* chess_game_get_current_state (ChessGame* self) {
	ChessState* result;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_->data;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = (ChessState*) _tmp1_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1614 "chess-game.c"
}


ChessPlayer* chess_game_get_white (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->players[COLOR_WHITE];
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp2_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1635 "chess-game.c"
}


ChessPlayer* chess_game_get_black (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->players[COLOR_BLACK];
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp2_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1656 "chess-game.c"
}


ChessPlayer* chess_game_get_current_player (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->current_player;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp2_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1677 "chess-game.c"
}


ChessPlayer* chess_game_get_opponent (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessPlayer* _tmp3_ = NULL;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_state_get_opponent (_tmp1_);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp3_;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1701 "chess-game.c"
}


ChessClock* chess_game_get_clock (ChessGame* self) {
	ChessClock* result;
	ChessClock* _tmp0_ = NULL;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_clock;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1716 "chess-game.c"
}


void chess_game_set_clock (ChessGame* self, ChessClock* value) {
	gboolean _tmp0_ = FALSE;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->is_started;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		return;
#line 1732 "chess-game.c"
	}
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = value;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_g_object_unref0 (self->priv->_clock);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->_clock = _tmp2_;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_notify ((GObject *) self, "clock");
#line 1744 "chess-game.c"
}


guint chess_game_get_n_moves (ChessGame* self) {
	guint result;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	result = _tmp1_ - 1;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	return result;
#line 1762 "chess-game.c"
}


static void chess_game_class_init (ChessGameClass * klass) {
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	chess_game_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_type_class_add_private (klass, sizeof (ChessGamePrivate));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_game_get_property;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_game_set_property;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_game_finalize;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_IS_PAUSED, g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY, g_param_spec_boolean ("should-show-paused-overlay", "should-show-paused-overlay", "should-show-paused-overlay", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_STATE, g_param_spec_object ("current-state", "current-state", "current-state", TYPE_CHESS_STATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_WHITE, g_param_spec_object ("white", "white", "white", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_BLACK, g_param_spec_object ("black", "black", "black", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_PLAYER, g_param_spec_object ("current-player", "current-player", "current-player", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_OPPONENT, g_param_spec_object ("opponent", "opponent", "opponent", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CLOCK, g_param_spec_object ("clock", "clock", "clock", TYPE_CHESS_CLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_N_MOVES, g_param_spec_uint ("n-moves", "n-moves", "n-moves", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_new ("turn_started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_PLAYER);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_new ("moved", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_MOVE);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_new ("paused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_new ("unpaused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_new ("undo", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	g_signal_new ("ended", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1807 "chess-game.c"
}


static void chess_game_instance_init (ChessGame * self) {
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv = CHESS_GAME_GET_PRIVATE (self);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->hold_count = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->_is_paused = FALSE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self->priv->_should_show_paused_overlay = FALSE;
#line 1820 "chess-game.c"
}


static void chess_game_finalize (GObject* obj) {
	ChessGame * self;
	ChessClock* _tmp0_ = NULL;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_GAME, ChessGame);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_clock;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ != NULL) {
#line 1833 "chess-game.c"
		ChessClock* _tmp1_ = NULL;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		_tmp1_ = self->priv->_clock;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_clock_stop (_tmp1_);
#line 1839 "chess-game.c"
	}
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	__g_list_free__g_object_unref0_0 (self->move_stack);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	_g_object_unref0 (self->priv->_clock);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (chess_game_parent_class)->finalize (obj);
#line 1847 "chess-game.c"
}


GType chess_game_get_type (void) {
	static volatile gsize chess_game_type_id__volatile = 0;
	if (g_once_init_enter (&chess_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessGame), 0, (GInstanceInitFunc) chess_game_instance_init, NULL };
		GType chess_game_type_id;
		chess_game_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessGame", &g_define_type_info, 0);
		g_once_init_leave (&chess_game_type_id__volatile, chess_game_type_id);
	}
	return chess_game_type_id__volatile;
}


static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	switch (property_id) {
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_IS_PAUSED:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_boolean (value, chess_game_get_is_paused (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_boolean (value, chess_game_get_should_show_paused_overlay (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CURRENT_STATE:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_current_state (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_WHITE:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_white (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_BLACK:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_black (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CURRENT_PLAYER:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_current_player (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_OPPONENT:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_opponent (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CLOCK:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_clock (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_N_MOVES:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		g_value_set_uint (value, chess_game_get_n_moves (self));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 1922 "chess-game.c"
		default:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 1928 "chess-game.c"
	}
}


static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
	switch (property_id) {
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_IS_PAUSED:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_set_is_paused (self, g_value_get_boolean (value));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_set_should_show_paused_overlay (self, g_value_get_boolean (value));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CLOCK:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		chess_game_set_clock (self, g_value_get_object (value));
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 1956 "chess-game.c"
		default:
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-game.vala"
		break;
#line 1962 "chess-game.c"
	}
}



