/* chess-engine.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from chess-engine.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013-2014 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libchess.h"
#include "portability.h"
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>


#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;
typedef struct _ChessEnginePrivate ChessEnginePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ChessEngine {
	GObject parent_instance;
	ChessEnginePrivate * priv;
};

struct _ChessEngineClass {
	GObjectClass parent_class;
	void (*process_input) (ChessEngine* self, gchar* data, int data_length1);
	void (*start_game) (ChessEngine* self);
	void (*report_move) (ChessEngine* self, ChessMove* move);
	void (*do_undo) (ChessEngine* self);
	void (*request_move) (ChessEngine* self);
};

struct _ChessEnginePrivate {
	gchar* binary;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	guint delay_seconds;
	guint pending_move_source_id;
	GPid pid;
	gint stdin_fd;
	gint stderr_fd;
	GIOChannel* stdout_channel;
	guint stdout_watch_id;
	gboolean started;
	gboolean _ready;
};


static gpointer chess_engine_parent_class = NULL;

GType chess_engine_get_type (void) G_GNUC_CONST;
#define CHESS_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_ENGINE, ChessEnginePrivate))
enum  {
	CHESS_ENGINE_DUMMY_PROPERTY,
	CHESS_ENGINE_READY
};
void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1);
static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1);
ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds);
static gchar** _vala_array_dup19 (gchar** self, int length);
gboolean chess_engine_start (ChessEngine* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void ___lambda4_ (ChessEngine* self);
static void ____lambda4__gspawn_child_setup_func (gpointer self);
static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status);
static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition);
static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
void chess_engine_start_game (ChessEngine* self);
static void chess_engine_real_start_game (ChessEngine* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_do_undo (ChessEngine* self);
static void chess_engine_real_do_undo (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
static void chess_engine_real_request_move (ChessEngine* self);
void chess_engine_move (ChessEngine* self);
static gboolean __lambda5_ (ChessEngine* self);
static gboolean ___lambda5__gsource_func (gpointer self);
void chess_engine_undo (ChessEngine* self);
void chess_engine_stop (ChessEngine* self);
void chess_engine_write (ChessEngine* self, gchar* data, int data_length1);
void chess_engine_write_line (ChessEngine* self, const gchar* line);
gboolean chess_engine_get_ready (ChessEngine* self);
void chess_engine_set_ready (ChessEngine* self, gboolean value);
static void chess_engine_finalize (GObject* obj);
static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void chess_engine_real_process_input (ChessEngine* self, gchar* data, int data_length1) {
}


void chess_engine_process_input (ChessEngine* self, gchar* data, int data_length1) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->process_input (self, data, data_length1);
}


static gchar** _vala_array_dup19 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


ChessEngine* chess_engine_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, guint delay_seconds) {
	ChessEngine * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint _tmp4_ = 0U;
	g_return_val_if_fail (binary != NULL, NULL);
	self = (ChessEngine*) g_object_new (object_type, NULL);
	_tmp0_ = binary;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->binary);
	self->priv->binary = _tmp1_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup19 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->args = _tmp3_;
	self->priv->args_length1 = _tmp3__length1;
	self->priv->_args_size_ = self->priv->args_length1;
	_tmp4_ = delay_seconds;
	self->priv->delay_seconds = _tmp4_;
	return self;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void ___lambda4_ (ChessEngine* self) {
	maybe_kill_orphan_engine ();
}


static void ____lambda4__gspawn_child_setup_func (gpointer self) {
	___lambda4_ ((ChessEngine*) self);
}


static void _chess_engine_engine_stopped_cb_gchild_watch_func (GPid pid, gint status, gpointer self) {
	chess_engine_engine_stopped_cb ((ChessEngine*) self, pid, status);
}


static gboolean _chess_engine_read_cb_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = chess_engine_read_cb ((ChessEngine*) self, source, condition);
	return result;
}


gboolean chess_engine_start (ChessEngine* self) {
	gboolean result = FALSE;
	gchar** argv = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint stdout_fd = 0;
	GPid _tmp16_ = 0;
	gint _tmp17_ = 0;
	GIOChannel* _tmp18_ = NULL;
	GIOChannel* _tmp22_ = NULL;
	GIOChannel* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->binary;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	argv = _tmp2_;
	argv_length1 = 1;
	_argv_size_ = argv_length1;
	_tmp3_ = self->priv->args;
	_tmp3__length1 = self->priv->args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp3_;
		arg_collection_length1 = _tmp3__length1;
		for (arg_it = 0; arg_it < _tmp3__length1; arg_it = arg_it + 1) {
			gchar* _tmp4_ = NULL;
			gchar* arg = NULL;
			_tmp4_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp4_;
			{
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				_tmp5_ = argv;
				_tmp5__length1 = argv_length1;
				_tmp6_ = arg;
				_tmp7_ = g_strdup (_tmp6_);
				_vala_array_add1 (&argv, &argv_length1, &_argv_size_, _tmp7_);
				_g_free0 (arg);
			}
		}
	}
	_tmp8_ = argv;
	_tmp8__length1 = argv_length1;
	_vala_array_add2 (&argv, &argv_length1, &_argv_size_, NULL);
	{
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		GPid _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp9_ = argv;
		_tmp9__length1 = argv_length1;
		g_spawn_async_with_pipes (NULL, _tmp9_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, ____lambda4__gspawn_child_setup_func, self, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_inner_error_);
		self->priv->pid = _tmp10_;
		self->priv->stdin_fd = _tmp11_;
		stdout_fd = _tmp12_;
		self->priv->stderr_fd = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch13_g_spawn_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally13;
	__catch13_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("chess-engine.vala:77: Failed to execute chess engine: %s\n", _tmp15_);
		result = FALSE;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp16_ = self->priv->pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp16_, _chess_engine_engine_stopped_cb_gchild_watch_func, g_object_ref (self), g_object_unref);
	_tmp17_ = stdout_fd;
	_tmp18_ = g_io_channel_unix_new (_tmp17_);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	self->priv->stdout_channel = _tmp18_;
	{
		GIOChannel* _tmp19_ = NULL;
		_tmp19_ = self->priv->stdout_channel;
		g_io_channel_set_flags (_tmp19_, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch14_g_io_channel_error;
			}
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally14;
	__catch14_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("chess-engine.vala:90: Failed to set input from chess engine to non-blo" \
"cking: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp22_ = self->priv->stdout_channel;
	g_io_channel_set_close_on_unref (_tmp22_, TRUE);
	_tmp23_ = self->priv->stdout_channel;
	_tmp24_ = g_io_add_watch (_tmp23_, G_IO_IN, _chess_engine_read_cb_gio_func, self);
	self->priv->stdout_watch_id = _tmp24_;
	self->priv->started = TRUE;
	g_signal_emit_by_name (self, "starting");
	result = TRUE;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void chess_engine_engine_stopped_cb (ChessEngine* self, GPid pid, gint status) {
	GPid _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = pid;
	g_spawn_close_pid (_tmp0_);
	pid = (GPid) 0;
	g_signal_emit_by_name (self, "stopped");
}


static void chess_engine_real_start_game (ChessEngine* self) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_start_game'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_start_game (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->start_game (self);
}


static void chess_engine_real_report_move (ChessEngine* self, ChessMove* move) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_report_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_report_move (ChessEngine* self, ChessMove* move) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->report_move (self, move);
}


static void chess_engine_real_do_undo (ChessEngine* self) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_do_undo'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_do_undo (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->do_undo (self);
}


static void chess_engine_real_request_move (ChessEngine* self) {
	g_critical ("Type `%s' does not implement abstract method `chess_engine_request_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void chess_engine_request_move (ChessEngine* self) {
	g_return_if_fail (self != NULL);
	CHESS_ENGINE_GET_CLASS (self)->request_move (self);
}


static gboolean __lambda5_ (ChessEngine* self) {
	gboolean result = FALSE;
	self->priv->pending_move_source_id = (guint) 0;
	chess_engine_request_move (self);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((ChessEngine*) self);
	return result;
}


void chess_engine_move (ChessEngine* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->delay_seconds;
	_tmp1_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp0_, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->pending_move_source_id = _tmp1_;
}


void chess_engine_undo (ChessEngine* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending_move_source_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->pending_move_source_id;
		g_source_remove (_tmp1_);
		self->priv->pending_move_source_id = (guint) 0;
	}
	chess_engine_do_undo (self);
}


void chess_engine_stop (ChessEngine* self) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp13_ = FALSE;
	GPid _tmp14_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->started;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->stdout_watch_id;
	g_source_remove (_tmp1_);
	{
		GIOChannel* _tmp2_ = NULL;
		_tmp2_ = self->priv->stdout_channel;
		g_io_channel_shutdown (_tmp2_, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch15_g_io_channel_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally15;
	__catch15_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("chess-engine.vala:149: Failed to close channel to engine's stdout: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = self->priv->stdin_fd;
	_tmp6_ = close (_tmp5_);
	if (_tmp6_ == (-1)) {
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = errno;
		_tmp8_ = g_strerror (_tmp7_);
		g_warning ("chess-engine.vala:153: Failed to close pipe to engine's stdin: %s", _tmp8_);
	}
	_tmp9_ = self->priv->stderr_fd;
	_tmp10_ = close (_tmp9_);
	if (_tmp10_ == (-1)) {
		gint _tmp11_ = 0;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = errno;
		_tmp12_ = g_strerror (_tmp11_);
		g_warning ("chess-engine.vala:156: Failed to close pipe to engine's stderr: %s", _tmp12_);
	}
	_tmp14_ = self->priv->pid;
	if (_tmp14_ != ((GPid) 0)) {
		GPid _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp15_ = self->priv->pid;
		_tmp16_ = kill ((pid_t) _tmp15_, SIGTERM);
		_tmp13_ = _tmp16_ == (-1);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp17_ = 0;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = errno;
		_tmp18_ = g_strerror (_tmp17_);
		g_warning ("chess-engine.vala:159: Failed to kill engine: %s", _tmp18_);
	}
	self->priv->started = FALSE;
}


static gboolean chess_engine_read_cb (ChessEngine* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* buf = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gsize n_read = 0UL;
	GIOStatus status = 0;
	gchar* _tmp0_ = NULL;
	GIOStatus _tmp10_ = 0;
	GIOStatus _tmp11_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_new0 (gchar, 1024);
	buf = (g_free (buf), NULL);
	buf = _tmp0_;
	buf_length1 = 1024;
	_buf_size_ = buf_length1;
	{
		GIOStatus _tmp1_ = 0;
		GIOChannel* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gsize _tmp4_ = 0UL;
		GIOStatus _tmp5_ = 0;
		_tmp2_ = source;
		_tmp3_ = buf;
		_tmp3__length1 = buf_length1;
		_tmp5_ = g_io_channel_read_chars (_tmp2_, _tmp3_, _tmp3__length1, &_tmp4_, &_inner_error_);
		n_read = _tmp4_;
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch16_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch16_g_io_channel_error;
			}
			buf = (g_free (buf), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		status = _tmp1_;
	}
	goto __finally16;
	__catch16_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("chess-engine.vala:177: Failed to read from engine: %s", _tmp7_);
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	goto __finally16;
	__catch16_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("chess-engine.vala:183: Failed to read from engine: %s", _tmp9_);
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		_g_error_free0 (e);
		buf = (g_free (buf), NULL);
		return result;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		buf = (g_free (buf), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp10_ = status;
	if (_tmp10_ == G_IO_STATUS_EOF) {
		g_debug ("chess-engine.vala:190: EOF");
		self->priv->stdout_watch_id = (guint) 0;
		result = FALSE;
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp11_ = status;
	if (_tmp11_ == G_IO_STATUS_NORMAL) {
		gsize _tmp12_ = 0UL;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		_tmp12_ = n_read;
		_tmp13_ = (gint) _tmp12_;
		buf = g_renew (gchar, buf, (gint) _tmp12_);
		(_tmp13_ > buf_length1) ? memset (buf + buf_length1, 0, sizeof (gchar) * (_tmp13_ - buf_length1)) : NULL;
		buf_length1 = _tmp13_;
		_buf_size_ = _tmp13_;
		_tmp14_ = buf;
		_tmp14__length1 = buf_length1;
		chess_engine_process_input (self, _tmp14_, _tmp14__length1);
	}
	result = TRUE;
	buf = (g_free (buf), NULL);
	return result;
}


void chess_engine_write (ChessEngine* self, gchar* data, int data_length1) {
	gsize offset = 0UL;
	gsize n_written = 0UL;
	g_return_if_fail (self != NULL);
	offset = (gsize) 0;
	n_written = (gsize) 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gsize _tmp7_ = 0UL;
			gchar* _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gsize _tmp9_ = 0UL;
			gssize _tmp10_ = 0L;
			gsize _tmp11_ = 0UL;
			gsize _tmp12_ = 0UL;
			if (!_tmp0_) {
				gboolean _tmp1_ = FALSE;
				gsize _tmp2_ = 0UL;
				_tmp2_ = n_written;
				if (_tmp2_ > ((gsize) 0)) {
					gsize _tmp3_ = 0UL;
					gchar* _tmp4_ = NULL;
					gint _tmp4__length1 = 0;
					_tmp3_ = offset;
					_tmp4_ = data;
					_tmp4__length1 = data_length1;
					_tmp1_ = _tmp3_ < ((gsize) _tmp4__length1);
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp5_ = self->priv->stdin_fd;
			_tmp6_ = data;
			_tmp6__length1 = data_length1;
			_tmp7_ = offset;
			_tmp8_ = data;
			_tmp8__length1 = data_length1;
			_tmp9_ = offset;
			_tmp10_ = write (_tmp5_, &_tmp6_[_tmp7_], _tmp8__length1 - _tmp9_);
			n_written = (gsize) _tmp10_;
			_tmp11_ = offset;
			_tmp12_ = n_written;
			offset = _tmp11_ + _tmp12_;
		}
	}
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


void chess_engine_write_line (ChessEngine* self, const gchar* line) {
	gchar* l = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* d = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gint d_length1 = 0;
	gint _d_size_ = 0;
	gchar* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = g_strconcat (_tmp0_, "\n", NULL);
	l = _tmp1_;
	_tmp2_ = line;
	g_debug ("chess-engine.vala:218: Writing line to engine: '%s'", _tmp2_);
	_tmp3_ = l;
	_tmp5_ = string_to_utf8 (_tmp3_, &_tmp4_);
	d = _tmp5_;
	d_length1 = _tmp4_;
	_d_size_ = d_length1;
	_tmp6_ = d;
	_tmp6__length1 = d_length1;
	if (_tmp6_ != NULL) {
		gchar* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		_tmp7_ = d;
		_tmp7__length1 = d_length1;
		chess_engine_write (self, _tmp7_, _tmp7__length1);
	}
	d = (g_free (d), NULL);
	_g_free0 (l);
}


gboolean chess_engine_get_ready (ChessEngine* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ready;
	result = _tmp0_;
	return result;
}


void chess_engine_set_ready (ChessEngine* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ready = _tmp0_;
	g_signal_emit_by_name (self, "ready-changed");
	g_object_notify ((GObject *) self, "ready");
}


static void chess_engine_class_init (ChessEngineClass * klass) {
	chess_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessEnginePrivate));
	((ChessEngineClass *) klass)->process_input = chess_engine_real_process_input;
	((ChessEngineClass *) klass)->start_game = chess_engine_real_start_game;
	((ChessEngineClass *) klass)->report_move = chess_engine_real_report_move;
	((ChessEngineClass *) klass)->do_undo = chess_engine_real_do_undo;
	((ChessEngineClass *) klass)->request_move = chess_engine_real_request_move;
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_engine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_engine_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_engine_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_ENGINE_READY, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("starting", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("ready_changed", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("moved", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("resigned", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("stopped", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("error", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("claim_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("offer_draw", TYPE_CHESS_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_engine_instance_init (ChessEngine * self) {
	self->priv = CHESS_ENGINE_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->_ready = FALSE;
}


static void chess_engine_finalize (GObject* obj) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_ENGINE, ChessEngine);
	_g_free0 (self->priv->binary);
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_free), NULL);
	_g_io_channel_unref0 (self->priv->stdout_channel);
	G_OBJECT_CLASS (chess_engine_parent_class)->finalize (obj);
}


GType chess_engine_get_type (void) {
	static volatile gsize chess_engine_type_id__volatile = 0;
	if (g_once_init_enter (&chess_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEngine), 0, (GInstanceInitFunc) chess_engine_instance_init, NULL };
		GType chess_engine_type_id;
		chess_engine_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEngine", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&chess_engine_type_id__volatile, chess_engine_type_id);
	}
	return chess_engine_type_id__volatile;
}


static void _vala_chess_engine_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		g_value_set_boolean (value, chess_engine_get_ready (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_engine_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_ENGINE, ChessEngine);
	switch (property_id) {
		case CHESS_ENGINE_READY:
		chess_engine_set_ready (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



