/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef POSITION_H
#define POSITION_H

#include <gtk/gtk.h>

#define POSITION(obj) GTK_CHECK_CAST (obj, position_get_type(), Position)
#define POSITION_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, position_get_type(), PositionClass)
#define IS_POSITION(obj)       GTK_CHECK_TYPE (obj, position_get_type())

typedef struct _Position        Position;
typedef struct _PositionClass   PositionClass;
typedef struct _PositionPrivate PositionPrivate;

struct _PositionClass {
	GtkObjectClass parent_class;
};

struct _Position {
	GtkObject        object;

	/* 10x10 board - extra for move generation */
	gchar            square[120]; 

	PositionPrivate *priv;
};

GtkType    position_get_type            (void);    
GtkObject *position_new                 (void);
GtkObject *position_new_initial         (void);
Position  *position_copy                (Position *pos );
void       position_set_initial         (Position *pos);
void       position_move                (Position *pos, int from, int to);
gshort     position_move_normalize      (Position *pos, gshort from,gshort to);
void       position_move_reverse_white  (Position *pos, int from, int to);
void       position_move_reverse_black  (Position *pos, int from, int to);
void       position_move_reverse        (Position *pos, int from, int to);
gint       position_move_generator      (Position *pos, gchar **index0,gshort *anz_s,gshort *anz_n);
gboolean   position_white_king_attack   (Position *pos);
gboolean   position_black_king_attack   (Position *pos);
gshort     position_legal_move          (Position *pos, gchar **zl,gshort *as,gshort *an);

/* Misc. accessors */
void       position_set_white_king      (Position *pos, short wki);
void       position_set_black_king      (Position *pos, short ski);
void       position_set_color_to_move   (Position *pos, short tomove);
short      position_get_color_to_move   (Position *pos);
short      position_last_piece_captured (Position *pos);

#endif /* POSITION_H */
