/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* game-view.h
 *
 * Copyright (C) 2001  Helix Code, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _GAME_VIEW_H_
#define _GAME_VIEW_H_

#include <gnome.h>
#include "board.h"
#include "engine.h"
#include "movlist.h"
#include "board_info.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GAME_TYPE_VIEW			(game_view_get_type ())
#define GAME_VIEW(obj)			(GTK_CHECK_CAST ((obj), GAME_TYPE_VIEW, GameView))
#define GAME_VIEW_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GAME_TYPE_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj)			(GTK_CHECK_TYPE ((obj), GAME_TYPE_VIEW))
#define IS_GAME_VIEW_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GAME_TYPE_VIEW))


typedef struct _GameView        GameView;
typedef struct _GameViewPrivate GameViewPrivate;
typedef struct _GameViewClass   GameViewClass;

struct _GameView {
	GtkVBox parent;

	GameViewPrivate *priv;
};

struct _GameViewClass {
	GtkVBoxClass parent_class;

	void (*info) (Engine *engine, GameInfo *info);
};


GtkType    game_view_get_type (void);
GtkWidget *game_view_new      (void);
GtkWidget *game_view_new_with_engine (Engine *engine);

guint game_view_get_id (GameView *view);
void game_view_set_id (GameView *view, guint id);

Board *game_view_get_board (GameView *view);
Engine *game_view_get_engine (GameView *view);
MoveList *game_view_get_movelist (GameView *view);
BoardInfo *game_view_get_board_info (GameView *view);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _GAME_VIEW_H_ */
