/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef ENGINE_H
#define ENGINE_H

#include <gtk/gtk.h>
#include "board.h"
#include "position.h"

#define ENGINE(obj)	GTK_CHECK_CAST (obj, engine_get_type(), Engine)
#define ENGINE_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, engine_get_type(), EngineClass)
#define IS_ENGINE(obj)       GTK_CHECK_TYPE (obj, engine_get_type())

typedef struct _Engine		Engine;
typedef struct _EngineClass	EngineClass;

typedef struct {
	gchar *white;
	gchar *black;
	gint white_time;
	gint black_time;
	gint tomove;
	gint result;
	gchar *description;
} GameInfo;

typedef void (*EngineFillMenu) (Engine *, GtkMenuShell *, gint pos);
typedef void (*EngineMove)     (Engine *, gint from, gint to);

struct _EngineClass {
	GtkObjectClass parent_class;
	
	/* Virtual functions */
	EngineFillMenu engine_fill_menu;
	EngineMove     engine_move;

	/* Signal prototypes */
	void (*game) (Engine *engine, gint ply, Position *pos);
	void (*move) (Engine *engine, gint from, gint to);
	void (*unmove) (Engine *engine, guint ply);
	void (*info) (Engine *engine, GameInfo *info);
};

struct _Engine {
	GtkObject object;

	GtkWidget *board;
};

GtkType    engine_get_type  (void);
GtkObject *engine_new       (void);
void       engine_fill_menu (Engine       *engine,
			     GtkMenuShell *shell,
			     gint          pos);
Board *    engine_get_board (Engine       *engine);
void       engine_set_board (Engine       *engine,
			     Board        *board);
void       engine_move      (Engine       *engine,
			     gint          from,
			     gint          to);

#endif






