/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include <signal.h>

#include "makros.h"
#include "child.h"
#include "cho1.h"
#include "pro.h"
#include "movlist.h"
#include "position.h"

static GSList *engines=NULL;

struct engine * engine_new(char *cmd, char **arg)
{
  struct engine *e;

  e = malloc( sizeof(struct engine));
  e->childpid = 0;

  e->notation = COORD;
  e->menudata = malloc(sizeof(struct engine_menu));
  e->menudata->menu_init = NULL;
  e->menudata->menu_new_cb = NULL;
  e->menudata->menu_flag_cb = NULL;
  e->menudata->menu_draw_cb = NULL;
  e->menudata->menu_resign_cb = NULL;
  e->menudata->menu_start_cb = NULL;
  e->menudata->menu_previous_cb = NULL;
  e->menudata->menu_next_cb = NULL;
  e->menudata->menu_end_cb = NULL;
  e->menudata->menu_now_cb = NULL;
  e->menudata->menu_cwhite_cb = NULL;
  e->menudata->menu_cblack_cb = NULL;
  e->menudata->menu_twop_cb = NULL;
  e->menudata->menu_twoc_cb = NULL;
  e->menudata->menu_analyze_cb = NULL;

  e->data = NULL;
  e->read_from = e->write_to = NULL;

  if (cmd != NULL)
  	start_child(cmd, arg, &e->read_from, &e->write_to, &e->childpid);

  engines = g_slist_append(engines,e);

  return e;
}

void engine_write(struct engine *e, char *format,...)
{
  FILE *file= e->write_to;

  va_list ap;
  va_start(ap,format);
  if (file)
    vfprintf(file,format,ap);
  debug_print(DEBUG_VERBOSE,format,ap);  
  va_end(ap);
}

static void position_to_engine(struct engine *e)
{
  int i;
  char s[10];
  char *p;

  engine_write(e,"edit\n");
  engine_write(e,"#\n");

  for (i=A1; i<= H8;i++)
    {
      p = s;
      switch (currPositionPtr->square[i])
	{
	case WP:  *p++='P';break;
	case WN:  *p++='N';break;
	case WB:  *p++='B';break;
	case WR:  *p++='R';break;
	case WQ:  *p++='Q';break;
	case WK:  *p++='K';break;
	default:   continue;
	}

      *p++   = i - i / 10 * 10 + 96;   /*  a - h       */
      *p++   = i / 10 + 47 ;              /*  1 - 8       */
      *p=0;
      printf("%s\n",s);  
      engine_write(e,"%s\n",s);  
    }

  engine_write(e,"c\n");  
  
  for (i=A1; i<= H8;i++)
    {
      p = s;
      switch (currPositionPtr->square[i])
	{
	case BP:  *p++='P';break;
	case BN:  *p++='N';break;
	case BB:  *p++='B';break;
	case BR:  *p++='R';break;
	case BQ:  *p++='Q';break;
	case BK:  *p++='K';break;
	default:   continue;
	}

      *p++   = i - i / 10 * 10 + 96;   /*  a - h       */
      *p++   = i / 10 + 47 ;              /*  1 - 8       */
      *p=0;
      printf("%s\n",s);  
      engine_write(e,"%s\n",s);  
    }

  engine_write(e,".\n");
}

void engine_write_move(int from, int to) {
  char s[100];
  char *str = NULL;

  if (first_chess_programm == NULL) return;

  if (gnomechess_movelist_currply(board.movelist) != gnomechess_movelist_maxply(board.movelist))
       position_to_engine(first_chess_programm);

  if (first_chess_programm->notation) {
	move_to_ascii(s,from,to);
	engine_write(first_chess_programm,"%s\n",s);
  } else {
	str = move_to_san(currPositionPtr,from, to);
	engine_write(first_chess_programm,"%s\n",str);
  	free(str);
  }
}

void engine_destroy_all() {
	int i;
	int n = g_slist_length(engines);
	struct engine *e;

	for (i=0;i<n;i++) {
		e = (struct engine *)g_slist_nth_data (engines,i);

		if (e->data)
			free(e->data);
		stop_child(e->childpid);
	}
}

  
