/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <glib.h>

#include "makros.h"
#include "position.h"
#include "pro.h"

static const int jump[]={ 8, 12,19, 21,-8,-12,-19,-21,     
                   9, 11,-9,-11, 1, 10,-10, -1,     
                   9, 11, 1, 10,-1,  1, 10, -1,
                  -9,-11, 1,-10,-1     };

static gchar *index,*sindex;

static void sdouble(gshort af,gshort a,gshort b);
static void wdouble(gshort af,gshort a,gshort b);
static void neuer_zug(gshort von,gshort nach);
static void neuer_szug(gshort von,gshort nach);
static void s_ro_l(void);
static void s_ro_k(void);
static void w_ro_k(void);
static void w_ro_l(void);

static void wpawn2(gshort af);
static void wpawn3(gshort af);
static void wpawn5(gshort af);
static void wpawn7(gshort af);
static void wb_um2(gshort af,gshort ef);
static void wknight(gshort af);
static void wbishop(gshort af);
static void wrook(gshort af);
static void wqueen(gshort af);
static void wking(gshort af);
static void wkingro(gshort af);

static void bpawn7(gshort af);
static void bpawn6(gshort af);
static void bpawn4(gshort af);
static void bpawn2(gshort af);
static void sb_um2(gshort af,gshort ef);
static void sknight(gshort af);
static void sbishop(gshort af);
static void srook(gshort af);
static void squeen(gshort af);
static void skingro(gshort af);
static void sking(gshort af);



static void inline neuer_zug(gshort von,gshort nach)
{

   *   index          = (gchar) von;
   * ( index + 1 )    = (gchar) nach;
       index         += 2;
}

static void wpawn2(gshort af)      
{
   register gshort ef;

    ef = af + 10;    
    if (currPositionPtr->square[ef] == EMPTY ) {
        neuer_zug(af,ef);
        ef = af + 20;
        if (currPositionPtr->square[ef] == EMPTY ) {
            neuer_zug(af,ef);
        }
    }
    if (BPIECE(currPositionPtr->square[af + 9 ])) neuer_szug(af,af+9);
    if (BPIECE(currPositionPtr->square[af +11 ])) neuer_szug(af,af+11);
}

static void wpawn3(gshort af)  
{
   register gshort ef;

     ef = af + 10;
     if ( currPositionPtr->square[ef] == EMPTY ) neuer_zug(af,ef);

     if ( BPIECE( currPositionPtr->square[af + 9 ] ) ) neuer_szug(af, af + 9 );
     if ( BPIECE( currPositionPtr->square[af +11 ] ) ) neuer_szug(af, af + 11 );
}

static void wpawn5(gshort af)   
{

   wpawn3(af);

   if ( ( af - 1 ) == currPositionPtr->ep )  
       neuer_szug(af,af+9);
   else
   if ( ( af + 1 ) == currPositionPtr->ep )  
     neuer_szug(af,af+11);
}

static void  wpawn7(gshort af)
{
register gshort ef;

   ef = af + 10;
   if (currPositionPtr->square[ef] == EMPTY ) wb_um2(af,ef);

   if (BPIECE( currPositionPtr->square[af + 9] )) wb_um2( af , af + 9);
   if (BPIECE( currPositionPtr->square[af +11] )) wb_um2 (af , af +11);

}
static void wb_um2(gshort af,gshort ef)
{
register gshort b,i;

        for (i=2;i<6;i++) {
                b = 128 + 8 * i + ef - A8;
                neuer_szug(af,b);
        }
}
static void wknight(gshort af)
{
   register gshort a,fi,bb;

   for (a = 0 ; a < 8;a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (BPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void wbishop(gshort af)
{
   gshort a = 8,
        b = 12;

   wdouble(af,a,b);
}

static void wrook(gshort af)
{
   gshort a = 12,
        b = 16;

   wdouble(af,a,b);
}

static void wqueen(gshort af)
{
   gshort a = 8,
        b = 16;

   wdouble(af,a,b);
}

static void wking(gshort af)
{
register gshort a;
register gshort fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (BPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void wkingro(gshort af)  
{
register gshort a;
register gshort fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (BPIECE(fi)) neuer_szug(af,bb);
      }
   }

   if ( currPositionPtr->wki != E1) return;
   if ( ! currPositionPtr->wth ) w_ro_k();  
   if ( ! currPositionPtr->wta ) w_ro_l();  
}
static void w_ro_k(void)
{
  if ( currPositionPtr->square[F1] == EMPTY &&
       currPositionPtr->square[G1] == EMPTY &&
       currPositionPtr->square[H1] == WR)
    neuer_zug(E1,G1);

}
static void w_ro_l(void)
{
  if (currPositionPtr->square[D1] == EMPTY &&
      currPositionPtr->square[C1] == EMPTY &&
      currPositionPtr->square[B1] == EMPTY &&
      currPositionPtr->square[A1] == WR) 
    neuer_zug(E1,C1);
}
static void wdouble(gshort af,gshort a,gshort b)   
{
        gshort jp,
             ef = af,
             fi;

        for ( ; a < b ; a ++ )
        {
                ef = af;
                jp = jump[a];

                do {
                        ef += jp;
                        fi  = currPositionPtr->square[ef];

                        if ( fi == EMPTY )   neuer_zug(af,ef);
                else    if ( fi == BORDER )   break;
                else    if ( BPIECE(fi) ) { neuer_szug(af,ef);break; }
                else    break;
                }       while ( TRUE );
        }
}

static void bpawn7(gshort af)      
{
   register gshort ef;

    ef = af - 10;                
    if (currPositionPtr->square[ef] == EMPTY ) {
        neuer_zug(af,ef);
        ef = af - 20;            
        if (currPositionPtr->square[ef] == EMPTY ) {
            neuer_zug(af,ef);
        }
    }


    if (WPIECE(currPositionPtr->square[af - 9 ])) neuer_szug(af,af-9);
    if (WPIECE(currPositionPtr->square[af -11 ])) neuer_szug(af,af-11);
}

static void bpawn6(gshort af)                
{
   register gshort ef;

     ef = af - 10;
     if ( currPositionPtr->square[ef] == EMPTY ) neuer_zug(af,ef);

     if ( WPIECE( currPositionPtr->square[af - 9 ] ) ) neuer_szug(af, af - 9 );
     if ( WPIECE( currPositionPtr->square[af -11 ] ) ) neuer_szug(af, af - 11 );
}

static void bpawn4(gshort af)         
{
   bpawn6(af);

   if (( af - 1) == currPositionPtr->ep )   
     neuer_szug( af, af-11);
   if (( af + 1) == currPositionPtr->ep ) 
     neuer_szug( af, af-9);
}

static void  bpawn2(gshort af)  
{
register gshort ef;

   ef = af - 10;
   if (currPositionPtr->square[ef] == EMPTY ) sb_um2(af,ef);


   if (WPIECE( currPositionPtr->square[af - 9] )) sb_um2( af , af - 9);
   if (WPIECE( currPositionPtr->square[af -11] )) sb_um2 (af , af -11);

}
static void sb_um2(gshort af,gshort ef)    
{
register gshort b,i;
 for (i=2;i<6;i++)
   {
     b = 128 + 8 * i + ef - A1;
     neuer_szug(af,b);
   }
}
static void sknight(gshort af)
{
   register gshort a,fi,bb;

   for (a = 0 ; a < 8;a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (WPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void sbishop(gshort af)
{
   gshort a=8,
        b=12;

   sdouble(af,a,b);
}

static void srook(gshort af)
{
   gshort a = 12,
        b = 16;

   sdouble(af,a,b);
}

static void squeen(gshort af)
{
   gshort a=8,
        b=16;

   sdouble(af,a,b);
}

static void sking(gshort af)
{
register gshort a;
register gshort fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (WPIECE(fi)) neuer_szug(af,bb);
      }
   }
}

static void skingro(gshort af)     
{
register gshort a;
register gshort fi,bb;

   for (a = 8; a < 16 ; a++) {
      bb=af+jump[a];
      fi=currPositionPtr->square[bb];

      switch (fi) {
         case EMPTY:  neuer_zug(af,bb);break;
         case BORDER:  break;

         default  :  if (WPIECE(fi)) neuer_szug(af,bb);
      }
   }

   if ( currPositionPtr->ski != E8) return;
   if ( ! currPositionPtr->sth ) s_ro_k();  
   if ( ! currPositionPtr->sta ) s_ro_l();  
}
static void s_ro_k(void)
{

  if ( currPositionPtr->square[F8] == EMPTY &&
       currPositionPtr->square[G8] == EMPTY && 
       currPositionPtr->square[H8] == BR)
    neuer_zug(E8,G8);

}
static void s_ro_l(void)
{
  if (currPositionPtr->square[D8] == EMPTY &&
      currPositionPtr->square[C8] == EMPTY &&
      currPositionPtr->square[B8] == EMPTY &&
      currPositionPtr->square[A8] == BR) 
    neuer_zug(E8,C8);
}
static void sdouble(gshort af,gshort a,gshort b)  
{
        gshort jp,
             ef = af,
             fi;

        for ( ; a < b ; a ++ )
        {
                ef = af;
                jp = jump[a];

                do
                {
                        ef += jp;
                        fi  = currPositionPtr->square[ef];

                        if ( fi == EMPTY )   neuer_zug(af,ef);
                else    if ( fi == BORDER )   break;
                else    if ( WPIECE(fi) ) { neuer_szug(af,ef);break; }
                else    break;
                }       while ( TRUE );
        }
}

static void neuer_szug(gshort von,gshort nach)  
{
               sindex       -= 2;
            *  sindex        = (gchar) von;
            * (sindex + 1 )  = (gchar) nach;
}

static int movgen_white(gchar **index0,gshort *anz_s,gshort *anz_n)
{
   register gshort af,figur;

   index = sindex = *index0;

      for( af = A1 ; af <= H1 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) { 
               switch (figur)   {
                  case    WP: abort();          break;
                  case    WN: wknight(af);       break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wkingro(af);        break;
               }
            }
      }

      for( af = A2 ; af <= H2 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) { 
               switch (figur)   {
                  case    WP: wpawn2(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }

      for( af = A3 ; af <= H3 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) { 
               switch (figur)   {
                  case    WP: wpawn3(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A4 ; af <= H4 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn3(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A5 ; af <= H5 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn5(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A6 ; af <= H6 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn3(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A7 ; af <= H7 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: wpawn7(af);          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
      }
      for( af = A8 ; af <= H8 ; af++ ) {
         figur = currPositionPtr->square[af];
            if ( WPIECE(figur)) {
               switch (figur)   {
                  case    WP: abort();          break;
                  case    WN: wknight(af);        break;
                  case    WB: wbishop(af);         break;
                  case    WR: wrook(af);            break;
                  case    WQ: wqueen(af);            break;
                  case    WK: wking(af);          break;
               }
            }
         }

      *anz_n = (gshort) (( index  - *index0) / 2) ;
      *anz_s = (gshort) (( *index0 - sindex) / 2 );

      af = *anz_n + *anz_s ;
      *index0 = sindex;

      return af;
}

static int movgen_black(gchar **index0,gshort *anz_s,gshort *anz_n)
{
   register gshort af,figur;

   index = sindex = *index0;

      for( af = A1 ; af <= H1 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: abort();          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);        break;
               }
            }
      }
      for( af = A2 ; af <= H2 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn2(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A3 ; af <= H3 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn6(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A4 ; af <= H4 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn4(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A5 ; af <= H5 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn6(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A6 ; af <= H6 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn6(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A7 ; af <= H7 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: bpawn7(af);          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: sking(af);          break;
               }
            }
      }
      for( af = A8 ; af <= H8 ; af++ ) {
         figur = currPositionPtr->square[af];
            if (BPIECE(figur)) {
               switch (figur) {
                  case   BP: abort();          break;
                  case   BN: sknight(af);        break;
                  case   BB: sbishop(af);         break;
                  case   BR: srook(af);            break;
                  case   BQ: squeen(af);            break;
                  case   BK: skingro(af);          break;
               }
            }
      }

      *anz_n = (gshort) (( index  - *index0) / 2) ;
      *anz_s = (gshort) (( *index0 - sindex) / 2 );
     
      af = *anz_n + *anz_s ;
      *index0 = sindex;

      return af;
}


int  move_generator(gchar **index0,gshort *anz_s,gshort *anz_n)
{

	if (currPositionPtr->tomove == WHITE ) 
		return movgen_white(index0,anz_s,anz_n);
	else if (currPositionPtr->tomove == BLACK ) 
		return  movgen_black(index0,anz_s,anz_n);
    else
        abort();


}
