%{
/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"
#include "dialog_login.h"
#include "engine_ics_scan.h"
#include "zvt.h"

#undef YY_INPUT
#define YY_INPUT(b,r,ms) (r=engine_ics_input(b,ms))

char text[255];
char *user = NULL;
char *pass = NULL;

static void engine_ics_login() {
	if (!engine_ics_get_user(first_chess_programm) || !engine_ics_get_pass(first_chess_programm)) {
		dialog_login_new(first_chess_programm);
	} 
	strcpy(text,engine_ics_get_user(first_chess_programm));
	strncat(text, "\n",1);
	engine_write(first_chess_programm, text);
}

static void engine_ics_password() {
	strcpy(text,engine_ics_get_pass(first_chess_programm));
	strncat(text, "\n",1);
	engine_write(first_chess_programm,text);
}

static void engine_ics_prompt() {
	if (!engine_ics_is_loggedin(first_chess_programm)) {
		engine_write(first_chess_programm,"set style 12\n");
		engine_ics_set_loggedin(first_chess_programm, TRUE);
	}
}

static void engine_ics_invaliduser() {
	if (!engine_ics_is_loggedin(first_chess_programm)) {
		engine_ics_set_user(first_chess_programm, NULL);
		engine_ics_set_pass(first_chess_programm, NULL);
	}
}

static void engine_ics_invalidpassword() {
	if (!engine_ics_is_loggedin(first_chess_programm))
		engine_ics_set_pass(first_chess_programm, NULL);
}

static void engine_ics_result(char *result) {
	char *rstr;

	rstr = strrchr(result, ' ');
	rstr++;
	gnomechess_movelist_set_result(board.movelist, rstr);
	gnomechess_timer_stop(board.whitetime);
	gnomechess_timer_stop(board.blacktime);
	engine_ics_set_game(first_chess_programm, 0);
}

%}

invalidusername \".*\"[ ]is[ ]not[ ]a[ ]registered[ ]name.
invalidpassword [Ii]nvalid[ ]+[Pp]assword

style		<12>
piece		[-prnbkqPRNBKQ]
board		({piece}{8}[ ]){8}

tf			[01]
prev		((-1)|[0-7])
num			[0-9]+
rel			((-3)|(-2)|(-1)|(0)|(1)|(2))
name		[a-zA-Z0-9\-]+
verb		[^ \t\n]+
time		\({num}:{num}\)
not			[^ \t\n]+

win			"1-0"
lose		"0-1"
draw		"1/2-1/2"
result		[{]Game.*[}].*({win}|{lose}|{draw})

%%
^(\r){0,1}login:	{engine_ics_login();}

^(\r)?password: 	{engine_ics_password();}

{invalidusername} 	{engine_ics_invaliduser();}

{invalidpassword} 	{engine_ics_invalidpassword();}

.ics%			{engine_ics_prompt(); return (PROMPT);}

{result}		{engine_ics_result(yytext);}

{style}[ ]{board}(W|B)[ ]{prev}[ ]({tf}[ ]){4}({num}[ ]){2}({name}[ ]){2}{rel}[ ]({num}[ ]){7}{verb}[ ]{time}[ ]{not}[ ]{tf}\n {engine_ics_update_board(yytext);}
		
.		{strncat(text, yytext, 1);}
\n		{strncat(text, yytext, 1);
		zvt_print_raw_text(board.messages,text);
		strcpy(text,"");}

%%
