#include "gnome_chess.h"
#include "portab.h"
#include "position.h"
#include "makros.h"

position* currPositionPtr;

static void gnomechess_position_set_initial_field(position *pos);

position* gnomechess_position_new() {
	position *pos;
	
	pos = malloc(sizeof(position));
	gnomechess_position_set_initial_field(pos);
	return pos;
}

position* gnomechess_position_new_initial() {
	position *pos;

	pos = gnomechess_position_new();
	gnomechess_position_set_initial(pos);

	return pos;
}

position* gnomechess_position_copy(position *pos ) {
	position *cpPos;

	cpPos = gnomechess_position_new();
	memcpy(cpPos, pos, sizeof(position));
	memcpy(cpPos->square, pos->square, sizeof(BYTE)*120);
	return cpPos;
}

static void gnomechess_position_set_initial_field(position *pos) {
     unsigned int a;            

     for (a = 0 ; a < 120 ; a++ )  {
          pos->square[a]= EMPTY;
     }

     for (a=0;a<10;a++)  {
          pos->square[a]     = BORDER;
          pos->square[a+10]  = BORDER;
          pos->square[a+100] = BORDER;
          pos->square[a+110] = BORDER;
          pos->square[a*10]  = BORDER;
          pos->square[a*10+9]= BORDER;
     }

     pos->wki =
     pos->wth =
     pos->wta =
     pos->ski =
     pos->sth =
     pos->sta = 0;

     pos->amzug = NMOVE;  

}

void gnomechess_position_set_initial(position *pos) {
    unsigned int a;

	/* The white pieces */
    pos->square[A1] = WR;
	pos->square[B1] = WN;
	pos->square[C1] = WB;
	pos->square[D1] = WQ;
    pos->square[E1] = WK;
	pos->square[F1] = WB;
	pos->square[G1] = WN;
	pos->square[H1] = WR;

	/* The black pieces */
	pos->square[A8] = BR;
	pos->square[B8] = BN;
	pos->square[C8] = BB;
	pos->square[D8] = BQ;
	pos->square[E8] = BK;
	pos->square[F8] = BB;
	pos->square[G8] = BN;
	pos->square[H8] = BR;

	/* Pawns on the 2nd and 7th ranks */
	for (a = A2; a <= H2 ;a++)  pos->square[a] = WP;
	for (a = A7; a <= H7 ;a++)  pos->square[a] = BP;

	/* The rest is blank */
	for (a = A3; a <= H3 ;a++)  pos->square[a] = EMPTY;
	for (a = A4; a <= H4 ;a++)  pos->square[a] = EMPTY;
	for (a = A5; a <= H5 ;a++)  pos->square[a] = EMPTY;
	for (a = A6; a <= H6 ;a++)  pos->square[a] = EMPTY;

	/* White to move, white king on E1 and black king on E8 */
	pos->wta = 0;
	pos->wth = 0;
	pos->wki = E1;
	pos->sta = 0;
	pos->sth = 0;
	pos->ski = E8;
	pos->amzug = WMOVE;
}

static void gnomechess_position_wcastle_short(position *pos) {
        pos->square[E1] = pos->square[H1] = EMPTY;
        pos->square[F1] = WR;
        pos->square[G1] = WK;
}

static void gnomechess_position_wcastle_long(position *pos) {
        pos->square[E1] = pos->square[A1] = EMPTY;
        pos->square[C1] = WK;
        pos->square[D1] = WR;
}

static void gnomechess_position_bcastle_short(position *pos) {
        pos->square[E8] = pos->square[H8] = EMPTY;
        pos->square[F8] = BR;
        pos->square[G8] = BK;
}

static void gnomechess_position_bcastle_long(position *pos) {
        pos->square[E8] = pos->square[A8] = EMPTY;
        pos->square[C8] = BK;
        pos->square[D8] = BR;
}

static void gnomechess_position_white_move(position *pos, int from, int to) {
	WORD piece,zfeld;

	piece = pos->square[from];

	switch (piece) {
		case WP :
			/* If we are promoting a pawn */
			if ( to & 128) {
				zfeld = (to & 7) + A8;            
				piece = ((to & 127) >> 3 ) + WP - 1;

				pos->vf = pos->square[zfeld];
				pos->square[from] = EMPTY;
				pos->square[zfeld]  = piece;
				pos->ep = EMPTY;
				return;
			}

			/* If we are capturing en passent */
			if((to-from) !=10) {
				if((to-from) !=20) {
					if(pos->square[to] == EMPTY) {
						pos->square[to-10] = EMPTY;
						pos->ep = EMPTY;
						pos->square[to] = WP;
						pos->square[from] = EMPTY;
						pos->vf = EMPTY;
						return;
					}
				}
			}

			pos->vf = pos->square[to];
			pos->square[to] = piece;
			pos->square[from]  = EMPTY;

			if ((to-from) == 20) 	
				pos->ep = to;
			else  
				pos->ep = EMPTY;
			return;

		case WK :
			pos->ep=EMPTY;
			pos->wki = to;
			pos->wta += 1;
			pos->wth += 1;

			/*  If we are not castling */
			if (from != E1 || abs(to-from) != 2) {
				pos->vf = pos->vf = pos->square[to];
				pos->square[to] = piece;
				pos->square[from]  = EMPTY;
				return;
			}

			/*  If we are castling */
			switch  (to) {
				case G1 :
					gnomechess_position_wcastle_short(pos);
					break;  
				case C1 :
					gnomechess_position_wcastle_long(pos);
					break;  
				default :       
					abort();
			}
			return;

		default :
			pos->ep=EMPTY;
			pos->vf = pos->square[to];
			pos->square[to] = piece;
			pos->square[from]  = EMPTY;

			/* Indicate if a rook has moved */
			if ( piece == WR && from == A1) pos->wta += 1;
			if ( piece == WR && from == H1) pos->wth += 1;
			return;
	}
}

static void gnomechess_position_black_move(position *pos, int from, int to) {
	WORD piece,zfeld;

	piece = pos->square[from];

	switch (piece) {
		case BP :
			/* If we are promoting a pawn */
			if ( to & 128) {
				zfeld = (to & 7) + A1;
				piece = ((to & 127) >> 3) + BP - 1;
				pos->vf = pos->square[zfeld];
				pos->square[from]    = EMPTY;
				pos->square[zfeld]  = piece;
				pos->ep = EMPTY;
				return;
			}

			/* If we are capturing en passent */
			if((from-to) !=10) {
				if((from-to) !=20) {
					if(pos->square[to] == EMPTY) {
						pos->square[to+10] = EMPTY;
						pos->ep = EMPTY;
						pos->square[to] = BP;
						pos->square[from] = EMPTY;
						pos->vf = EMPTY;
						return;
					}
				}
			}

			pos->vf = pos->square[to];
			pos->square[to] = piece;
			pos->square[from]  = EMPTY;

			if ((from-to) == 20) 	
				pos->ep = to;
			else                   
				pos->ep = EMPTY;	
			return;

		case BK :
			pos->ep=EMPTY;
			pos->ski = to;
			pos->sta += 1;
			pos->sth += 1;

			/*  If we are not castling */
			if (from != E8 || abs(to-from) != 2) {
				pos->vf = pos->square[to];
				pos->square[to] = piece;
				pos->square[from]  = EMPTY;
				return;
			}

			/*  If we are castling */
			switch  (to)    {
				case G8 :       
					gnomechess_position_bcastle_short(pos);
					break; 
				case C8 :
					gnomechess_position_bcastle_long(pos);
					break; 
				default :
					abort();
			}
			return;

		default :
			pos->ep=EMPTY;
			pos->vf = pos->square[to];
			pos->square[to] = piece;
			pos->square[from]  = EMPTY;

			/* Indicate if a rook has moved */
			if ( piece == BR && from == A8) pos->sta += 1;
			if ( piece == BR && from == H8) pos->sth += 1;
			return;
	}
}

void gnomechess_position_make_move(position *pos, int from, int to) {

	switch (currPositionPtr->amzug) {
		case WMOVE:
			gnomechess_position_white_move(pos, from,to);
			pos->amzug = BMOVE;
			break;
		case BMOVE:
			gnomechess_position_black_move(pos, from,to);
			pos->amzug = WMOVE;
			break;
        	default :
			abort();
	}
}

void gnomechess_position_destroy(position **pos) {
	if (*pos)
		free(*pos);
	*pos = NULL;
}
