/* child.c */

#include "gnome_chess.h"
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include <signal.h>

#include "portab.h"
#include "cho1.h"
#include "pro.h"
#include "position.h"
#include "child.h"

int start_child(char *cmd, char *arg, FILE **readpipe, FILE **writepipe,pid_t *childpid)
{
int pipe1[2],pipe2[2];

if((pipe(pipe1) <0) || (pipe(pipe2) < 0))
  {
    perror("pipe");
    exit(-1);
  }

if((*childpid = fork())<0)
  {
    perror("fork");
    exit(-1);
  }
else if (*childpid > 0) /* Parent */
  {
    close(pipe1[0]);
    close(pipe2[1]);

    *readpipe  = fdopen(pipe2[0],"r");
    *writepipe = fdopen(pipe1[1],"w");
    setlinebuf(*writepipe);

    return *childpid;
  }
else   /* Child */
  {
    close(pipe1[1]);
    close(pipe2[0]);

    dup2(pipe1[0],0);
    dup2(pipe2[1],1);

    close(pipe1[0]);
    close(pipe2[1]);

    if (debug)
      fprintf (stderr,"cmd: %s %s\n",cmd,arg);

    if (execlp(cmd,cmd,arg,NULL) <0)
      perror("execlp");
    return 0;
  }

// NOT REACHED
  abort(); 
  return 0;
}

// Kill Child
int stop_child(pid_t childpid)
{

 if ( kill(childpid,SIGTERM) )
   { 
     if (debug)
       fprintf(stderr,"kill failed\n");
     return 1;
   }
 return 0;
}