# Note that this is NOT a relocatable package
%define ver      0.2.0
%define rel      1
%define prefix   /usr

Summary: GNOME chess
Name: gnome-chess
Version: %ver
Release: %rel
Copyright: GPL
Group: Games
Source: ftp://ftp.gnome.org/pub/gnome-chess-%{ver}.tar.gz
BuildRoot: /tmp/gnome-chess-root
URL: http://www.gnome.org
Docdir: %{prefix}/doc

%description
GNOME Chess

GNOME Chess is part of the GNOME project and is a graphical chess
interface.  It can provide and interface to GNU Chess, Crafty, chess
servers and PGN files.

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix --localstatedir=/var/lib
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix --localstatedir=/var/lib
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} \
	localstatedir=$RPM_BUILD_ROOT/var/lib install

strip $RPM_BUILD_ROOT%{prefix}/bin/* || :

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/*
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*
%{prefix}/share/gnome/apps/Games/*
