#include "../config.h"
#include <gnome.h>
#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "portab.h"
#include "typedef.h"
#include "makros.h"
#include "var.h"
#include "pro.h"
#include "menu.h"
#include "child.h"
#include "board.h"
#include "ini.h"
#include "txt_load.h"

#ifdef CHESS_ENGINE_CRAFTY
#define     FIRST_CHESS_PROGRAMM CHESS_ENGINE_CRAFTY
#define     FIRST_CHESS_PROGRAMM_ARG "xboard"
#else
#ifdef CHESS_ENGINE_GNUCHESS
#define     FIRST_CHESS_PROGRAMM CHESS_ENGINE_GNUCHESS
#define     FIRST_CHESS_PROGRAMM_ARG NULL
#endif
#endif

struct engine *first_chess_programm;

/* The debugging level */
int debugging = 0;

static char *fcp = NULL;
static char **startup_files = NULL;

static poptContext ctx;

static const struct poptOption gnome_chess_popt_options [] = {
	{ "fcp", '\0', POPT_ARG_STRING, &fcp, 0,
	  N_("First Chess Programm"),   N_("FILE") },
	{ "debug", '\0', POPT_ARG_INT, &debugging, 0,
	  N_("Enables some debugging functions"), N_("LEVEL") },
	{ NULL, '\0', 0, NULL, 0 }
};

int main(int argc,char *argv[])
{
     GtkWidget *box;
     GtkWidget *app;

     bindtextdomain (PACKAGE, GNOMELOCALEDIR);
     textdomain (PACKAGE);

     gnome_init_with_popt_table ("chess", VERSION, argc, argv, gnome_chess_popt_options,0, &ctx);

     ini_chessboard();

     //     pgn_test(); 
     //return 0;

     app = gnome_app_new ("chess", _("Gnomified chess program"));

     create_menus(app);

     if(fcp)
     first_chess_programm = new_engine(fcp,NULL);
     else
     first_chess_programm = new_engine(FIRST_CHESS_PROGRAMM,FIRST_CHESS_PROGRAMM_ARG);
     //     engine_write(first_chess_programm,"log off\n");
     engine_write(first_chess_programm,"xboard\n");
     engine_write(first_chess_programm,"post\n");
     engine_write(first_chess_programm,"easy\n");
     engine_write(first_chess_programm,"level 60 2 0\n");

     box = init_board();
     gnome_app_set_contents ( GNOME_APP (app), box);

     gtk_widget_show(box);
     gtk_widget_show (app);

     startup_files = poptGetArgs (ctx);
     if (startup_files) 
       pgn_open(startup_files);
     
     poptFreeContext (ctx);


     gtk_main ();


     return 0;
}

