#include <gnome.h>

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "portab.h"
#include "makros.h"
#include "typedef.h"
#include "var.h"
#include "pro.h"
#include "partie.h"
#include "txt_load.h"
#include "cho1.h"
#include "ini.h"
#include "board.h"

#define DEBUG 

struct  pgn_tag
{
  char *event;
  char *site;
  char *date;
  char *round;
  char *white;
  char *black;
  char *result;
};

enum {
  PGN_EVENT,
  PGN_SITE,
  PGN_DATE,
  PGN_ROUND,
  PGN_WHITE,
  PGN_BLACK,
  PGN_RESULT, 
  PGN_WHITE_COUNTRY, 
  PGN_BLACK_COUNTRY, 
  PGN_WHITE_TITLE,
  PGN_BLACK_TITLE,
  PGN_WHITE_ELO,
  PGN_BLACK_ELO,
  PGN_REMARK,
  PGN_ECO,
  PGN_OPENING,
  PGN_VARIATION,
  PGN_PLYCOUNT,
  PGN_ANNOTATOR,
  PGN_TIMECONTROL,
  PGN_NIC,
  PGN_EVENTDATE
};

static struct
{
  gchar *name;
  gint token;
} symbols[] = {
  { "Event", PGN_EVENT },         
  { "Site", PGN_SITE },
  { "Date", PGN_DATE },
  { "Round", PGN_ROUND },
  { "White", PGN_WHITE },
  { "Black", PGN_BLACK },
  { "Result", PGN_RESULT },
  { "WhiteCountry", PGN_WHITE_COUNTRY },
  { "BlackCountry", PGN_BLACK_COUNTRY },
  { "WhiteTitle", PGN_WHITE_TITLE },
  { "BlackTitle", PGN_BLACK_TITLE },
  { "WhiteELO", PGN_WHITE_ELO },
  { "BlackELO", PGN_BLACK_ELO },
  { "ELOWhite", PGN_WHITE_ELO }, // some broken programs use this
  { "ELOBlack", PGN_BLACK_ELO }, // and this
  { "Remark", PGN_REMARK },
  { "ECO", PGN_ECO },
  { "NIC", PGN_NIC },
  { "Opening", PGN_OPENING },
  { "Variation", PGN_VARIATION },
  { "Plycount", PGN_PLYCOUNT },
  { "Annotator", PGN_ANNOTATOR },
  { "EventDate", PGN_EVENTDATE },
  { "TimeControl", PGN_TIMECONTROL },
};

static guint nsymbols = sizeof (symbols) / sizeof (symbols[0]);

static GScannerConfig scanner_config =
{
  (
   " \t\n\r"
   )			/* cset_skip_characters */,
  (
   G_CSET_a_2_z
   "_"
   G_CSET_A_2_Z
   "_0123456789"
   )			/* cset_identifier_first */,
  (
   G_CSET_a_2_z
   "_0123456789"
   G_CSET_A_2_Z
   G_CSET_LATINS
   G_CSET_LATINC
   "-+\\='./;:,$"
   )			/* cset_identifier_nth */,
  ( ";\n" )		/* cpair_comment_single */,
  
  FALSE			/* case_sensitive */,
  
  TRUE			/* skip_comment_multi */,
  TRUE			/* skip_comment_single */,
  TRUE			/* scan_comment_multi */,
  TRUE			/* scan_identifier */,
  FALSE			/* scan_identifier_1char */,
  FALSE			/* scan_identifier_NULL */,
  TRUE			/* scan_symbols */,
  FALSE			/* scan_binary */,
  TRUE			/* scan_octal */,
  TRUE			/* scan_float */,
  TRUE			/* scan_hex */,
  FALSE			/* scan_hex_dollar */,
  TRUE			/* scan_string_sq */,
  TRUE			/* scan_string_dq */,
  TRUE			/* numbers_2_int */,
  FALSE			/* int_2_float */,
  FALSE			/* identifier_2_string */,
  TRUE			/* char_2_token */,
  FALSE			/* symbol_2_token */,
  FALSE			/* scope_0_fallback */
};

static char *filename;

static int txt_reg_move(char *str, int test);
static void pgn_header_load(GScanner *s, struct pgn_tag *);
static GScanner* pgn_scanner_init(void);
static GList * pgn_index(const char *fname);
static void  pgn_clist_add(GtkWidget * list ,struct pgn_tag tag);
static  GtkWidget  * pgn_clist_new(GList *game_list);
static void select_game(GtkWidget * widget,int row,int column,
                         GdkEventButton * bevent, GList *data);
static int txt_load_from_fp(FILE *fp, int len, int test);
static int txt_load(char *newbuf, int len, int test);
static void clist_click_column (GtkCList * clist, gint column, gpointer data);

#ifdef DEBUG
void pgn_test(void);
void pgn_test(void)
{
  int i,n;
  FILE *file;
  char *fname="ttt";
  GList *game_list;
  GList *game;

  filename = g_strdup(fname);
  game_list=pgn_index(fname);

  n = g_list_length(game_list); 
  file = fopen(fname, "r");

  game = game_list;

  for(i=0;i<n-1;i++)
    {
      printf("Game %d\n",i+1);
      fseek(file,(long)game->data,SEEK_SET);
      txt_load_from_fp(file,(long)game->next->data - (long)game->data, TRUE);
      game = game->next;
    }
}
#endif

/* HACK ALERT
   gscanner now has buffers and does no longer like external seeks.
   this hack works around the problem
   According to Tim Janik on gtk-devel (12 Nov 1998) 
   "this will hopefully change, as soon as an IO abstraction for GLib is
   implemented which can be used as an input to GScanner."          
*/


static void
g_scanner_sync_file_offset_extern (GScanner *scanner, gint offset )
{
  g_return_if_fail (scanner != NULL);

  if (scanner->input_fd >= 0)
    {
      if (lseek (scanner->input_fd, offset, SEEK_SET) >= 0)
	{
	  /* we succeeded, blow our buffer's contents now */
	  scanner->text = NULL;
	  scanner->text_end = NULL;
	}
    }
}

/* End of HACK ALERT */

void pgn_open(const char *fname)
{
  GtkWidget *clist;
  int i,n;
  int file;
  GList *game_list;
  GScanner *s = pgn_scanner_init();

  filename = g_strdup(fname);
  game_list=pgn_index(fname);
  n=g_list_length(game_list);
  clist = pgn_clist_new(game_list);

  file = open(fname, O_RDONLY);
  g_scanner_input_file(s,file);

  for(i=0;i<n-1;i++)
    {
      struct pgn_tag tag;
      
      printf("%ld\n",(long)g_list_nth_data(game_list,i));
      g_scanner_sync_file_offset_extern(s,(long)g_list_nth_data(game_list,i));
      pgn_header_load(s, &tag);
      pgn_clist_add(clist,tag);
    }

  close(file);
  g_scanner_destroy(s);
}
  
static void  pgn_clist_add(GtkWidget * clist ,struct pgn_tag tag)
{

  char    *text[3] = { "", "","" };
  gint row;

  printf("%s %s %s\n",tag.white,tag.black,tag.result);

  row=gtk_clist_append (GTK_CLIST(clist), text);
  gtk_clist_set_text (GTK_CLIST(clist), row , 0, tag.white);
  gtk_clist_set_text (GTK_CLIST(clist), row , 1, tag.black);
  gtk_clist_set_text (GTK_CLIST(clist), row , 2, tag.result);
  
}

static GList * pgn_index(const char *fname)
{
  long tell;

  FILE *fp = fopen(fname,"r");
  char buf[1024];
  char *p;

  int i=0;

  GList *game_list = NULL;

  if (!fp) return FALSE;

  while(1)
    {
      tell= ftell(fp);
      if ( !fgets(buf,sizeof(buf),fp)) break;

      if ((p=strstr(buf,"[Event \"")))
	{
	  i++;

	  if ( !(i % 1000)) printf("%d\n",i);

	  // for now use g_list_prepend(), because it is much faster
          // than g_list_append() ( O(1) vs. O(n) );

	  // if (p != buf) printf("offset %d\n",p-buf);
	  game_list = g_list_prepend(game_list,(void *) (tell + (p-buf)));
	}
    }

  game_list = g_list_prepend(game_list,(void *) tell);
  game_list = g_list_reverse(game_list);
  fclose(fp);
  return game_list;
}

static int txt_load_from_fp(FILE *fp, int len, int test)
{
  int ret;

  char *buf = malloc(len);
  // printf("%d %d\n",len,test);

  fread(buf,len,1,fp);
  ret = txt_load(buf,len,test);
  free(buf);
  return ret;
}

static GScanner* pgn_scanner_init()
{
  int i;
  GScanner *s = g_scanner_new(&scanner_config);

  for (i = 0; i < nsymbols; i++)
    g_scanner_add_symbol (s, symbols[i].name, 
			  GINT_TO_POINTER (symbols[i].token));
  return s;

}

static void pgntag(GTokenValue value1, GTokenValue value2, struct pgn_tag *tag)
{
	  switch (value1.v_int)
	    {
	    case PGN_EVENT:
	      tag->event = g_strdup(value2.v_string);
	      break;
	    case PGN_SITE:
	      tag->site = g_strdup(value2.v_string);
	      break;
	    case PGN_DATE:
	      tag->date = g_strdup(value2.v_string);
	      break;
	    case PGN_ROUND:
	      tag->round = g_strdup(value2.v_string);
	      break;
	    case PGN_WHITE:
	      tag->white = g_strdup(value2.v_string);
	      break;
	    case PGN_BLACK:
	      tag->black = g_strdup(value2.v_string);
	      break;
	    case PGN_RESULT:
	      tag->result = g_strdup(value2.v_string);
	      break;
	    default:
	      // printf("unused Tag");
	    }
}

static struct pgn_tag * pgn_tag_new(void)
{
  struct pgn_tag *tag= malloc(sizeof( struct pgn_tag));

  tag->event=tag->site=tag->date=tag->round=tag->white=tag->black=tag->result=0;

  return tag;
}
static void pgn_tag_destroy(struct pgn_tag *tag)
{
  if (tag->event) g_free(tag->event);
  if (tag->site)  g_free(tag->site);
  if (tag->date)  g_free(tag->date);
  if (tag->round) g_free(tag->round);
  if (tag->white) g_free(tag->white);
  if (tag->black) g_free(tag->black);
  if (tag->result)g_free(tag->result);

  g_free(tag);
}

static int txt_load(char *newbuf, int len, int test)
{
  struct pgn_tag *tag= pgn_tag_new();
  int ret =FALSE;
  GScanner *s = pgn_scanner_init();

  ini_game();

  g_scanner_input_text(s,newbuf,len);

  while(1)
    {
      GTokenValue value1,value2;
      GTokenType token2;
      GTokenType token =g_scanner_get_next_token(s);
      //      printf("%d ",token);

      if (token == G_TOKEN_EOF) break;


      switch(token)
	{
	case  G_TOKEN_LEFT_BRACE:
	  token2 =g_scanner_get_next_token(s);
	  value1 = g_scanner_cur_value(s);

	  if (token2 == G_TOKEN_SYMBOL)
	    {
	      g_scanner_get_next_token(s);
	      value2 = g_scanner_cur_value(s);
	      //	      printf (" \"%s\"]\n",value2.v_string);
	      pgntag(value1,value2,tag);
	    }
	  else
	    {
	      printf ("Unknown Tag [%s", value1.v_string);
	      g_scanner_get_next_token(s);
	      value2 = g_scanner_cur_value(s);
	      printf (" \"%s\"]\n",value2.v_string);
	    }
	  token2 =g_scanner_get_next_token(s);
	  if (token2 != G_TOKEN_RIGHT_BRACE)
	    {
	      printf("parse error\n");
	      ret = FALSE;
	      goto finish;
	    }
	  break;
	case  G_TOKEN_RIGHT_BRACE:
	case  G_TOKEN_SYMBOL:  
	case  G_TOKEN_STRING:
	  puts("parse error");
	  break;
	case  G_TOKEN_FLOAT:
	  // puts("float");
	  break;
	case  G_TOKEN_IDENTIFIER:
	  // puts("identifier");
	  value1 = g_scanner_cur_value(s);
	  //	  puts(value1.v_string);
	  if (  '0' <=  *value1.v_string &&  *value1.v_string <= '9')
	    break;
	  txt_reg_move(value1.v_string, test);
	  // g_free(value1.v_string);
	  break;
	case G_TOKEN_LEFT_CURLY: // comments are ignored for now
	  {
	    do 
	      {
		token2 =g_scanner_get_next_token(s);
		//    printf("CURLY: %d\n",token2);
		if (token2 ==  G_TOKEN_IDENTIFIER) 
		  {
		    //   puts("identifier");
		    value1 = g_scanner_cur_value(s);
		    // puts(value1.v_string);
		  }
		else 
		  if (token2 ==  G_TOKEN_EOF) 
		    { 
		      printf("EOF in comment!");
		      ret = FALSE;
		      goto finish;
		    }
	      }
	    while(token2 != G_TOKEN_RIGHT_CURLY);
	    break;
	  }
	case G_TOKEN_LEFT_PAREN: // RAVs are ignored for now
	  { 
	    int nest=1;
	    // printf("nest %d\n",nest);
	    while(1) 
	      {
		token2 =g_scanner_get_next_token(s);
		// printf("token: %d\n",token2);
		if (token2 == G_TOKEN_EOF)
		  {
		    printf("EOF in RAV!");
		    ret = FALSE;
		    goto finish;
		  }
		else
		if (token2 == G_TOKEN_LEFT_PAREN) 
		  {
		    nest++;
		    //  printf("nest %d\n",nest);
		  }
		else
		if (token2 == G_TOKEN_RIGHT_PAREN) 
		  {
		    nest--;
		    // printf("unnest %d\n",nest);
		    if (!nest) break;
		  }

	      }
	  }
	  break;
	default:
	  printf("unknown %d\n",token);
	  ret = FALSE;
	  goto finish;
	}
    }

  ret = TRUE;

 finish:
  pgn_tag_destroy(tag);
  g_scanner_destroy(s);
  return ret;
}

static void pgn_header_load(GScanner *s, struct pgn_tag * tp)
{

  while(1)
    {
      GTokenValue value1,value2;
      GTokenType token =g_scanner_get_next_token(s);
//      printf("%d\n",token);

	if (token == G_TOKEN_EOF) break;


      switch(token)
	{
	case  G_TOKEN_LEFT_BRACE:
	  break;
	case  G_TOKEN_RIGHT_BRACE:
	  break;
	case  G_TOKEN_SYMBOL:  
	  value1 = g_scanner_cur_value(s);
          g_scanner_get_next_token(s);
	  value2 = g_scanner_cur_value(s);
	  pgntag(value1,value2,tp);
	  break;
	case  G_TOKEN_STRING:
	  puts("string");
	  break;
	case  G_TOKEN_FLOAT:
	  // puts("float");
	  break;
	case  G_TOKEN_IDENTIFIER:
	  // puts("identifier");
	  value1 = g_scanner_cur_value(s);
	  // puts(value1.v_string);
	  // txt_reg_move(value1.v_string);
	  goto finish;
	  break;
	  
	default:
	  printf("unknown %d\n",token);
	  return;
	}
    }

 finish:
}


static void delete_x(char *str)
{
  char *p = strchr(str,'x');

  if (p)
      while(( *p = *(p+1)))
	p++;
}

static void delete_plus(char *str)
{
  char *p = strchr(str,'+');

  if (p)
      while(( *p = *(p+1)))
	p++;
}

static void delete_ep(char *str)
{
  char *p = strstr(str,"ep");

  if (p)
      while(( *p = *(p+2)))
	p++;
}

static void delete_equal(char *str)
{
  char *p = strstr(str,"=");

  if (p)
      while(( *p = *(p+1)))
	p++;
}

static inline int txt_reg_move_found(BYTE *aq, int test)
{
	    int piece=feld[*aq];
	    make_move(*aq,*(aq+1));
	    if (!test) notation_update(piece,*aq,*(aq+1));
	    return TRUE;		
}

static int txt_reg_move(char *str, int test)
{
  WORD anz,anz_n,anz_s;
  WORD i;
  BYTE *ap,*aq;
  BYTE *p;
  BYTE zugliste[AB_ZUGL];
  BYTE liste[100][10];

  delete_x(str);
  delete_plus(str);
  delete_ep(str);
  delete_equal(str);

  ap =  zugliste + AB_ZUG_S;
  anz = legal_move(&ap,&anz_s,&anz_n);

  for ( aq = ap , i = 0 ; i < anz ; i++ , aq += 2 ) 
  {
    p=liste[i];
    piece_move_to_ascii(p,feld[(WORD)*aq],*aq,*(aq+1));
    if ( *p == ' ')  /* pawn move */
      {
	p++;         /* e.g. e2e4 */
	if (!strcmp(p,str))
	  return txt_reg_move_found(aq,test);
	p[1]=p[2];  /* e.g. ed5 */
	p[2]=p[3];
	p[3]=p[4];
	p[4]=p[5];
	if (p[0] != p[1])   /* not e.g. bb3 */
	  if (!strcmp(p,str))
	    return txt_reg_move_found(aq,test);

	p++;	 /* e.g. d5 */
	if (!strcmp(p,str))
	  return txt_reg_move_found(aq,test);

      }
    else  /* no pawn move */
      {
	char  tmp;

	if (!strcmp(p,str))  /* e.g. Ng1f3 */
	  return txt_reg_move_found(aq,test);

	tmp =p[2];
	p[2]=p[3];         /* Ngf3 */
	p[3]=p[4];
	p[4]=p[5];

	if (!strcmp(p,str))
	  return txt_reg_move_found(aq,test);

	p[1]=tmp;       /* N1f3 */

	if (!strcmp(p,str))
	  return txt_reg_move_found(aq,test);

	p[1]=p[2];    /* Nf3 */
	p[2]=p[3];
	p[3]=p[4];

	if (!strcmp(p,str))
	  return txt_reg_move_found(aq,test);
      }
  }
  printf("not found: %s\n",str);
  return FALSE;
}

static char *titles[] = { "White","Black","Result"};

static  GtkWidget  * pgn_clist_new(GList *game_list)
{
  GtkWidget       *window;
  GtkWidget       *scrolled_window;
  GtkWidget       *clist;
  int i;

  window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  scrolled_window = gtk_scrolled_window_new (NULL, NULL);

  clist = gtk_clist_new_with_titles(3,titles);
  gtk_clist_set_selection_mode(GTK_CLIST (clist),GTK_SELECTION_BROWSE);

  for (i = 0; i < 3; i++)
      gtk_clist_set_column_auto_resize (GTK_CLIST (clist), i, TRUE);

  gtk_widget_set_usize (clist, 200, 200);

  gtk_widget_show (clist);
  gtk_container_add (GTK_CONTAINER (window), scrolled_window);
  gtk_container_add(GTK_CONTAINER(scrolled_window), clist);

  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),         
				  GTK_POLICY_AUTOMATIC,             
				  GTK_POLICY_AUTOMATIC);                  
  
  GTK_CLIST(clist)->sort_type = GTK_SORT_DESCENDING;

  gtk_signal_connect (GTK_OBJECT (clist), "click_column",
		      GTK_SIGNAL_FUNC (clist_click_column),
		      NULL);

  gtk_signal_connect (GTK_OBJECT (clist),
		      "select_row",
		      (GtkSignalFunc) select_game,
		      game_list);

  gtk_widget_show (scrolled_window);
  gtk_widget_show (window);
  return clist;
}

static void
clist_click_column (GtkCList * clist, gint column, gpointer data)
{
  if (column == clist->sort_column)
    {
      if (clist->sort_type == GTK_SORT_ASCENDING)
	clist->sort_type = GTK_SORT_DESCENDING;
      else
	clist->sort_type = GTK_SORT_ASCENDING;
    }
  else
    gtk_clist_set_sort_column (clist, column);

  gtk_clist_set_compare_func (clist, NULL);
  gtk_clist_sort (clist);
}

static void
select_game(GtkWidget * widget,int row,int column,GdkEventButton * event,GList *game_list)
{
  FILE *fp;
  printf("select game");

  fp = fopen(filename,"r");
  if (fp)
    {
      fseek(fp,(long) g_list_nth_data(game_list,row),SEEK_SET);
      txt_load_from_fp(fp, (long)g_list_nth_data(game_list,row+1) - (long)g_list_nth_data(game_list,row), FALSE);
      update_board();
    }
}

