#include <stdlib.h>
#include "portab.h"
#include "makros.h"
#include "typedef.h"
#include "var.h"
#include "pro.h"

static void wrk(void);
static void wrl(void);
static void srk(void);
static void srl(void);

static void wrk()   /*      White short castling  */
{
        feld[E1] = feld[H1]=LEER;
        feld[F1] = WT;
        feld[G1] = WK;
}
static void wrl()
{
        feld[E1]=feld[A1]=LEER;
        feld[C1]=WK;
        feld[D1]=WT;
}
static void srk()
{
        feld[E8]=feld[H8]=LEER;
        feld[F8]=ST;
        feld[G8]=SK;
}
static void srl()
{
        feld[E8]=feld[A8]=LEER;
        feld[C8]=SK;
        feld[D8]=ST;
}

static void white_move(int von, int nach)
{
   REG WORD figur,zfeld;

     figur = feld[von];

     switch (figur) {
        case WB :
                if ( nach & 128) 
				{

	                zfeld = (nach & 7) + A8;            
	                figur = ((nach & 127) >> 3 ) + WB - 1;

	                stp->vf = feld[zfeld];
	                feld[von] = LEER;
	                feld[zfeld]  = figur;
                    stp->ep = LEER;
                    stp->amzug = SAZ;
                    return;
                }

                /* en passent */

                if((nach-von) !=10) 
				{
                        if((nach-von) !=20)
					    {
                                if(feld[nach] == LEER)
							    {
                                        feld[nach-10] = LEER;
                                        stp->ep = LEER;
                                        feld[nach] = WB;
                                        feld[von] = LEER;
                                        stp->vf = LEER;
                                        stp->amzug = SAZ;
                                        return;
                                }
                        }
                }

                stp->vf = feld[nach];
                feld[nach] = figur;
                feld[von]  = LEER;

                if ((nach-von) == 20) 	
		  stp->ep = nach;
                else  
	          stp->ep = LEER;

               	stp->amzug=SAZ;
                return;

        case WK :
                  stp->ep=LEER;
                  stp->wki = nach;
                  stp->wta += 1;
                  stp->wth += 1;

	          /* castling */
                  if (von != E1)
                  {
                          stp->vf = stp->vf = feld[nach];
                          feld[nach] = figur;
                          feld[von]  = LEER;
                          stp->amzug=SAZ;
                          return;
                  }
                  if (abs(nach-von) != 2 )
                  {
                          stp->vf = stp->vf = feld[nach];
                          feld[nach] = figur;
                          feld[von]  = LEER;
                          stp->amzug=SAZ;
                          return;
                  }

                /*  castling */

                  switch  (nach)    {

                        case G1 :       wrk();break;  
                        case C1 :       wrl();break;  
                        default :       abort();
                  }
                  stp->amzug=SAZ;
                  return;
        case WT :
                  stp->ep=LEER;
                  stp->vf = feld[nach];
                  feld[nach] = figur;
                  feld[von]  = LEER;

                  if ( von == A1) stp->wta += 1;
                  if ( von == H1) stp->wth += 1;
                  stp->amzug=SAZ;
                  return;
        default :
                  stp->ep=LEER;
                  stp->vf = stp->vf = feld[nach];
                  feld[nach] = figur;
                  feld[von]  = LEER;
                  stp->amzug=SAZ;
                  return;
     }
}

static void black_move(int von, int nach)
{
   REG WORD figur,zfeld;

     figur = feld[von];

     switch (figur) {
        case SB :
                if ( nach & 128)	
			    {
	                zfeld = (nach & 7) + A1;
        	        figur = ((nach & 127) >> 3) + SB - 1;
                	stp->vf = feld[zfeld];
	                feld[von]    = LEER;
        	        feld[zfeld]  = figur;
                    	stp->ep = LEER;
		      	stp->amzug = WAZ;
         	      	return;
        	}

        	if((von-nach) !=10) 
			{
                	if((von-nach) !=20)
				    {
                        	if(feld[nach] == LEER)
						    {
                                	feld[nach+10] = LEER;
             				stp->ep = LEER;
                                	feld[nach] = SB;
                                	feld[von] = LEER;
                                	stp->vf = LEER;
                                	stp->amzug = WAZ;
                                	return;
	                        }
        	        }
        	}

	        stp->vf = feld[nach];
        	feld[nach] = figur;
	        feld[von]  = LEER;

        	if ((von-nach) == 20) 	
			stp->ep = nach;
        	else                   
			stp->ep = LEER;	

            stp->amzug=WAZ;
            return;

        case SK :
                  stp->ep=LEER;
                  stp->ski = nach;
                  stp->sta += 1;
                  stp->sth += 1;

                  if (von != E8)
                  {
                          stp->vf = feld[nach];
                          feld[nach] = figur;
                          feld[von]  = LEER;
                          stp->amzug=WAZ;
                          return;
                  }
                  if (abs(nach-von) != 2 )
                  {
                          stp->vf = stp->vf = feld[nach];
                          feld[nach] = figur;
                          feld[von]  = LEER;
                          stp->amzug=WAZ;
                          return;
                  }
                /*      castling */
                  switch  (nach)    {

                        case G8 :       srk();break; 
                        case C8 :       srl();break; 
                        default :       abort();
                  }
                  stp->amzug=WAZ;
                  return;
        case ST :
                  stp->ep=LEER;
                  stp->vf = feld[nach];
                  feld[nach] = figur;
                  feld[von]  = LEER;

                  if ( von == A8) stp->sta += 1;
                  if ( von == H8) stp->sth += 1;
                  stp->amzug=WAZ;
                  return;
        default :
                  stp->ep=LEER;
                  stp->vf = feld[nach];
                  feld[nach] = figur;
                  feld[von]  = LEER;
                  stp->amzug=WAZ;
                  return;
     }
}



void make_move( int from, int to)
{
        switch (stp->amzug) {

                case WAZ:       white_move(from,to);
                                break;
                case SAZ:       black_move(from,to);
                                break;
                default :       abort();
        }
}
