#include <gdk/gdkkeysyms.h> 
#include "menu.h"

static GnomeUIInfo file_menu[] = {

 {GNOME_APP_UI_ITEM,N_("_Load Game ..."),NULL,load_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Save Game ..."),NULL,save_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("E_xit"),NULL,quit_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,GDK_q,GDK_CONTROL_MASK,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo game_menu[] = 
{
  {GNOME_APP_UI_ITEM,N_("_New Game"),NULL,new_game_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("_Take Back"),NULL,takeback_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,GDK_b,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Forward"),NULL,forward_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,GDK_f,0,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo options_menu[] = 
{
  {GNOME_APP_UI_ITEM,N_("_Two Players"),NULL,two_players_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Two Machines"),NULL,two_machines_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Analyse Mode"),NULL,analyse_mode_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  GNOMEUIINFO_SEPARATOR,

  {GNOME_APP_UI_ITEM,N_("_Level"),NULL,level_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Move Now"),NULL,move_now_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  {GNOME_APP_UI_ITEM,N_("_Go"),NULL,go_cb,NULL,
  NULL, GNOME_APP_PIXMAP_NONE,NULL,0,0,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo help_menu[] = 
{
  {GNOME_APP_UI_ITEM,N_("_About"),NULL,about_cb,NULL,
  NULL, GNOME_APP_PIXMAP_STOCK,GNOME_STOCK_MENU_ABOUT,0,0,NULL},

  GNOMEUIINFO_END  
};

static GnomeUIInfo mainmenu[] = {

	{GNOME_APP_UI_SUBTREE, N_("_File"), NULL, file_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	{GNOME_APP_UI_SUBTREE, N_("_Game"), NULL, game_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	{GNOME_APP_UI_SUBTREE, N_("_Options"), NULL, options_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	/*	GNOMEUIINFO_JUSTIFY_RIGHT , */

	{GNOME_APP_UI_SUBTREE, N_("_Help"), NULL, help_menu, NULL, NULL,
	GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},

	GNOMEUIINFO_END  
};

static GnomeUIInfo toolbar [] = {
	GNOMEUIINFO_ITEM_STOCK (N_("New"),
				N_("Start a new game"),
				new_game_cb, GNOME_STOCK_PIXMAP_NEW),
	GNOMEUIINFO_ITEM_STOCK (N_("Open"),
				N_("Opens a game"),
				load_cb, GNOME_STOCK_PIXMAP_OPEN),
	GNOMEUIINFO_ITEM_STOCK (N_("Save"),
				N_("Saves a game"),
				save_cb, GNOME_STOCK_PIXMAP_SAVE),
	GNOMEUIINFO_ITEM_STOCK (N_("First"),
				N_("Go to beginning of game"),
				first_cb, GNOME_STOCK_PIXMAP_FIRST),
	GNOMEUIINFO_ITEM_STOCK (N_("Takeback"),
				N_("Take one move back"),
				takeback_cb, GNOME_STOCK_PIXMAP_BACK),
	GNOMEUIINFO_ITEM_STOCK (N_("Forward"),
				N_("Move one move forward"),
				forward_cb, GNOME_STOCK_PIXMAP_FORWARD),
	GNOMEUIINFO_ITEM_STOCK (N_("Last"),
				N_("Go to the end of game"),
				last_cb, GNOME_STOCK_PIXMAP_LAST),

	GNOMEUIINFO_END
};

void create_menus(GtkWidget *app)
{
  GtkWidget *tb;
  GnomeDockItem *item;                                                                        
  gnome_app_create_menus (GNOME_APP(app),mainmenu);
  gnome_app_create_toolbar (GNOME_APP (app),toolbar);
 
  item = gnome_app_get_dock_item_by_name(GNOME_APP(app), GNOME_APP_TOOLBAR_NAME);             
  tb = gnome_dock_item_get_child (item);    
  gtk_toolbar_set_style (GTK_TOOLBAR (tb), GTK_TOOLBAR_ICONS);    

}
